/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.PointFloat;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.SpriteFrame;

public class Utility {
    static float[] sinTable = new float[91];
    static float[] cosTable = new float[91];
    static float[] tanTable = new float[91];

    public static float approach(float current, float target, float speed) {
        if (current == target) {
            return current;
        }
        if (current < target) {
            if ((current += speed) > target) {
                return target;
            }
            return current;
        }
        if ((current -= speed) < target) {
            return target;
        }
        return current;
    }

    public static Bitmap[][] stretchArray(Bitmap[][] src, int expandby) {
        Bitmap[][] dest = new Bitmap[src.length + expandby][];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static Point[] stretchArray(Point[] src, int expandby) {
        Point[] dest = new Point[src.length + expandby];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static int[][] stretchArray(int[][] src, int expandby) {
        int[][] dest = new int[src.length + expandby][];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static int[] stretchArray(int[] src, int expandby) {
        int[] dest = new int[src.length + expandby];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static boolean[] stretchArray(boolean[] src, int expandby) {
        boolean[] dest = new boolean[src.length + expandby];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static boolean isElementInArray(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    public static SpriteFrame[][] stretchArray(SpriteFrame[][] src, int expandby) {
        SpriteFrame[][] dest = new SpriteFrame[src.length + expandby][];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static int roundUp(float value) {
        int intValue = (int)value;
        if (value > (float)intValue) {
            return intValue + 1;
        }
        return intValue;
    }

    public static float lerp(float start, float end, float percent) {
        return start + percent * (end - start);
    }

    public static Bitmap[] getArray(Bitmap bitmap) {
        Bitmap[] array = new Bitmap[]{bitmap};
        return array;
    }

    public static float getSin(float angleDegrees) {
        if ((angleDegrees = Utility.wrapAngle(angleDegrees)) > 90.0f) {
            return Utility.getCos(angleDegrees - 90.0f);
        }
        return sinTable[(int)angleDegrees];
    }

    public static float getCos(float angleDegrees) {
        if ((angleDegrees = Utility.wrapAngle(angleDegrees)) > 90.0f) {
            return -Utility.getSin(angleDegrees - 90.0f);
        }
        return cosTable[(int)angleDegrees];
    }

    public static float getTan(float angleDegrees) {
        return Utility.getSin(angleDegrees) / Utility.getCos(angleDegrees);
    }

    public static int getInverseSin(float value) {
        return Utility.binarySearchClosestValue(sinTable, value);
    }

    public static int getInverseCos(float value) {
        return 90 - Utility.binarySearchClosestValue(sinTable, value);
    }

    public static int getInverseTan(float value) {
        return Utility.binarySearchClosestValue(tanTable, value);
    }

    private static int binarySearchClosestValue(float[] array, float value) {
        int n = array.length;
        int lower = 0;
        int upper = n - 1;
        while (lower <= upper) {
            int middle = (lower + upper) / 2;
            if (value == array[middle]) {
                return middle;
            }
            if (value > array[middle]) {
                lower = middle + 1;
                if (!(value < array[lower])) continue;
                if (array[lower] - value < value - array[middle]) {
                    return lower;
                }
                return middle;
            }
            if (!(value < array[middle]) || !(value > array[upper = middle - 1])) continue;
            if (value - array[upper] < array[middle] - value) {
                return upper;
            }
            return middle;
        }
        return -1;
    }

    public static int percent(int value, int percent) {
        return value * percent / 100;
    }

    public static float wrapAngle(float angle) {
        if (angle >= 360.0f) {
            angle -= (float)((int)(angle / 360.0f) * 360);
        }
        if (angle < 0.0f && (angle += (float)(360 * (int)(-angle / 360.0f + 1.0f))) == 360.0f) {
            angle = 0.0f;
        }
        return angle;
    }

    public static boolean isPointInsidePolygon(Point pointToCheck, Point[] polygonPoints) {
        int rightSideCount = 0;
        int i = 0;
        int j = polygonPoints.length - 1;
        while (i < polygonPoints.length) {
            if ((polygonPoints[i].X - polygonPoints[j].X) * (pointToCheck.Y - polygonPoints[j].Y) - (polygonPoints[i].Y - polygonPoints[j].Y) * (pointToCheck.X - polygonPoints[j].X) > 0.0f) {
                ++rightSideCount;
            }
            j = i++;
        }
        return rightSideCount == polygonPoints.length;
    }

    public static boolean isPointInsidePolygon(PointFloat pointToCheck, PointFloat[] polygonPoints) {
        int rightSideCount = 0;
        int i = 0;
        int j = polygonPoints.length - 1;
        while (i < polygonPoints.length) {
            if ((polygonPoints[i].x - polygonPoints[j].x) * (pointToCheck.y - polygonPoints[j].y) - (polygonPoints[i].y - polygonPoints[j].y) * (pointToCheck.x - polygonPoints[j].x) > 0.0f) {
                ++rightSideCount;
            }
            j = i++;
        }
        return rightSideCount == polygonPoints.length;
    }

    public static float getRotatedPointX(float centerX, float centerY, float x, float y, float angle) {
        return centerX + (x - centerX) * Utility.getCos(angle) + (y - centerY) * Utility.getSin(angle);
    }

    public static float getRotatedPointY(float centerX, float centerY, float x, float y, float angle) {
        return centerY - (x - centerX) * Utility.getSin(angle) + (y - centerY) * Utility.getCos(angle);
    }

    public static float getRotatedScaledPointX(float centerX, float centerY, float x, float y, float angle, float scaleX, float scaleY) {
        return centerX + (x - centerX) * scaleX * Utility.getCos(angle) + (y - centerY) * scaleY * Utility.getSin(angle);
    }

    public static float getRotatedScaledPointY(float centerX, float centerY, float x, float y, float angle, float scaleX, float scaleY) {
        return centerY - (x - centerX) * scaleX * Utility.getSin(angle) + (y - centerY) * scaleY * Utility.getCos(angle);
    }

    public static double getAngleOfLineWithHorizontal(Point p1, Point p2) {
        PointFloat difference = new PointFloat(p1.X - p2.X, p1.Y - p2.Y);
        float num2 = difference.x * difference.x + difference.y * difference.y;
        float num = 1.0f / (float)Math.sqrt(num2);
        difference.x *= num;
        difference.y *= num;
        int baseAngle = difference.x == 0.0f ? 90 : Utility.getInverseTan(Math.abs(difference.y / difference.x));
        if (difference.x < 0.0f && difference.y > 0.0f) {
            baseAngle = 180 - baseAngle;
        } else if (difference.x < 0.0f && difference.y < 0.0f) {
            baseAngle += 180;
        } else if (difference.x > 0.0f && difference.y < 0.0f) {
            baseAngle = 360 - baseAngle;
        }
        return baseAngle;
    }

    public static String[] split(String str, String splitBy) {
        int index;
        ArrayList list = new ArrayList();
        while ((index = str.indexOf(splitBy)) != -1) {
            list.addElement(str.substring(0, index));
            str = str.substring(index + splitBy.length());
        }
        list.addElement(str);
        String[] splits = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            splits[i] = (String)list.elementAt(i);
        }
        return splits;
    }

    public static int[] parseInt(String[] values) {
        int[] integers = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = Integer.parseInt(values[i]);
        }
        return integers;
    }

    public static FXVector add(FXVector v1, FXVector v2) {
        return new FXVector(v1.xFX + v2.xFX, v1.yFX + v2.yFX);
    }

    public static FXVector sub(FXVector v1, FXVector v2) {
        return new FXVector(v1.xFX - v2.xFX, v1.yFX - v2.yFX);
    }

    public static FXVector mul(FXVector vector, float scalar) {
        return new FXVector(vector.xFX * scalar, vector.yFX * scalar);
    }

    public static boolean parseBoolean(String value) {
        return value.trim().equalsIgnoreCase("true");
    }

    public static FXVector scl(FXVector vector, float scalar) {
        vector.xFX *= scalar;
        vector.yFX *= scalar;
        return vector;
    }

    public static FXVector[] getSortedPointsClockwise(FXVector[] vertices) {
        int i;
        FXVector[] verts = new FXVector[vertices.length];
        for (int i2 = 0; i2 < vertices.length; ++i2) {
            verts[i2] = vertices[i2];
        }
        FXVector total = new FXVector(0.0f, 0.0f);
        for (int i3 = 0; i3 < verts.length; ++i3) {
            total.xFX += verts[i3].xFX;
            total.yFX += verts[i3].yFX;
        }
        FXVector average = new FXVector(total.xFX / (float)verts.length, total.yFX / (float)verts.length);
        float[] angles = new float[verts.length];
        for (i = 0; i < verts.length; ++i) {
            angles[i] = (float)Utility.getAngleOfLineWithHorizontal(new Point(average.xFX, average.yFX), new Point(verts[i].xFX, verts[i].yFX));
        }
        for (i = 0; i < verts.length - 1; ++i) {
            for (int k = i + 1; k < verts.length; ++k) {
                if (!(angles[i] > angles[k])) continue;
                float temp = angles[i];
                angles[i] = angles[k];
                angles[k] = temp;
                FXVector temp2 = verts[i];
                verts[i] = verts[k];
                verts[k] = temp2;
            }
        }
        return verts;
    }

    public static FXVector[] getReverseArray(FXVector[] verts) {
        FXVector[] v = new FXVector[verts.length];
        int j = 0;
        for (int i = verts.length - 1; i >= 0; --i) {
            v[i] = verts[j++];
        }
        return v;
    }

    public static int[] getReverseArray(int[] values) {
        int[] v = new int[values.length];
        int j = 0;
        for (int i = values.length - 1; i >= 0; --i) {
            v[i] = values[j++];
        }
        return v;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static {
        for (int i = 0; i <= 90; ++i) {
            Utility.sinTable[i] = (float)Math.sin(Math.toRadians(i));
            Utility.cosTable[i] = (float)Math.cos(Math.toRadians(i));
            Utility.tanTable[i] = (float)Math.tan(Math.toRadians(i));
        }
    }
}

