/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import at.emini.physics2D.Body;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.Joint;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.Box2DHelper;
import com.renderedideas.gamemanager.GameBackground;
import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameObjectManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.PolygonMap;
import com.renderedideas.gamemanager.UserData;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Sound;
import com.renderedideas.yourgamename.ExplosionEffect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class Box2DTestView
extends GameView3D
implements PhysicsEventListener {
    public static final int SCREEN_RUNNING = 1;
    public static final int SCREEN_LOADING = 2;
    public static final int SCREEN_GAMEOVER = 3;
    public static final int SCREEN_CLEAR = 4;
    public static Box2DTestView instance;
    public int currentScreen;
    boolean isLoadingStarted;
    World box2dWorld;
    PolygonMap polygonMap;
    Body bikeFrameBody;
    Body bikeRearWheelBody;
    Body bikeFrontWheelBody;
    Body groundBody;
    Body clearFlagBody;
    Shape bikeFrameFixture;
    Shape clearFlagFixture;
    Joint revJointFrontWheel;
    Joint revJointRearWheel;
    FXVector bikePosition;
    FXVector bikeInitialPosition;
    Sound idleSound;
    Sound runningSound;
    Sound explosionSound;
    Sound clearSound;
    GameBackground background;
    ExplosionEffect explosionEffect;
    GameObjectManager gameObjectManager;
    GameFont gameplayFont;
    boolean leftTouch;
    boolean rightTouch;
    int leftTouchPointerID;
    int rightTouchPointerID;
    boolean isDied;
    public static int currentLevel;
    boolean flag = false;

    public Box2DTestView() {
        GameManager.setUpM3G();
        instance = this;
        this.currentScreen = 2;
        this.isLoadingStarted = false;
        this.gameplayFont = new GameFont("/images/fonts/font_gameplay");
        PlatformService.startAccelerometer();
    }

    public void update() {
        if (this.currentScreen == 1) {
            float[] readings = PlatformService.getAccelerometerReadings();
            this.accelerometerData(readings[0], readings[1], readings[2], -1.0f, 1.0f);
            this.box2dWorld.tick();
            FXVector currentPosition = new FXVector(this.bikeFrameBody.positionFX());
            float moveX = (currentPosition.xFX - this.bikePosition.xFX) * 1.0f;
            float moveY = -(currentPosition.yFX - this.bikePosition.yFX) * 1.0f;
            this.bikePosition = currentPosition;
            this.polygonMap.MoveMap(moveX, moveY, 0.0f);
            if (!this.isDied && -currentPosition.yFX * 1.0f > this.polygonMap.dimensionBottomRight.Y + (float)(GameManager.screenHeight / 2)) {
                this.die();
            }
            this.background.update((int)moveX / 5);
            this.gameObjectManager.updateObjects();
            this.processInput();
        } else if (this.currentScreen == 2) {
            if (!this.isLoadingStarted) {
                this.isLoadingStarted = true;
                PlatformService.startLoadingThread();
                return;
            }
            try {
                this.loadGame();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Debug.printException("dkj838", ex);
            }
        } else if (this.currentScreen == 3) {
            this.currentScreen = 1;
            this.update();
            this.currentScreen = 3;
        } else if (this.currentScreen == 4) {
            // empty if block
        }
    }

    private void processInput() {
        if (this.leftTouch) {
            if (!this.runningSound.isPlaying()) {
                this.idleSound.stop();
                this.runningSound.play();
            }
            this.bikeRearWheelBody.applyTorque(-2000.0f);
        }
        if (this.rightTouch) {
            this.bikeRearWheelBody.angularVelocity2FX(0.0f);
        }
    }

    public void paint(Graphics g2, float extrapolationFactor) {
        if (this.currentScreen != 1) {
            if (this.currentScreen == 2) {
                Bitmap.fillColor(g2, 0, 0, GameManager.screenWidth, GameManager.screenHeight, 0, 0, 0);
                this.gameplayFont.drawString("Loading", g2, 350, 240);
            } else if (this.currentScreen == 3) {
                this.currentScreen = 1;
                this.paint(g2, extrapolationFactor);
                this.currentScreen = 3;
                this.gameplayFont.drawString("Tap to retry", g2, 350, 240);
            } else if (this.currentScreen == 4) {
                Bitmap.fillColor(g2, 0, 0, GameManager.screenWidth, GameManager.screenHeight, 111, 111, 111);
                this.gameplayFont.drawString("Clear. Tap to continue", g2, 350, 240);
            }
        }
    }

    public void paintGUI(Graphics g2) {
    }

    public void keyPressed(int keyID) {
    }

    public void keyReleased(int keyID) {
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pointerID, int x, int y) {
        this.flag = true;
        if (this.currentScreen == 1 && !this.isDied) {
            if (x < GameManager.screenWidth / 2) {
                this.leftTouch = true;
                this.leftTouchPointerID = pointerID;
            } else {
                this.rightTouch = true;
                this.rightTouchPointerID = pointerID;
            }
        } else if (this.currentScreen == 3) {
            try {
                this.restartGame();
            }
            catch (Exception ex) {
                Debug.printException("jjjjsldk", ex);
            }
        } else if (this.currentScreen == 4) {
            this.loadNextLevel();
        }
    }

    public void pointerReleased(int pointerID, int x, int y) {
        if (this.currentScreen == 1) {
            if (this.leftTouch && pointerID == this.leftTouchPointerID) {
                this.leftTouch = false;
                this.runningSound.stop();
                if (!this.idleSound.isPlaying()) {
                    this.idleSound.play();
                }
            }
            if (this.rightTouch && pointerID == this.rightTouchPointerID) {
                this.rightTouch = false;
            }
        }
    }

    public void pointerDragged(int pointerID, int x, int y) {
    }

    public void onBackKey() {
        PlatformService.exit();
    }

    public void handleSwipe(int direction, int pointerId) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
    }

    public void accelerometerData(float x, float y, float z, float min, float max) {
        if (this.currentScreen == 1) {
            if (Math.abs(y) > 0.0f) {
                this.bikeFrameBody.applyTorque(-y * 10000.0f);
            } else {
                this.bikeFrameBody.applyTorque(y * 10000.0f);
            }
        }
    }

    public void eventTriggered(Event event, Object o) {
        if (this.currentScreen != 1) {
            return;
        }
        Contact _contact = (Contact)o;
        if (_contact.concernsBody(this.clearFlagBody)) {
            if (!this.isDied) {
                this.currentScreen = 4;
                this.idleSound.stop();
                this.runningSound.stop();
                this.clearSound.play();
            }
        } else if (!this.isDied && _contact.concernsBody(this.bikeFrameBody)) {
            this.die();
        }
    }

    private void die() {
        this.isDied = true;
        this.explosionEffect.initialize();
        this.explosionEffect.position.X = (int)(this.bikeFrameBody.positionFX().xFX * 1.0f - this.polygonMap.startX);
        this.explosionEffect.position.Y = (int)(-this.bikeFrameBody.positionFX().yFX * 1.0f - this.polygonMap.startY);
        this.explosionEffect.imageSet.setState(0, true, 1);
        GameObjectManager.gameObjectList.addElement(this.explosionEffect);
        Box2DHelper.removeJoint(this.box2dWorld, "/bike_java.json>revJointFrontWheel");
        Box2DHelper.removeJoint(this.box2dWorld, "/bike_java.json>revJointRearWheel");
        Box2DHelper.removeBody(this.box2dWorld, "/bike_java.json>frameBody");
        this.leftTouch = false;
        this.rightTouch = false;
        this.idleSound.stop();
        this.runningSound.stop();
        this.explosionSound.play();
    }

    public void loadGame() throws Exception {
        this.createBox2dWorld();
        this.loadSounds();
        this.background = new GameBackground("/bg.png");
        this.explosionEffect = new ExplosionEffect();
        this.gameObjectManager = new GameObjectManager();
        this.polygonMap = new PolygonMap("/maps/map" + currentLevel + ".map", this.box2dWorld);
        this.loadBodiesReferences();
        this.setupMapPosition();
        this.bikeInitialPosition = new FXVector(this.bikePosition.xFX * 1.0f, -this.bikePosition.yFX * 1.0f);
        PlatformService.stopLoadingThread();
        this.currentScreen = 1;
        this.idleSound.play();
    }

    private void createBox2dWorld() {
        this.box2dWorld = new World();
        this.box2dWorld.setGravity(new FXVector(0.0f, -150.0f));
        this.box2dWorld.setDampingRotationalFX(0.1f);
        this.box2dWorld.setPhysicsEventListener(this);
    }

    private void loadSounds() throws Exception {
        this.idleSound = new Sound(100, "/sounds/idle.wav", -1);
        this.runningSound = new Sound(100, "/sounds/running.wav", -1);
        this.explosionSound = new Sound(100, "/sounds/clear.wav", 1);
        this.clearSound = new Sound(100, "/sounds/clear.wav", 1);
    }

    private void setupMapPosition() {
        this.polygonMap.startX = ((UserData)this.clearFlagFixture.getUserData()).body.positionFX().xFX * 1.0f;
        this.polygonMap.startY = -((UserData)this.clearFlagFixture.getUserData()).body.positionFX().yFX * 1.0f;
        float playerPosX = this.bikeFrameBody.positionFX().xFX * 1.0f - (float)(GameManager.screenWidth / 5);
        float playerPosY = -this.bikeFrameBody.positionFX().yFX * 1.0f - (float)(GameManager.screenHeight / 2);
        this.polygonMap.MoveMap(playerPosX - this.polygonMap.startX, playerPosY - this.polygonMap.startY, 0.0f);
        this.bikePosition = this.bikeFrameBody.positionFX();
    }

    public void loadNextLevel() {
        Debug.print("next level", (short)1);
        ++currentLevel;
        Box2DHelper.bodies.clear();
        Box2DHelper.joints.clear();
        Box2DHelper.fixtures.clear();
        this.currentScreen = 2;
        this.isLoadingStarted = false;
    }

    public void restartGame() throws Exception {
        Box2DHelper.bodies.clear();
        Box2DHelper.joints.clear();
        Box2DHelper.fixtures.clear();
        this.createBox2dWorld();
        this.polygonMap = new PolygonMap("/maps/map" + currentLevel + ".map", this.box2dWorld);
        this.loadBodiesReferences();
        this.setupMapPosition();
        this.idleSound.play();
        this.isDied = false;
        this.currentScreen = 1;
    }

    private void loadBodiesReferences() {
        this.bikeFrameBody = (Body)Box2DHelper.bodies.get("/bike_java.json>frameBody");
        this.bikeRearWheelBody = (Body)Box2DHelper.bodies.get("/bike_java.json>rearWheelBody");
        this.bikeFrontWheelBody = (Body)Box2DHelper.bodies.get("/bike_java.json>frontWheelBody");
        this.bikeFrameFixture = (Shape)Box2DHelper.fixtures.get("/bike_java.json>frameBody>frameFixture");
        this.clearFlagBody = (Body)Box2DHelper.bodies.get(">clear");
        this.clearFlagFixture = (Shape)Box2DHelper.fixtures.get(">clear>clear");
        this.revJointFrontWheel = (Joint)Box2DHelper.joints.get("/bike_java.json>revJointFrontWheel");
        this.revJointRearWheel = (Joint)Box2DHelper.joints.get("/bike_java.json>revJointRearWheel");
        this.groundBody = (Body)Box2DHelper.bodies.get(">ground");
        Event event = Event.createBodyEvent(this.bikeFrameBody, null, 4, 1, 1, 1, 1);
        this.box2dWorld.addEvent(event);
        event = Event.createBodyEvent(this.clearFlagBody, null, 4, 1, 1, 1, 1);
        this.box2dWorld.addEvent(event);
    }

    public void paint2D_before(Graphics g2) {
        if (this.currentScreen == 1) {
            this.background.paint(g2);
        }
    }

    public void paint3D_before(Graphics3D g2) {
        if (this.currentScreen == 1) {
            Box2DHelper.drawWorld(null, g2, this.box2dWorld, this.polygonMap.startX, this.polygonMap.startY, GameManager.screenWidth, GameManager.screenHeight, false, false, true);
        }
    }

    public void paint2D_after(Graphics g2) {
        if (this.currentScreen == 1) {
            Box2DHelper.drawWorld(g2, null, this.box2dWorld, this.polygonMap.startX, this.polygonMap.startY, GameManager.screenWidth, GameManager.screenHeight, true, true, false);
            this.gameObjectManager.paintObjects(g2);
        }
    }

    public void paint3D_after(Graphics3D g2) {
    }

    public void handleSwipe(int direction) {
    }

    static {
        currentLevel = 1;
    }
}

