/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.admanager;

import com.emobtech.googleanalyticsme.Event;
import com.renderedideas.admanager.AdData;
import com.renderedideas.gamemanager.GameView;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;
import javax.microedition.lcdui.Graphics;

public class GameplayAdView
extends GameView {
    private AdData adData;
    Bitmap yes;
    Bitmap no;

    public GameplayAdView(final AdData adData) {
        this.adData = adData;
        this.yes = new Bitmap("/donotdelete/yes.png");
        this.no = new Bitmap("/donotdelete/no.png");
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    GameplayAdView.this.analyzeData(adData);
                }
                catch (Exception e2) {
                    if (adData != null) {
                        GameMIDlet.tracker.addToQueue(new Event("/GameplayAdView", "Exception", adData.response, null));
                    }
                    e2.printStackTrace();
                    GameplayAdView.this.skipAd();
                }
            }
        });
        t.start();
    }

    public void update() {
    }

    private void analyzeData(AdData adData) {
        if (adData.type.equals("update")) {
            this.analyzeUpdate(adData);
        } else if (adData.type.equals("ad")) {
            this.hitAllBeacons(adData);
            if (adData.adType.equals("banner")) {
                this.analyzeBanner(adData);
            } else if (adData.adType.equals("text")) {
                this.analyzeText(adData);
            } else if (adData.adType.equals("prompt")) {
                this.analyzePrompt(adData);
            } else if (adData.adType.equals("custom")) {
                this.analyzeCustom(adData);
            } else if (adData.adType.equals("call")) {
                this.analyzeCall(adData);
            }
        }
    }

    private void analyzeUpdate(AdData adData) {
        if (PlatformService.showYesNoDialog(adData.title, adData.text)) {
            PlatformService.openURL(adData.clickUrl);
            PlatformService.sleepThread(2000);
            GameMIDlet.instance.exit();
        } else {
            this.skipAd();
        }
    }

    private void analyzeBanner(final AdData adData) {
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    GameplayAdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void analyzeText(final AdData adData) {
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    GameplayAdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void analyzePrompt(final AdData adData) {
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    GameplayAdView.this.clickAd();
                }
            });
            t.start();
        }
        if (adData.isFlipButtons.equals("true")) {
            int optionSelected = GameMIDlet.instance.showOptionsDialog(adData.title, adData.img, adData.text, adData.negativeText, adData.positiveText);
            if (optionSelected == 2) {
                this.clickAd();
            } else if (optionSelected == 1) {
                this.skipAd();
            }
        } else {
            int optionSelected = GameMIDlet.instance.showOptionsDialog(adData.title, adData.img, adData.text, adData.positiveText, adData.negativeText);
            if (optionSelected == 1) {
                this.clickAd();
            } else if (optionSelected == 2) {
                this.skipAd();
            }
        }
    }

    private void analyzeCustom(final AdData adData) {
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    GameplayAdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void analyzeCall(AdData adData) {
        this.analyzeBanner(adData);
    }

    public static void cacheData(AdData adData) {
        try {
            if (adData.type.equals("ad")) {
                if (adData.adType.equals("banner")) {
                    GameplayAdView.cacheBanner(adData);
                } else if (adData.adType.equals("text")) {
                    GameplayAdView.cacheText(adData);
                } else if (adData.adType.equals("prompt")) {
                    GameplayAdView.cachePrompt(adData);
                } else if (adData.adType.equals("custom")) {
                    GameplayAdView.cacheCustom(adData);
                } else if (adData.adType.equals("call")) {
                    GameplayAdView.cacheCall(adData);
                }
            }
        }
        catch (Exception e2) {
            if (adData != null) {
                GameMIDlet.tracker.addToQueue(new Event("/Adview", "Exception", adData.response, null));
            }
            e2.printStackTrace();
        }
    }

    public static void cacheBanner(AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            GameplayAdView.rotateResizeAndScale(adData);
        }
        catch (Exception ex) {
            Debug.print("993ndk:" + ex);
        }
    }

    public static void cacheText(AdData adData) {
    }

    public static void cachePrompt(AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            GameplayAdView.rotateResizeAndScale(adData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cacheCustom(AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            GameplayAdView.rotateResizeAndScale(adData);
            if (!adData.positiveButtonImgUrl.equals("null") && !adData.positiveButtonImgUrl.equals("")) {
                adData.positiveButtonImg = PlatformService.getBitmapResponseFromServer(adData.positiveButtonImgUrl);
            }
            if (!adData.negativeButtonImgUrl.equals("null") && !adData.negativeButtonImgUrl.equals("")) {
                adData.negativeButtonImg = PlatformService.getBitmapResponseFromServer(adData.negativeButtonImgUrl);
            }
        }
        catch (Exception ex) {
            Debug.print("993ndk:" + ex);
        }
    }

    public static void cacheCall(AdData adData) {
        GameplayAdView.cacheBanner(adData);
    }

    public void paint(Graphics g2, float ef) {
        if (this.adData.type.equals("ad")) {
            if (this.adData.adType.equals("banner")) {
                this.paintBanner(g2, this.adData);
            } else if (this.adData.adType.equals("text")) {
                this.paintText(g2, this.adData);
            } else if (this.adData.adType.equals("custom")) {
                this.paintCustom(g2, this.adData);
            } else if (this.adData.adType.equals("call")) {
                this.paintCall(g2, this.adData);
            }
        }
    }

    private void paintBanner(Graphics g2, AdData adData) {
        Bitmap.fillColor(g2, 0, 0, GameplayAdView.getWidth(), GameplayAdView.getHeight(), 0, 0, 0);
        if (adData.img != null) {
            Bitmap.drawBitmap(g2, adData.img, GameplayAdView.getWidth() / 2 - adData.img.getWidth() / 2, GameplayAdView.getHeight() / 2 - adData.img.getHeight() / 2);
        }
        if (adData.img != null) {
            Bitmap.drawMultilineString(g2, adData.text, GameplayAdView.getWidth() / 10, GameplayAdView.getHeight() / 2 + adData.img.getHeight() / 2, GameplayAdView.getWidth() * 8 / 10);
        } else {
            Bitmap.drawMultilineString(g2, adData.text, GameplayAdView.getWidth() / 10, GameplayAdView.getHeight() / 2 - Bitmap.getMultilineStringHeight(adData.text, GameplayAdView.getWidth() * 8 / 10) / 2, GameplayAdView.getWidth() * 8 / 10);
        }
        Bitmap.drawBitmap(g2, this.no, 0, GameplayAdView.getHeight() - this.no.getHeight());
        Bitmap.drawBitmap(g2, this.yes, GameplayAdView.getWidth() - this.yes.getWidth(), GameplayAdView.getHeight() - this.yes.getHeight());
    }

    private void paintText(Graphics g2, AdData adData) {
        this.paintBanner(g2, adData);
    }

    private void paintCustom(Graphics g2, AdData adData) {
        Bitmap.fillColor(g2, 0, 0, GameplayAdView.getWidth(), GameplayAdView.getHeight(), adData.bgColor);
        if (adData.img != null) {
            Bitmap.drawBitmap(g2, adData.img, GameplayAdView.getWidth() / 2 - adData.img.getWidth() / 2, GameplayAdView.getHeight() / 2 - adData.img.getHeight() / 2);
        }
        if (adData.img != null) {
            Bitmap.drawMultilineString(g2, adData.text, GameplayAdView.getWidth() / 10, GameplayAdView.getHeight() / 2 + adData.img.getHeight() / 2, GameplayAdView.getWidth() * 8 / 10, adData.textColor);
        } else {
            Bitmap.drawMultilineString(g2, adData.text, GameplayAdView.getWidth() / 10, GameplayAdView.getHeight() / 2 - Bitmap.getMultilineStringHeight(adData.text, GameplayAdView.getWidth() * 8 / 10) / 2, GameplayAdView.getWidth() * 8 / 10, adData.textColor);
        }
        if (adData.positiveButtonImg != null) {
            Bitmap.drawBitmap(g2, adData.positiveButtonImg, GameplayAdView.getWidth() - adData.positiveButtonImg.getWidth(), GameplayAdView.getHeight() - adData.positiveButtonImg.getHeight());
        } else {
            Bitmap.drawBitmap(g2, this.yes, GameplayAdView.getWidth() - this.yes.getWidth(), GameplayAdView.getHeight() - this.yes.getHeight());
        }
        if (adData.negativeButtonImg != null) {
            Bitmap.drawBitmap(g2, adData.negativeButtonImg, 0, GameplayAdView.getHeight() - adData.negativeButtonImg.getHeight());
        } else {
            Bitmap.drawBitmap(g2, this.no, 0, GameplayAdView.getHeight() - this.yes.getHeight());
        }
    }

    private void paintCall(Graphics g2, AdData adData) {
        this.paintBanner(g2, adData);
    }

    public void keyPressed(int keyID) {
        if (keyID == 101) {
            this.skipAd();
        } else if (keyID == 102) {
            this.clickAd();
        }
    }

    public void keyReleased(int keyID) {
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pid, int x, int y) {
        if (this.adData == null || this.adData.adType == null) {
            return;
        }
        if (this.adData.negativeButtonImg != null) {
            if (x <= this.adData.negativeButtonImg.getWidth() && y >= GameplayAdView.getHeight() - this.adData.negativeButtonImg.getHeight()) {
                this.skipAd();
            } else {
                this.clickAd();
            }
        } else if (x <= this.no.getWidth() && y >= GameplayAdView.getHeight() - this.no.getHeight()) {
            this.skipAd();
        } else {
            this.clickAd();
        }
    }

    public void pointerReleased(int pid, int x, int y) {
    }

    public void pointerDragged(int pid, int x, int y) {
    }

    public void onBackKey() {
        this.skipAd();
    }

    public void handleSwipe(int direction) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        this.adData.img = null;
        this.adData.imgList = null;
        Game.gamePlayAdData.img = null;
        Game.gamePlayAdData.imgList = null;
        this.no = null;
        this.yes = null;
    }

    public void accelerometerData(double x, double y, double z, double min, double max) {
    }

    public void messageBoxComplete() {
    }

    public void option1Selected() {
    }

    public void option2Selected() {
    }

    public void positiveUserSelection() {
    }

    public void userInputReceived(String input) {
    }

    void clickAd() {
        PlatformService.openURL(this.adData.clickUrl);
        this.skipAd();
    }

    private void skipAd() {
        Game.changeView(Constants.VIEW_AFTER_GAMEPLAYAD);
    }

    static int getWidth() {
        return GameMIDlet.instance.gameCanvas.getWidth();
    }

    static int getHeight() {
        return GameMIDlet.instance.gameCanvas.getHeight();
    }

    private void hitAllBeacons(final AdData adData) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < adData.beaconList.length; ++i) {
                    try {
                        if (adData.beaconList[i].indexOf(".jpg") != -1 || adData.beaconList[i].indexOf(".png") != -1 || adData.beaconList[i].indexOf(".gif") != -1) {
                            PlatformService.getBitmapResponseFromServer(adData.beaconList[i]);
                            continue;
                        }
                        PlatformService.getStringResponseFromServer(adData.beaconList[i], null);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        t.start();
    }

    public static void rotateResizeAndScale(AdData adData) {
        if (adData == null || adData.img == null) {
            return;
        }
        if (!adData.rotation.equals("0")) {
            if (adData.rotation.equals("90")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 90);
            } else if (adData.rotation.equals("180")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 180);
            } else if (adData.rotation.equals("270")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 270);
            }
        }
        if (adData.isResize.equals("true")) {
            if (adData.isMaintainAspectRatio.equals("true")) {
                float scaleFactor;
                float f2 = scaleFactor = adData.img.getWidth() > adData.img.getHeight() ? (float)GameplayAdView.getWidth() / (float)adData.img.getWidth() : (float)GameplayAdView.getHeight() / (float)adData.img.getHeight();
                if ((float)adData.img.getWidth() * scaleFactor > (float)GameplayAdView.getWidth()) {
                    scaleFactor = (float)GameplayAdView.getWidth() / (float)adData.img.getWidth();
                }
                if ((float)adData.img.getHeight() * scaleFactor > (float)GameplayAdView.getHeight()) {
                    scaleFactor = (float)GameplayAdView.getHeight() / (float)adData.img.getHeight();
                }
                adData.img = Bitmap.scaleBitmap(adData.img, (int)((float)adData.img.getWidth() * scaleFactor), (int)((float)adData.img.getHeight() * scaleFactor));
            } else {
                adData.img = Bitmap.scaleBitmap(adData.img, GameplayAdView.getWidth(), GameplayAdView.getHeight());
            }
        }
        if (!adData.scale.equals("1")) {
            float scale = Float.parseFloat(adData.scale);
            adData.img = Bitmap.scaleBitmap(adData.img, (int)((float)adData.img.getWidth() * scale), (int)((float)adData.img.getHeight() * scale));
        }
    }
}

