/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameObject;
import com.renderedideas.platform.Bitmap;
import javax.microedition.lcdui.Graphics;

public final class CollisionRect {
    public int left = -1;
    public int right = -1;
    public int top = -1;
    public int bottom = -1;

    public CollisionRect(GameObject gameObject, int shrinkPercentX, int shrinkPercentY) {
        this.calcCollisionRect(gameObject, shrinkPercentX, shrinkPercentY);
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public void setRect(int left, int right, int top, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public void shrink(int percentX, int percentY) {
        int width = this.right - this.left;
        int height = this.bottom - this.top;
        this.left += width * percentX / 2 / 100;
        this.right -= width * percentX / 2 / 100;
        this.top += height * percentY / 2 / 100;
        this.bottom -= height * percentY / 2 / 100;
    }

    public void calcCollisionRect(GameObject gameObject, int shrinkPercentX, int shrinkPercentY) {
        int width = gameObject.imageSet.getWidth();
        int height = gameObject.imageSet.getHeight();
        this.setRect((int)gameObject.position.X - width / 2, (int)gameObject.position.X + width / 2, (int)gameObject.position.Y - height / 2, (int)gameObject.position.Y + height / 2);
        this.shrink(shrinkPercentX, shrinkPercentY);
    }

    public String toString() {
        return "Rect: " + this.left + "," + this.right + "," + this.top + "," + this.bottom;
    }

    public void drawCollisionRect(Graphics g2) {
        Bitmap.fillColor(g2, this.left, this.top, this.right - this.left, this.bottom - this.top, 255, 0, 0);
    }
}

