/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.LoadResources;

public class SpriteFrame {
    public Bitmap bitmap;
    public int fx;
    public int fy;
    public int width;
    public int height;

    public static final SpriteFrame[] extractSpriteFrames(String filePath) {
        String xml = LoadResources.loadFileAsString(filePath + ".sprites");
        int count = 0;
        int i = 0;
        while ((i = xml.indexOf("<spr", i + 1)) != -1) {
            ++count;
        }
        int index = xml.indexOf("scale=\"");
        int scale = 100;
        if (index != -1) {
            scale = Integer.parseInt(xml.substring(index += 7, xml.indexOf("\"", index + 1)));
        }
        SpriteFrame[] frames = new SpriteFrame[count];
        Bitmap sourceBitmap = new Bitmap(filePath + ".png");
        index = 0;
        for (i = 0; i < count; ++i) {
            frames[i] = new SpriteFrame();
            int startIndex = xml.indexOf("<spr", index);
            startIndex = xml.indexOf("x=\"", startIndex) + 3;
            int endIndex = xml.indexOf("\"", startIndex);
            int x = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("y=\"", startIndex) + 3;
            endIndex = xml.indexOf("\"", startIndex);
            int y = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("w=\"", startIndex) + 3;
            endIndex = xml.indexOf("\"", startIndex);
            int width = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("h=\"", startIndex) + 3;
            endIndex = xml.indexOf("\"", startIndex);
            int height = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("fx=\"", startIndex) + 4;
            endIndex = xml.indexOf("\"", startIndex);
            frames[i].fx = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("fy=\"", startIndex) + 4;
            endIndex = xml.indexOf("\"", startIndex);
            frames[i].fy = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("fw=\"", startIndex) + 4;
            endIndex = xml.indexOf("\"", startIndex);
            frames[i].width = Integer.parseInt(xml.substring(startIndex, endIndex));
            startIndex = xml.indexOf("fh=\"", startIndex) + 4;
            endIndex = xml.indexOf("\"", startIndex);
            frames[i].height = Integer.parseInt(xml.substring(startIndex, endIndex));
            frames[i].bitmap = Bitmap.getImageRegion(sourceBitmap, x * scale / 100, y * scale / 100, width * scale / 100, height * scale / 100);
            index = xml.indexOf("<spr", endIndex);
        }
        return frames;
    }

    public static final SpriteFrame[] extractReverseSpriteFrames(String filePath) {
        SpriteFrame[] frames = SpriteFrame.extractSpriteFrames(filePath);
        SpriteFrame[] reverseFrames = new SpriteFrame[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            reverseFrames[i] = frames[frames.length - 1 - i];
        }
        return reverseFrames;
    }

    public static SpriteFrame[] flipSpriteHorizontally(SpriteFrame[] frames) {
        SpriteFrame[] returnFrames = new SpriteFrame[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            returnFrames[i] = new SpriteFrame();
            returnFrames[i].bitmap = Bitmap.flipBitmapHorizontal(frames[i].bitmap);
            returnFrames[i].fx = frames[i].width - (frames[i].fx + frames[i].bitmap.getWidth());
            returnFrames[i].fy = frames[i].fy;
            returnFrames[i].width = frames[i].width;
            returnFrames[i].height = frames[i].height;
        }
        return returnFrames;
    }

    public static SpriteFrame[] flipSpriteVertically(SpriteFrame[] frames) {
        SpriteFrame[] returnFrames = new SpriteFrame[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            returnFrames[i] = new SpriteFrame();
            returnFrames[i].bitmap = Bitmap.flipBitmapVertical(frames[i].bitmap);
            returnFrames[i].fx = frames[i].fx;
            returnFrames[i].fy = frames[i].height - (frames[i].fy + frames[i].bitmap.getHeight());
            returnFrames[i].width = frames[i].width;
            returnFrames[i].height = frames[i].height;
        }
        return returnFrames;
    }
}

