/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameObject;
import com.renderedideas.gamemanager.GameObjectManager;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.yourgamename.BitmapCacher;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.LevelInfo;
import javax.microedition.lcdui.Graphics;

public class Target
extends GameObject {
    Bitmap target = BitmapCacher.target;
    int right;
    int left;
    int top;
    int bottom;
    int radius1 = 20;
    int radius2 = 16;
    int radius3 = 12;
    int radius4 = 8;
    int radius5 = 4;
    int distance;
    int NUMBER_OF_CIRCLES = 5;
    int bullesEyeDistance;

    public Target() {
        this.position = LevelInfo.levelBackGround == 0 ? new Point((float)GameManager.screenWidth * 0.3166f, (float)GameManager.screenHeight * 0.53f) : new Point((float)GameManager.screenWidth * 0.31f, (float)GameManager.screenHeight * 0.52f);
        this.left = (int)(this.position.X - (float)(this.target.getWidth() / 2));
        this.right = (int)(this.position.X + (float)(this.target.getWidth() / 2));
        this.top = (int)(this.position.Y - (float)this.target.getHeight() * 0.328125f);
        this.bottom = (int)(this.position.Y + (float)(this.target.getHeight() / 2));
        this.velocity = new Point(0.0f, 2.0f);
    }

    public void initialize() {
    }

    public void updateObject() {
        if ((float)this.left < (float)GameManager.screenWidth * 0.25f || (float)this.right > (float)GameManager.screenWidth * 0.75f) {
            this.velocity.X = -this.velocity.X;
        }
        this.position.X += this.velocity.X;
        this.updateBounds();
    }

    void updateBounds() {
        this.left = (int)(this.position.X - (float)(this.target.getWidth() / 2));
        this.right = (int)(this.position.X + (float)(this.target.getWidth() / 2));
        this.top = (int)(this.position.Y - (float)this.target.getHeight() * 0.328125f);
        this.bottom = (int)(this.position.Y + (float)this.target.getHeight() * 0.328125f);
    }

    public void paintObject(Graphics g2) {
        Bitmap.drawBitmap(g2, this.target, (int)(this.position.X - (float)(this.target.getWidth() / 2)), (int)(this.position.Y - (float)this.target.getHeight() * 0.328f));
    }

    public boolean onCollision(GameObject go) {
        return false;
    }

    public void animationStateComplete(int currentState) {
    }

    public int getPoints(float x, float y) {
        this.bullesEyeDistance = 3;
        if (Math.abs(GameObjectManager.player.target.Y - GameObjectManager.target.position.Y) < (float)this.bullesEyeDistance && Math.abs(GameObjectManager.player.target.X - GameObjectManager.target.position.X) < 1.0f) {
            Debug.print("BullsEye");
            return 32;
        }
        int level = -1;
        for (int i = 0; i < this.NUMBER_OF_CIRCLES && this.isPointInsideCircle(x, y, Constants.TARGET_RADIUS_ARRAY[i]); ++i) {
            ++level;
        }
        if (level == -1) {
            return 0;
        }
        return Constants.TARGET_POINT_ARRAY[level];
    }

    public boolean isPointInsideCircle(float x, float y, float radius) {
        float X = (x - this.position.X) * (x - this.position.X);
        float Y = (y - this.position.Y) * (y - this.position.Y);
        return X + Y < radius * radius;
    }
}

