/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameObject;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.SpriteFrame;
import com.renderedideas.yourgamename.BitmapCacher;
import com.renderedideas.yourgamename.GameplayView;
import javax.microedition.lcdui.Graphics;

public class Player
extends GameObject {
    static final int MAX_HORIZONTAL_SWAY = 4;
    static final int MAX_VERTICAL_SWAY = 4;
    static float TARGET_X_OFFSET;
    static float TARGET_Y_OFFSET;
    SpriteFrame[] bow = BitmapCacher.bowAnimation;
    SpriteFrame[] arrow;
    public static int leftBound;
    public static int rightBound;
    public static int topBound;
    public static int bottomBound;
    static float velocityMultiplyer;
    public Point target;
    Point swayPoint;
    long lastSwayTime;
    public static int currentState;
    int arrowFrameDuration;
    Point bowDefaultPosition;
    long bowFireAnimationTime = -1L;
    Bitmap crossHair = BitmapCacher.crossHair;
    float minSpeedForKeyEvent;
    float maxSpeedForKeyEvent;
    float resetSpeedKey;
    int arrowIndex = -1;
    long frameCurrentTime = -1L;

    public Player() {
        leftBound = (int)((float)GameManager.screenWidth * 0.25f);
        rightBound = (int)((float)GameManager.screenWidth * 0.89f);
        topBound = (int)((float)GameManager.screenHeight * 0.53f);
        bottomBound = (int)((float)GameManager.screenHeight * 0.76f);
        this.velocity = new Point();
        this.position = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenWidth * 0.65f);
        this.bowDefaultPosition = new Point(this.position.X, this.position.Y);
        TARGET_X_OFFSET = (float)this.bow[0].width * 0.3224f;
        TARGET_Y_OFFSET = (float)this.bow[0].height * 0.4255f;
        this.target = new Point(this.position.X - (float)(this.bow[0].width / 2) + TARGET_X_OFFSET, this.position.Y - (float)(this.bow[0].height / 2) + TARGET_Y_OFFSET);
        this.swayPoint = new Point(this.position.X, this.position.Y);
        currentState = 1;
        this.bowFireAnimationTime = -1L;
        this.maxSpeedForKeyEvent = 5.0f;
        this.minSpeedForKeyEvent = this.resetSpeedKey = 2.0f;
        Debug.print("player");
    }

    public void initialize() {
    }

    public void updateObject() {
        if (currentState == 0) {
            this.bowFireAnimationTime = -1L;
        }
        if (Math.abs(this.velocity.X) > 0.0f && Math.abs(this.velocity.Y) > 0.0f) {
            this.moveBow();
        } else if (GameplayView.time - this.lastSwayTime > 500L) {
            this.setSwayPoint();
        } else {
            this.applySway();
        }
    }

    public void applySway() {
        if (GameplayView.arrowAirTime < 0L) {
            this.position.X = Utility.lerp(this.position.X, this.swayPoint.X, 0.1f);
            this.position.Y = Utility.lerp(this.position.Y, this.swayPoint.Y, 0.1f);
            this.restrictBow();
            this.moveTargetPoint();
        }
    }

    public void setSwayPoint() {
        this.lastSwayTime = GameplayView.time;
        this.swayPoint.X = this.position.X + 4.0f - (float)PlatformService.nextInt(9);
        this.swayPoint.Y = this.position.Y + 4.0f - (float)PlatformService.nextInt(9);
        this.applySway();
    }

    public void moveBow() {
        this.position.X += this.velocity.X * velocityMultiplyer;
        this.position.Y += this.velocity.Y * velocityMultiplyer;
        this.restrictBow();
        this.moveTargetPoint();
    }

    public void moveTargetPoint() {
        this.target.X = this.position.X - (float)(this.bow[Player.currentState].width / 2) + TARGET_X_OFFSET;
        this.target.Y = this.position.Y - (float)(this.bow[Player.currentState].height / 2) + TARGET_Y_OFFSET;
    }

    public void restrictBow() {
        if (this.position.X > (float)rightBound) {
            this.position.X = rightBound;
        }
        if (this.position.X < (float)leftBound) {
            this.position.X = leftBound;
        }
        if (this.position.Y < (float)topBound) {
            this.position.Y = topBound;
        }
        if (this.position.Y > (float)bottomBound) {
            this.position.Y = bottomBound;
        }
    }

    public void paintObject(Graphics g2) {
        Bitmap.drawSprite(g2, this.bow[currentState], (int)(this.position.X - (float)(this.bow[Player.currentState].width / 2)) + this.arrowIndex * 2, (int)(this.position.Y - (float)(this.bow[Player.currentState].height / 2)));
        if (GameplayView.arrowAirTime <= -1L) {
            this.arrowIndex = 0;
        }
        Bitmap.drawBitmap(g2, this.crossHair, (int)(this.target.X - (float)(this.crossHair.getWidth() / 2)), (int)(this.target.Y - (float)(this.crossHair.getHeight() / 2)));
    }

    void updateArrowFrame() {
    }

    public boolean onCollision(GameObject go) {
        return false;
    }

    public void animationStateComplete(int currentState) {
    }

    public void setVelocity(int x1, int y1, int x2, int y2) {
        int X = x1 - x2;
        int Y = y1 - y2;
        float mag = X * X + Y * Y;
        velocityMultiplyer = (mag = (float)Math.sqrt(mag)) > 40.0f ? 1.5f : (mag > 20.0f ? 1.0f : 0.5f);
        this.velocity.X = (float)X / mag;
        this.velocity.Y = (float)Y / mag;
    }

    public void resetBowPosition() {
        this.position.X = this.bowDefaultPosition.X;
        this.position.Y = this.bowDefaultPosition.Y;
    }

    public void movementInKeyPress(String str) {
        this.minSpeedForKeyEvent = this.resetSpeedKey;
        if (str == "right") {
            this.minSpeedForKeyEvent = Utility.lerp(this.minSpeedForKeyEvent, this.maxSpeedForKeyEvent, 0.1f);
            this.position.X += this.minSpeedForKeyEvent;
        } else if (str == "left") {
            this.minSpeedForKeyEvent = Utility.lerp(this.minSpeedForKeyEvent, this.maxSpeedForKeyEvent, 0.1f);
            this.position.X -= this.minSpeedForKeyEvent;
        }
        if (str == "down") {
            this.minSpeedForKeyEvent = Utility.lerp(this.minSpeedForKeyEvent, this.maxSpeedForKeyEvent, 0.1f);
            this.position.Y += this.minSpeedForKeyEvent;
        } else if (str == "up") {
            this.minSpeedForKeyEvent = Utility.lerp(this.minSpeedForKeyEvent, this.maxSpeedForKeyEvent, 0.1f);
            this.position.Y -= this.minSpeedForKeyEvent;
        }
    }

    static {
        velocityMultiplyer = 1.0f;
    }
}

