/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Shape;
import at.emini.physics2D.Spring;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.BodyImage;
import com.renderedideas.gamemanager.ColorRGBA;
import com.renderedideas.gamemanager.UserData;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.gamemanager.Utility3D;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.DictionaryKeyValue;
import com.renderedideas.platform.LoadResources;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Box2DHelper {
    public static final ColorRGBA STATIC_BODY_COLOR = ColorRGBA.Green;
    public static final ColorRGBA DYNAMIC_BODY_COLOR = ColorRGBA.Red;
    public static final ColorRGBA KINEMATIC_BODY_COLOR = ColorRGBA.White;
    public static final ColorRGBA SENSOR_COLOR = ColorRGBA.Yellow;
    public static final ColorRGBA DISABLED_BODY_COLOR = ColorRGBA.Gray;
    public static final ColorRGBA JOINT_COLOR = ColorRGBA.Black;
    public static final int DRAW_LINE_WIDTH = 5;
    public static final float DRAWING_CULL_DISTANCE = 400.0f;
    public static DictionaryKeyValue bodies;
    public static DictionaryKeyValue fixtures;
    public static DictionaryKeyValue joints;
    private static FXVector[] rotatedVertices;

    public static void initStatics() {
        bodies = new DictionaryKeyValue();
        fixtures = new DictionaryKeyValue();
        joints = new DictionaryKeyValue();
        rotatedVertices = new FXVector[100];
        for (int i = 0; i < rotatedVertices.length; ++i) {
            Box2DHelper.rotatedVertices[i] = new FXVector();
        }
    }

    public static void load(World world, String filePath, float positionX, float positionY, boolean initializeEnabled) throws Exception {
        String name;
        int i;
        Debug.print("Loading... " + filePath, (short)1);
        String json = LoadResources.loadFileAsString(filePath);
        JSONObject jWorld = new JSONObject(json);
        Body[] bodyArray = new Body[jWorld.getJSONArray("body").length()];
        int bodyIndex = 0;
        for (i = 0; i < bodyArray.length; ++i) {
            JSONObject jBody = jWorld.getJSONArray("body").optJSONObject(i);
            name = Box2DHelper.getString(jBody.getString("name"));
            int type = Box2DHelper.getInt(jBody.getString("type"));
            float angle = Box2DHelper.getFloat(jBody.getString("angle"));
            float angularDamping = Box2DHelper.getFloat(jBody.getString("angularDamping"));
            float angularVelocity = Box2DHelper.getFloat(jBody.getString("angularVelocity"));
            boolean awake = Box2DHelper.getBool(jBody.getString("awake"));
            boolean bullet = Box2DHelper.getBool(jBody.getString("bullet"));
            boolean fixedRotation = Box2DHelper.getBool(jBody.getString("fixedRotation"));
            float linearDamping = Box2DHelper.getFloat(jBody.getString("linearDamping"));
            FXVector linearVelocity = Box2DHelper.getVector2(jBody.optJSONObject("linearVelocity"));
            float massData_mass = Box2DHelper.getFloat(jBody.getString("massData-mass"));
            FXVector massData_center = Box2DHelper.getVector2(jBody.optJSONObject("massData-center"));
            float massData_I = Box2DHelper.getFloat(jBody.getString("massData-I"));
            FXVector position = Box2DHelper.getVector2(jBody.optJSONObject("position"));
            position.xFX += positionX * 1.0f;
            position.yFX += -positionY * 1.0f;
            DictionaryKeyValue bodyCustomProperties = Box2DHelper.getCustomProperties(jBody.optJSONArray("customProperties"));
            Body body = Box2DHelper.createBody(world, name, type == 0 ? false : (type == 1 ? true : true), angle, angularDamping, angularVelocity, awake, bullet, fixedRotation, linearVelocity, linearDamping, position, initializeEnabled, true, filePath, bodyCustomProperties);
            bodyArray[bodyIndex++] = body;
            float massData = massData_mass;
            for (int j = 0; j < jBody.getJSONArray("fixture").length(); ++j) {
                FXVector[] vertices;
                JSONObject jFixture = jBody.getJSONArray("fixture").optJSONObject(j);
                String fixtureName = Box2DHelper.getString(jFixture.getString("name"));
                float density = Box2DHelper.getFloat(jFixture.getString("density"));
                int filter_categoryBits = jFixture.getString("filter-categoryBits") == null ? 1 : Box2DHelper.getInt(jFixture.getString("filter-categoryBits"));
                int filter_maskBits = jFixture.getString("filter-maskBits") == null ? 65535 : Box2DHelper.getInt(jFixture.getString("filter-maskBits"));
                int filter_groupIndex = Box2DHelper.getInt(jFixture.getString("filter-groupIndex, null"));
                float friction = Box2DHelper.getFloat(jFixture.getString("friction"));
                float restitution = Box2DHelper.getFloat(jFixture.getString("restitution"));
                boolean sensor = Box2DHelper.getBool(jFixture.getString("sensor"));
                DictionaryKeyValue fixtureCustomProperties = Box2DHelper.getCustomProperties(jFixture.optJSONArray("customProperties"));
                if (jFixture.opt("circle") != null) {
                    FXVector center = Box2DHelper.getVector2(jFixture.optJSONObject("circle").optJSONObject("center"));
                    float radius = Box2DHelper.getFloat(jFixture.optJSONObject("circle").getString("radius"));
                    Box2DHelper.createCircleFixture(body, fixtureName, center, radius, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, filePath, fixtureCustomProperties);
                    continue;
                }
                if (jFixture.opt("polygon") != null) {
                    vertices = Box2DHelper.getVectors(jFixture.optJSONObject("polygon").optJSONObject("vertices"));
                    Box2DHelper.createPolygonFixture(body, fixtureName, vertices, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, filePath, fixtureCustomProperties);
                    continue;
                }
                if (jFixture.opt("chain") == null) continue;
                vertices = Box2DHelper.getVectors(jFixture.optJSONObject("chain").optJSONObject("vertices"));
                boolean hasNextVertex = Box2DHelper.getBool(jFixture.optJSONObject("chain").optString("hasNextVertex"));
                boolean hasPrevVertex = Box2DHelper.getBool(jFixture.optJSONObject("chain").optString("hasPrevVertex"));
                FXVector nextVertex = Box2DHelper.getVector2(jFixture.optJSONObject("chain").optJSONObject("nextVertex"));
                FXVector prevVertex = Box2DHelper.getVector2(jFixture.optJSONObject("chain").optJSONObject("prevVertex"));
                for (int ii = 0; ii < vertices.length - 1; ++ii) {
                    FXVector startPoint = vertices[ii];
                    FXVector endPoint = vertices[ii + 1];
                    if (ii == 0) {
                        Box2DHelper.createEdgeFixture(body, fixtureName, startPoint, endPoint, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, filePath, fixtureCustomProperties);
                        continue;
                    }
                    Body body1 = Box2DHelper.createBody(world, name + "_" + fixtureName, type == 0 ? false : (type == 1 ? true : true), angle, angularDamping, angularVelocity, awake, bullet, fixedRotation, linearVelocity, linearDamping, position, initializeEnabled, true, filePath, bodyCustomProperties);
                    Box2DHelper.createEdgeFixture(body1, fixtureName, startPoint, endPoint, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, filePath, fixtureCustomProperties);
                }
            }
        }
        if (jWorld.opt("image") != null) {
            for (i = 0; i < jWorld.getJSONArray("image").length(); ++i) {
                int ii;
                int[] nArray;
                JSONObject jImage = jWorld.getJSONArray("image").optJSONObject(i);
                name = Box2DHelper.getString(jImage.getString("name"));
                float opacity = Box2DHelper.getFloat(jImage.getString("opacity"));
                float renderOrder = Box2DHelper.getFloat(jImage.getString("renderOrder"));
                float scale = Box2DHelper.getFloat(jImage.getString("scale"));
                float aspectScale = Box2DHelper.getFloat(jImage.getString("aspectScale"));
                float angle = Box2DHelper.getFloat(jImage.getString("angle"));
                int body = Box2DHelper.getInt(jImage.getString("body"));
                FXVector center = Box2DHelper.getVector2(jImage.optJSONObject("center"));
                FXVector[] corners = Box2DHelper.getVectors(jImage.optJSONObject("corners"));
                String file = Box2DHelper.getString(jImage.getString("file"));
                int filter = Box2DHelper.getInt(jImage.getString("filter"));
                boolean flip = Box2DHelper.getBool(jImage.getString("flip"));
                if (jImage.getString("colorTint") == null) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = 255;
                    nArray2[1] = 255;
                    nArray2[2] = 255;
                    nArray = nArray2;
                    nArray2[3] = 255;
                } else {
                    nArray = Box2DHelper.getIntArray(jImage.getJSONArray("colorTint"));
                }
                int[] colorTint = nArray;
                int[] triangles = Box2DHelper.getIntArray(jImage.optJSONArray("glDrawElements"));
                triangles = Utility.getReverseArray(triangles);
                FXVector[] uvs = Box2DHelper.getVector2D(jImage.optJSONArray("glTexCoordPointer"));
                FXVector[] vertices = Box2DHelper.getVector2D(jImage.optJSONArray("glVertexPointer"));
                for (ii = 0; ii < vertices.length; ++ii) {
                    vertices[ii].yFX *= -1.0f;
                    vertices[ii] = Utility.mul(vertices[ii], 1.0f);
                }
                for (ii = 0; ii < uvs.length; ++ii) {
                    uvs[ii].yFX = 1.0f - uvs[ii].yFX;
                }
                DictionaryKeyValue imageCustomProperties = Box2DHelper.getCustomProperties(jImage.optJSONArray("customProperties"));
                Box2DHelper.createBodyImage(world, file, opacity, renderOrder, scale, aspectScale, angle, bodyArray[body], center, corners, new Bitmap(file), filter, flip, new ColorRGBA(colorTint[0], colorTint[1], colorTint[2], colorTint[3]), triangles, uvs, vertices, imageCustomProperties);
            }
        }
        if (jWorld.opt("joint") != null) {
            for (int k = 0; k < jWorld.getJSONArray("joint").length(); ++k) {
                float upperLimit;
                float refAngle;
                float motorSpeed;
                float lowerLimit;
                JSONObject jJoint = jWorld.getJSONArray("joint").optJSONObject(k);
                String type = Box2DHelper.getString(jJoint.getString("type"));
                String jointName = Box2DHelper.getString(jJoint.getString("name"));
                FXVector anchorA = Box2DHelper.getVector2(jJoint.optJSONObject("anchorA"));
                FXVector anchorB = Box2DHelper.getVector2(jJoint.optJSONObject("anchorB"));
                int bodyA = Box2DHelper.getInt(jJoint.getString("bodyA"));
                int bodyB = Box2DHelper.getInt(jJoint.getString("bodyB"));
                boolean collideConnected = Box2DHelper.getBool(jJoint.getString("collideConnected"));
                DictionaryKeyValue jointCustomProperties = Box2DHelper.getCustomProperties(jJoint.optJSONArray("customProperties"));
                if (type.equals("revolute")) {
                    boolean enableLimit = Box2DHelper.getBool(jJoint.getString("enableLimit"));
                    boolean enableMotor = Box2DHelper.getBool(jJoint.getString("enableMotor"));
                    float jointSpeed = Box2DHelper.getFloat(jJoint.getString("jointSpeed"));
                    lowerLimit = Box2DHelper.getFloat(jJoint.getString("lowerLimit"));
                    float maxMotorTorque = Box2DHelper.getFloat(jJoint.getString("maxMotorTorque"));
                    motorSpeed = Box2DHelper.getFloat(jJoint.getString("motorSpeed"));
                    refAngle = Box2DHelper.getFloat(jJoint.getString("refAngle"));
                    upperLimit = Box2DHelper.getFloat(jJoint.getString("upperLimit"));
                    Box2DHelper.createRevoluteJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, collideConnected, enableLimit, enableMotor, lowerLimit, maxMotorTorque, motorSpeed, refAngle, upperLimit, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("distance")) {
                    float dampingRatio = Box2DHelper.getFloat(jJoint.getString("dampingRatio"));
                    float frequency = Box2DHelper.getFloat(jJoint.getString("frequency"));
                    float length = Box2DHelper.getFloat(jJoint.getString("length"));
                    Box2DHelper.createDistanceJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, collideConnected, dampingRatio, frequency, length, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("prismatic")) {
                    boolean enableLimit = Box2DHelper.getBool(jJoint.getString("enableLimit"));
                    boolean enableMotor = Box2DHelper.getBool(jJoint.getString("enableMotor"));
                    FXVector localAxisA = Box2DHelper.getVector2(jJoint.optJSONObject("localAxisA"));
                    lowerLimit = Box2DHelper.getFloat(jJoint.getString("lowerLimit"));
                    float maxMotorForce = Box2DHelper.getFloat(jJoint.getString("maxMotorForce"));
                    motorSpeed = Box2DHelper.getFloat(jJoint.getString("motorSpeed"));
                    refAngle = Box2DHelper.getFloat(jJoint.getString("refAngle"));
                    upperLimit = Box2DHelper.getFloat(jJoint.getString("upperLimit"));
                    Box2DHelper.createPrismaticJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, localAxisA, collideConnected, enableLimit, enableMotor, lowerLimit, maxMotorForce, motorSpeed, refAngle, upperLimit, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("wheel")) {
                    boolean enableMotor = Box2DHelper.getBool(jJoint.getString("enableMotor"));
                    FXVector localAxisA = Box2DHelper.getVector2(jJoint.optJSONObject("localAxisA"));
                    float maxMotorTorque = Box2DHelper.getFloat(jJoint.getString("maxMotorTorque"));
                    float motorSpeed2 = Box2DHelper.getFloat(jJoint.getString("motorSpeed"));
                    float springDampingRatio = Box2DHelper.getFloat(jJoint.getString("springDampingRatio"));
                    float springFrequency = Box2DHelper.getFloat(jJoint.getString("springFrequency"));
                    Box2DHelper.createWheelJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, localAxisA, collideConnected, enableMotor, maxMotorTorque, motorSpeed2, springDampingRatio, springFrequency, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("rope")) {
                    float maxLength = Box2DHelper.getFloat(jJoint.getString("maxLength"));
                    Box2DHelper.createRopeJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, collideConnected, maxLength, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("motor")) {
                    float maxForce = Box2DHelper.getFloat(jJoint.getString("maxForce"));
                    float maxTorque = Box2DHelper.getFloat(jJoint.getString("maxTorque"));
                    float correctionFactor = Box2DHelper.getFloat(jJoint.getString("correctionFactor"));
                    Box2DHelper.createMotorJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], collideConnected, maxForce, maxTorque, filePath, jointCustomProperties);
                    continue;
                }
                if (type.equals("weld")) {
                    float refAngle2 = Box2DHelper.getFloat(jJoint.getString("refAngle"));
                    float dampingRatio = Box2DHelper.getFloat(jJoint.getString("dampingRatio"));
                    float frequency = Box2DHelper.getFloat(jJoint.getString("frequency"));
                    Box2DHelper.createWeldJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, collideConnected, refAngle2, dampingRatio, frequency, filePath, jointCustomProperties);
                    continue;
                }
                if (!type.equals("friction")) continue;
                float maxForce = Box2DHelper.getFloat(jJoint.getString("maxForce"));
                float maxTorque = Box2DHelper.getFloat(jJoint.getString("maxTorque"));
                Box2DHelper.createFrictionJoint(world, jointName, bodyArray[bodyA], bodyArray[bodyB], anchorA, anchorB, collideConnected, maxForce, maxTorque, filePath, jointCustomProperties);
            }
        }
    }

    public static World loadWorld(String filePath, boolean initializeEnabled) throws Exception {
        String json = LoadResources.loadFileAsString(filePath);
        JSONObject jWorld = new JSONObject(json);
        FXVector gravity = Box2DHelper.getVector2(jWorld.optJSONObject("gravity"));
        boolean allowSleep = Box2DHelper.getBool(jWorld.getString("allowSleep"));
        boolean autoClearForces = Box2DHelper.getBool(jWorld.getString("autoClearForces"));
        int positionIterations = Box2DHelper.getInt(jWorld.getString("positionIterations"));
        int velocityIterations = Box2DHelper.getInt(jWorld.getString("velocityIterations"));
        int stepsPerSecond = Box2DHelper.getInt(jWorld.getString("stepsPerSecond"));
        boolean warmStarting = Box2DHelper.getBool(jWorld.getString("warmStarting"));
        boolean continuousPhysics = Box2DHelper.getBool(jWorld.getString("continuousPhysics"));
        boolean subStepping = Box2DHelper.getBool(jWorld.getString("subStepping"));
        World world = new World();
        world.setGravity(gravity);
        Box2DHelper.load(world, filePath, 0.0f, 0.0f, initializeEnabled);
        return world;
    }

    public static Body createBody(World world, String name, boolean bodyType, float angle, float angularDamping, float angularVelocity, boolean awake, boolean bullet, boolean fixedRotation, FXVector linearVelocity, float linearDamping, FXVector position, boolean initializeEnabled, boolean sleepAllowed, String filePath, DictionaryKeyValue customProperties) {
        Body body = new Body(position, Shape.createCircle(1), bodyType);
        body.setRotation2FX(angle);
        body.setRotatable(!fixedRotation);
        world.addBody(body);
        body.setUserData(new UserData(name, customProperties));
        bodies.put(filePath + ">" + name, body);
        Debug.print("Added body: " + filePath + ">" + name, (short)1);
        return body;
    }

    public static Shape createCircleFixture(Body body, String fixtureName, FXVector center, float radius, float density, int filter_categoryBits, int filter_maskBits, int filter_groupIndex, float friction, float restitution, boolean sensor, float massData, String filePath, DictionaryKeyValue customProperties) {
        Shape fixture = Shape.createCircle((int)radius);
        fixture.getBoundingRadiusFX();
        fixture.setMassFX(massData);
        fixture.setElasticityFX(restitution);
        fixture.setFrictionFX(friction);
        body.addCollisionLayer(filter_categoryBits);
        body.setShape(fixture);
        ((UserData)body.getUserData()).isSetShape = true;
        fixture.setUserData(new UserData(fixtureName, customProperties, body));
        fixtures.put(filePath + ">" + ((UserData)body.getUserData()).name + ">" + fixtureName, fixture);
        Debug.print("Added Fixture: " + filePath + ">" + ((UserData)body.getUserData()).name + ">" + fixtureName, (short)1);
        return fixture;
    }

    public static Shape createPolygonFixture(Body body, String fixtureName, FXVector[] verts, float density, int filter_categoryBits, int filter_maskBits, int filter_groupIndex, float friction, float restitution, boolean sensor, float massData, String filePath, DictionaryKeyValue customProperties) {
        FXVector[] v = Utility.getReverseArray(verts);
        Shape fixture = new Shape(v);
        fixture.setMassFX(massData);
        fixture.setElasticityFX(restitution);
        fixture.setFrictionFX(friction);
        body.addCollisionLayer(filter_categoryBits);
        body.setShape(fixture);
        ((UserData)body.getUserData()).isSetShape = true;
        fixture.setUserData(new UserData(fixtureName, customProperties, body));
        fixtures.put(filePath + ">" + ((UserData)body.getUserData()).name + ">" + fixtureName, fixture);
        Debug.print("Added Fixture: " + filePath + ">" + ((UserData)body.getUserData()).name + ">" + fixtureName, (short)1);
        return fixture;
    }

    public static Shape createEdgeFixture(Body body, String fixtureName, FXVector startPoint, FXVector endPoint, float density, int filter_categoryBits, int filter_maskBits, int filter_groupIndex, float friction, float restitution, boolean sensor, float massData, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("Edge Simulated with polygon", (short)1);
        Debug.print("pos:" + body.positionFX().xFX + ", " + body.positionFX().yFX);
        Debug.print("start:" + startPoint.xFX + ", " + startPoint.yFX);
        Debug.print("end:" + endPoint.xFX + ", " + endPoint.yFX);
        FXVector[] verts = new FXVector[]{endPoint, startPoint, Utility.add(startPoint, new FXVector(0.0f, -5.0f)), Utility.add(endPoint, new FXVector(0.0f, -5.0f))};
        return Box2DHelper.createPolygonFixture(body, fixtureName, verts, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, filePath, customProperties);
    }

    public static Joint createRevoluteJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, boolean collideConnected, boolean enableLimit, boolean enableMotor, float lowerLimit, float maxMotorTorque, float motorSpeed, float refAngle, float upperLimit, String filePath, DictionaryKeyValue customProperties) {
        Joint joint = new Joint(bodyA, bodyB, anchorA, anchorB, false);
        world.addConstraint(joint);
        joint.setUserData(new UserData(jointName, customProperties));
        joints.put(filePath + ">" + jointName, joint);
        Debug.print("Added Joint: " + filePath + ">" + jointName, (short)1);
        return joint;
    }

    public static Spring createDistanceJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, boolean collideConnected, float dampingRatio, float frequency, float length, String filePath, DictionaryKeyValue customProperties) {
        Spring joint = new Spring(bodyA, bodyB, anchorA, anchorB, -1);
        joint.setCoefficientFX(dampingRatio);
        world.addConstraint(joint);
        joint.setUserData(new UserData(jointName, customProperties));
        joints.put(filePath + ">" + jointName, joint);
        Debug.print("Added Joint: " + filePath + ">" + jointName, (short)1);
        return joint;
    }

    public static Joint createPrismaticJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, FXVector localAxisA, boolean collideConnected, boolean enableLimit, boolean enableMotor, float lowerLimit, float maxMotorForce, float motorSpeed, float refAngle, float upperLimit, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("Prismatic joint not supported!!!", (short)2);
        return null;
    }

    public static Joint createWheelJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, FXVector localAxisA, boolean collideConnected, boolean enableMotor, float maxMotorTorque, float motorSpeed, float springDampingRatio, float springFrequency, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("WHEEL JOINT NOT SUPPORTED!!!!", (short)2);
        return null;
    }

    public static Joint createRopeJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, boolean collideConnected, float maxLength, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("ROPE JOINT NOT SUPPORTED!!!!", (short)2);
        return null;
    }

    public static Joint createMotorJoint(World world, String jointName, Body bodyA, Body bodyB, boolean collideConnected, float maxForce, float maxTorque, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("MOTOR JOINT NOT SUPPORTED!!!!", (short)2);
        return null;
    }

    public static Joint createWeldJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, boolean collideConnected, float refAngle, float dampingRatio, float frequency, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("WELD JOINT NOT SUPPORTED!!!!", (short)2);
        return null;
    }

    public static Joint createFrictionJoint(World world, String jointName, Body bodyA, Body bodyB, FXVector anchorA, FXVector anchorB, boolean collideConnected, float maxForce, float maxTorque, String filePath, DictionaryKeyValue customProperties) {
        Debug.print("FRICTION JOINT NOT SUPPORTED!!!!", (short)2);
        return null;
    }

    public static BodyImage createBodyImage(World world, String name, float opacity, float renderOrder, float scale, float aspectScale, float angle, Body body, FXVector center, FXVector[] corners, Bitmap bitmap, int filter, boolean flip, ColorRGBA tintColor, int[] triangles, FXVector[] uvs, FXVector[] vertices, DictionaryKeyValue customProperties) {
        BodyImage bodyImage = new BodyImage();
        bodyImage.name = name;
        bodyImage.opacity = opacity;
        bodyImage.renderOrder = renderOrder;
        bodyImage.scale = scale;
        bodyImage.aspectScale = aspectScale;
        bodyImage.angle = angle;
        bodyImage.body = body;
        bodyImage.center = center;
        bodyImage.corners = corners;
        bodyImage.bitmap = bitmap;
        bodyImage.filter = filter;
        bodyImage.flip = flip;
        bodyImage.colorTint = tintColor;
        bodyImage.strips = triangles;
        short[] uv = new short[uvs.length * 2];
        int j = 0;
        for (int i = 0; i < uvs.length; ++i) {
            uv[j++] = (short)(uvs[i].xFX * 255.0f);
            uv[j++] = (short)(uvs[i].yFX * 255.0f);
        }
        bodyImage.uvs = uv;
        short[] verts = new short[vertices.length * 3];
        j = 0;
        for (int i = 0; i < vertices.length; ++i) {
            verts[j++] = (short)vertices[i].xFX;
            verts[j++] = (short)vertices[i].yFX;
            verts[j++] = 0;
        }
        bodyImage.vertices = verts;
        ArrayList list = Utility3D.getTrianglesFromStrip(bodyImage.vertices, bodyImage.uvs, bodyImage.strips);
        bodyImage.vertices = (short[])list.elementAt(0);
        bodyImage.uvs = (short[])list.elementAt(1);
        bodyImage.strips = (int[])list.elementAt(2);
        bodyImage.customProperties = customProperties;
        ((UserData)body.getUserData()).bodyImageList.addElement(bodyImage);
        Box2DHelper.sortByRenderOrder(world);
        return bodyImage;
    }

    private static short[] getShortArray(int[] triangles) {
        short[] inShort = new short[triangles.length];
        for (int i = 0; i < inShort.length; ++i) {
            inShort[i] = (short)triangles[i];
        }
        return inShort;
    }

    public static void removeBody(World box2dWorld, String bodyKey) {
        Debug.print("removeBody: " + bodyKey);
        Body body = (Body)bodies.remove(bodyKey);
        Shape fixture = body.shape();
        fixtures.remove(bodyKey + ">" + ((UserData)fixture.getUserData()).name);
        box2dWorld.removeBody(body);
    }

    public static void removeJoint(World box2dWorld, String jointKey) {
        Joint joint = (Joint)joints.remove(jointKey);
        box2dWorld.removeConstraint(joint);
    }

    public static void removeFixture(World box2dWorld, String fixtureKey) {
    }

    private static void sortByRenderOrder(World world) {
        Debug.print("SORT BY RENDER ORDER NOT IMPLEMENTED YET!!!", (short)2);
    }

    public static void drawBody(Graphics target, Graphics3D target3D, Body body, float startX, float startY, int screenWidth, int screenHeight, boolean drawLines, boolean drawImages) {
        if (drawImages) {
            int count = ((UserData)body.getUserData()).bodyImageList.size();
            for (int k = 0; k < count; ++k) {
                BodyImage bodyImage = (BodyImage)((UserData)body.getUserData()).bodyImageList.elementAt(k);
                float positionX = body.positionFX().xFX * 1.0f;
                float positionY = -body.positionFX().yFX * 1.0f;
                float angle = (float)((double)(body.rotation2FX() * 180.0f) / Math.PI);
                Bitmap.drawTexturedPolygon(target3D, bodyImage.vertices, bodyImage.uvs, positionX -= (float)((int)startX), positionY -= (float)((int)startY), bodyImage.renderOrder, angle, bodyImage.strips, (Bitmap)bodyImage.bitmap, 1.0f, 1.0f);
            }
        }
        if (drawLines) {
            Shape fixture;
            Shape shape = fixture = body.shape();
            ColorRGBA drawColor = STATIC_BODY_COLOR;
            if (body.isDynamic()) {
                drawColor = DYNAMIC_BODY_COLOR;
            }
            boolean POLYGON_SHAPE = true;
            int CIRCLE_SHAPE = 2;
            int shapeType = 1;
            if (body.getVertices().length == 1) {
                shapeType = 2;
            }
            switch (shapeType) {
                case 1: {
                    Shape polygonShape = shape;
                    int vertexCount = polygonShape.getCorners().length;
                    float rotation = (float)((double)(body.rotation2FX() * 180.0f) / Math.PI);
                    FXVector[] vertices = polygonShape.getCorners();
                    for (int j = 0; j < vertexCount; ++j) {
                        FXVector vertex = Utility.add(vertices[j], body.positionFX());
                        Box2DHelper.rotatedVertices[j].xFX = Utility.getRotatedPointX(body.positionFX().xFX, body.positionFX().yFX, vertex.xFX, vertex.yFX, -rotation);
                        Box2DHelper.rotatedVertices[j].yFX = Utility.getRotatedPointY(body.positionFX().xFX, body.positionFX().yFX, vertex.xFX, vertex.yFX, -rotation);
                        Box2DHelper.rotatedVertices[j] = Utility.mul(rotatedVertices[j], 1.0f);
                        Box2DHelper.rotatedVertices[j].yFX = -Box2DHelper.rotatedVertices[j].yFX;
                        Box2DHelper.rotatedVertices[j].xFX -= startX;
                        Box2DHelper.rotatedVertices[j].yFX -= startY;
                    }
                    Bitmap.fillColor(target, (int)(body.positionFX().xFX * 1.0f - startX) - 2, (int)(-body.positionFX().yFX * 1.0f - startY) - 2, 4, 4, drawColor.R, drawColor.G, drawColor.B);
                    Bitmap.drawPolygon(target, rotatedVertices, 5, vertexCount, drawColor.R, drawColor.G, drawColor.B, drawColor.A);
                    break;
                }
                case 2: {
                    Shape circleShape = shape;
                    float rotation = (float)((double)(body.rotation2FX() * 180.0f) / Math.PI);
                    FXVector center = Utility.add(circleShape.getCorners()[0], body.positionFX());
                    center.yFX -= circleShape.getBoundingRadiusFX();
                    float x = Utility.getRotatedPointX(body.positionFX().xFX, body.positionFX().yFX, center.xFX, center.yFX, -rotation);
                    float y = Utility.getRotatedPointY(body.positionFX().xFX, body.positionFX().yFX, center.xFX, center.yFX, -rotation);
                    center.xFX = x;
                    center.yFX = -y;
                    center = Utility.mul(center, 1.0f);
                    center.xFX -= startX;
                    center.yFX -= startY;
                    Bitmap.drawCircle(target, center, circleShape.getBoundingRadiusFX() * 1.0f, 5, 16, drawColor.R, drawColor.G, drawColor.B, drawColor.A);
                }
            }
        }
    }

    public static void drawJoint(Graphics target, Constraint joint, float startX, float startY, int screenWidth, int screenHeight) {
    }

    public static void drawWorld(Graphics target, Graphics3D target3D, World world, float startX, float startY, int screenWidth, int screenHeight, boolean drawLines, boolean drawJoints, boolean drawImages) {
        int bodyCount = world.getBodyCount();
        Body[] bodies = world.getBodies();
        for (int i = 0; i < bodyCount; ++i) {
            Box2DHelper.drawBody(target, target3D, bodies[i], startX, startY, screenWidth, screenHeight, drawLines, drawImages);
        }
        if (drawJoints) {
            int jointCount = world.getConstraintCount();
            Constraint[] joints = world.getConstraints();
            for (int i = 0; i < jointCount; ++i) {
                Box2DHelper.drawJoint(target, joints[i], startX, startY, screenWidth, screenHeight);
            }
        }
    }

    private static float getFloat(String jToken) {
        if (jToken == null) {
            return 0.0f;
        }
        return Float.parseFloat(jToken);
    }

    private static FXVector[] getVector2D(JSONArray jToken) throws JSONException {
        if (jToken == null) {
            return null;
        }
        FXVector[] vectors = new FXVector[jToken.length() / 2];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[vectors.length - 1 - i] = new FXVector(Float.parseFloat(jToken.getString(i * 2)), Float.parseFloat(jToken.getString(i * 2 + 1)));
        }
        return vectors;
    }

    private static int getInt(String jToken) {
        if (jToken == null) {
            return 0;
        }
        return (int)Float.parseFloat(jToken);
    }

    private static int[] getIntArray(JSONArray jToken) throws Exception {
        if (jToken == null) {
            return null;
        }
        int[] values = new int[jToken.length()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Integer.parseInt(jToken.getString(i));
        }
        return values;
    }

    private static String getString(String jToken) {
        if (jToken == null) {
            return "";
        }
        return jToken;
    }

    private static boolean getBool(String jToken) {
        if (jToken == null) {
            return false;
        }
        return jToken.equalsIgnoreCase("true");
    }

    private static FXVector getVector2(JSONObject jToken) throws Exception {
        if (jToken == null) {
            return new FXVector(0.0f, 0.0f);
        }
        if (jToken.toString().equals("0")) {
            return new FXVector(0.0f, 0.0f);
        }
        return new FXVector((float)jToken.getDouble("x"), (float)jToken.getDouble("y"));
    }

    private static FXVector[] getVectors(JSONObject jToken) throws Exception {
        if (jToken == null) {
            FXVector[] vectors = new FXVector[]{new FXVector(0.0f, 0.0f)};
            return vectors;
        }
        if (jToken.toString().equals("0")) {
            FXVector[] vectors = new FXVector[]{new FXVector(0.0f, 0.0f)};
            return vectors;
        }
        FXVector[] vectors = new FXVector[jToken.getJSONArray("x").length()];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = new FXVector(Float.parseFloat(jToken.getJSONArray("x").getString(i)), Float.parseFloat(jToken.getJSONArray("y").getString(i)));
        }
        return vectors;
    }

    private static DictionaryKeyValue getCustomProperties(JSONArray jToken) throws Exception {
        DictionaryKeyValue customProperties = new DictionaryKeyValue();
        if (jToken == null) {
            return null;
        }
        int count = jToken.length();
        for (int i = 0; i < count; ++i) {
            customProperties.put("name", jToken.optJSONObject(i).getString("name"));
            if (jToken.optJSONObject(i).getString("int") != null) {
                customProperties.put("int", jToken.optJSONObject(i).getString("int"));
                continue;
            }
            if (jToken.optJSONObject(i).getString("float") != null) {
                customProperties.put("float", jToken.optJSONObject(i).getString("float"));
                continue;
            }
            if (jToken.optJSONObject(i).getString("string") != null) {
                customProperties.put("string", jToken.optJSONObject(i).getString("string"));
                continue;
            }
            if (jToken.optJSONObject(i).getString("vec2") != null) {
                customProperties.put("vec2", jToken.optJSONObject(i).getString("vec2"));
                continue;
            }
            if (jToken.optJSONObject(i).getString("boolean") != null) {
                customProperties.put("boolean", jToken.optJSONObject(i).getString("boolean"));
                continue;
            }
            if (jToken.optJSONObject(i).getString("color") == null) continue;
            customProperties.put("color", jToken.optJSONObject(i).getString("color"));
        }
        return customProperties;
    }

    static {
        Box2DHelper.initStatics();
    }
}

