/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.emobtech.googleanalyticsme.Tracker;
import com.renderedideas.admanager.AdManager;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameCanvas;
import com.renderedideas.platform.MyGesture;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Storage;
import com.renderedideas.platform.VservManager;
import com.renderedideas.platform.accelerometer.AccelerometerProvider;
import com.renderedideas.platform.gestures.GestureProvider;
import com.renderedideas.platform.iap.IAPProvider;
import com.renderedideas.platform.misc.MiscProvider;
import com.renderedideas.platform.multitouch.MultitouchProvider;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class GameMIDlet
extends MIDlet
implements CommandListener {
    public static boolean iap = false;
    public static Tracker tracker;
    public Command option1Command;
    public Command option2Command;
    public Command option3Command;
    public static boolean bought;
    public MyGesture myGesture;
    private static final int RATEME_FIRST_PROMPT = 4;
    private static final int RATEME_SECOND_PROMPT = 8;
    public static GameMIDlet instance;
    public Display display;
    public GameCanvas gameCanvas;
    private AccelerometerProvider provider;
    private MiscProvider settingsProvider;
    public IAPProvider iapProvider;
    public Random random;
    public TextBox textBox;
    public boolean messageBoxComplete;
    public boolean yesNoDialogComplete;
    public boolean optionDialogComplete;
    public boolean userInputComplete;
    boolean isYesNoDialogSelectionPositive;
    int optionSelection;
    public Form feedbackForm;
    public TextField message;
    public TextField name;
    public TextField email;
    public boolean isMultitouchEnabled;
    public boolean isSecondaryMultitouchEnabled;
    public boolean isShowFps;
    float[] readings;
    static Hashtable configHashTable;
    static MIDlet vservMidlet;
    static boolean isStartInstanceRunning;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startMainApp() {
        try {
            this.iapProvider = IAPProvider.getProvider();
            this.iapProvider = null;
        }
        catch (ClassNotFoundException e2) {
            Debug.print("No IAP");
        }
        if (this.gameCanvas != null) {
            this.gameCanvas.showNotify();
            this.display.setCurrent((Displayable)this.gameCanvas);
            return;
        }
        try {
            this.settingsProvider = MiscProvider.getProvider();
        }
        catch (Exception e3) {
            Debug.print("No API");
        }
        this.gameCanvas = new GameCanvas(instance);
        new AdManager();
        this.gameCanvas.start();
        this.display.setCurrent((Displayable)this.gameCanvas);
        try {
            if (iap) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseMainApp() {
        if (this.gameCanvas != null) {
            this.gameCanvas.hideNotify();
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    public void exit() {
        this.gameCanvas.running = false;
        PlatformService.sleepThread(50);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public int getWidth() {
        return 320;
    }

    public int getHeight() {
        return 240;
    }

    public boolean isAccelerometerAvailable() {
        try {
            this.provider = AccelerometerProvider.getProvider();
            this.provider = null;
            return true;
        }
        catch (Exception e2) {
            Debug.print("-----NO ACCELEROMETER DETECTED during TEST-----" + e2);
            return false;
        }
    }

    public void startAccelerometer() {
        if (this.provider == null) {
            try {
                this.provider = AccelerometerProvider.getProvider();
                this.provider.openAccelerationSensor();
            }
            catch (Exception e2) {
                this.provider = null;
                Debug.print("-----NO ACCELEROMETER DETECTED-----");
            }
        }
    }

    public void stopAccelerometer() {
        if (this.provider != null) {
            this.provider.closeSensor();
        }
    }

    public void dataReceived(double x, double y, double z, double minValue, double maxValue) {
        double range = maxValue - minValue;
        this.readings[0] = (float)(x / range);
        this.readings[1] = (float)(y / range);
        this.readings[2] = (float)(z / range);
    }

    public float[] getAccelerometerReadings() {
        return this.readings;
    }

    public void preventScreenSleep() {
        try {
            if (this.settingsProvider != null) {
                this.settingsProvider.preventScreenSleep();
            }
        }
        catch (Exception e2) {
            Debug.print("No API");
        }
    }

    public void allowScreenSleep() {
        try {
            if (this.settingsProvider != null) {
                this.settingsProvider.allowScreenSleep();
            }
        }
        catch (Exception e2) {
            Debug.print("No API");
        }
    }

    public void rateMyApp() {
        int launchCount = 1;
        if (Storage.readData("launchCount") != null) {
            launchCount = Integer.parseInt(Storage.readData("launchCount"));
            Storage.saveData("launchCount", "" + ++launchCount);
        } else {
            Storage.saveData("launchCount", "1");
        }
        if (launchCount != 4 && launchCount != 8) {
            return;
        }
        String appName = this.getAppProperty("AppName");
        Alert alert = new Alert("Enjoying " + appName + "?", "Would you like to download more games from us?", null, AlertType.CONFIRMATION);
        Command yes = new Command("Download", 4, 1);
        Command no = new Command("No thanks", 3, 1);
        alert.setTimeout(-2);
        alert.addCommand(yes);
        alert.addCommand(no);
        alert.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)alert);
    }

    public boolean showYesNoDialog(String title, String message) {
        Alert alert = new Alert(title, message, null, AlertType.CONFIRMATION);
        Command yes = new Command("Yes", 4, 1);
        Command no = new Command("No", 3, 1);
        alert.setTimeout(-2);
        alert.addCommand(yes);
        alert.addCommand(no);
        alert.setCommandListener((CommandListener)this);
        this.yesNoDialogComplete = false;
        this.display.setCurrent((Displayable)alert);
        while (!this.yesNoDialogComplete) {
            PlatformService.sleepThread(200);
        }
        return this.isYesNoDialogSelectionPositive;
    }

    public int showOptionsDialog(String title, String message, String option1, String option2) {
        Alert alert = new Alert(title, message, null, AlertType.CONFIRMATION);
        this.option1Command = new Command(option1, 4, 1);
        this.option2Command = new Command(option2, 3, 1);
        alert.setTimeout(-2);
        alert.addCommand(this.option1Command);
        alert.addCommand(this.option2Command);
        alert.setCommandListener((CommandListener)this);
        this.optionDialogComplete = false;
        this.display.setCurrent((Displayable)alert);
        while (!this.optionDialogComplete) {
            PlatformService.sleepThread(200);
        }
        return this.optionSelection;
    }

    public int showOptionsDialog(String title, Bitmap bitmap, String message, String option1, String option2) {
        Alert alert = new Alert(title, message, bitmap == null ? null : bitmap.image, AlertType.CONFIRMATION);
        this.option1Command = new Command(option1, 4, 1);
        this.option2Command = new Command(option2, 3, 1);
        alert.setTimeout(-2);
        alert.addCommand(this.option1Command);
        alert.addCommand(this.option2Command);
        alert.setCommandListener((CommandListener)this);
        this.optionDialogComplete = false;
        this.display.setCurrent((Displayable)alert);
        while (!this.optionDialogComplete) {
            PlatformService.sleepThread(200);
        }
        return this.optionSelection;
    }

    public int show3OptionsDialog(String title, String message, String option1, String option2, String option3) {
        Alert alert = new Alert(title, message, null, AlertType.CONFIRMATION);
        this.option1Command = new Command(option1, 4, 1);
        this.option2Command = new Command(option2, 8, 1);
        this.option3Command = new Command(option3, 7, 1);
        alert.setTimeout(-2);
        alert.addCommand(this.option1Command);
        alert.addCommand(this.option2Command);
        alert.addCommand(this.option3Command);
        alert.setCommandListener((CommandListener)this);
        this.optionDialogComplete = false;
        this.display.setCurrent((Displayable)alert);
        while (!this.optionDialogComplete) {
            PlatformService.sleepThread(200);
        }
        return this.optionSelection;
    }

    public void showMessageBox(String title, String message) {
        Alert alert = new Alert(title, message, null, AlertType.CONFIRMATION);
        Command yes = new Command("OK", 4, 1);
        alert.setTimeout(-2);
        alert.addCommand(yes);
        alert.setCommandListener((CommandListener)this);
        this.messageBoxComplete = false;
        this.display.setCurrent((Displayable)alert);
        while (!this.messageBoxComplete) {
            PlatformService.sleepThread(200);
        }
    }

    public void showFeedbackForm() {
        this.feedbackForm = new Form("Feedback");
        this.message = new TextField("Message:", "", 500, 0);
        this.feedbackForm.append((Item)this.message);
        this.email = new TextField("Email (Optional):", "", 60, 0);
        this.feedbackForm.append((Item)this.email);
        this.name = new TextField("Name (Optional):", "", 50, 0);
        this.feedbackForm.append((Item)this.name);
        this.feedbackForm.addCommand(new Command("Submit", 4, 0));
        this.feedbackForm.addCommand(new Command("Back", 3, 1));
        this.feedbackForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.feedbackForm);
    }

    public String getUserInput(String question) {
        this.textBox = new TextBox(question, "", 1000, 0);
        this.textBox.addCommand(new Command("Ok", 4, 0));
        this.textBox.addCommand(new Command("Cancel", 3, 1));
        this.textBox.setCommandListener((CommandListener)this);
        this.userInputComplete = false;
        this.display.setCurrent((Displayable)this.textBox);
        while (!this.userInputComplete) {
            PlatformService.sleepThread(200);
        }
        if (this.textBox.getString() == null || this.textBox.getString().trim().equals("")) {
            return null;
        }
        return this.textBox.getString();
    }

    public void commandAction(Command c2, Displayable d2) {
        if (c2.getLabel().equals("Download")) {
            PlatformService.openURL("http://www.renderedideas.com/moreapps.php");
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("No thanks")) {
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("Yes")) {
            this.isYesNoDialogSelectionPositive = true;
            this.yesNoDialogComplete = true;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("No")) {
            this.isYesNoDialogSelectionPositive = false;
            this.yesNoDialogComplete = true;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2 == this.option1Command) {
            this.optionDialogComplete = true;
            this.optionSelection = 1;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2 == this.option2Command) {
            this.optionDialogComplete = true;
            this.optionSelection = 2;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2 == this.option3Command) {
            this.optionDialogComplete = true;
            this.optionSelection = 3;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("Ok")) {
            this.userInputComplete = true;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("Cancel")) {
            this.userInputComplete = true;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("OK")) {
            this.messageBoxComplete = true;
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("Submit")) {
            if (!(this.message.getString().trim().equals("") && this.email.getString().trim().equals("") && this.name.getString().trim().equals(""))) {
                new Thread(){

                    public void run() {
                        GameMIDlet.this.submitFeedback();
                    }
                }.start();
            }
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c2.getLabel().equals("Back")) {
            this.display.setCurrent((Displayable)this.gameCanvas);
            this.feedbackForm = null;
        } else if (c2.getLabel().equals("Close")) {
            this.exit();
        }
    }

    public boolean submitFeedback() {
        HttpConnection httpConn = null;
        String parameters = "message=" + GameMIDlet.urlEncode(this.message.getString()) + "&name=" + GameMIDlet.urlEncode(this.name.getString()) + "&email=" + GameMIDlet.urlEncode(this.email.getString()) + "&device=" + GameMIDlet.urlEncode(System.getProperty("microedition.platform")) + "&appname=" + GameMIDlet.urlEncode(instance.getAppProperty("MIDlet-Name") + "_v" + instance.getAppProperty("MIDlet-Version"));
        String url = "" + parameters;
        DataInputStream is = null;
        OutputStream os = null;
        Debug.print("requesting..." + url);
        try {
            httpConn = (HttpConnection)Connector.open((String)url);
            httpConn.setRequestMethod("GET");
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                StringBuffer sb = new StringBuffer();
                os = httpConn.openOutputStream();
                is = httpConn.openDataInputStream();
                while ((chr = ((InputStream)is).read()) != -1) {
                    sb.append((char)chr);
                }
                Debug.print(sb.toString());
                Alert alert = new Alert("Success", "We've received your feedback. Thanks!", null, AlertType.INFO);
                alert.setTimeout(3000);
                this.display.setCurrent((Displayable)alert);
            } else {
                Alert alert = new Alert("Error", "Feedback can't be submitted. Please check your connection settings.", null, AlertType.INFO);
                alert.setTimeout(3000);
                this.display.setCurrent((Displayable)alert);
                Debug.print("Error in opening HTTP Connection. Error#" + respCode);
            }
        }
        catch (Exception e2) {
            Alert alert = new Alert("Error", "Feedback can't be submitted. Please check your connection settings.", null, AlertType.INFO);
            alert.setTimeout(3000);
            this.display.setCurrent((Displayable)alert);
            Debug.print("error in conn:" + e2);
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        return false;
    }

    public static String urlEncode(String s) {
        String sbuffer = "334co3434pyr45454i34ght 343re344n444de443r434ed 3434id343ea3434s34";
        if (sbuffer.equals("A")) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == ' ') {
                sbuf.append('+');
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '*') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(GameMIDlet.hex(ch));
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(GameMIDlet.hex(0xC0 | ch >> 6));
                sbuf.append(GameMIDlet.hex(0x80 | ch & 0x3F));
                continue;
            }
            sbuf.append(GameMIDlet.hex(0xE0 | ch >> 12));
            sbuf.append(GameMIDlet.hex(0x80 | ch >> 6 & 0x3F));
            sbuf.append(GameMIDlet.hex(0x80 | ch & 0x3F));
        }
        return sbuf.toString();
    }

    public static String hex(int sym) {
        String hex = "%00%01%02%03%04%05%06%07%08%09%0a%0b%0c%0d%0e%0f%10%11%12%13%14%15%16%17%18%19%1a%1b%1c%1d%1e%1f%20%21%22%23%24%25%26%27%28%29%2a%2b%2c%2d%2e%2f%30%31%32%33%34%35%36%37%38%39%3a%3b%3c%3d%3e%3f%40%41%42%43%44%45%46%47%48%49%4a%4b%4c%4d%4e%4f%50%51%52%53%54%55%56%57%58%59%5a%5b%5c%5d%5e%5f%60%61%62%63%64%65%66%67%68%69%6a%6b%6c%6d%6e%6f%70%71%72%73%74%75%76%77%78%79%7a%7b%7c%7d%7e%7f%80%81%82%83%84%85%86%87%88%89%8a%8b%8c%8d%8e%8f%90%91%92%93%94%95%96%97%98%99%9a%9b%9c%9d%9e%9f%a0%a1%a2%a3%a4%a5%a6%a7%a8%a9%aa%ab%ac%ad%ae%af%b0%b1%b2%b3%b4%b5%b6%b7%b8%b9%ba%bb%bc%bd%be%bf%c0%c1%c2%c3%c4%c5%c6%c7%c8%c9%ca%cb%cc%cd%ce%cf%d0%d1%d2%d3%d4%d5%d6%d7%d8%d9%da%db%dc%dd%de%df%e0%e1%e2%e3%e4%e5%e6%e7%e8%e9%ea%eb%ec%ed%ee%ef%f0%f1%f2%f3%f4%f5%f6%f7%f8%f9%fa%fb%fc%fd%fe%ff";
        return "%00%01%02%03%04%05%06%07%08%09%0a%0b%0c%0d%0e%0f%10%11%12%13%14%15%16%17%18%19%1a%1b%1c%1d%1e%1f%20%21%22%23%24%25%26%27%28%29%2a%2b%2c%2d%2e%2f%30%31%32%33%34%35%36%37%38%39%3a%3b%3c%3d%3e%3f%40%41%42%43%44%45%46%47%48%49%4a%4b%4c%4d%4e%4f%50%51%52%53%54%55%56%57%58%59%5a%5b%5c%5d%5e%5f%60%61%62%63%64%65%66%67%68%69%6a%6b%6c%6d%6e%6f%70%71%72%73%74%75%76%77%78%79%7a%7b%7c%7d%7e%7f%80%81%82%83%84%85%86%87%88%89%8a%8b%8c%8d%8e%8f%90%91%92%93%94%95%96%97%98%99%9a%9b%9c%9d%9e%9f%a0%a1%a2%a3%a4%a5%a6%a7%a8%a9%aa%ab%ac%ad%ae%af%b0%b1%b2%b3%b4%b5%b6%b7%b8%b9%ba%bb%bc%bd%be%bf%c0%c1%c2%c3%c4%c5%c6%c7%c8%c9%ca%cb%cc%cd%ce%cf%d0%d1%d2%d3%d4%d5%d6%d7%d8%d9%da%db%dc%dd%de%df%e0%e1%e2%e3%e4%e5%e6%e7%e8%e9%ea%eb%ec%ed%ee%ef%f0%f1%f2%f3%f4%f5%f6%f7%f8%f9%fa%fb%fc%fd%fe%ff".substring(sym * 3, sym * 3 + 3);
    }

    public boolean isTouchSupported() {
        return this.gameCanvas.hasPointerEvents();
    }

    public void enableGestures() {
        if (!GestureProvider.enableGestures()) {
            this.myGesture = new MyGesture();
        }
    }

    public void disableGestures() {
        if (GestureProvider.provider != null) {
            GestureProvider.provider.disableGestures();
            GestureProvider.provider = null;
        }
        if (this.myGesture != null) {
            this.myGesture.points = null;
            this.myGesture.time = null;
            this.myGesture = null;
        }
    }

    public void enableMultitouch() {
        if (!this.isMultitouchEnabled && MultitouchProvider.enableMultitouch()) {
            this.isMultitouchEnabled = true;
        }
    }

    public void disableMultitouch() {
        if (MultitouchProvider.provider != null) {
            MultitouchProvider.provider.disableMultitouch();
            MultitouchProvider.provider = null;
        }
        this.isMultitouchEnabled = false;
    }

    void showFps() {
        this.isShowFps = true;
    }

    static {
        bought = false;
    }

    public void pauseApp() {
        if (!VservManager.startMainApp) {
            return;
        }
        this.pauseMainApp();
    }

    public void constructorMainApp() {
        this.isYesNoDialogSelectionPositive = false;
        this.optionSelection = 1;
        this.isMultitouchEnabled = false;
        this.isSecondaryMultitouchEnabled = false;
        this.isShowFps = false;
        this.readings = new float[3];
        instance = this;
        this.display = Display.getDisplay((MIDlet)instance);
        new Storage();
        this.random = new Random();
        this.userInputComplete = false;
        this.optionDialogComplete = false;
        this.yesNoDialogComplete = false;
        this.messageBoxComplete = false;
        try {
            tracker = Tracker.getInstance(this, "UA-54603338-3", 30L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startApp() {
        if (VservManager.startMainApp) {
            this.startMainApp();
            return;
        }
        if (isStartInstanceRunning) {
            return;
        }
        isStartInstanceRunning = true;
        configHashTable = new Hashtable();
        configHashTable.put("staticAdTemplate", "staticAd_start.txt");
        configHashTable.put("staticAdResource", "fb.png");
        configHashTable.put("showAt", "start");
        configHashTable.put("geoData", "true");
        configHashTable.put("viewMandatory", "true");
        configHashTable.put("zoneId", "8a5f63dc");
        configHashTable.put("startAfterCount", "0");
        configHashTable.put("cache", "8a5f63dc");
        configHashTable.put("showAds", "true");
        configHashTable.put("staticAdPosition", "0");
        configHashTable.put("staticAdOnlyOnFailure", "false");
        configHashTable.put("supportedScreens", "352x288|300x250|216x162|168x126|120x90");
        new VservManager(this, configHashTable).showAtStart();
    }
}

