/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.Message;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import javax.microedition.lcdui.Graphics;

public class MessageQueue {
    public ArrayList messageList = new ArrayList();
    public GameFont messageFont;

    public void addMessage(String msg, int delayInMilliseconds, Point centerPosition, Point scrollSpeedMilliPixel) {
        Message message = new Message(msg, delayInMilliseconds, centerPosition, scrollSpeedMilliPixel);
        this.messageList.addElement(message);
    }

    public void update() {
        for (int i = 0; i < this.messageList.size(); ++i) {
            Message currentMessage = (Message)this.messageList.elementAt(i);
            currentMessage.centerPosition.X += currentMessage.scrollSpeedInPixel.X;
            currentMessage.centerPosition.Y += currentMessage.scrollSpeedInPixel.Y;
            long currentTime = PlatformService.currentTimeMillis();
            currentMessage.delayInMilliSeconds = (int)((long)currentMessage.delayInMilliSeconds - (currentTime - currentMessage.creationTime));
            currentMessage.creationTime = currentTime;
            if (currentMessage.delayInMilliSeconds > 0) continue;
            this.messageList.removeElementAt(0);
            if (this.messageList.size() <= 0) {
                currentMessage = null;
                continue;
            }
            Message message = (Message)this.messageList.elementAt(0);
        }
    }

    public void paint(Graphics g2) {
        for (int i = 0; i < this.messageList.size(); ++i) {
            Message currentMessage = (Message)this.messageList.elementAt(i);
            if (this.messageFont == null) {
                Debug.print("Warning!!! MessageFont is not set in MessageQueue.java");
                return;
            }
            this.messageFont.drawString(currentMessage.message, g2, (int)currentMessage.centerPosition.X / 1000, (int)currentMessage.centerPosition.Y / 1000);
        }
    }
}

