/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Shape {
    protected FXVector[] mVertices;
    int[] a;
    int b = 0;
    private int k;
    float c;
    private float l;
    float d;
    float e = 0.0f;
    protected float mElasticityFX = 0.0f;
    protected float mFrictionFX = 0.25f;
    float f = 1.0f;
    float g = 1.0f;
    float h = 1.0f;
    float i = 1.0f;
    int j = -1;
    protected UserData mUserData = null;
    protected FXVector mCcentroid = new FXVector();
    public static final float MAX_MASS_FX = Float.MAX_VALUE;

    public static Shape createRectangle(int n, int n2) {
        float f2 = n;
        float f3 = n2;
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-f2 / 2.0f, -f3 / 2.0f);
        fXVectorArray2[1] = new FXVector(-f2 / 2.0f, f3 / 2.0f);
        fXVectorArray2[2] = new FXVector(f2 / 2.0f, f3 / 2.0f);
        fXVectorArray2[3] = new FXVector(f2 / 2.0f, -f3 / 2.0f);
        Shape shape = new Shape(fXVectorArray2);
        return shape;
    }

    public static Shape createCircle(int n) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0.0f, n);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[n2];
        FXVector fXVector = new FXVector(0.0f, n);
        for (int i = 0; i < n2; ++i) {
            float f2 = (float)Math.PI * 2 * (float)((i << 1) + 1) / (float)(n2 << 1);
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix(f2);
            fXVectorArray[n2 - 1 - i] = fXMatrix.mult(fXVector);
        }
        Shape shape = new Shape(fXVectorArray);
        return shape;
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n = ((PhysicsFileReader)object).getVersion();
        if (n <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n2 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n2];
        for (int i = 0; i < n2; ++i) {
            fXVectorArray[i] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.mUserData = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.mVertices = fXVectorArray;
        this.updateInternals();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.mVertices = new FXVector[shape.mVertices.length];
        System.arraycopy(shape.mVertices, 0, this.mVertices, 0, this.mVertices.length);
        this.setElasticityFX(shape.mElasticityFX);
        this.setFrictionFX(shape.mFrictionFX);
        this.updateInternals();
        this.setMassFX(shape.f);
        if (shape.mUserData != null) {
            this.mUserData = shape.mUserData.copy();
        }
    }

    protected Shape() {
    }

    protected void updateInternals() {
        this.a();
        this.k = 0;
        for (int i = 0; i < this.mVertices.length; ++i) {
            FXVector fXVector = this.mVertices[i];
            int n = fXVector.lengthSquare();
            if (n <= this.k * this.k) continue;
            this.k = (int)fXVector.lengthFX();
        }
        this.c = this.k;
        this.b();
        Shape shape = this;
        this.l = shape.d = shape.c * 2.0f;
        for (int i = 0; i < shape.a.length && shape.a[i] >= 0; i += 2) {
            float f2;
            FXVector fXVector = new FXVector(shape.mVertices[shape.a[i]]);
            fXVector.subtract(shape.mVertices[shape.a[i + 1]]);
            fXVector.normalize();
            float f3 = 0.0f;
            float f4 = f2 = shape.mVertices[0].xFX * fXVector.yFX - shape.mVertices[0].yFX * fXVector.xFX;
            for (int j = 1; j < shape.mVertices.length; ++j) {
                float f5;
                f3 = shape.mVertices[j].xFX * fXVector.yFX - shape.mVertices[j].yFX * fXVector.xFX;
                if (f5 < f4) {
                    f4 = f3;
                    continue;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            if (shape.d < f2 - f4) {
                shape.d = f2 - f4;
            }
            if (!(shape.l > f2 - f4)) continue;
            shape.l = f2 - f4;
        }
    }

    public void correctCentroid() {
        if (this.mVertices.length < 3) {
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        int n2 = this.mVertices.length - 1;
        while (n < this.mVertices.length) {
            float f4 = this.mVertices[n].xFX * this.mVertices[n2].yFX - this.mVertices[n].yFX * this.mVertices[n2].xFX;
            f2 += f4 * (this.mVertices[n].xFX + this.mVertices[n2].xFX);
            f3 += f4 * (this.mVertices[n].yFX + this.mVertices[n2].yFX);
            n2 = n++;
        }
        f2 /= this.e * 6.0f;
        f3 /= this.e * 6.0f;
        for (n = 0; n < this.mVertices.length; ++n) {
            this.mVertices[n].subtract(new FXVector(f2, f3));
        }
        this.updateInternals();
    }

    public FXVector[] getCorners() {
        return this.mVertices;
    }

    public int getBoundingRadiusSquare() {
        return this.k * this.k;
    }

    protected int getBoundingRadius() {
        return this.k;
    }

    public float getBoundingRadiusFX() {
        return this.c;
    }

    void a() {
        if (this.mVertices.length == 1) {
            this.a = new int[0];
            this.b = 0;
            return;
        }
        this.a = new int[this.mVertices.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n = 0;
        int n2 = this.mVertices.length - 1;
        while (n < this.mVertices.length) {
            FXVector fXVector = new FXVector(this.mVertices[n]);
            fXVector.subtract(this.mVertices[n2]);
            fXVector.normalize();
            boolean bl = true;
            for (int i = 0; i < vector.size(); ++i) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i);
                if (!(Math.abs(fXVector.xFX * fXVector2.xFX + fXVector.yFX * fXVector2.yFX) > 0.9980469f)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.a[vector.size() << 1] = n;
                this.a[(vector.size() << 1) + 1] = n2;
                vector.addElement(fXVector);
            }
            n2 = n++;
        }
        this.b = vector.size() << 1;
        for (n = vector.size() << 1; n < this.a.length; ++n) {
            this.a[n] = -1;
        }
    }

    public void setFriction(int n) {
        this.mFrictionFX = (float)n / 100.0f;
    }

    public void setFrictionFX(float f2) {
        this.mFrictionFX = f2;
    }

    public float getFrictionFX() {
        return this.mFrictionFX;
    }

    public void setElasticity(int n) {
        this.mElasticityFX = (float)n / 100.0f;
    }

    public void setElasticityFX(float f2) {
        this.mElasticityFX = f2;
    }

    public float getElasticityFX() {
        return this.mElasticityFX;
    }

    public final void setMass(int n) {
        this.setMassFX(n);
    }

    public final void setMassFX(float f2) {
        if (this.e == 0.0f) {
            this.h = Float.MAX_VALUE;
            this.g = 1.0f;
            this.i = 1.0f;
            return;
        }
        this.f = f2;
        this.g = 1.0f / f2;
        if (this.g == 0.0f) {
            this.g = 1.0f;
        }
        this.b();
    }

    public int getMass() {
        return (int)this.f;
    }

    public float getMassFX() {
        return this.f;
    }

    public int getId() {
        return this.j;
    }

    public float getAreaFX() {
        return this.e;
    }

    void b() {
        float f2;
        float f3;
        float f4;
        int n;
        this.e = 0.0f;
        this.h = 0.0f;
        if (this.mVertices.length == 1) {
            this.e = (float)Math.PI * (this.c * this.c);
            this.h = this.f / 2.0f * this.c * this.c;
        } else if (this.mVertices.length > 2) {
            for (n = 0; n < this.mVertices.length; ++n) {
                FXVector fXVector = this.mVertices[n];
                FXVector fXVector2 = this.mVertices[n + 1 >= this.mVertices.length ? 0 : n + 1];
                float f5 = fXVector2.xFX * fXVector.yFX - fXVector2.yFX * fXVector.xFX;
                this.e += f5 / 2.0f;
                f4 = fXVector.xFX;
                f3 = fXVector.yFX;
                float f6 = fXVector2.xFX;
                f2 = fXVector2.yFX;
                f4 = (f4 * f4 + f6 * f4 + f6 * f6) / 12.0f;
                f3 = (f3 * f3 + f2 * f3 + f2 * f2) / 12.0f;
                this.h += f5 * (f4 + f3);
            }
            this.h = this.h / this.e * this.f;
        }
        if (this.e > 0.0f) {
            f3 = 0.0f;
            f2 = 0.0f;
            n = 0;
            int n2 = this.mVertices.length - 1;
            while (n < this.mVertices.length) {
                f4 = this.mVertices[n].xFX * this.mVertices[n2].yFX - this.mVertices[n].yFX * this.mVertices[n2].xFX;
                f3 += f4 * (this.mVertices[n].xFX + this.mVertices[n2].xFX);
                f2 += f4 * (this.mVertices[n].yFX + this.mVertices[n2].yFX);
                n2 = n++;
            }
            this.mCcentroid.assignFX(f3 /= this.e * 6.0f, f2 /= this.e * 6.0f);
        } else {
            this.mCcentroid.assignFX(0.0f, 0.0f);
        }
        this.h += this.f * this.mCcentroid.lengthSquareFX();
        if (this.h == 0.0f) {
            this.i = 2.1474836E9f;
            return;
        }
        this.i = 1.0f / this.h;
    }

    protected final void getVerticesFX(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.mVertices.length) {
            return;
        }
        for (int i = 0; i < this.mVertices.length; ++i) {
            fXMatrix.mult(this.mVertices[i], fXVectorArray[i]);
            fXVectorArray[i].xFX += fXVector.xFX;
            fXVectorArray[i].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

