/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.Model3D;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.SpriteFrame;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.TriangleStripArray;

public class Bitmap {
    public Image image;
    public String path;
    public static boolean applyShadow = false;
    public static Bitmap shadow = null;
    public static Model3D plane;
    public static short[] verts;
    public static short[] uvs;
    public static int[] triangles;
    static Sprite sprite;

    public Bitmap() {
    }

    public Bitmap(String path) {
        Debug.print("path: " + path);
        if (!path.endsWith(".png")) {
            path = path + ".png";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        try {
            this.image = Image.createImage((String)path);
            if (applyShadow) {
                this.image = Bitmap.multiplyBitmaps((Bitmap)this, (Bitmap)Bitmap.shadow).image;
            }
        }
        catch (Exception e2) {
            PlatformService.errorQuit("Error:platform:Bitmap:constructor:" + path + ":" + e2);
        }
    }

    public Bitmap(Image image) {
        this.image = image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        this.image.getRGB(rgbData, offset, scanlength, x, y, width, height);
    }

    private static Bitmap createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        Bitmap bitmap = new Bitmap();
        bitmap.image = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)processAlpha);
        return bitmap;
    }

    public static void drawBitmap(Graphics target, Bitmap bitmap, int x, int y) {
        target.drawImage(bitmap.image, x, y, 0);
    }

    public static void drawSprite(Graphics target, SpriteFrame spriteFrame, int x, int y) {
        String str = "334co3434pyr45454i34ght 343re344n444de443r434ed 3434id343ea3434s34";
        if (str.equals("A")) {
            return;
        }
        target.drawImage(spriteFrame.bitmap.image, x + spriteFrame.fx, y + spriteFrame.fy, 0);
    }

    public static void drawBitmap(Graphics target, Image image, int x, int y) {
        target.drawImage(image, x, y, 0);
    }

    private static int[] getRGB(Bitmap bitmap) {
        int[] data = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.image.getRGB(data, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        return data;
    }

    public static byte[] getRGB_byte(Bitmap bitmap) {
        int[] array = Bitmap.getRGB(bitmap);
        byte[] b2 = new byte[array.length * 3];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            b2[k++] = (byte)(array[i] >> 16 & 0xFF);
            b2[k++] = (byte)(array[i] >> 8 & 0xFF);
            b2[k++] = (byte)(array[i] & 0xFF);
        }
        return b2;
    }

    public static void fillColor(Graphics graphics, int x, int y, int width, int height, int r, int g2, int b2) {
        graphics.setColor(r, g2, b2);
        graphics.fillRect(x, y, width, height);
    }

    public static void fillColor(Graphics graphics, int x, int y, int width, int height, String hexColor) {
        graphics.setColor(Integer.parseInt(hexColor, 16));
        graphics.fillRect(x, y, width, height);
    }

    public static void drawString(Graphics graphics, String str, int x, int y, int r, int g2, int b2) {
        graphics.setColor(r, g2, b2);
        graphics.drawString(str, x, y, 0);
    }

    public static int getStringWidth(String str) {
        Font font = Font.getDefaultFont();
        return font.stringWidth(str);
    }

    public static int drawMultilineString(Graphics graphics, String str, int x, int y, int width) {
        Bitmap.fillColor(graphics, x, y, width, Bitmap.getMultilineStringHeight(str, width), 190, 0, 0);
        graphics.setColor(234, 255, 0);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        ArrayList lines = Bitmap.wrap(str, font, width);
        for (int i = 0; i < lines.size(); ++i) {
            int liney = y + i * font.getHeight();
            graphics.drawString((String)lines.elementAt(i), x, liney, 0);
            graphics.drawLine(x, liney + font.getHeight(), x + font.stringWidth(((String)lines.elementAt(i)).trim()), liney + font.getHeight());
        }
        return y + lines.size() * font.getHeight();
    }

    public static int drawMultilineString(Graphics graphics, String str, int x, int y, int width, String hexColor) {
        graphics.setColor(Integer.parseInt(hexColor, 16));
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        ArrayList lines = Bitmap.wrap(str, font, width);
        for (int i = 0; i < lines.size(); ++i) {
            int liney = y + i * font.getHeight();
            graphics.drawString((String)lines.elementAt(i), x, liney, 0);
            graphics.drawLine(x, liney + font.getHeight(), x + font.stringWidth(((String)lines.elementAt(i)).trim()), liney + font.getHeight());
        }
        return y + lines.size() * font.getHeight();
    }

    public static int drawMultilineString2(Graphics graphics, String str, int x, int y, int width) {
        graphics.setColor(255, 255, 255);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        ArrayList lines = Bitmap.wrap(str, font, width);
        for (int i = 0; i < lines.size(); ++i) {
            int liney = y + i * font.getHeight();
            graphics.drawString((String)lines.elementAt(i), x, liney, 0);
        }
        return y + lines.size() * font.getHeight();
    }

    public static int getMultilineStringHeight(String str, int width) {
        Font font = Font.getFont((int)0, (int)1, (int)16);
        ArrayList lines = Bitmap.wrap(str, font, width);
        return lines.size() * font.getHeight();
    }

    private static ArrayList wrap(String text, Font font, int width) {
        ArrayList result = new ArrayList();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = font.substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public static Bitmap combineBitmaps(Bitmap bitmap1, Bitmap bitmap2) {
        Image resultImage = Image.createImage((int)bitmap1.getWidth(), (int)bitmap1.getHeight());
        Graphics graphics = resultImage.getGraphics();
        Bitmap.drawBitmap(graphics, bitmap1, 0, 0);
        Bitmap.drawBitmap(graphics, bitmap2, 0, 0);
        return new Bitmap(resultImage);
    }

    public static Bitmap multiplyBitmaps(Bitmap bitmap1, Bitmap bitmap2) {
        int[] rgb_b1 = Bitmap.getRGB(bitmap1);
        int[] rgb_b2 = Bitmap.getRGB(bitmap2);
        int[] rgb_multiplied = new int[rgb_b1.length];
        for (int i = 0; i < rgb_b1.length; ++i) {
            int pixel_b1 = rgb_b1[i];
            int alpha_b1 = (pixel_b1 & 0xFF000000) >> 24;
            int red_b1 = (pixel_b1 & 0xFF0000) >> 16;
            int green_b1 = (pixel_b1 & 0xFF00) >> 8;
            int blue_b1 = pixel_b1 & 0xFF;
            int pixel_b2 = rgb_b2[i];
            int alpha_b2 = (pixel_b2 & 0xFF000000) >> 24;
            int red_b2 = (pixel_b2 & 0xFF0000) >> 16;
            int green_b2 = (pixel_b2 & 0xFF00) >> 8;
            int blue_b2 = pixel_b2 & 0xFF;
            int red_m = red_b1 * red_b2 / 255;
            int green_m = green_b1 * green_b2 / 255;
            int blue_m = blue_b1 * blue_b2 / 255;
            int alpha_m = alpha_b1;
            red_m = Math.min(Math.max(0, red_m), 255);
            green_m = Math.min(Math.max(0, green_m), 255);
            blue_m = Math.min(Math.max(0, blue_m), 255);
            rgb_multiplied[i] = (alpha_m << 24) + (red_m << 16) + (green_m << 8) + blue_m;
        }
        return new Bitmap(Image.createRGBImage((int[])rgb_multiplied, (int)bitmap1.getWidth(), (int)bitmap1.getHeight(), (boolean)true));
    }

    private static final Bitmap loadClippedImage(Bitmap srcBitmap, int originX, int originY, int width, int height) {
        Bitmap fileImage = srcBitmap;
        return Bitmap.getImageRegion(fileImage, originX, originY, width, height);
    }

    private static final Bitmap loadClippedImage(Bitmap srcBitmap, int originX, int originY) {
        Bitmap fileImage = srcBitmap;
        if (originX == 0 && originY == 0) {
            return fileImage;
        }
        return Bitmap.getImageRegion(fileImage, originX, originY, fileImage.getWidth(), fileImage.getHeight());
    }

    public static final Bitmap getImageRegion(Bitmap srcBitmap, int x, int y, int width, int height) {
        int[] rgb = new int[width * height];
        srcBitmap.getRGB(rgb, 0, width, x, y, width, height);
        if (x + width > srcBitmap.getWidth() || y + height > srcBitmap.getHeight()) {
            Debug.print("Warning: attempting extract using (" + x + "," + y + "," + width + "," + height + ") when image is " + "(" + srcBitmap.getWidth() + "," + srcBitmap.getHeight() + ")");
        }
        Bitmap result = Bitmap.createRGBImage(rgb, width, height, true);
        return result;
    }

    public static final Bitmap[] extractFrames(Bitmap sourceImage, int sourceX, int sourceY, int totalFramesWide, int totalFramesHigh, int frameWidth, int frameHeight) {
        Bitmap[] frames = new Bitmap[totalFramesWide * totalFramesHigh];
        int frameCount = 0;
        for (int fy = 0; fy < totalFramesHigh; ++fy) {
            for (int fx = 0; fx < totalFramesWide; ++fx) {
                frames[frameCount] = Bitmap.getImageRegion(sourceImage, sourceX + fx * frameWidth, sourceY + fy * frameHeight, frameWidth, frameHeight);
                ++frameCount;
            }
        }
        return frames;
    }

    public static final Bitmap[] extractFrames(Bitmap sourceImage, int sourceX, int sourceY, int totalFramesWide, int totalFramesHigh) {
        Bitmap[] frames = new Bitmap[totalFramesWide * totalFramesHigh];
        int frameCount = 0;
        int frameWidth = sourceImage.getWidth() / totalFramesWide;
        int frameHeight = sourceImage.getHeight() / totalFramesHigh;
        for (int fy = 0; fy < totalFramesHigh; ++fy) {
            for (int fx = 0; fx < totalFramesWide; ++fx) {
                frames[frameCount] = Bitmap.getImageRegion(sourceImage, sourceX + fx * frameWidth, sourceY + fy * frameHeight, frameWidth, frameHeight);
                ++frameCount;
            }
        }
        return frames;
    }

    public static final Bitmap[] extractFramesReverse(Bitmap sourceImage, int sourceX, int sourceY, int totalFramesWide, int totalFramesHigh) {
        Bitmap[] frames = Bitmap.extractFrames(sourceImage, sourceX, sourceY, totalFramesWide, totalFramesHigh);
        Bitmap[] reverseFrames = new Bitmap[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            reverseFrames[i] = frames[frames.length - 1 - i];
        }
        return reverseFrames;
    }

    public static Bitmap flipBitmapHorizontal(Bitmap bitmap) {
        Bitmap b2 = Bitmap.createRGBImage(Bitmap.getRGB(bitmap), bitmap.getWidth(), bitmap.getHeight(), true);
        return new Bitmap(Image.createImage((Image)b2.image, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (int)2));
    }

    public static Bitmap[] flipBitmapHorizontal(Bitmap[] bitmaps) {
        Bitmap[] returnFrames = new Bitmap[bitmaps.length];
        for (int i = 0; i < bitmaps.length; ++i) {
            returnFrames[i] = Bitmap.flipBitmapHorizontal(bitmaps[i]);
        }
        return returnFrames;
    }

    public static Bitmap flipBitmapVertical(Bitmap bitmap) {
        Bitmap b2 = Bitmap.createRGBImage(Bitmap.getRGB(bitmap), bitmap.getWidth(), bitmap.getHeight(), true);
        return new Bitmap(Image.createImage((Image)b2.image, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (int)1));
    }

    public static Bitmap[] flipBitmapVertical(Bitmap[] bitmaps) {
        Bitmap[] returnFrames = new Bitmap[bitmaps.length];
        for (int i = 0; i < bitmaps.length; ++i) {
            returnFrames[i] = Bitmap.flipBitmapVertical(bitmaps[i]);
        }
        return returnFrames;
    }

    public static Bitmap scaleBitmap(Bitmap original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += original.getWidth();
        }
        Image image = Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
        return new Bitmap(image);
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int angleDegrees) {
        switch (angleDegrees) {
            case 90: {
                Bitmap b2 = Bitmap.createRGBImage(Bitmap.getRGB(bitmap), bitmap.getWidth(), bitmap.getHeight(), true);
                return new Bitmap(Image.createImage((Image)b2.image, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (int)5));
            }
            case 180: {
                Bitmap b2 = Bitmap.createRGBImage(Bitmap.getRGB(bitmap), bitmap.getWidth(), bitmap.getHeight(), true);
                return new Bitmap(Image.createImage((Image)b2.image, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (int)3));
            }
            case 270: {
                Bitmap b2 = Bitmap.createRGBImage(Bitmap.getRGB(bitmap), bitmap.getWidth(), bitmap.getHeight(), true);
                return new Bitmap(Image.createImage((Image)b2.image, (int)0, (int)0, (int)b2.getWidth(), (int)b2.getHeight(), (int)6));
            }
        }
        Debug.print("INVALID ANGLE !!!!");
        return null;
    }

    public static void drawPolygon(Graphics target, FXVector[] vertices, int lineWidth, int count, int tintColorR, int tintColorG, int tintColorB, int tintColorA) {
        if (count > 0) {
            for (int i = 0; i < count - 1; ++i) {
                target.setColor(tintColorR, tintColorG, tintColorB);
                target.drawLine((int)vertices[i].xFX, (int)vertices[i].yFX, (int)vertices[i + 1].xFX, (int)vertices[i + 1].yFX);
            }
            target.drawLine((int)vertices[count - 1].xFX, (int)vertices[count - 1].yFX, (int)vertices[0].xFX, (int)vertices[0].yFX);
        }
    }

    public static void drawCircle(Graphics target, FXVector center, float radius, int lineWidth, int segments, int tintColorR, int tintColorG, int tintColorB, int tintColorA) {
        int width = (int)(radius * 2.0f);
        int height = (int)(radius * 2.0f);
        target.setColor(tintColorR, tintColorG, tintColorB);
        target.drawArc((int)center.xFX - 1, (int)center.yFX - 1, 2, 2, 0, 360);
        target.setColor(tintColorR, tintColorG, tintColorB);
        target.drawArc((int)center.xFX - width / 2, (int)center.yFX - height / 2, width, height, 0, 360);
    }

    public static void drawTexturedPolygon(Graphics3D target, short[] vertices, short[] uvs, float positionX, float positionY, float renderOrder, float angle, int[] stripLengths, Bitmap bitmap, float scaleX, float scaleY) {
        short[] verts = vertices;
        if (positionX != 0.0f || positionY != 0.0f || angle != 0.0f || scaleX != 1.0f || scaleY != 1.0f) {
            verts = new short[vertices.length];
            int length = vertices.length;
            if (angle == 0.0f) {
                for (int i = 0; i < length; i += 3) {
                    verts[i] = (short)((float)vertices[i] + positionX);
                    verts[i + 1] = (short)((float)vertices[i + 1] + positionY);
                }
            } else {
                for (int i = 0; i < length; i += 3) {
                    float pX = (float)vertices[i] + positionX;
                    float pY = (float)vertices[i + 1] + positionY;
                    verts[i] = (short)Utility.getRotatedScaledPointX(positionX, positionY, pX, pY, angle, scaleX, scaleY);
                    verts[i + 1] = (short)Utility.getRotatedScaledPointY(positionX, positionY, pX, pY, angle, scaleX, scaleY);
                }
            }
        }
        Bitmap.plane.vertexArray.set(0, verts.length / 3, verts);
        Bitmap.plane.texArray.set(0, uvs.length / 2, uvs);
        Bitmap.plane.vertexBuffer.setPositions(Bitmap.plane.vertexArray, 1.0f, null);
        Bitmap.plane.vertexBuffer.setTexCoords(0, Bitmap.plane.texArray, 0.003921569f, null);
        Bitmap.plane.indexBuffer = new TriangleStripArray(0, stripLengths);
        Bitmap.plane.appearance[0].getTexture(0).setImage(new Image2D(100, (Object)bitmap.image));
        target.render(Bitmap.plane.vertexBuffer, Bitmap.plane.indexBuffer, Bitmap.plane.appearance[0], null);
    }

    public static void drawBitmap(Graphics3D target, Bitmap bitmap, float positionX, float positionY, float angle, float scaleX, float scaleY) {
        Bitmap.drawTexturedPolygon(target, verts, uvs, positionX, positionY, 0.0f, angle, triangles, bitmap, scaleX, scaleY);
    }

    public static void drawBitmap(Graphics target, Bitmap bitmap, int x, int y, boolean isFlipHorizontal, int angle) {
        if (isFlipHorizontal || angle != 0) {
            if (sprite == null) {
                sprite = new Sprite(bitmap.image);
            }
            sprite.setImage(bitmap.image, bitmap.getWidth(), bitmap.getHeight());
            if (isFlipHorizontal) {
                if (angle == 90) {
                    sprite.setTransform(7);
                } else if (angle == 180) {
                    sprite.setTransform(1);
                } else if (angle == 270) {
                    sprite.setTransform(4);
                } else {
                    sprite.setTransform(2);
                }
            } else if (angle == 90) {
                sprite.setTransform(5);
            } else if (angle == 180) {
                sprite.setTransform(3);
            } else if (angle == 270) {
                sprite.setTransform(6);
            }
            sprite.setPosition(x, y);
            sprite.paint(target);
        } else {
            target.drawImage(bitmap.image, x, y, 0);
        }
    }

    public static void drawSprite(Graphics target, SpriteFrame spriteFrame, int x, int y, boolean isFlipHorizontal, int angle) {
        if (isFlipHorizontal) {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + (spriteFrame.width - (spriteFrame.fx + spriteFrame.bitmap.getWidth())), y + spriteFrame.fy, isFlipHorizontal, angle);
        } else if (angle == 90) {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + spriteFrame.fy, y + spriteFrame.fx, isFlipHorizontal, angle);
        } else if (angle == 270) {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + spriteFrame.fy, y - spriteFrame.fx, isFlipHorizontal, angle);
        } else if (angle == 180) {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x - spriteFrame.fx, y + spriteFrame.fy, isFlipHorizontal, angle);
        } else {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + spriteFrame.fx, y + spriteFrame.fy, isFlipHorizontal, angle);
        }
    }

    public static void drawBitmap(Graphics target, Bitmap bitmap, int x, int y, boolean isFlipHorizontal) {
        if (isFlipHorizontal) {
            if (sprite == null) {
                sprite = new Sprite(bitmap.image);
            }
            sprite.setImage(bitmap.image, bitmap.getWidth(), bitmap.getHeight());
            sprite.setTransform(2);
            sprite.setPosition(x, y);
            sprite.paint(target);
        } else {
            target.drawImage(bitmap.image, x, y, 0);
        }
    }

    public static void drawSprite(Graphics target, SpriteFrame spriteFrame, int x, int y, boolean isFlipHorizontal) {
        if (isFlipHorizontal) {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + (spriteFrame.width - (spriteFrame.fx + spriteFrame.bitmap.getWidth())), y + spriteFrame.fy, isFlipHorizontal);
        } else {
            Bitmap.drawBitmap(target, spriteFrame.bitmap, x + spriteFrame.fx, y + spriteFrame.fy, isFlipHorizontal);
        }
    }

    static {
        verts = new short[]{0, 0, 0, 100, 0, 0, 100, 100, 0, 0, 100, 0};
        uvs = new short[]{0, 0, 255, 0, 255, 255, 0, 255, 0};
        triangles = new int[]{0, 2, 1, 0, 3, 2};
    }
}

