/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.admanager.AdData;
import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameView;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Sound;
import com.renderedideas.platform.Storage;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.CreditView;
import com.renderedideas.yourgamename.GameplayView;
import com.renderedideas.yourgamename.HelpView;
import com.renderedideas.yourgamename.LevelSelectView;
import com.renderedideas.yourgamename.ScoreView;
import com.renderedideas.yourgamename.Selector;
import com.renderedideas.yourgamename.StorageHandler;
import com.renderedideas.yourgamename.ViewMenu;
import com.renderedideas.yourgamename.ViewSplash;

public class Game {
    public static AdData gamePlayAdData;
    public static boolean showAd;
    public static GameFont commonFont;
    public static boolean endlessMode;
    public static String volumeStorageValue;
    public static boolean volumeFlag;
    public static String playerName;
    public static String highScoreString;
    public static int highScore;
    public static Sound clickSound;

    public static void startGame() {
        GameManager.currentView = new ViewSplash();
        Game.setVolumeFlag();
        Game.setPlayerName();
        Game.setHighScore();
        commonFont = new GameFont("fonts/commonFonts");
        if (!PlatformService.isTouchSupported()) {
            Selector.initialize();
        }
        try {
            clickSound = new Sound(100, "audio/click.wav", 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setVolumeFlag() {
        volumeStorageValue = Storage.readData("volumeStorageValue");
        volumeFlag = volumeStorageValue == null || volumeStorageValue.equals("true");
    }

    public static void changeView(int viewID) {
        GameView view = GameManager.currentView;
        GameManager.currentView = null;
        view.deallocate();
        if (viewID == Constants.VIEW_ID_MENU) {
            GameManager.currentView = new ViewMenu();
        } else if (viewID == Constants.VIEW_ID_GAMEPLAY_VIEW) {
            GameManager.currentView = new GameplayView();
        } else if (viewID == Constants.VIEW_ID_CREDIT) {
            GameManager.currentView = new CreditView();
        } else if (viewID != Constants.VIEW_ID_HOWTOPLAY) {
            if (viewID == Constants.VIEW_ID_HELP) {
                GameManager.currentView = new HelpView();
            } else if (viewID == Constants.SCORE_VIEW_ID) {
                GameManager.currentView = new ScoreView();
            } else if (viewID == Constants.LEVEL_SELECT_VIEW_ID) {
                GameManager.currentView = new LevelSelectView();
            }
        }
    }

    public static void playClickSound() {
        if (volumeFlag) {
            clickSound.play();
        }
    }

    private static void setPlayerName() {
        playerName = StorageHandler.getPlayerName();
        if (playerName == null) {
            StorageHandler.savePlayerName("Player");
            playerName = StorageHandler.getPlayerName();
        }
    }

    private static void setHighScore() {
        highScoreString = Storage.readData("SCORE");
        if (highScoreString == null) {
            highScore = 0;
            StorageHandler.savePlayerScore(highScore);
        } else {
            highScore = Integer.parseInt(highScoreString);
        }
    }
}

