/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.graphics.CNText;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import schoolfriends.CNPaletteShiftImage;
import schoolfriends.CNSound;
import schoolfriends.graphics.Render;
import schoolfriends.loading.CNSaveData;

public class Data {
    public static final int GENDER_FEMALE = 0;
    public static final int GENDER_MALE = 1;
    public static int FRAME_MULTIPLIER = 30;
    public static int MEMORY_LENGTH = 5;
    public static int[] mobjs;
    public static CNImage exclamation;
    public static final boolean OBJECTGFXTYPE_Object = false;
    public static final boolean OBJECTGFXTYPE_Character = true;
    public static final int TRIGGER_OnRoomEnter = 1;
    public static final int TRIGGER_OnIdle = 2;
    public static final int TRIGGER_OnStat = 3;
    public static final int TRIGGER_OnPlayerNear = 4;
    public static final int TRIGGER_OnClick = 5;
    public static final int TRIGGER_OnRoomLeave = 6;
    public static Room[] rooms;
    public static int[] roomnames;
    public static boolean[] roomlocked;
    public static Tile[] tiles;
    public static MasterCharacter[] mchrs;
    public static PlacedObject player;
    public static MasterCharacter playerCharacter;
    public static CNImage[] animations;
    public static CNImage shadow;
    public static CNSound[] sounds;
    public static Frame[][] frames;
    public static Palette[] palettes;
    public static int tile_w;
    public static int tile_h;
    public static Vector destinations;
    public static Vector options;
    public static int tile_w_half;
    public static int tile_h_half;
    public static Tile[][][] partlists;
    public static Tile[] manifest;
    private static final int STAR_EXPONENT = 4;
    private static final int STAR_EXPONENT1 = 4;
    private static final int STAR_EXPONENT2 = 12;
    private static final int STAR_EXPONENT3 = 24;
    private static final int STAR_EXPONENT4 = 40;
    private static final int STAR_EXPONENT5 = 60;
    private static final int STAR_EXPONENT6 = 84;
    private static int STAR_TOTALVALUE;

    public static void SaveData() {
        try {
            RecordStore s = RecordStore.openRecordStore((String)"SchoolData", (boolean)true);
            boolean bl = false;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static int getCharacterID(String name) {
        return Data.getCharacterID(CNText.getStringID(name));
    }

    public static int getCharacterID(int name) {
        for (int i = 0; i < mchrs.length; ++i) {
            if (Data.mchrs[i].ingamename != name) continue;
            return i;
        }
        return -1;
    }

    public static int setCharacterAttribute(int character, int attribute, int value) {
        try {
            if (value > 100) {
                value = 100;
            }
            if (value < 0) {
                value = 0;
            }
            Data.mchrs[character].attributes[attribute] = value;
            return value;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getCharacterAttribute(int character, int attribute) {
        try {
            return Data.mchrs[character].attributes[attribute];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getCharacterAttribute(MasterCharacter character, int attribute) {
        try {
            return character.attributes[attribute];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static MasterCharacter getCharacter(int character) {
        if (character < 0 || character >= mchrs.length) {
            return null;
        }
        return mchrs[character];
    }

    static {
        tile_w = 24;
        tile_h = 12;
        destinations = new Vector();
        options = new Vector();
        tile_w_half = tile_w / 2;
        tile_h_half = tile_h / 2;
        for (int i = 1; i <= 5; ++i) {
            STAR_TOTALVALUE += 4 * i;
        }
    }

    public static class RequiredAnimation {
        public int mchr;
        public int anim;

        public RequiredAnimation(int mchr, int anim) {
            this.mchr = mchr;
            this.anim = anim;
        }
    }

    public static class CronJob {
        public long time;
        public int scriptID;

        public CronJob(long time, int scriptID) {
            this.time = time;
            this.scriptID = scriptID;
        }
    }

    public static class Destination {
        public int x;
        public int y;
        public int room;
        public boolean tile;

        public Destination() {
        }

        public Destination(int room, int x, int y, boolean tile) {
            this.room = room;
            this.x = x;
            this.y = y;
            this.tile = tile;
        }
    }

    public static class Palette {
        public int colour;
        public int index;
        public int row;
        public int[] colours;

        public Palette() {
        }

        public Palette(int colour, int[] colours) {
            this.colour = colour;
            this.colours = colours;
        }
    }

    public static class GeneratedImageSet {
        public static final int MAX_GENERATED_IMAGES = 16;
        private int m_iGenImgsPointer = -1;
        private GeneratedImage[] genimgs;
        private String m_original;

        public GeneratedImageSet(String _original, GeneratedImage img) {
            this.m_original = _original;
            this.genimgs = new GeneratedImage[16];
            this.pushGeneratedImage(img);
        }

        public void pushGeneratedImage(GeneratedImage _img) {
            ++this.m_iGenImgsPointer;
            if (this.m_iGenImgsPointer >= 16) {
                this.m_iGenImgsPointer = 0;
            }
            this.genimgs[this.m_iGenImgsPointer] = _img;
        }

        public final GeneratedImage getGeneratedImage(int _index) {
            return this.genimgs[_index];
        }

        public final String getOriginalPath() {
            return this.m_original;
        }
    }

    public static class GeneratedImage {
        private String m_original;
        private Image m_generated;
        private int[] m_palindices;
        private static int[] m_prevPalindices;

        public GeneratedImage(String _original, int[] _palindices) {
            this.m_original = _original;
            this.m_palindices = _palindices;
            this.generate();
            if (this.put()) {
                return;
            }
        }

        public GeneratedImage(int _partlist, int _partset, int _part, int[] _palindices) {
            this.m_original = "" + _partlist + "-" + _partset + "-" + _part;
            this.m_palindices = _palindices;
            this.generateUsingManifest(_partlist, _partset, _part);
            if (this.put()) {
                return;
            }
        }

        private boolean put() {
            int i = Render.generated_image_sets.size();
            while (i-- > 0) {
                GeneratedImageSet gis = (GeneratedImageSet)Render.generated_image_sets.elementAt(i);
                if (!gis.getOriginalPath().equals(this.m_original)) continue;
                gis.pushGeneratedImage(this);
                return true;
            }
            Render.generated_image_sets.addElement(new GeneratedImageSet(this.m_original, this));
            return false;
        }

        private void generate() {
            try {
                boolean shifting = false;
                if (this.m_palindices != null) {
                    byte[] g_bFind = null;
                    byte[] g_bReplace = null;
                    m_prevPalindices = this.m_palindices;
                    int len = palettes.length;
                    g_bFind = new byte[len * 3];
                    g_bReplace = new byte[len * 3];
                    for (int i = len - 1; i > 0; --i) {
                        int col1 = Data.palettes[i].colour;
                        int index = 0;
                        if (Data.palettes[i].index < this.m_palindices.length && this.m_palindices[Data.palettes[i].index] > 0) {
                            index = this.m_palindices[Data.palettes[i].index] - 1;
                        }
                        int col2 = Data.palettes[i].colours[index % Data.palettes[i].colours.length];
                        g_bFind[i * 3] = (byte)((col1 & 0xFF0000) >> 16);
                        g_bFind[i * 3 + 1] = (byte)((col1 & 0xFF00) >> 8);
                        g_bFind[i * 3 + 2] = (byte)(col1 & 0xFF);
                        g_bReplace[i * 3] = (byte)((col2 & 0xFF0000) >> 16);
                        g_bReplace[i * 3 + 1] = (byte)((col2 & 0xFF00) >> 8);
                        g_bReplace[i * 3 + 2] = (byte)(col2 & 0xFF);
                    }
                    this.m_generated = CNPaletteShiftImage.createImage(this.m_original, g_bFind, g_bReplace);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void generateUsingManifest(int _partlist, int _partset, int _part) {
            try {
                boolean shifting = false;
                if (this.m_palindices != null) {
                    Image source = Data.partlists[_partlist][_partset][_part].img.getImage();
                    boolean x = false;
                    boolean y = false;
                    int w = source.getWidth();
                    int h = source.getHeight();
                    int[] rgb = new int[w * h];
                    source.getRGB(rgb, 0, w, 0, 0, w, h);
                    int len = palettes.length;
                    int index = 0;
                    int[] iaReplace = new int[len];
                    for (int i = len - 1; i > 0; --i) {
                        index = 0;
                        if (Data.palettes[i].index < this.m_palindices.length && this.m_palindices[Data.palettes[i].index] > 0) {
                            index = this.m_palindices[Data.palettes[i].index] - 1;
                        }
                        iaReplace[i] = Data.palettes[i].colours[index % Data.palettes[i].colours.length];
                    }
                    this.m_generated = Image.createRGBImage((int[])rgb, (int)w, (int)h, (boolean)true);
                }
            }
            catch (Exception e) {
                Log.addError("Darn. I had an error paletteshifting!");
                e.printStackTrace();
            }
        }

        public boolean isThis(String _original, int[] _palindices) {
            if (_original != this.m_original || (_palindices == null || this.m_palindices == null) && _palindices != this.m_palindices) {
                return false;
            }
            if (_palindices == null) {
                return true;
            }
            if (_palindices.length != this.m_palindices.length) {
                return false;
            }
            for (int i = _palindices.length - 1; i >= 0; --i) {
                if (_palindices[i] == this.m_palindices[i]) continue;
                return false;
            }
            return true;
        }

        public boolean isThisPalette(int[] _palindices) {
            if ((_palindices == null || this.m_palindices == null) && _palindices != this.m_palindices) {
                return false;
            }
            if (_palindices == null || _palindices == this.m_palindices) {
                return true;
            }
            if (_palindices.length != this.m_palindices.length) {
                return false;
            }
            for (int i = _palindices.length - 1; i >= 0; i -= 4) {
                if (_palindices[i] == this.m_palindices[i]) continue;
                return false;
            }
            return true;
        }

        public final Image getImage() {
            return this.m_generated;
        }
    }

    public static class FrameElement {
        public int partlist;
        public int part;
        public int x;
        public int y;
        public int flags;
    }

    public static class Frame {
        public int time;
        public FrameElement[] elements;

        public Frame(int time) {
            this.time = time;
        }
    }

    public static class PlacedObject
    extends DepthSortable {
        public int z;
        public int depth_fix;
        public boolean type;
        public boolean left = true;
        public boolean hidden = false;
        public boolean day = true;
        public boolean night = true;
        public boolean directionlocked = false;
        public int gfx;
        public int ingamename;
        public int sel_x;
        public int sel_y;
        public int chr_anim = 1;
        public int frame = 0;
        public int frame_timer = 0;
        public int idle_anim = 1;
        public AssignedScript[] scripts;
        public boolean anim = false;
        public boolean anim_loop = true;
        public boolean anim_reverse = false;
        public boolean anim_forwards = true;
        public int anim_start = 0;
        public int anim_end = 0;
        public int anim_frame = 0;
        public int anim_delay = 0;
        public int anim_delay_counter = 0;
        public long anim_duration = 0L;

        public PlacedObject() {
            this.hidden = false;
            this.anim = false;
            this.chr_anim = 1;
        }

        public PlacedObject(int x, int y, int z, int depth_fix, boolean type, int gfx, AssignedScript[] scripts) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.depth_fix = depth_fix;
            this.type = type;
            this.gfx = gfx;
            this.scripts = scripts;
            this.hidden = false;
            this.anim = false;
            this.chr_anim = 1;
        }
    }

    public static class MasterCharacter
    implements CNSaveData.Storable {
        public int ingamename;
        public int[] attributes;
        public AssignedScript[] scripts;
        public int[] partsets;
        public int[] palindices;
        public Tile[][] frames;
        public boolean SO = false;
        public boolean mugged;
        public boolean gottenLaid = false;
        public boolean carryingGift = false;
        public int[] memory;
        public int memoryPointer;
        public int m_id;
        public int mugs;
        public static final int STAR_WIDTH = 15;
        private static final int[] levelColors = new int[]{16730112, 16733184, 16745216, 0xFFA000, 0xFFC000};
        public static int colorToggle = 0;
        private static int[] m_iaStoredPaletteIndicies;
        private static int[] m_iaStoredPartsets;

        public MasterCharacter(int _id) {
            this.m_id = _id;
            this.SO = false;
            this.mugged = false;
        }

        public int remember(int topic) {
            int dejavu = this.getTimesMemorised(topic);
            this.memory[this.memoryPointer] = topic;
            ++this.memoryPointer;
            if (this.memoryPointer >= this.memory.length) {
                this.memoryPointer = 0;
            }
            return dejavu;
        }

        private int getTimesMemorised(int _topic) {
            int times = 0;
            for (int i = 0; i < this.memory.length; ++i) {
                if (this.memory[i] != _topic) continue;
                ++times;
            }
            return times;
        }

        private int getLastMemory() {
            return this.memory[this.memoryPointer > 0 ? this.memoryPointer - 1 : this.memory.length - 1];
        }

        public int getRelationshipStars() {
            return 0;
        }

        public void save(CNSaveData _rms) {
            _rms.writeArrayS8(this.partsets);
            _rms.writeArrayU16(this.palindices);
            _rms.writeArrayS8(this.attributes);
        }

        public void load(CNSaveData _rms) throws IOException {
            this.partsets = _rms.readArrayS8();
            this.palindices = _rms.readArrayU16();
            this.attributes = _rms.readArrayS8();
        }

        public static void CloneCharacter(int source, int destination) {
            Data.mchrs[destination].frames = Data.mchrs[source].frames;
            Data.mchrs[destination].palindices = Data.mchrs[source].palindices;
            Data.mchrs[destination].partsets = Data.mchrs[source].partsets;
        }

        public static void CloneClothes(int source, int destination) {
            try {
                int[] temp;
                MasterCharacter src = mchrs[source];
                MasterCharacter dest = mchrs[destination];
                if (src == null || dest == null || src == dest) {
                    return;
                }
                if (dest.partsets.length < src.partsets.length) {
                    temp = new int[src.partsets.length];
                    System.arraycopy(dest.partsets, 0, temp, 0, dest.partsets.length);
                    dest.partsets = temp;
                }
                if (dest.palindices.length < src.palindices.length) {
                    temp = new int[src.palindices.length];
                    System.arraycopy(dest.palindices, 0, temp, 0, dest.palindices.length);
                    dest.palindices = temp;
                }
                int i = dest.palindices.length;
                while (i-- > 0) {
                    dest.palindices[i] = src.palindices[i];
                }
                dest.frames = null;
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class AssignedScript {
        public int script;
        public int trigger;
    }

    public static class Tile {
        public int hotspot_x;
        public int hotspot_y;
        public CNImage img;
    }

    public static class CNPoly {
        public int colourIndex;
        public boolean m_wall;
        private CNPoint[] m_points;

        public CNPoly() {
            this.m_points = new CNPoint[3];
            this.colourIndex = 0;
            this.m_wall = false;
        }

        public CNPoly(CNPoint[] p) {
            this.m_points = p;
            this.colourIndex = 0;
            this.m_wall = false;
        }

        public CNPoint[] getPoints() {
            return this.m_points;
        }
    }

    public static class CNPoint {
        public int X;
        public int Y;

        public CNPoint() {
            this.X = 0;
            this.Y = 0;
        }

        public CNPoint(int in_x, int in_y) {
            this.X = in_x;
            this.Y = in_y;
        }
    }

    public static class CNColour {
        public int r;
        public int g;
        public int b;

        public CNColour() {
            this.r = 0;
            this.g = 0;
            this.b = 0;
        }

        public CNColour(int in_r, int in_g, int in_b) {
            this.r = in_r;
            this.g = in_g;
            this.b = in_b;
        }
    }

    public static class Room {
        public int[][] floor;
        public Wall[] walls;
        public PlacedObject[] objs;
        public int name;
        public int sound;
        public int spawnX;
        public int spawnY;
        public int tileCountX;
        public int tileCountY;
        public Vector shadowPoints;
        public CNColour[] colours;
        public static PlacedObject g_highlightedobject;

        public void RemoveCharacter(int character) {
            for (int i = this.objs.length - 1; i >= 0; --i) {
                if (!this.objs[i].type || this.objs[i].gfx != character) continue;
                this.RemoveObjectID(i);
            }
        }

        public void RemoveObject(int objnum) {
            int i = this.objs.length;
            while (i-- > 0) {
                if (this.objs[i].type || this.objs[i].gfx != objnum) continue;
                this.RemoveObjectID(i);
            }
        }

        public void RemoveObjectID(int objnum) {
            if (objnum >= 0 && objnum < this.objs.length) {
                PlacedObject[] prev = this.objs;
                this.objs = new PlacedObject[prev.length - 1];
                if (objnum > 0) {
                    System.arraycopy(prev, 0, this.objs, 0, objnum);
                }
                if (objnum < prev.length - 1) {
                    System.arraycopy(prev, objnum + 1, this.objs, objnum, prev.length - objnum - 1);
                }
                Render.updateDepthSort(this);
                System.gc();
            }
        }

        public boolean attemptMove(int x_new, int y_new) {
            int tx = Render.worldToTileX(x_new, y_new);
            int ty = Render.worldToTileY(x_new, y_new);
            if (tx >= 0 && ty >= 0 && tx < this.floor[0].length && ty < this.floor.length && this.floor[ty][tx] > 0) {
                int r = tile_w * 24;
                int i = this.objs.length;
                while (i-- > 0) {
                    int y;
                    int x;
                    PlacedObject p = this.objs[i];
                    if (!p.type || p.hidden || (x = x_new - p.x) * x + (y = y_new - p.y) * y * 9 >= r) continue;
                    return false;
                }
                Data.player.x = x_new;
                Data.player.y = y_new;
                return true;
            }
            return false;
        }

        public void ShowCharacter(int character, int x, int y, boolean relative, boolean tile) {
            if (tile) {
                int xx = x;
                int yy = y;
                x = Render.tileToWorldX(xx, yy) + tile_w_half;
                y = Render.tileToWorldY(xx, yy);
                if (relative) {
                    x += Render.worldToTileX(Data.player.x, Data.player.y);
                    y += Render.worldToTileY(Data.player.x, Data.player.y);
                }
            } else if (relative) {
                x += Data.player.x;
                y += Data.player.y;
            }
            PlacedObject[] prev = this.objs;
            this.objs = new PlacedObject[prev.length + 1];
            System.arraycopy(prev, 0, this.objs, 0, prev.length);
            if (character >= 0 && character < mchrs.length) {
                this.objs[prev.length] = new PlacedObject(x, y, 0, 0, true, character, Data.mchrs[character].scripts);
                this.objs[prev.length].ingamename = Data.mchrs[character].ingamename;
            } else {
                this.objs[prev.length] = new PlacedObject(x, y, 0, 0, true, character, null);
            }
            this.objs[prev.length].sel_y = -70;
            Render.updateDepthSort(this);
            System.gc();
        }

        public void HideAllCharactersInRoom() {
            int i = this.objs.length;
            while (i-- > 0) {
                if (!this.objs[i].type) continue;
                this.objs[i].hidden = true;
            }
            Render.updateDepthSort(this);
        }

        public void HideObjectID(int start, int end) {
            if (end > start) {
                start ^= end;
                end ^= start;
                start ^= end;
            }
            while (start <= end) {
                this.objs[start].hidden = true;
                ++start;
            }
            Render.updateDepthSort(this);
        }

        public void ShowObjectID(int start, int end) {
            if (end > start) {
                start ^= end;
                end ^= start;
                start ^= end;
            }
            while (start <= end) {
                this.objs[start].hidden = false;
                ++start;
            }
            Render.updateDepthSort(this);
        }

        public void UnhideAll() {
            int i = this.objs.length;
            while (i-- > 0) {
                this.objs[i].hidden = false;
            }
            Render.updateDepthSort(this);
        }

        public void SetSelectedObject(int objnum) {
            g_highlightedobject = null;
            if (objnum < 0) {
                return;
            }
            int i = this.objs.length;
            while (i-- > 0) {
                if (this.objs[i].type || this.objs[i].gfx != objnum || this.objs[i].hidden) continue;
                g_highlightedobject = this.objs[i];
                return;
            }
        }

        public void SetSelectedCharacter(int character) {
            g_highlightedobject = null;
            for (int i = this.objs.length - 1; i >= 0; --i) {
                if (!this.objs[i].type || this.objs[i].gfx != character || this.objs[i].hidden) continue;
                g_highlightedobject = this.objs[i];
                return;
            }
        }

        public void setHighlightedIndex(int _index) {
            g_highlightedobject = _index < 0 ? null : this.objs[_index];
        }

        public int getHighlightedIndex() {
            if (g_highlightedobject != null) {
                int i = this.objs.length;
                while (i-- > 0) {
                    if (this.objs[i] != g_highlightedobject) continue;
                    return i;
                }
            }
            return -1;
        }

        public void UnsetSelectedObject() {
            g_highlightedobject = null;
        }

        public void SetSelectedObjectID(int number) {
            try {
                g_highlightedobject = this.objs[number];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Wall
    extends DepthSortable {
        public int tile;
    }

    public static abstract class DepthSortable {
        public int x;
        public int y;
        public int depth;
    }
}

