/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.graphics;

import com.creativenorth.base.Core;
import com.creativenorth.dev.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CNImage {
    private int m_command;
    private Image m_image;
    private String m_path;
    private int m_w;
    private int m_h;
    private boolean m_isBad;
    private boolean m_isLoaded;
    private boolean m_isPermanent;

    public CNImage(Image _img) {
        this.m_image = _img;
        this.m_w = this.m_image.getWidth();
        this.m_w = this.m_image.getHeight();
        this.m_isBad = false;
        this.m_isLoaded = true;
        this.m_isPermanent = true;
    }

    public CNImage(String path) {
        this.m_isBad = false;
        this.m_isLoaded = false;
        this.m_isPermanent = false;
        this.prime(path);
    }

    public CNImage(int command) {
        this.m_isBad = false;
        this.m_isLoaded = false;
        this.m_isPermanent = false;
        this.prime(command);
    }

    public String getPath() {
        return this.m_path;
    }

    private void prime(String path) {
        this.m_path = path;
        this.m_command = 0;
        try {
            this.load();
            if (this.m_image == null) {
                this.m_isBad = true;
                Log.addError("Null image created from: '" + this.m_path + "'");
                return;
            }
        }
        catch (Exception e) {
            this.m_isBad = true;
            this.m_image = null;
            Log.addError("Image file not valid: '" + this.m_path + "'");
            return;
        }
        this.m_w = this.m_image.getWidth();
        this.m_h = this.m_image.getHeight();
        this.m_image = null;
        if (this.m_w <= 0 || this.m_h <= 0) {
            this.m_isBad = true;
            Log.addError("Image created from: '" + this.m_path + "' has invalid sizes");
            return;
        }
    }

    private void prime(int command) {
        this.m_path = "";
        this.m_command = command;
        try {
            this.load();
            if (this.m_image == null) {
                this.m_isBad = true;
                Log.addError("Null image created from command: '" + this.m_command + "'");
                return;
            }
        }
        catch (Exception e) {
            this.m_isBad = true;
            this.m_image = null;
            Log.addError("Image command not valid: '" + this.m_command + "'");
            return;
        }
        this.m_w = this.m_image.getWidth();
        this.m_h = this.m_image.getHeight();
        this.m_image = null;
        if (this.m_w <= 0 || this.m_h <= 0) {
            this.m_isBad = true;
            Log.addError("Image created from command: '" + this.m_command + "' has invalid sizes");
            return;
        }
    }

    private void load() throws IOException {
        if (this.m_isPermanent) {
            return;
        }
        this.m_image = this.m_command > 0 ? Core.me.createImageFromCommand(this.m_command) : Image.createImage((String)this.m_path);
    }

    public void reload() {
        if (this.m_isPermanent) {
            return;
        }
        if (this.m_isBad || this.m_isLoaded) {
            return;
        }
        try {
            this.load();
        }
        catch (Exception e) {
            Log.addError("Image reload failed for path: '" + this.m_path + "' command: '" + this.m_command + "'");
        }
        this.m_isLoaded = true;
    }

    public void unload() {
        if (this.m_isPermanent) {
            return;
        }
        this.m_image = null;
        this.m_isLoaded = false;
    }

    public int getWidth() {
        return this.m_w;
    }

    public int getHeight() {
        return this.m_h;
    }

    public Image getImage() {
        this.reload();
        return this.m_image;
    }

    public static int copy4ByteInt(InputStream input, ByteArrayOutputStream output) throws IOException {
        int store = input.read();
        output.write(store);
        int value = store;
        value <<= 8;
        store = input.read();
        output.write(store);
        value += store;
        value <<= 8;
        store = input.read();
        output.write(store);
        value += store;
        value <<= 8;
        store = input.read();
        output.write(store);
        return value += store;
    }

    public static void write4ByteInt(long value, ByteArrayOutputStream output) {
        output.write((int)(value >>> 24) & 0xFF);
        output.write((int)(value >>> 16) & 0xFF);
        output.write((int)(value >>> 8) & 0xFF);
        output.write((int)value & 0xFF);
    }
}

