/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.io;

import com.creativenorth.dev.Log;
import java.io.IOException;
import java.io.InputStream;

public class Stream {
    protected InputStream loadStream;
    protected byte[] dataBytes;
    protected int dataPosition;
    private int m_iMaxSize;
    private int m_iCurrentFile;
    private String m_path;

    public Stream() {
        this.loadStream = null;
        this.dataBytes = null;
        this.dataPosition = 0;
    }

    public Stream(String _path, int _maxSize) {
        this.m_iMaxSize = _maxSize;
        this.m_iCurrentFile = 0;
        this.m_path = _path;
        this.loadStream = _path.getClass().getResourceAsStream(this.m_path + this.m_iCurrentFile);
        if (this.loadStream == null) {
            Log.addError("Failed trying to load stream for the file '" + this.m_path + "'");
        }
        this.dataBytes = null;
        this.dataPosition = 0;
    }

    public Stream(String path) {
        this.loadStream = path.getClass().getResourceAsStream(path);
        if (this.loadStream == null) {
            Log.addError("Failed trying to load stream for the file '" + path + "'");
        }
        this.dataBytes = null;
        this.dataPosition = 0;
        this.m_iMaxSize = 0;
    }

    public Stream(byte[] data) {
        this.loadStream = null;
        this.dataBytes = data;
        this.dataPosition = 0;
    }

    public int available() throws IOException {
        if (this.loadStream != null) {
            return this.loadStream.available();
        }
        return 0;
    }

    private void skip() throws IOException {
        if (this.loadStream != null) {
            if (this.m_iMaxSize > 0 && this.dataPosition + 1 > this.m_iMaxSize) {
                if (this.loadStream != null) {
                    this.loadStream.close();
                }
                ++this.m_iCurrentFile;
                this.loadStream = this.m_path.getClass().getResourceAsStream(this.m_path + this.m_iCurrentFile);
                if (this.loadStream == null) {
                    Log.addError("Failed trying to load stream for the file '" + this.m_path + "'");
                }
                this.dataBytes = null;
                this.dataPosition = 0;
            }
            ++this.dataPosition;
            this.loadStream.skip(1L);
        }
    }

    private int read() throws IOException {
        if (this.loadStream != null) {
            if (this.m_iMaxSize > 0 && this.dataPosition + 1 > this.m_iMaxSize) {
                if (this.loadStream != null) {
                    this.loadStream.close();
                }
                ++this.m_iCurrentFile;
                this.loadStream = this.m_path.getClass().getResourceAsStream(this.m_path + this.m_iCurrentFile);
                if (this.loadStream == null) {
                    // empty if block
                }
                this.dataBytes = null;
                this.dataPosition = 0;
            }
            ++this.dataPosition;
            return this.loadStream.read();
        }
        if (this.dataBytes != null) {
            int val = this.dataBytes[this.dataPosition];
            val += 256;
            ++this.dataPosition;
            return val %= 256;
        }
        return 0;
    }

    public void skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            this.skip();
        }
    }

    public void close() throws IOException {
        if (this.loadStream != null) {
            this.loadStream.close();
        }
        if (this.dataBytes != null) {
            this.dataBytes = null;
            this.dataPosition = 0;
        }
    }

    public int position() {
        return this.dataPosition;
    }

    public String readString() throws IOException {
        int length = this.read();
        String value = "";
        for (int c = 0; c < length; ++c) {
            value = value + (char)this.read();
        }
        return value;
    }

    public void skipLongString() throws IOException {
        int length = this.readU16();
        this.skip(length);
    }

    public String readLongString() throws IOException {
        int length = this.readU16();
        String value = "";
        for (int c = 0; c < length; ++c) {
            value = value + (char)this.read();
        }
        return value.toString();
    }

    public int[] readArrayU8() throws IOException {
        int[] value = new int[this.readU16()];
        int i = value.length;
        while (i-- > 0) {
            value[i] = this.readU8();
        }
        return value;
    }

    public int[] readArrayU16() throws IOException {
        int[] value = new int[this.readU16()];
        int i = value.length;
        while (i-- > 0) {
            value[i] = this.readU16();
        }
        return value;
    }

    public int[] readArrayS8() throws IOException {
        int[] value = new int[this.readU16()];
        int i = value.length;
        while (i-- > 0) {
            value[i] = this.readS8();
        }
        return value;
    }

    public int readU8() throws IOException {
        int value = this.read();
        return value;
    }

    public int readU16() throws IOException {
        int value = this.read();
        value <<= 8;
        return value += this.read();
    }

    public int readU24() throws IOException {
        int value = this.read();
        value <<= 8;
        value += this.read();
        value <<= 8;
        return value += this.read();
    }

    public int readU32() throws IOException {
        int value = this.read();
        value <<= 8;
        value += this.read();
        value <<= 8;
        value += this.read();
        value <<= 8;
        return value += this.read();
    }

    public int readS8() throws IOException {
        int value = this.read();
        return value < 128 ? value : value - 256;
    }

    public int readS16() throws IOException {
        int value = this.read();
        value <<= 8;
        return (value += this.read()) < 32768 ? value : value - 65536;
    }

    public int readS24() throws IOException {
        int value = this.read();
        value <<= 8;
        value += this.read();
        value <<= 8;
        return (value += this.read()) < 0x800000 ? value : value - 0x1000000;
    }

    public long readS32() throws IOException {
        long value = this.read();
        value <<= 8;
        value += (long)this.read();
        value <<= 8;
        value += (long)this.read();
        value <<= 8;
        return (value += (long)this.read()) < 0x80000000L ? value : value - 0x100000000L;
    }

    public String readFullString() throws IOException {
        String value = "";
        char a = (char)this.read();
        while ((byte)a != -1) {
            value = value + a;
            a = (char)this.read();
        }
        return value;
    }

    public String[] toLines() {
        if (this.dataBytes == null) {
            return null;
        }
        int lineCount = 0;
        String line = "";
        for (int i = 0; i < this.dataBytes.length; ++i) {
            if (this.dataBytes[i] == 10) {
                if ((line = line.trim()).length() > 0) {
                    ++lineCount;
                }
                line = "";
                continue;
            }
            line = line + (char)this.dataBytes[i];
        }
        String[] value = new String[lineCount];
        lineCount = 0;
        for (int i = 0; i < this.dataBytes.length; ++i) {
            if (this.dataBytes[i] == 10) {
                if ((line = line.trim()).length() > 0) {
                    value[lineCount] = line;
                    ++lineCount;
                }
                line = "";
                continue;
            }
            line = line + (char)this.dataBytes[i];
        }
        return value;
    }
}

