/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNMosaic;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import schoolfriends.loading.CNSaveData;

public class MessageList
extends ScreenObject
implements CNSaveData.Storable {
    public static MessageList me;
    final int MAX_MESSAGES;
    int messageCount = 0;
    int[] m_messageList;
    int[] m_fromList;
    int highlightedMessage = 0;
    int topMessage = 0;
    int m_iMessageLines;
    final int BAR_HEIGHT;
    final int SEPARATOR_THICKNESS;
    final int TEXT_DROP;
    final int SHIFT_BOUNDRY;
    int ROW_COUNT;
    boolean m_bPopupActive;
    final int POPUP_MARGIN;

    public MessageList() {
        this.MAX_MESSAGES = 20;
        this.BAR_HEIGHT = 20;
        this.SEPARATOR_THICKNESS = 2;
        this.TEXT_DROP = 4;
        this.SHIFT_BOUNDRY = 2;
        this.POPUP_MARGIN = 5;
        this.visible = false;
        me = this;
        this.m_messageList = new int[20];
        this.m_fromList = new int[20];
    }

    public void load(Stream _stream) throws IOException {
        super.load(_stream);
        this.ROW_COUNT = this.boundsHeight / 20;
        this.enableScrollBar(11, 3, 10217215, 40951, 10217215);
    }

    public void refresh() {
        if (this.messageCount <= 0) {
            return;
        }
        this.m_iMessageLines = this.getTextdrop(this.messageCount - 1 - this.highlightedMessage);
        this.setScrollBarMaximum(20 * (this.messageCount + this.m_iMessageLines), this.boundsHeight - this.boundsHeight % 20);
        if (this.m_bScrollNeeded) {
            this.setScrollBarPosition(this.topMessage * 20);
        }
    }

    private int getTextdrop(int index) {
        return CNText.recalcNewlines(this.m_messageList[index], this.boundsWidth - 12);
    }

    private void shiftHighlight(int _dir) {
        if (this.messageCount <= 0) {
            return;
        }
        this.highlightedMessage += _dir;
        if (this.highlightedMessage < 0) {
            this.highlightedMessage = 0;
        }
        if (this.highlightedMessage > this.messageCount - 1) {
            this.highlightedMessage = this.messageCount - 1;
        }
        if (this.highlightedMessage - this.topMessage > this.ROW_COUNT - 2 - 1 && this.topMessage < this.messageCount - this.ROW_COUNT) {
            this.topMessage += _dir;
        }
        if (this.highlightedMessage - this.topMessage < 2 && this.topMessage > 0) {
            --this.topMessage;
        }
        this.refresh();
    }

    public void addMessage(int _from, int _msg) {
        if (_from < 0 || _msg < 0) {
            return;
        }
        if (this.messageCount == 20) {
            System.arraycopy(this.m_fromList, 1, this.m_fromList, 0, this.messageCount - 1);
            System.arraycopy(this.m_messageList, 1, this.m_messageList, 0, this.messageCount - 1);
            --this.messageCount;
        }
        this.m_fromList[this.messageCount] = _from;
        this.m_messageList[this.messageCount] = _msg;
        ++this.messageCount;
        int count = 0;
        int index = 0;
        for (int i = 0; i < this.messageCount; ++i) {
            if ((count += 22 + this.getTextdrop(i)) > this.boundsHeight) {
                this.ROW_COUNT = index;
                break;
            }
            ++index;
        }
    }

    public boolean onKeyDown(int keymask) {
        if (!this.visible) {
            return false;
        }
        if (this.m_bPopupActive) {
            this.m_bPopupActive = false;
            return true;
        }
        if ((keymask & 0x10) == 16) {
            this.m_bPopupActive = true;
            return true;
        }
        if ((keymask & 4) == 4) {
            this.shiftHighlight(1);
            return true;
        }
        if ((keymask & 1) == 1) {
            this.shiftHighlight(-1);
            return true;
        }
        return false;
    }

    public void render(CNGraphics graphics) {
        if (!this.visible) {
            return;
        }
        graphics.setColor(this.color);
        graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        graphics.fillRect(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        CNText.setFont(0);
        int y = this.boundsY;
        for (int i = this.topMessage; i < this.messageCount && i < this.topMessage + this.ROW_COUNT; ++i) {
            int x = this.boundsX + 5;
            graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            graphics.setColor(7983099);
            graphics.fillRect(this.boundsX, y, this.boundsWidth, 20);
            graphics.setColor(10217215);
            graphics.fillRect(this.boundsX + 2, y + 20 - 2, this.boundsWidth - 4, 2);
            if (i == this.highlightedMessage) {
                graphics.setColor(16742656);
                graphics.fillRect(this.boundsX + 2, y, this.boundsWidth - 4, 18);
            }
            int message = this.m_messageList[this.messageCount - 1 - i];
            int from = this.m_fromList[this.messageCount - 1 - i];
            if (from == 509) {
                CNMosaic.mosaics[4].draw(graphics.m_graphics, 1, x, y + 1);
            } else if (from == 508) {
                CNMosaic.mosaics[4].draw(graphics.m_graphics, 0, x, y + 1);
            }
            CNText.drawString(from, x + 20, y + 4);
            y += 20;
            if (i != this.highlightedMessage) continue;
            CNText.drawString(message, x + 6, y + 4);
            y += 20 * this.m_iMessageLines;
        }
        if (this.m_bScrollNeeded) {
            this.renderVerticalScrollBar(graphics.m_graphics, this.boundsX + this.boundsWidth, this.boundsY, this.boundsHeight);
        }
    }

    public void save(CNSaveData _rms) {
        int i;
        int[] arr = new int[20];
        for (i = 0; i < arr.length; ++i) {
            arr[i] = this.m_messageList[i];
        }
        _rms.writeArrayU16(arr);
        _rms.writeU8(this.messageCount);
        arr = new int[20];
        for (i = 0; i < arr.length; ++i) {
            arr[i] = this.m_fromList[i];
        }
        _rms.writeArrayU16(arr);
    }

    public void load(CNSaveData _rms) throws IOException {
        int[] arr = _rms.readArrayU16();
        this.m_messageList = new int[20];
        System.arraycopy(arr, 0, this.m_messageList, 0, 20);
        this.messageCount = _rms.readU8();
        arr = _rms.readArrayU16();
        this.m_fromList = new int[20];
        System.arraycopy(arr, 0, this.m_fromList, 0, 20);
    }

    public void clean() {
        this.m_messageList = new int[20];
        this.m_fromList = new int[20];
        this.messageCount = 0;
        this.highlightedMessage = 0;
        this.topMessage = 0;
        this.m_iMessageLines = 0;
    }
}

