/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.games;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.util.math.MathUtil;
import java.util.Random;
import schoolfriends.games.MiniGame;
import schoolfriends.graphics.Engine;

public class NumberGame
extends ScreenObject {
    private CNImage m_image;
    private int[] numbers;
    private int spacing_x = 2;
    private int revealed = 0;
    public int level = 3;
    public static NumberGame me;
    private static final long WAIT_TIME = 2000L;
    private boolean completed = false;
    private int targetlevel = 6;
    private boolean failed = false;
    private long timer;
    private Random rnd = new Random();

    public NumberGame() {
        me = this;
        this.m_image = new CNImage("/NumbersOrange24w.png");
        this.visible = false;
    }

    public boolean onKeyDown(int keymask) {
        if (keymask == 2048) {
            MiniGame.g_bNumberGameShown = false;
            this.hide();
        }
        if (keymask == 16 && ScreenObject.isVisible(65)) {
            this.failed = false;
            Engine.hideMessageBox();
            this.timer = System.currentTimeMillis() + 2000L;
        }
        return true;
    }

    public boolean onNumberKey(int number) {
        if (System.currentTimeMillis() < this.timer) {
            return false;
        }
        if (number == 5 && (this.failed || ScreenObject.isVisible(65))) {
            this.failed = false;
            Engine.hideMessageBox();
            this.timer = System.currentTimeMillis() + 2000L;
        } else if (this.revealed < this.numbers.length && number != this.numbers[this.revealed] && !this.failed) {
            this.failed = true;
            Engine.ShowMessageUltra(4, null, 98 + Math.abs(this.rnd.nextInt() % 7), -1, false);
            this.restartlevel();
        } else if (this.revealed < this.numbers.length && number == this.numbers[this.revealed]) {
            ++this.revealed;
        }
        return true;
    }

    public void newGame() {
        System.out.println("zzzzzzzzzzzzzzzzzzzzzzzzzzzzz");
        this.level = 3;
        this.completed = false;
        this.timer = System.currentTimeMillis() + 2000L;
        this.revealed = 0;
        this.numbers = new int[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.numbers[i] = MathUtil.random(1, 9);
        }
    }

    public void newGame(int _level) {
        this.level = 3;
        this.completed = false;
        this.timer = System.currentTimeMillis() + 2000L;
        this.revealed = 0;
        this.level += _level;
        this.numbers = new int[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.numbers[i] = MathUtil.random(1, 9);
        }
    }

    public void newGameLimited(int _level) {
        this.level = 3;
        this.completed = false;
        this.timer = System.currentTimeMillis() + 2000L;
        this.targetlevel = _level;
        this.revealed = 0;
        this.numbers = new int[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.numbers[i] = MathUtil.random(1, 9);
        }
    }

    private void nextLevel() {
        this.completed = false;
        this.revealed = 0;
        ++this.level;
        this.numbers = new int[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.numbers[i] = MathUtil.random(1, 9);
        }
    }

    private void restartlevel() {
        this.completed = false;
        this.revealed = 0;
        this.numbers = new int[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.numbers[i] = MathUtil.random(1, 9);
        }
    }

    public void render(CNGraphics g) {
        if (!this.visible) {
            return;
        }
        if (Engine.messageBoxIsVisible()) {
            return;
        }
        g.setClip(0, 0, CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT);
        int pos_x = (CNGraphics.SCREEN_WIDTH >> 1) - (this.numbers.length * (12 + this.spacing_x) - this.spacing_x) / 2;
        int pos_y = (CNGraphics.SCREEN_HEIGHT >> 1) - 30;
        g.fillDrawRect(40951, 1, pos_x - 5, pos_y - 10, this.numbers.length * (12 + this.spacing_x) - this.spacing_x + 10, 31);
        for (int i = 0; i < this.numbers.length; ++i) {
            if (i < this.revealed || System.currentTimeMillis() < this.timer) {
                g.m_graphics.drawRegion(this.m_image.getImage(), (this.numbers[i] - 1) * 12, 0, 12, 12, 0, pos_x, pos_y, 0);
            } else {
                g.m_graphics.drawRegion(this.m_image.getImage(), 108, 0, 12, 12, 0, pos_x, pos_y, 0);
            }
            pos_x += 12 + this.spacing_x;
        }
        if (this.revealed == this.numbers.length) {
            if (!this.completed) {
                this.completed = true;
                this.timer = System.currentTimeMillis();
            } else if (this.timer + 1000L < System.currentTimeMillis()) {
                if (this.level < 8) {
                    if (this.level == this.targetlevel) {
                        MiniGame.g_bNumberGameShown = false;
                        if (this.level == 7) {
                            Engine.ShowMessageUltra(4, null, 91, -1, false);
                        }
                        this.hide();
                    } else {
                        Engine.ShowMessageUltra(4, null, 92 + Math.abs(this.rnd.nextInt() % 6), -1, false);
                    }
                    this.nextLevel();
                } else {
                    Engine.ShowMessageUltra(4, null, 91, -1, false);
                    MiniGame.g_bNumberGameShown = false;
                    this.hide();
                    this.nextLevel();
                }
            }
        }
    }
}

