/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.levels;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class level3
extends GameCanvas
implements Runnable,
CommandListener {
    private Graphics g = this.getGraphics();
    private Slumber game;
    private boolean gameIsOn;
    private int resourcesReceived = 3;
    private int selectedCharacter;
    private Command backCommand;
    private Sprite character;
    private LayerManager layerManager;
    private TiledLayer floor;
    private TiledLayer walls;
    private TiledLayer holes;
    private Sprite torch;
    private Sprite torch2;
    private Image tileset;
    private Image tilesetHoles;
    private static final int TILE_LENGTH = 24;
    private int torchCounter = 1;
    private boolean characterMoving = false;
    private int windowX;
    private int windowY;
    private boolean pointerUp = false;
    private boolean pointerDown = false;

    public level3(boolean suppressKeyEvents, Slumber game, int x) {
        super(suppressKeyEvents);
        this.selectedCharacter = x;
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.addCharacter();
        try {
            this.initializeGraphics();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintObjects(this.g);
        this.game = game;
        this.gameIsOn = true;
        Thread thread = new Thread(this);
        thread.start();
        this.characterMoving = true;
    }

    public void initializeGraphics() throws IOException {
        try {
            this.tileset = Image.createImage((String)"/tilesetti.png");
        }
        catch (Exception e) {
            System.out.println("Tileset problem");
        }
        try {
            this.tilesetHoles = Image.createImage((String)"/level_3/reika.png");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.floor = this.getMap("/level_3/level3_floor.smp", this.tileset);
        this.walls = this.getMap("/level_3/level3_walls.smp", this.tileset);
        this.holes = this.getMap("/level_3/level3_holes.smp", this.tilesetHoles);
        this.layerManager = new LayerManager();
        this.layerManager.append((Layer)this.character);
        this.character.setVisible(true);
        this.character.setTransform(2);
        this.character.setPosition(96, 144);
        this.windowX = 48;
        this.windowY = 120 - this.getHeight() / 2;
        this.character.defineReferencePixel(20, 15);
        this.layerManager.append((Layer)this.holes);
        this.layerManager.append((Layer)this.walls);
        this.layerManager.append((Layer)this.floor);
        this.layerManager.setViewWindow(this.windowX, this.windowY, this.getWidth(), this.getHeight());
    }

    protected void paintObjects(Graphics g) {
        this.flushGraphics();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.layerManager.paint(g, 0, 0);
    }

    public void pointerPressed(int x, int y) {
        if (y < this.getWidth() / 2) {
            this.pointerUp = true;
        }
        if (y > this.getWidth() / 2) {
            this.pointerDown = true;
        }
    }

    public void moveToon() {
        int characterSpeedY = 6;
        if (this.pointerDown) {
            this.character.move(4, characterSpeedY);
            this.checkCollision(2);
        } else if (this.pointerUp) {
            this.character.move(4, characterSpeedY * -1);
            this.checkCollision(1);
        } else {
            this.character.move(4, 0);
        }
        this.windowX += 4;
        this.layerManager.setViewWindow(this.windowX, this.windowY, this.getWidth(), this.getHeight());
    }

    public void pointerReleased(int x, int y) {
        this.pointerDown = false;
        this.pointerUp = false;
    }

    public void pointerDragged(int x, int y) {
    }

    public void run() {
        int frameCounter = 1;
        while (this.gameIsOn) {
            if (this.characterMoving) {
                this.moveToon();
                if (frameCounter < 4) {
                    this.character.setFrame(frameCounter);
                    ++frameCounter;
                } else if (frameCounter == 4) {
                    frameCounter = 1;
                }
            }
            if (this.character.getX() == 2736) {
                this.characterMoving = false;
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    System.out.println("No sleep");
                }
                this.levelEnd();
            }
            this.checkForHole();
            this.paintObjects(this.g);
            this.torchCounter = this.torchCounter == 4 ? 0 : ++this.torchCounter;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Something went wrong");
            }
        }
    }

    public void addCharacter() {
        switch (this.selectedCharacter) {
            case 1: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/girl_animationtest.png"), 35, 41);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading IMG");
                }
            }
            case 5: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/herosprite copy.png"), 41, 43);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading image");
                }
            }
        }
    }

    public TiledLayer getMap(String fpath, Image ftiles) {
        TiledLayer tMap = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(fpath);
            DataInputStream ds = new DataInputStream(is);
            try {
                ds.skipBytes(8);
                int mW = ds.readByte();
                int mH = ds.readByte();
                byte tW = ds.readByte();
                byte tH = ds.readByte();
                tMap = new TiledLayer(mW, mH, ftiles, (int)tW, (int)tH);
                int rCtr = 0;
                while (rCtr < mH) {
                    int cCtr = 0;
                    while (cCtr < mW) {
                        byte nB = ds.readByte();
                        if (nB > 0) {
                            tMap.setCell(cCtr, rCtr, nB + 1);
                        }
                        ++cCtr;
                    }
                    ++rCtr;
                }
            }
            catch (Exception ex) {
                tMap = null;
                System.err.println("map loading error1 : " + ex.getMessage());
            }
            ds.close();
            ds = null;
            is = null;
        }
        catch (Exception ex) {
            tMap = null;
            System.err.println("map loading error2 : " + ex.getMessage());
        }
        return tMap;
    }

    public void checkCollision(int direction) {
        if (this.character.collidesWith(this.walls, true)) {
            if (direction == 1) {
                this.character.move(0, 6);
            }
            if (direction == 2) {
                this.character.move(0, -6);
            }
        }
    }

    public void checkForHole() {
        if (this.holes.getCell(this.character.getRefPixelX() / 24, this.character.getRefPixelY() / 24) != 0) {
            this.resourcesReceived = 0;
            this.characterMoving = false;
            try {
                Thread.sleep(900L);
            }
            catch (Exception e) {
                System.out.println("nope");
            }
            this.levelEnd();
        }
    }

    private void levelEnd() {
        this.game.endOfLevel(this.resourcesReceived);
        this.gameIsOn = false;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.game.save();
            this.game.endOfLevel(0);
        }
    }
}

