/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.ui;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class VillageScreen
extends GameCanvas
implements CommandListener {
    private Graphics g = this.getGraphics();
    private Slumber game;
    private int resources;
    private Sprite build;
    private Image villageBG;
    private Sprite workshop;
    private LayerManager layerManager;
    private Command backCommand = new Command("Back", 2, 1);
    private Image star;
    private int buildingCost = 4;
    private boolean workshopBuilt = false;
    private boolean hospitalBuilt = false;
    private boolean schoolBuilt = false;

    protected VillageScreen(boolean suppressKeyEvents, Slumber game) {
        super(suppressKeyEvents);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        try {
            this.initializeGfx();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.paintObjects(this.g);
        this.game = game;
    }

    protected void initializeGfx() throws IOException {
        this.layerManager = new LayerManager();
        this.build = new Sprite(Image.createImage((String)"/buildbutton.png"), 37, 22);
        this.star = Image.createImage((String)"/village_star copy.png");
        this.villageBG = Image.createImage((String)"/village.png");
        this.workshop = new Sprite(Image.createImage((String)"/workshop.png"), 126, 146);
        this.layerManager.append((Layer)this.workshop);
        this.layerManager.append((Layer)this.build);
        this.build.setPosition(this.getWidth() - this.build.getWidth() - 10, this.getHeight() - this.build.getHeight() - 10);
        this.workshop.setVisible(false);
    }

    protected void paintObjects(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.villageBG, 0, 0, 20);
        g.setColor(0, 0, 0);
        g.drawString("= " + this.resources, 55, this.getHeight() - this.star.getHeight() - 2, 17);
        g.drawImage(this.star, 10, this.getHeight() - this.star.getHeight() - 10, 20);
        this.layerManager.paint(g, 0, 0);
        this.flushGraphics();
    }

    public void pointerPressed(int x, int y) {
        if (y > this.getHeight() - this.build.getHeight() - 10 && x > this.getWidth() - this.build.getWidth() - 10) {
            this.build.nextFrame();
            this.paintObjects(this.g);
        }
    }

    public void pointerReleased(int x, int y) {
        if (y > this.getHeight() - this.build.getHeight() - 10 && x > this.getWidth() - this.build.getWidth() - 10) {
            this.game.changeScreen(6);
            this.build.nextFrame();
            this.paintObjects(this.g);
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void setResources(int x) {
        this.resources += x;
    }

    public int getResources() {
        int howManyStars = this.resources;
        return howManyStars;
    }

    public void paintAgain() {
        this.paintObjects(this.g);
    }

    public void addBuilding(int x) {
        if (x == 1) {
            this.workshop.setVisible(true);
            this.workshopBuilt = true;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.game.save();
            this.game.changeScreen(1);
        }
    }

    public boolean getBuilding(int building) {
        boolean hasBeenBuilt = false;
        switch (building) {
            case 0: {
                hasBeenBuilt = this.workshopBuilt;
            }
        }
        return hasBeenBuilt;
    }

    public void savedBuildings(int building, boolean hasBeenBuilt) {
        switch (building) {
            case 0: {
                this.workshopBuilt = hasBeenBuilt;
            }
        }
    }

    public int getBuildingCost(int x) {
        int cost = this.buildingCost;
        return cost;
    }
}

