/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.Audio;
import bluegammon.Bluegammon;
import bluegammon.Device;
import bluegammon.Resources;
import bluegammon.RmsFacade;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.popup.Popup;
import bluegammon.logic.BoardState;
import bluegammon.logic.BoardStateListener;
import bluegammon.logic.GameRecord;
import bluegammon.logic.LocalPlayer;
import bluegammon.logic.Player;
import bluegammon.logic.Rand;
import bluegammon.logic.RemotePlayer;
import bluegammon.logic.Rules;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BoardMediator
implements BoardStateListener {
    public static void startup() {
        BoardState.getInstance().setGameListener(new BoardMediator());
    }

    public static void init(Player player, Player player2, boolean bl) {
        BoardState boardState = BoardState.getInstance();
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        boardState.setPlayers(player, player2);
        boardState.setGameFinished(false);
        if (!bl) {
            int n;
            int n2 = BoardMediator.newDiceValue();
            if (n2 == (n = BoardMediator.newDiceValue())) {
                n2 = n2 > 3 ? --n2 : ++n2;
            }
            boolean bl2 = n2 > n;
            boardState.setStartPositions();
            boardCanvas.setStartPositions();
            boardCanvas.invalidate();
            boardCanvas.selectTurns(n2, n);
        }
    }

    public static void shutdown() {
        BoardCanvas.getInstance().shutdown();
    }

    public static void makePlayerMove(int n) {
        BoardState boardState = BoardState.getInstance();
        int[][] nArray = BoardMediator.getPossibleMoves();
        boardState.makeMove(nArray[n][0], nArray[n][1], BoardMediator.isCurrentPlayerWhite());
        int n2 = nArray[n][2];
        int n3 = boardState.getDiceValue(n2);
        BoardCanvas.getInstance().consumeDiceValue(n3);
        boardState.consumeDice(n2);
        boardState.commitMove(BoardMediator.isCurrentPlayerWhite(), n3);
    }

    public static void undoLastMove() {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        int n = BoardState.getInstance().undoLastMove(BoardMediator.isCurrentPlayerWhite());
        boardCanvas.setQueryCommit(false);
        boardCanvas.cursorNearestIndex(n, 0);
        boardCanvas.updateUndoCommand();
        boardCanvas.updateCursor();
    }

    public static void commitTurn() {
        BoardMediator.newTurn(!BoardMediator.isCurrentPlayerWhite());
        BoardCanvas.getInstance().setQueryCommit(false);
    }

    public static void newTurn(boolean bl) {
        if (!BoardState.getInstance().isGameFinished()) {
            BoardState.getInstance().setTurn(bl);
            Player player = BoardState.getInstance().getCurrentPlayer();
            if (player instanceof LocalPlayer) {
                BoardCanvas.getInstance().setCurrentLocalPlayer((LocalPlayer)player);
            } else {
                BoardCanvas.getInstance().setCurrentLocalPlayer(null);
            }
            BoardState.getInstance().newDiceValues(BoardMediator.newDiceValue(), BoardMediator.newDiceValue());
            BoardCanvas.getInstance().throwDices(bl);
            if (Bluegammon.getGameType() != Bluegammon.GAME_TYPE_LOCAL && !BoardMediator.isRemoteTurn()) {
                Device.vibrate(100, 0, 1);
            }
        }
    }

    public static synchronized void exitGame(int n) {
        if (n == 2 || n == 3) {
            boolean bl;
            boolean bl2 = n == 2;
            boolean bl3 = bl = !BoardMediator.getLocalPlayer().isWhite();
            if (n == 3) {
                bl = !bl;
                Bluegammon.showPopup(Resources.getChars(Resources.TXT_REMOTE_GAVE_UP), Popup.ALT_OK, 10, 0, 0, null);
            }
            int n2 = BoardState.getInstance().calculatePiecesLeft(!bl);
            int n3 = BoardState.getInstance().calculatePoints(!bl);
            BoardMediator.finishGame(bl, n2, n3, !bl2);
            if (bl2) {
                Bluegammon.exitGame();
            }
        } else if (n == 1) {
            if (!BoardMediator.isGameFinished()) {
                Bluegammon.showPopup(Resources.getChars(Resources.TXT_BT_REMOTE_QUIT), Popup.ALT_OK, 0, 0, 0, null);
                Bluegammon.exitGame();
            }
        } else {
            if (Bluegammon.isShowingPopup()) {
                Bluegammon.getCurrentPopup().dispose();
            }
            Bluegammon.exitGame();
        }
    }

    public static synchronized void lostRemoteConnection(IOException iOException) {
        if (!BoardMediator.isGameFinished()) {
            System.err.println("Lost remote connection!");
            iOException.printStackTrace();
            Audio.playSound(5);
            Bluegammon.showPopup(Resources.getChars(Resources.TXT_BT_CONN_LOST), Popup.ALT_OK, 0, 0, 0, null);
            Bluegammon.exitGame();
        }
    }

    public static void showMessage(char[] cArray) {
        Device.vibrate(100, 50, 3);
        Audio.playSound(4);
        cArray = (new String(BoardMediator.getOpponentPlayer().getName()) + ":\n\n" + new String(cArray)).toCharArray();
        Bluegammon.showPopup(cArray, null, 60, 0, 0, null);
    }

    public static Player getCurrentPlayer() {
        return BoardState.getInstance().getCurrentPlayer();
    }

    public static Player getOpponentPlayer() {
        Player player = BoardState.getInstance().getCurrentPlayer();
        Player player2 = BoardState.getInstance().getWaitingPlayer();
        if (Bluegammon.getGameType() == Bluegammon.GAME_TYPE_LOCAL) {
            return player2;
        }
        return player instanceof LocalPlayer ? player2 : player;
    }

    public static LocalPlayer getLocalPlayer() {
        Player player = BoardState.getInstance().getCurrentPlayer();
        Player player2 = BoardState.getInstance().getWaitingPlayer();
        if (player instanceof LocalPlayer) {
            return (LocalPlayer)player;
        }
        if (player2 instanceof LocalPlayer) {
            return (LocalPlayer)player2;
        }
        return null;
    }

    public static boolean isRemoteTurn() {
        return BoardState.getInstance().getCurrentPlayer() instanceof RemotePlayer;
    }

    public static int[][] getPossibleMoves() {
        return BoardState.getInstance().getPossibleMoves(BoardMediator.isCurrentPlayerWhite());
    }

    public static int countPossibleMoves() {
        if (BoardState.getInstance().getCurrentPlayer() == null) {
            return 0;
        }
        return BoardState.getInstance().countPossibleMoves(BoardMediator.isCurrentPlayerWhite());
    }

    public static boolean isGameFinished() {
        return BoardState.getInstance().isGameFinished();
    }

    public static void forceGameFinished() {
        BoardState.getInstance().setGameFinished(true);
    }

    public static int countUndoableMoves() {
        return BoardState.getInstance().countUndoableMoves();
    }

    public static int newDiceValue() {
        return Math.abs(Rand.random() % 6) + 1;
    }

    public static int getDiceValue(int n) {
        return BoardState.getInstance().getDiceValue(n);
    }

    public static int countStatePieces(int n) {
        return BoardState.getInstance().countPieces(n);
    }

    public static BoardCanvas getCanvas() {
        return BoardCanvas.getInstance();
    }

    protected static void finishGame(boolean bl, int n, int n2, boolean bl2) {
        BoardMediator.commitTurn();
        if (Bluegammon.getGameType() == Bluegammon.GAME_TYPE_LOCAL) {
            RmsFacade.setBoolean(2, false);
            RmsFacade.set(3, null);
            Audio.playSound(6);
        } else {
            boolean bl3 = BoardMediator.getLocalPlayer().isWhite() && bl || !BoardMediator.getLocalPlayer().isWhite() && !bl;
            GameRecord.updateGameResult(BoardMediator.getOpponentPlayer(), bl3, n2 * n);
            GameRecord.saveGame(BoardMediator.getOpponentPlayer(), null);
            Audio.playSound(bl3 ? 6 : 7);
        }
        BoardState.getInstance().setGameFinished(true);
        if (bl2) {
            BoardCanvas.getInstance().finishGame(bl, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGame(InputStream inputStream, boolean bl) throws IOException {
        FilterInputStream filterInputStream = null;
        BoardState boardState = BoardState.getInstance();
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        try {
            int n;
            boardCanvas.invalidate();
            filterInputStream = new DataInputStream(inputStream);
            boardState.loadState((DataInputStream)filterInputStream);
            boardCanvas.loadCanvas((DataInputStream)filterInputStream);
            Rules.loadRules((DataInputStream)filterInputStream);
            Rand.loadSeed((DataInputStream)filterInputStream);
            boolean bl2 = ((DataInputStream)filterInputStream).readBoolean();
            if (Bluegammon.getGameType() != Bluegammon.GAME_TYPE_LOCAL) {
                n = boardState.getCurrentPlayer().isWhite() ? 1 : 0;
                BoardMediator.getLocalPlayer().setWhite(bl2 ^= bl);
                BoardMediator.getOpponentPlayer().setWhite(!bl2);
                boardState.setCurrentPlayer(n != 0);
            }
            for (n = 0; n < 26; ++n) {
                boardCanvas.setPieces(true, n, boardState.countPieces(true, n));
                boardCanvas.setPieces(false, n, boardState.countPieces(false, n));
            }
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        Player player = boardState.getCurrentPlayer();
        boardCanvas.setCurrentLocalPlayer(player instanceof LocalPlayer ? (LocalPlayer)player : null);
        boardCanvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveGame(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = null;
        int n = 0;
        try {
            dataOutputStream = new DataOutputStream(outputStream);
            n += BoardState.getInstance().saveState(dataOutputStream);
            n += BoardCanvas.getInstance().saveCanvas(dataOutputStream);
            n += Rules.saveRules(dataOutputStream);
            n += Rand.saveSeed(dataOutputStream);
            dataOutputStream.writeBoolean(BoardMediator.getLocalPlayer().isWhite());
        }
        finally {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        return ++n;
    }

    public static boolean isCurrentPlayerWhite() {
        return BoardState.getInstance().isCurrentPlayerWhite();
    }

    public void turnChange(boolean bl) {
    }

    public void pieceMoved(boolean bl, int n, int n2) {
        BoardCanvas.getInstance().movePiece(bl, n, n2, BoardState.getInstance().countPieces(n), BoardState.getInstance().countPieces(n2) - 1);
    }

    public void undoAdded(int n, int n2) {
    }

    public void undoPerformed(int n, int n2) {
        BoardCanvas.getInstance().undoConsumedDiceValue(n2);
    }

    public void gameFinished(boolean bl, int n, int n2) {
        BoardMediator.finishGame(bl, n, n2, true);
    }

    private BoardMediator() {
    }
}

