/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.App;
import app.Constantes;
import app.MainMenu;
import com.movilenio.game.GameSection;
import com.movilenio.game.Kernel;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import movilib.BitmapFont;

public class Game
extends GameSection {
    public boolean bExitTemp;
    public BitmapFont font;
    public static final byte SELECCION_FICHAS = 0;
    public static final byte INICIO_TURNO = 1;
    public static final byte TIRAR_DADO = 2;
    public static final byte ELEGIR_FICHA = 3;
    public static final byte MOVIMIENTO_FICHA = 4;
    public static final byte FICHAS_BLOQUEADAS = 5;
    public static final byte TERCER_SEIS = 6;
    public static final byte LLEGADA_META = 7;
    public static final byte FICHA_CAPTURADA = 8;
    public static final byte CAMPEON = 9;
    public static final byte GAME_OVER = 10;
    public int wScreen;
    public int hScreen;
    public byte[] keyMap;
    public Image[] marco;
    public String[] textos;
    public String[] cads;
    public byte estado;
    public byte[] libres = new byte[]{0, 0, 0, 0};
    public byte turno;
    public byte contraMovil;
    public byte[] players;
    public byte[][] fichas;
    public byte[][] casillas;
    public byte indice;
    public byte casillaDest;
    public byte inc;
    public byte dX;
    public byte dY;
    public byte bloqueXdest;
    public byte bloqueYdest;
    public short topeX;
    public short topeY;
    public byte[] mare = new byte[]{5, 12, 17, 56, 63, 68, 22, 29, 34, 39, 46, 51};
    public byte[][] entrada = new byte[][]{{68, 51, 17, 34}, {0, -1, 1, 0}, {1, 0, 0, -1}, {0, 1, 1, 0}, {1, 0, 0, 1}};
    public byte[][] casa = new byte[][]{{4, 17, 4, 17}, {4, 4, 17, 17}};
    public short[][] meta = Constantes.meta;
    public byte[] seis;
    public byte[] ultDes;
    public byte[][] escaleras;
    public byte nPlayers;
    public byte op;
    public int[] color = new int[]{15539236, 3979384, 6315176, 16774258};
    public byte contador;
    public byte xVirtual;
    public short y;
    public short y0;
    public short x;
    public byte FACTOR;
    public byte resDado;
    public Random aleatorio = new Random();
    public byte[][] filaDado = new byte[][]{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {1, 0, 1}};
    public byte[][] puntosDado = new byte[][]{{0, 2, 0}, {1, 0, 3}, {1, 2, 3}, {4, 0, 4}, {4, 2, 4}, {4, 4, 4}};
    public Image tabler;
    public Image[] dado;
    public Image flecha;
    public Image barra;
    public Image[] tablero;
    public Image[] ficha;
    public Image[] colores;
    public int wClip;

    public Game() {
        this.textos = App.loadLines("/text.txt", null, 0, null);
    }

    public boolean initSection() {
        this.keyMap = Kernel.instance.keyMap;
        this.topeX = (short)(198 - Kernel.instance.getWidth());
        this.topeY = (short)(198 - Kernel.instance.getHeight());
        this.wScreen = Kernel.instance.getWidth();
        this.hScreen = Kernel.instance.getHeight();
        this.font = MainMenu.font;
        return true;
    }

    public void loadResources() {
        int n;
        super.loadResources();
        this.marco = new Image[6];
        for (n = 0; n < 6; ++n) {
            this.marco[n] = Kernel.instance.loadImage("/frame" + n + ".png");
        }
        this.wClip = this.marco[2] != null ? Kernel.instance.getWidth() - this.marco[2].getWidth() * 4 : Kernel.instance.getWidth() - 4;
        if (this.estado == 0) {
            this.colores = new Image[4];
            for (n = 0; n < 4; ++n) {
                this.colores[n] = Kernel.instance.loadImage("/m" + n + ".png");
            }
        }
        this.tablero = new Image[4];
        for (n = 0; n < 4; ++n) {
            this.tablero[n] = Kernel.instance.loadImage("/t" + n + ".png");
        }
        this.tabler = Kernel.instance.loadImage("/tablej.png");
        this.dado = new Image[6];
        for (n = 0; n < 6; ++n) {
            this.dado[n] = Kernel.instance.loadImage("/d" + n + ".png");
        }
        this.ficha = new Image[4];
        for (n = 0; n < 4; ++n) {
            this.ficha[n] = Kernel.instance.loadImage("/f" + n + ".png");
        }
        this.barra = Kernel.instance.loadImage("/barra.png");
        this.flecha = Kernel.instance.loadImage("/flecha.png");
    }

    public void freeResources() {
        int n;
        super.freeResources();
        if (this.colores != null) {
            for (n = 0; n < this.colores.length; ++n) {
                this.colores[n] = null;
            }
        }
        if (this.marco != null) {
            for (n = 0; n < 6; ++n) {
                this.marco[n] = null;
            }
        }
        this.marco = null;
        if (this.dado != null) {
            for (n = 0; n < 6; ++n) {
                this.dado[n] = null;
            }
        }
        this.dado = null;
        if (this.tablero != null) {
            for (n = 0; n < 4; ++n) {
                this.tablero[n] = null;
            }
        }
        this.tablero = null;
        for (n = 0; n < 4; ++n) {
            this.ficha[n] = null;
        }
        this.ficha = null;
        this.tabler = null;
        this.barra = null;
        this.flecha = null;
        System.gc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        try {
            graphics.setClip(0, 0, this.wScreen, this.hScreen);
            int n = this.barra.getWidth();
            int n2 = this.barra.getHeight();
            switch (this.estado) {
                case 0: {
                    this.paintSelectPlayers(graphics);
                    return;
                }
                case 1: {
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
                    graphics.setColor(0xFFFFFF);
                    this.contador = (byte)(this.contador - 1);
                    if (this.contador > 0) {
                        this.drawStrings(graphics, this.cads, this.wScreen >> 1, this.hScreen - this.cads.length * MainMenu.incY >> 1, 17);
                    } else {
                        this.contador = (byte)3;
                    }
                    this.paintFrame(graphics);
                    return;
                }
                case 2: {
                    this.paintDice(graphics);
                    this.paintFrame(graphics);
                    return;
                }
                case 3: {
                    this.pintaTablero(graphics);
                    this.contador = (byte)(this.contador - 1);
                    if (this.contador <= 0) {
                        graphics.setColor(0);
                        graphics.fillRect(this.bloqueXdest * 9 - this.x, this.bloqueYdest * 9 - this.y, (int)this.dX, (int)this.dY);
                        this.contador = (byte)5;
                    }
                    this.pintaFichas(graphics);
                    if (this.fichas[this.turno][this.indice] > 0) {
                        graphics.drawImage(this.flecha, this.casillas[this.fichas[this.turno][this.indice]][0] * 9 - this.x - 31 + (this.contador << 1), this.casillas[this.fichas[this.turno][this.indice]][1] * 9 - this.y - 38 + (this.contador << 1), 20);
                    }
                    if (this.fichas[this.turno][this.indice] < 0) {
                        graphics.drawImage(this.flecha, this.casillas[this.entrada[0][this.players[this.turno]]][0] * 9 - this.x - 31 + (this.contador << 1) - this.entrada[1][this.players[this.turno]] * 9 * this.fichas[this.turno][this.indice], this.casillas[this.entrada[0][this.players[this.turno]]][1] * 9 - this.y - 39 + (this.contador << 1) - this.entrada[2][this.players[this.turno]] * 9 * this.fichas[this.turno][this.indice], 20);
                    }
                    graphics.drawImage(this.barra, 0, this.hScreen - n2, 0);
                    graphics.drawImage(this.barra, this.wScreen, this.hScreen - n2, 24);
                    graphics.setColor(0xFFFF00);
                    this.font.drawString(graphics, this.textos[0], n >> 1, this.hScreen - (n2 >> 1), 3);
                    this.font.drawString(graphics, this.textos[1], this.wScreen - (n >> 1), this.hScreen - (n2 >> 1), 3);
                    return;
                }
                case 4: {
                    this.pintaTablero(graphics);
                    this.pintaFichas(graphics);
                    graphics.drawImage(this.barra, 0, this.hScreen - n2, 0);
                    this.font.drawString(graphics, this.textos[0], n >> 1, this.hScreen - (n2 >> 1), 3);
                    this.contador = (byte)(this.contador - 1);
                    if (this.contador > 0) return;
                    if (this.resDado > 0) {
                        this.abandonaCasilla();
                        this.cambiaScroll(this.turno, this.indice);
                    }
                    this.contador = (byte)4;
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, this.wScreen, this.hScreen);
                    graphics.setColor(0xFFFFFF);
                    this.contador = (byte)(this.contador - 1);
                    if (this.contador > 0) {
                        this.drawStrings(graphics, this.cads, this.wScreen >> 1, this.hScreen - this.cads.length * MainMenu.incY >> 1, 17);
                    } else {
                        this.contador = (byte)3;
                    }
                    this.paintFrame(graphics);
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
    }

    public void paintSelectPlayers(Graphics graphics) {
        int n;
        graphics.setColor(this.color[this.op]);
        graphics.fillRect(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
        this.paintFrame(graphics);
        if (this.colores != null) {
            n = Kernel.instance.getHeight() - this.colores[this.op].getHeight() >> 1;
            graphics.drawImage(this.colores[this.op], Kernel.instance.getWidth() - this.colores[this.op].getWidth() >> 1, n, 20);
        } else {
            n = Kernel.instance.getHeight() >> 1;
        }
        graphics.setColor(0);
        this.drawStrings(graphics, this.cads, this.wScreen >> 1, n >> 1, 17);
        graphics.setColor(0);
        int n2 = 1;
        if (this.marco[1] != null) {
            n2 = this.marco[2].getWidth();
        }
        if (this.contraMovil == 1 || this.contraMovil == 0 && this.turno > 1) {
            this.font.drawString(graphics, this.textos[2], n2 + 2, this.hScreen - n2, 32);
        }
        this.font.drawString(graphics, this.textos[3], this.wScreen - 2 - n2, this.hScreen - n2, 40);
    }

    public void paintFrame(Graphics graphics) {
        try {
            if (this.marco[0] != null) {
                graphics.drawImage(this.marco[2], 0, 0, 0);
                graphics.drawImage(this.marco[3], this.wScreen, 0, 24);
                graphics.drawImage(this.marco[0], 0, 0, 0);
                graphics.drawImage(this.marco[1], this.wScreen, 0, 24);
                graphics.drawImage(this.marco[4], 0, this.hScreen - this.marco[4].getHeight(), 0);
                graphics.drawImage(this.marco[5], this.wScreen, this.hScreen - this.marco[5].getHeight(), 24);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void paintDice(Graphics graphics) {
        int n = 18 + this.tabler.getHeight();
        int n2 = Kernel.instance.getWidth();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, n2, n);
        if (this.tabler != null) {
            graphics.drawImage(this.tabler, n2 - this.tabler.getWidth() >> 1, 18, 20);
        }
        graphics.setColor(0);
        int n3 = Kernel.instance.getHeight() - n;
        graphics.fillRect(0, n, n2, this.hScreen - n);
        graphics.drawImage(this.dado[this.op], (int)this.x, (int)this.y, 20);
        this.op = (byte)(this.op + 1);
        if (this.op > 3) {
            this.op = 0;
        }
        if (this.xVirtual > 20) {
            this.op = 0;
            n3 = n + (n3 - this.dado[4].getHeight() >> 1);
            graphics.drawImage(this.dado[4], n2 >> 1, n3, 17);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.filaDado[this.puntosDado[this.resDado][i]][j] != 1 || this.estado != 2) continue;
                    graphics.drawImage(this.dado[5], (n2 >> 1) + (j - 1) * 9, n3 + (this.dado[4].getHeight() - this.dado[5].getHeight() >> 1) + (i - 1) * 9, 17);
                }
            }
        }
    }

    public void pintaTablero(Graphics graphics) {
        short s = (short)this.tablero[0].getWidth();
        graphics.drawImage(this.tablero[0], (int)(-this.x), (int)(-this.y), 20);
        graphics.drawImage(this.tablero[1], -this.x + s, (int)(-this.y), 20);
        graphics.drawImage(this.tablero[2], (int)(-this.x), -this.y + s, 20);
        graphics.drawImage(this.tablero[3], -this.x + s, -this.y + s, 20);
    }

    public void pintaFichas(Graphics graphics) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            for (n4 = 1; n4 < 69; ++n4) {
                int n5;
                int n6;
                if (this.casillas[n4][3] < 0) continue;
                if (this.casillas[n4][2] == 2) {
                    n6 = 5;
                    n5 = 0;
                } else {
                    n6 = 0;
                    n5 = 5;
                }
                if (this.casillas[n4][3] % 10 == 0) {
                    graphics.drawImage(this.ficha[this.players[this.casillas[n4][3] / 10]], this.casillas[n4][0] * 9 - this.x + n6, this.casillas[n4][1] * 9 - this.y + n5, 20);
                    continue;
                }
                graphics.drawImage(this.ficha[this.players[this.casillas[n4][3] / 10]], this.casillas[n4][0] * 9 - this.x, this.casillas[n4][1] * 9 - this.y, 20);
                graphics.drawImage(this.ficha[this.players[this.casillas[n4][3] % 10 - 1]], this.casillas[n4][0] * 9 - this.x + 2 * n6, this.casillas[n4][1] * 9 - this.y + 2 * n5, 20);
            }
            for (n4 = 0; n4 < this.nPlayers; ++n4) {
                for (n3 = 1; n3 < 8; ++n3) {
                    if (this.escaleras[n4][n3] == 1) {
                        graphics.drawImage(this.ficha[this.players[n4]], this.casillas[this.entrada[0][this.players[n4]]][0] * 9 - this.x + this.entrada[1][this.players[n4]] * 9 * n3 + 5 * this.entrada[4][this.players[n4]], this.casillas[this.entrada[0][this.players[n4]]][1] * 9 - this.y + this.entrada[2][this.players[n4]] * 9 * n3 + 5 * this.entrada[3][this.players[n4]], 20);
                    }
                    if (this.escaleras[n4][n3] != 2) continue;
                    graphics.drawImage(this.ficha[this.players[n4]], this.casillas[this.entrada[0][this.players[n4]]][0] * 9 - this.x + this.entrada[1][this.players[n4]] * 9 * n3 + 9 * this.entrada[4][this.players[n4]], this.casillas[this.entrada[0][this.players[n4]]][1] * 9 - this.y + this.entrada[2][this.players[n4]] * 9 * n3 + 9 * this.entrada[3][this.players[n4]], 20);
                    graphics.drawImage(this.ficha[this.players[n4]], this.casillas[this.entrada[0][this.players[n4]]][0] * 9 - this.x + this.entrada[1][this.players[n4]] * 9 * n3, this.casillas[this.entrada[0][this.players[n4]]][1] * 9 - this.y + this.entrada[2][this.players[n4]] * 9 * n3, 20);
                }
            }
            for (n2 = 0; n2 < this.nPlayers; ++n2) {
                for (n = 0; n < 4; ++n) {
                    if (this.fichas[n2][n] != 0) continue;
                    n3 = (byte)(n % 2);
                    n4 = (byte)(n / 2);
                    if (n3 == 0) {
                        n3 = -1;
                    }
                    if (n4 == 0) {
                        n4 = -1;
                    }
                    graphics.drawImage(this.ficha[this.players[n2]], (this.casa[0][this.players[n2]] + n3) * 9 - this.x, (this.casa[1][this.players[n2]] + n4) * 9 - this.y, 20);
                }
            }
            for (n2 = 0; n2 < this.nPlayers; ++n2) {
                for (n = 0; n < 4; ++n) {
                    if (this.fichas[n2][n] != 70) continue;
                    graphics.drawImage(this.ficha[this.players[n2]], this.meta[0][this.players[n2]] + this.meta[2][n] * this.entrada[4][this.players[n2]] * 9 - this.x, this.meta[1][this.players[n2]] + this.meta[2][n] * this.entrada[3][this.players[n2]] * 9 + this.entrada[4][this.players[n2]] * this.meta[3][n] * 9 - this.y, 20);
                }
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Pinta fichas: " + exception.toString());
            return;
        }
    }

    public void doFrame() {
        switch (this.estado) {
            case 2: {
                if (this.xVirtual < 110) {
                    this.xVirtual = (byte)(this.xVirtual + 4);
                }
                if (this.x >= 80 || this.xVirtual >= 17) break;
                this.y = (short)(35 - (this.y0 - this.xVirtual * this.xVirtual / this.FACTOR));
                this.x = (short)(this.x + 4);
                if (this.xVirtual != 16 || this.x >= 80) break;
                this.xVirtual = (byte)-16;
                this.FACTOR = (byte)(this.FACTOR + 3);
                this.y0 = (short)(this.xVirtual * this.xVirtual / this.FACTOR);
                return;
            }
            case 3: 
            case 4: {
                if (Kernel.instance.getKeyPressedStatus(2) || Kernel.instance.getKeyPressedStatus(10)) {
                    this.x = (short)(this.x - 5);
                    if (this.x < 0) {
                        this.x = 0;
                    }
                }
                if (Kernel.instance.getKeyPressedStatus(3) || Kernel.instance.getKeyPressedStatus(11)) {
                    this.x = (short)(this.x + 5);
                    if (this.x > this.topeX) {
                        this.x = this.topeX;
                    }
                }
                if (Kernel.instance.getKeyPressedStatus(0) || Kernel.instance.getKeyPressedStatus(8)) {
                    this.y = (short)(this.y - 5);
                    if (this.y < 0) {
                        this.y = 0;
                    }
                }
                if (!Kernel.instance.getKeyPressedStatus(1) && !Kernel.instance.getKeyPressedStatus(9)) break;
                this.y = (short)(this.y + 5);
                if (this.y <= this.topeY) break;
                this.y = this.topeY;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int n) {
        try {
            switch (this.estado) {
                case 0: {
                    if ((n == this.keyMap[13] || n == this.keyMap[5]) && this.turno > 1) {
                        this.inicializaPartida(this.turno);
                        this.turno = (byte)-1;
                        this.maquinaEstados(1);
                        return;
                    }
                    if (n == this.keyMap[14] || n == this.keyMap[6]) {
                        Kernel.instance.setGameSection(App.mainMenu);
                        return;
                    }
                    if (n == this.keyMap[10] || n == this.keyMap[2]) {
                        do {
                            this.op = (byte)(this.op - 1);
                            if (this.op >= 0) continue;
                            this.op = (byte)3;
                        } while (this.libres[this.op] == 1);
                    }
                    if (n == this.keyMap[11] || n == this.keyMap[3]) {
                        do {
                            this.op = (byte)(this.op + 1);
                            if (this.op <= 3) continue;
                            this.op = 0;
                        } while (this.libres[this.op] == 1);
                    }
                    if (n == this.keyMap[12] || n == this.keyMap[4] || n == this.keyMap[13]) {
                        this.players[this.turno] = this.op;
                        this.libres[this.op] = 1;
                        this.turno = (byte)(this.turno + 1);
                        if (this.turno > 3 && this.contraMovil == 0 || this.turno > 1 && this.contraMovil == 1) {
                            this.inicializaPartida(this.turno);
                            this.turno = (byte)-1;
                            this.maquinaEstados(1);
                            return;
                        }
                        do {
                            this.op = (byte)(this.op + 1);
                            if (this.op <= 3) continue;
                            this.op = 0;
                        } while (this.libres[this.op] == 1);
                    }
                    this.cads = this.turno == 1 && this.contraMovil == 1 ? App.loadLines(null, this.font, this.wClip, this.textos[21]) : App.loadLines(null, this.font, this.wClip, this.textos[20] + " " + (this.turno + 1));
                    return;
                }
                case 1: {
                    this.maquinaEstados(2);
                    return;
                }
                case 2: {
                    if (this.xVirtual > 25) {
                        this.estado = (byte)10;
                        if (this.seis[this.turno] == 3) {
                            this.maquinaEstados(6);
                            return;
                        } else {
                            this.maquinaEstados(3);
                        }
                        return;
                    } else {
                        this.xVirtual = (byte)17;
                        this.x = (short)80;
                        this.y = (short)35;
                    }
                    return;
                }
                case 3: {
                    if (n == this.keyMap[13] || n == this.keyMap[5]) {
                        try {
                            App.mainMenu.op = 1;
                            Kernel.instance.setGameSection(App.mainMenu);
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            exception.printStackTrace();
                        }
                    }
                    if (n == this.keyMap[14] || n == this.keyMap[6]) {
                        this.cambiaFicha(this.indice);
                    }
                    if (n != this.keyMap[4] && n != this.keyMap[12]) return;
                    this.maquinaEstados(4);
                    return;
                }
                case 4: {
                    if (n == this.keyMap[13] || n == this.keyMap[5]) {
                        try {
                            App.mainMenu.op = 1;
                        }
                        catch (Exception exception) {
                            Exception exception3 = exception;
                            exception.printStackTrace();
                        }
                        Kernel.instance.setGameSection(App.mainMenu);
                    }
                    if (n != this.keyMap[4] && n != this.keyMap[12] || this.resDado != 0) return;
                    this.ultDes[this.turno] = this.indice;
                    if (this.seis[this.turno] > 0) {
                        this.turno = (byte)(this.turno - 1);
                        if (this.turno == -1) {
                            this.turno = (byte)(this.nPlayers - 1);
                        }
                    }
                    this.maquinaEstados(1);
                    return;
                }
                case 5: 
                case 6: {
                    this.maquinaEstados(1);
                    return;
                }
                case 7: {
                    this.resDado = (byte)9;
                    this.maquinaEstados(3);
                    return;
                }
                case 8: {
                    this.resDado = (byte)19;
                    this.maquinaEstados(3);
                    return;
                }
                case 9: {
                    this.maquinaEstados(10);
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void maquinaEstados(int n) {
        switch (n) {
            case 0: {
                this.inicializaParchis();
                this.libres[3] = 0;
                this.libres[2] = 0;
                this.libres[1] = 0;
                this.libres[0] = 0;
                this.estado = (byte)n;
                Kernel.instance.setGameSection(App.game);
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[20] + " 1");
                break;
            }
            case 1: {
                if (this.colores[0] != null) {
                    this.colores[0] = null;
                    this.colores[1] = null;
                    this.colores[2] = null;
                    this.colores[3] = null;
                    System.gc();
                }
                this.bExitTemp = true;
                this.turno = (byte)(this.turno + 1);
                if (this.turno >= this.nPlayers) {
                    this.turno = 0;
                }
                if (this.contraMovil == 1 && this.turno == 1) {
                    this.cads = App.loadLines(null, this.font, this.wClip, this.textos[6]);
                    break;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[5] + " " + (this.turno + 1));
                break;
            }
            case 2: {
                this.resDado = (byte)((((this.aleatorio.nextInt() & 0xFFFF) - 1) * 6 + 1) / 65535);
                if (this.resDado < 1) {
                    this.resDado = -this.resDado;
                }
                this.op = 0;
                this.xVirtual = 0;
                this.x = 0;
                this.FACTOR = (byte)5;
                this.y = this.y0 = (short)(400 / this.FACTOR);
                if (this.resDado == 5) {
                    byte by = this.turno;
                    this.seis[by] = (byte)(this.seis[by] + 1);
                    break;
                }
                this.seis[this.turno] = 0;
                break;
            }
            case 3: {
                this.estado = (byte)n;
                if (this.fichas[this.turno][0] != 0 && this.fichas[this.turno][1] != 0 && this.fichas[this.turno][2] != 0 && this.fichas[this.turno][3] != 0 && this.resDado == 5) {
                    this.resDado = (byte)6;
                }
                this.resDado = (byte)(this.resDado + 1);
                if (this.contraMovil == 0 || this.contraMovil == 1 && this.turno == 0) {
                    try {
                        this.estado = (byte)3;
                        this.cambiaFicha(-1);
                        return;
                    }
                    catch (Exception exception) {
                        System.out.println("EF: " + exception.toString());
                        break;
                    }
                }
                this.estado = (byte)4;
                this.riesgo(this.resDado);
                return;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.contraMovil == 1 && this.turno == 1) {
                    this.cads = App.loadLines(null, this.font, this.wClip, this.textos[9]);
                    break;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[7] + " " + (this.turno + 1) + "\n\n" + this.textos[8]);
                break;
            }
            case 6: {
                this.casillaDest = 1;
                if (this.fichas[this.turno][this.ultDes[this.turno]] > 0) {
                    this.casillas[this.fichas[this.turno][this.ultDes[this.turno]]][3] = this.casillas[this.fichas[this.turno][this.ultDes[this.turno]]][3] % 10 != 0 ? (this.casillas[this.fichas[this.turno][this.ultDes[this.turno]]][3] % 10 - 1 == this.turno ? (int)(this.casillas[this.fichas[this.turno][this.ultDes[this.turno]]][3] / 10 * 10) : (int)((this.casillas[this.fichas[this.turno][this.ultDes[this.turno]]][3] % 10 - 1) * 10)) : -1;
                    this.casillaDest = 0;
                    this.fichas[this.turno][this.ultDes[this.turno]] = 0;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[10]);
                break;
            }
            case 7: {
                if (this.contraMovil == 1 && this.turno == 1) {
                    this.cads = App.loadLines(null, this.font, this.wClip, this.textos[11] + "\n\n" + this.textos[15] + " 10");
                    break;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[7] + " " + (this.turno + 1) + "\n\n" + this.textos[11] + "\n" + this.textos[12] + " 10");
                break;
            }
            case 8: {
                if (this.contraMovil == 1 && this.turno == 1) {
                    this.cads = App.loadLines(null, this.font, this.wClip, this.textos[14] + "\n\n" + this.textos[15] + " 20");
                    break;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[7] + " " + (this.turno + 1) + "\n\n" + this.textos[13] + "\n" + this.textos[12] + " 20");
                break;
            }
            case 9: {
                if (this.contraMovil == 1 && this.turno == 1) {
                    this.cads = App.loadLines(null, this.font, this.wClip, this.textos[17]);
                    break;
                }
                this.cads = App.loadLines(null, this.font, this.wClip, this.textos[7] + " " + (this.turno + 1) + "\n\n" + this.textos[17]);
                break;
            }
            case 10: {
                this.bExitTemp = false;
                this.nPlayers = 0;
                this.guardaPartida();
                App.mainMenu.op = 0;
                Kernel.instance.setGameSection(App.mainMenu);
            }
        }
        this.estado = (byte)n;
    }

    public void inicializaPartida(byte n) {
        this.nPlayers = n;
        this.turno = 0;
        this.fichas = new byte[n][4];
        this.escaleras = new byte[n][10];
        this.seis = new byte[n];
        this.ultDes = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.fichas[i][0] = this.mare[this.players[i] * 3];
            for (int j = 1; j < 4; ++j) {
                this.fichas[i][j] = 0;
            }
            this.casillas[this.fichas[i][0]][3] = (byte)(i * 10);
        }
    }

    public void inicializaParchis() {
        this.turno = 0;
        this.players = new byte[4];
        this.players[3] = -1;
        this.players[2] = -1;
        this.players[1] = -1;
        this.players[0] = -1;
        this.casillas = new byte[71][4];
        for (int n = 0; n < this.casillas.length; n = (int)((byte)(n + 1))) {
            this.casillas[n][0] = 8;
            this.casillas[n][1] = n;
            this.casillas[n][2] = 2;
            this.casillas[n][3] = -1;
            if (n > 8) {
                this.casillas[n][0] = (byte)(8 - (n - 9));
                this.casillas[n][1] = 8;
                this.casillas[n][2] = 3;
            }
            if (n == 17) {
                this.casillas[n][0] = 1;
                byte[] byArray = this.casillas[n];
                byArray[1] = (byte)(byArray[1] + 2);
            }
            if (n > 17) {
                this.casillas[n][0] = (byte)(n - 17);
                this.casillas[n][1] = 12;
            }
            if (n > 25) {
                this.casillas[n][0] = 8;
                byte[] byArray = this.casillas[n];
                byArray[1] = (byte)(byArray[1] + (n - 25));
                this.casillas[n][2] = 2;
            }
            if (n == 34) {
                this.casillas[n][0] = 10;
                this.casillas[n][1] = 20;
            }
            if (n > 34) {
                this.casillas[n][0] = 12;
                this.casillas[n][1] = (byte)(20 - (n - 35));
            }
            if (n > 42) {
                byte[] byArray = this.casillas[n];
                byArray[0] = (byte)(byArray[0] + (n - 42));
                this.casillas[n][1] = 12;
                this.casillas[n][2] = 3;
            }
            if (n == 51) {
                this.casillas[n][0] = 20;
                byte[] byArray = this.casillas[n];
                byArray[1] = (byte)(byArray[1] - 2);
            }
            if (n > 51) {
                this.casillas[n][0] = (byte)(20 - (n - 52));
                this.casillas[n][1] = 8;
            }
            if (n > 59) {
                this.casillas[n][0] = 12;
                byte[] byArray = this.casillas[n];
                byArray[1] = (byte)(byArray[1] - (n - 60));
                this.casillas[n][2] = 2;
            }
            if (n != 68) continue;
            this.casillas[n][0] = 10;
            this.casillas[n][1] = 1;
        }
    }

    public void drawStrings(Graphics graphics, String[] stringArray, int n, int n2, int n3) {
        int n4 = stringArray.length;
        for (int i = 0; i < n4; ++i) {
            this.font.drawString(graphics, stringArray[i], n, n2, 1);
            n2 += this.font.fontHeight + 2;
        }
    }

    public void cambiaScroll(int n, int n2) {
        try {
            short s = (short)(Kernel.instance.getWidth() >> 1);
            short s2 = (short)(Kernel.instance.getHeight() >> 1);
            if (this.fichas[n][n2] > 0) {
                this.x = (short)(this.casillas[this.fichas[n][n2]][0] * 9 - s);
                this.y = (short)(this.casillas[this.fichas[n][n2]][1] * 9 - s2);
            } else if (this.fichas[n][n2] == 0) {
                this.x = (short)(this.casillas[this.mare[this.players[n] * 3]][0] * 9 - s);
                this.y = (short)(this.casillas[this.mare[this.players[n] * 3]][1] * 9 - s2);
            } else {
                this.x = (short)(this.casillas[this.entrada[0][this.players[n]]][0] * 9 + this.entrada[1][this.players[n]] * 9 * -this.fichas[n][n2] + 5 * this.entrada[4][this.players[n]] - s);
                this.y = (short)(this.casillas[this.entrada[0][this.players[n]]][1] * 9 + this.entrada[2][this.players[n]] * 9 * -this.fichas[n][n2] + 5 * this.entrada[3][this.players[n]] - s2);
            }
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.x > this.topeX) {
                this.x = this.topeX;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.y > this.topeY) {
                this.y = this.topeY;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Cambia scroll: " + exception.toString());
            return;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte celdaDestino(int n, int n2) {
        try {
            int n3;
            byte by = 0;
            by = this.fichas[this.turno][n];
            if (n2 == 5) {
                if (this.fichas[this.turno][0] == 0 || this.fichas[this.turno][1] == 0 || this.fichas[this.turno][2] == 0 || this.fichas[this.turno][3] == 0) {
                    if (this.casillas[this.mare[this.players[this.turno] * 3]][3] % 10 - 1 == this.turno && this.casillas[this.mare[this.players[this.turno] * 3]][3] % 10 - 1 == this.casillas[this.mare[this.players[this.turno] * 3]][3] / 10) {
                        if (by == 0) {
                            return 0;
                        }
                    } else {
                        if (by != 0) {
                            return 0;
                        }
                        return this.mare[this.players[this.turno] * 3];
                    }
                }
            } else if (by == 0) {
                return 0;
            }
            if (this.fichas[this.turno][n] == 70) {
                return 0;
            }
            boolean bl = true;
            while (true) {
                int n4;
                block34: {
                    int n5;
                    boolean bl2;
                    block35: {
                        block32: {
                            block33: {
                                block31: {
                                    if (!bl || (bl = false)) break block31;
                                    if (n2 != 6 && n2 != 7) break block32;
                                    n3 = 0;
                                    n4 = 0;
                                }
                                if (n4 >= 4) break block33;
                                if (this.fichas[this.turno][n4] <= 0 || this.fichas[this.turno][n4] >= 69 || this.casillas[this.fichas[this.turno][n4]][3] % 10 == 0) break block34;
                                bl2 = true;
                                n5 = this.fichas[this.turno][n4];
                                break block35;
                            }
                            if (n3 == 1 && this.casillas[this.fichas[this.turno][n]][3] % 10 == 0) {
                                return 0;
                            }
                        }
                        if (by < 0) {
                            if (by - n2 < -8) {
                                return 0;
                            }
                            if (by - n2 > -8 && this.escaleras[this.turno][-(by - n2)] == 2) {
                                return 0;
                            }
                            return (byte)(by - n2);
                        }
                        break;
                    }
                    for (int i = 0; i < n2; ++i) {
                        if (n5 > 0) {
                            if ((n5 = (int)(n5 + 1)) > 68) {
                                n5 = 1;
                            }
                            if (n5 == this.entrada[0][this.players[this.turno]] + 1) {
                                n5 = -1;
                            } else if (this.casillas[n5][3] > -1 && this.casillas[n5][3] / 10 == this.casillas[n5][3] % 10 - 1) {
                                bl2 = false;
                            }
                        }
                        if (n5 >= 0 || this.escaleras[this.turno][-(n5 = (byte)(n5 - 1))] != 2) continue;
                        bl2 = false;
                    }
                    if (bl2) {
                        n3 = 1;
                    }
                }
                ++n4;
            }
            n3 = n2;
            while (true) {
                if (n3 <= 0) {
                    return by;
                }
                if ((by = (byte)(by + 1)) - 1 <= this.entrada[0][this.players[this.turno]] && by > this.entrada[0][this.players[this.turno]]) {
                    if (n3 > 8) {
                        return 0;
                    }
                    return (byte)(-n3);
                }
                if (by == 69) {
                    by = 1;
                }
                if (this.casillas[by][3] > 0 && this.casillas[by][3] % 10 - 1 == this.casillas[by][3] / 10) {
                    return 0;
                }
                if (this.casillas[by][3] > 0 && this.casillas[by][3] % 10 != 0 && n3 == 1) {
                    return 0;
                }
                --n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Celda Destino: " + exception.toString());
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void abandonaCasilla() {
        block12: {
            block21: {
                block19: {
                    block20: {
                        int n;
                        block15: {
                            block16: {
                                block18: {
                                    block17: {
                                        block13: {
                                            block14: {
                                                this.inc = 1;
                                                if (this.fichas[this.turno][this.indice] <= 0) break block13;
                                                this.casillas[this.fichas[this.turno][this.indice]][3] = this.casillas[this.fichas[this.turno][this.indice]][3] % 10 == 0 ? -1 : (this.casillas[this.fichas[this.turno][this.indice]][3] / 10 == this.turno ? (byte)((this.casillas[this.fichas[this.turno][this.indice]][3] % 10 - 1) * 10) : (byte)(this.casillas[this.fichas[this.turno][this.indice]][3] / 10 * 10));
                                                if (this.fichas[this.turno][this.indice] == this.entrada[0][this.players[this.turno]]) {
                                                    this.fichas[this.turno][this.indice] = -1;
                                                    byte[] byArray = this.escaleras[this.turno];
                                                    byArray[1] = (byte)(byArray[1] + 1);
                                                    this.resDado = (byte)(this.resDado - 1);
                                                    return;
                                                }
                                                byte by = (byte)(this.fichas[this.turno][this.indice] + this.inc);
                                                if (by == 69) {
                                                    by = 1;
                                                }
                                                if (by > 0 && this.casillas[by][3] % 10 > 0) {
                                                    this.inc = (byte)2;
                                                    this.resDado = (byte)(this.resDado - 1);
                                                }
                                                byte[] byArray = this.fichas[this.turno];
                                                byte by2 = this.indice;
                                                byArray[by2] = (byte)(byArray[by2] + this.inc);
                                                if (this.fichas[this.turno][this.indice] == this.entrada[0][this.players[this.turno]] + 1 || this.fichas[this.turno][this.indice] == this.entrada[0][this.players[this.turno]] + 2) {
                                                    this.fichas[this.turno][this.indice] = (byte)(this.entrada[0][this.turno] - this.fichas[this.turno][this.indice]);
                                                    this.escaleras[this.turno][1] = 1;
                                                    this.resDado = (byte)(this.resDado - 1);
                                                    return;
                                                }
                                                if (this.fichas[this.turno][this.indice] >= 69) {
                                                    byte[] byArray2 = this.fichas[this.turno];
                                                    byte by3 = this.indice;
                                                    byArray2[by3] = (byte)(byArray2[by3] - 68);
                                                }
                                                if (this.casillas[this.fichas[this.turno][this.indice]][3] != -1) break block14;
                                                this.casillas[this.fichas[this.turno][this.indice]][3] = (byte)(this.turno * 10);
                                                break block12;
                                            }
                                            boolean bl = false;
                                            for (n = 0; n < this.mare.length; ++n) {
                                                if (this.fichas[this.turno][this.indice] != this.mare[n]) continue;
                                                bl = true;
                                            }
                                            if (!bl && this.casillas[this.fichas[this.turno][this.indice]][3] / 10 != this.turno && this.resDado <= 1) break block15;
                                            byte[] byArray = this.casillas[this.fichas[this.turno][this.indice]];
                                            byArray[3] = (byte)(byArray[3] + (this.turno + 1));
                                            break block12;
                                        }
                                        if (this.fichas[this.turno][this.indice] != 0) break block16;
                                        this.fichas[this.turno][this.indice] = this.mare[this.players[this.turno] * 3];
                                        this.resDado = 1;
                                        if (this.casillas[this.fichas[this.turno][this.indice]][3] != -1) break block17;
                                        this.casillas[this.fichas[this.turno][this.indice]][3] = (byte)(this.turno * 10);
                                        break block12;
                                    }
                                    if (this.casillas[this.fichas[this.turno][this.indice]][3] % 10 != 0) break block18;
                                    byte[] byArray = this.casillas[this.fichas[this.turno][this.indice]];
                                    byArray[3] = (byte)(byArray[3] + (this.turno + 1));
                                    break block12;
                                }
                                if (this.casillas[this.fichas[this.turno][this.indice]][3] % 10 - 1 == this.turno) break block19;
                                break block20;
                            }
                            byte[] byArray = this.escaleras[this.turno];
                            byte by = -this.fichas[this.turno][this.indice];
                            byArray[by] = (byte)(byArray[by] - 1);
                            byte[] byArray3 = this.fichas[this.turno];
                            byte by4 = this.indice;
                            byArray3[by4] = (byte)(byArray3[by4] - 1);
                            byte[] byArray4 = this.escaleras[this.turno];
                            byte by5 = -this.fichas[this.turno][this.indice];
                            byArray4[by5] = (byte)(byArray4[by5] + 1);
                            if (this.fichas[this.turno][this.indice] == -8) {
                                this.fichas[this.turno][this.indice] = 70;
                                if (this.fichas[this.turno][0] == 70 && this.fichas[this.turno][1] == 70 && this.fichas[this.turno][2] == 70 && this.fichas[this.turno][3] == 70) {
                                    this.maquinaEstados(9);
                                    break block12;
                                } else {
                                    this.maquinaEstados(7);
                                }
                            }
                            break block12;
                        }
                        for (n = 0; n < 4; ++n) {
                            if (this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] / 10][n] != this.fichas[this.turno][this.indice]) continue;
                            this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] / 10][n] = 0;
                            break;
                        }
                        this.casillas[this.fichas[this.turno][this.indice]][3] = (byte)(this.turno * 10);
                        this.resDado = (byte)20;
                        this.maquinaEstados(8);
                        return;
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] % 10 - 1][i] != this.fichas[this.turno][this.indice]) continue;
                        this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] % 10 - 1][i] = 0;
                        break;
                    }
                    byte[] byArray = this.casillas[this.fichas[this.turno][this.indice]];
                    byArray[3] = (byte)(byArray[3] - this.casillas[this.fichas[this.turno][this.indice]][3] % 10);
                    byte[] byArray5 = this.casillas[this.fichas[this.turno][this.indice]];
                    byArray5[3] = (byte)(byArray5[3] + (this.turno + 1));
                    break block21;
                }
                for (int i = 0; i < 4; ++i) {
                    if (this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] / 10][i] != this.fichas[this.turno][this.indice]) continue;
                    this.fichas[this.casillas[this.fichas[this.turno][this.indice]][3] / 10][i] = 0;
                    break;
                }
                byte[] byArray = this.casillas[this.fichas[this.turno][this.indice]];
                byArray[3] = (byte)(byArray[3] - this.casillas[this.fichas[this.turno][this.indice]][3] / 10 * 10);
                byte[] byArray6 = this.casillas[this.fichas[this.turno][this.indice]];
                byArray6[3] = (byte)(byArray6[3] + this.turno * 10);
            }
            this.resDado = (byte)20;
            this.maquinaEstados(8);
        }
        this.resDado = (byte)(this.resDado - 1);
    }

    public void riesgo(int n) {
        int n2;
        int n3;
        int n4;
        short[] sArray = new short[]{50, 50, 50, 50};
        block0: for (n4 = 0; n4 < 4; n4 = (int)((byte)(n4 + 1))) {
            int n5;
            n3 = this.fichas[1][n4];
            if (n3 == 70) {
                sArray[n4] = 0;
                continue;
            }
            if (n3 == 0) {
                if (n == 5 && this.casillas[this.mare[this.players[1] * 3]][3] != 12) {
                    sArray[n4] = 1000;
                    continue;
                }
                sArray[n4] = 0;
                continue;
            }
            if ((n == 6 || n == 7) && this.fichas[1][n4] > 0 && this.casillas[this.fichas[1][n4]][3] % 10 != 0) {
                sArray[n4] = 2000;
            }
            n2 = 0;
            for (n5 = 0; n5 < this.mare.length; ++n5) {
                if (this.mare[n5] != n3) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                for (n5 = 1; n5 <= 7; ++n5) {
                    if (n3 > 0) {
                        n3 = (byte)(n3 - 1);
                    }
                    if (n3 == 0) {
                        n3 = 68;
                    }
                    if (n3 <= 0 || this.casillas[n3][3] / 10 != 0 && this.casillas[n3][3] % 10 != 1) continue;
                    int n6 = n4;
                    sArray[n6] = (short)(sArray[n6] + 40);
                }
            }
            n3 = this.fichas[1][n4];
            for (n5 = 1; n5 <= n; ++n5) {
                if (n3 > 0) {
                    n3 = (byte)(n3 + 1);
                }
                if (n3 < 0) {
                    byte by = (byte)(n3 - 1);
                    n3 = by;
                    if (by > -8 && this.escaleras[1][-n3] == 2) {
                        sArray[n4] = 0;
                        continue block0;
                    }
                }
                if (n3 > 68) {
                    n3 = 1;
                }
                if (n5 < n) {
                    if (n3 == -8) {
                        sArray[n4] = 0;
                        continue block0;
                    }
                    if (n3 > 0 && this.casillas[n3][3] > -1) {
                        if (this.casillas[n3][3] / 10 == this.casillas[n3][3] % 10 - 1) {
                            sArray[n4] = 0;
                            continue block0;
                        }
                        if (this.casillas[n3][3] < 10) {
                            int n7 = n4;
                            sArray[n7] = (short)(sArray[n7] - 40);
                        }
                    }
                    if (n3 != this.entrada[0][this.players[1]]) continue;
                    int n8 = n4;
                    sArray[n8] = (short)(sArray[n8] + 20);
                    n3 = -1;
                    ++n;
                    continue;
                }
                if (n3 == -8) {
                    int n9 = n4;
                    sArray[n9] = (short)(sArray[n9] + 25);
                    System.out.println("meta");
                }
                for (int i = 0; i < this.mare.length; ++i) {
                    if (this.mare[i] != n3) continue;
                    int n10 = n4;
                    sArray[n10] = (short)(sArray[n10] + 30);
                }
                if (n3 <= 0) continue;
                if (this.casillas[n3][3] >= 0 && this.casillas[n3][3] % 10 != 0) {
                    sArray[n4] = 0;
                    continue block0;
                }
                if (this.casillas[n3][3] == 10) {
                    int n11 = n4;
                    sArray[n11] = (short)(sArray[n11] + 35);
                }
                if (this.casillas[n3][3] != 0) continue;
                int n12 = n4;
                sArray[n12] = (short)(sArray[n12] + 100);
            }
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            if (sArray[n2] <= n3) continue;
            n4 = n2;
            n3 = sArray[n2];
        }
        this.indice = (byte)n4;
        this.cambiaScroll(1, this.indice);
        if (sArray[0] == 0 && sArray[1] == 0 && sArray[2] == 0 && sArray[3] == 0) {
            this.maquinaEstados(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cambiaFicha(int n) {
        this.indice = (byte)n;
        try {
            int n2 = 0;
            Game game = this;
            synchronized (game) {
                do {
                    this.indice = (byte)(this.indice + 1);
                    if (this.indice > 3) {
                        this.indice = 0;
                    }
                    this.casillaDest = this.celdaDestino(this.indice, this.resDado);
                    if (this.casillaDest == 0) {
                        n2 = (byte)(n2 + 1);
                    }
                    if (n2 != 4) continue;
                    this.maquinaEstados(5);
                    return;
                } while (this.casillaDest == 0);
            }
        }
        catch (Exception exception) {
            System.out.println("Cambia ficha 1: " + exception.toString());
        }
        if (this.casillaDest < 0) {
            this.bloqueXdest = (byte)(this.casillas[this.entrada[0][this.players[this.turno]]][0] + this.entrada[1][this.players[this.turno]] * -this.casillaDest);
            this.bloqueYdest = (byte)(this.casillas[this.entrada[0][this.players[this.turno]]][1] + this.entrada[2][this.players[this.turno]] * -this.casillaDest);
            if (this.players[this.turno] == 1 || this.players[this.turno] == 2) {
                this.dX = (byte)9;
                this.dY = (byte)18;
            } else {
                this.dX = (byte)18;
                this.dY = (byte)9;
            }
        } else {
            this.bloqueXdest = this.casillas[this.casillaDest][0];
            this.bloqueYdest = this.casillas[this.casillaDest][1];
            if (this.casillas[this.casillaDest][2] == 3) {
                this.dX = (byte)9;
                this.dY = (byte)18;
            } else {
                this.dX = (byte)18;
                this.dY = (byte)9;
            }
        }
        this.cambiaScroll(this.turno, this.indice);
    }

    public void guardaPartida() {
        byte[][] byArray = new byte[1][24];
        try {
            int n;
            for (n = 0; n < 22; ++n) {
                byArray[0][n] = 0;
            }
            byArray[0][0] = this.nPlayers;
            byArray[0][1] = this.turno;
            byArray[0][2] = this.contraMovil;
            byArray[0][3] = App.mainMenu.bSound ? (byte)0 : 1;
            n = 4;
            for (int i = 0; i < this.fichas.length; ++i) {
                byArray[0][n] = this.players[i];
                n = (byte)(n + 1);
                for (int j = 0; j < 4; ++j) {
                    byArray[0][n] = this.fichas[i][j];
                    n = (byte)(n + 1);
                }
            }
        }
        catch (Exception exception) {}
        Kernel.saveRMS("PARTIDA", byArray, 0);
    }

    public void leePartida() {
        try {
            byte[][] byArray = Kernel.loadRMS("PARTIDA", 0);
            byte[] byArray2 = byArray[0];
            this.bExitTemp = true;
            App.mainMenu.bSound = byArray2[3] == 0;
            int n = byArray2[0];
            if (n <= 0 || n > 4) {
                this.bExitTemp = false;
                return;
            }
            this.nPlayers = n;
            this.fichas = new byte[n][4];
            this.escaleras = new byte[n][10];
            this.seis = new byte[n];
            this.ultDes = new byte[n];
            this.inicializaParchis();
            this.turno = byArray2[1];
            this.contraMovil = byArray2[2];
            int n2 = 4;
            for (int i = 0; i < n; ++i) {
                this.players[i] = byArray2[n2];
                ++n2;
                for (int j = 0; j < 4; ++j) {
                    this.fichas[i][j] = byArray2[n2];
                    ++n2;
                    if (this.fichas[i][j] > 0 && this.fichas[i][j] < 69) {
                        if (this.casillas[this.fichas[i][j]][3] == -1) {
                            this.casillas[this.fichas[i][j]][3] = (byte)(i * 10);
                        } else {
                            byte[] byArray3 = this.casillas[this.fichas[i][j]];
                            byArray3[3] = (byte)(byArray3[3] + (byte)(i + 1));
                        }
                    }
                    if (this.fichas[i][j] >= 0) continue;
                    byte[] byArray4 = this.escaleras[0];
                    byte by = -this.fichas[i][j];
                    byArray4[by] = (byte)(byArray4[by] + 1);
                }
            }
            App.mainMenu.op = 1;
            this.estado = 1;
            return;
        }
        catch (Exception exception) {
            this.bExitTemp = false;
            System.out.println("LLE PARTIDA: " + exception.toString());
            return;
        }
    }

    public void show(boolean bl) {
        Kernel.instance.keyStatus = 0;
        Kernel.instance.pause(!bl);
    }
}

