/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.dvj2me.dvSprite;
import com.dvidearts.dvj2me.dvUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends dvSprite {
    private Game game;
    public dvSprite sword;
    public short wx;
    public short wy;
    boolean invinsible;
    boolean death;
    byte invinsible_counter = 0;
    byte mAnimation = (byte)-1;
    byte carryRockIndex = (byte)-1;
    static final byte SWORD0 = 0;
    static final byte SWORD1 = 1;
    static final byte SWORD2 = 2;
    static final byte SWORD3 = 3;
    static final byte SWORD4 = 4;

    public Player(Game g, Image img) {
        super(img, g.TILEW, g.TILEH);
        this.game = g;
        try {
            switch (this.game.buildType) {
                case 2: 
                case 3: 
                case 4: {
                    this.sword = new dvSprite(Image.createImage((String)(Game.PATH_240x240 + "swords.png")), this.game.SWORDW, this.game.SWORDH);
                    break;
                }
                case 0: 
                case 1: {
                    this.sword = new dvSprite(Image.createImage((String)(Game.PATH_320x480 + "swords.png")), this.game.SWORDW, this.game.SWORDH);
                }
            }
        }
        catch (Exception e) {
            System.out.println("could not load swords");
        }
        this.wx = 0;
        this.wy = 0;
        this.setAnimation((byte)0);
        this.invinsible = true;
        this.invinsible_counter = 0;
        this.death = false;
        this.offset(this.game.x, this.game.y);
        this.defineCollisionRectangle(this.game.TILEW / 4, this.game.TILEW / 2 + this.game.TILEW / 4, -this.game.TILEW / 4, -this.game.TILEW / 4);
        this.sword.defineCollisionRectangle(this.game.TILEW / 8, this.game.TILEW / 8, -this.game.TILEW / 8, -this.game.TILEW / 8);
    }

    public void offset(int ix, int iy) {
        this.setOffset(-this.getWidth() / 2 + ix, -(this.getHeight() - this.getHeight() / 3) + iy);
        this.sword.setOffset(-this.sword.getWidth() / 2 + ix, -this.sword.getHeight() / 2 + iy);
    }

    void addHeart() {
        this.game.sinfo[this.game.infoSlot].health = (byte)(this.game.sinfo[this.game.infoSlot].health + 1);
        if (this.game.sinfo[this.game.infoSlot].health > this.game.sinfo[this.game.infoSlot].numHearts) {
            this.game.sinfo[this.game.infoSlot].health = this.game.sinfo[this.game.infoSlot].numHearts;
        }
    }

    void dropHeart(short x, short y) {
        if (dvUtil.RandNum(1, 5) == 2) {
            for (int i = 0; i < this.game.world.heartAlive.length; ++i) {
                if (this.game.world.heartAlive[i]) continue;
                this.game.world.heartAlive[i] = true;
                this.game.world.objHeart[i].x = (short)(x + 4);
                this.game.world.objHeart[i].y = y;
                return;
            }
        }
    }

    void addMagic() {
        int amount = 0;
        int num = 0;
        switch (this.game.sinfo[this.game.infoSlot].swordLevel) {
            case 0: {
                amount = 30;
                break;
            }
            case 1: {
                amount = 25;
                break;
            }
            case 2: {
                amount = 20;
                break;
            }
            case 3: {
                amount = 15;
                break;
            }
            case 4: {
                amount = 10;
            }
        }
        num = this.game.sinfo[this.game.infoSlot].magic;
        if ((num += amount) > 100) {
            num = 100;
        }
        this.game.sinfo[this.game.infoSlot].magic = (byte)num;
    }

    int getSwordDamage() {
        return 1;
    }

    public void draw(Graphics g, World world) {
        if (this.death) {
            if (!this.game.wipe.IsActive()) {
                if (this.getFrame() >= Gameplay.FRAMES_DEATH.length - 1) {
                    world.fadeTo = 0;
                    this.game.wipe.Out();
                    this.game.dvutil.pause(1000L);
                } else {
                    this.nextFrame();
                }
            }
            this.paint(g);
            return;
        }
        if (this.game.sinfo[this.game.infoSlot].health < 1) {
            this.game.sinfo[this.game.infoSlot].health = 0;
            this.death = true;
            this.carryRockIndex = (byte)-1;
            this.setAnimation((byte)9);
        }
        if (this.invinsible && this.game.currframe % 2 == 0) {
            this.invinsible_counter = (byte)(this.invinsible_counter + 1);
            if (this.invinsible_counter > 15) {
                this.invinsible_counter = 0;
                this.invinsible = false;
            } else {
                return;
            }
        }
        this.paint(g);
        boolean cutting = false;
        int xoff = 0;
        int yoff = 0;
        switch (this.mAnimation) {
            case 5: {
                if (this.getFrame() >= 2) break;
                yoff = this.sword.getHeight() / 2 + this.getHeight() / 3;
                this.sword.setPosition(this.getX(), this.getY() + yoff);
                this.sword.setFrame(2);
                this.sword.paint(g);
                cutting = true;
                break;
            }
            case 6: {
                if (this.getFrame() >= 2) break;
                yoff = -(this.sword.getHeight() / 2 + (this.getHeight() - this.getHeight() / 3));
                this.sword.setPosition(this.getX(), this.getY() + yoff);
                this.sword.setFrame(0);
                this.sword.paint(g);
                cutting = true;
                break;
            }
            case 7: {
                if (this.getFrame() >= 2) break;
                xoff = -(this.sword.getWidth() / 2 + this.getWidth() / 2);
                yoff = -1;
                this.sword.setPosition(this.getX() + xoff, this.getY() + yoff);
                this.sword.setFrame(3);
                this.sword.paint(g);
                cutting = true;
                break;
            }
            case 8: {
                if (this.getFrame() >= 2) break;
                xoff = this.sword.getWidth() / 2 + this.getWidth() / 2;
                yoff = -1;
                this.sword.setPosition(this.getX() + xoff, this.getY() + yoff);
                this.sword.setFrame(1);
                this.sword.paint(g);
                cutting = true;
            }
        }
        if (cutting) {
            int col = world.currmap.getColumn(this.wx + xoff);
            int row = world.currmap.getRow(this.wy + yoff);
            short cellid = world.currmap.getCell(col, row);
            switch (this.game.sinfo[this.game.infoSlot].swordLevel) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (cellid != 8) break;
                    if (col == 1 && row == 2) {
                        world.currmap.setCell(col, row, (short)10);
                        break;
                    }
                    world.currmap.setCell(col, row, (short)5);
                    break;
                }
                case 3: 
                case 4: {
                    if (cellid != 8 && cellid != 9) break;
                    if (col == 1 && row == 2) {
                        world.currmap.setCell(col, row, (short)10);
                    } else {
                        world.currmap.setCell(col, row, (short)5);
                    }
                    if (col != 24 || row != 26) break;
                    world.currmap.setCell(col, row, (short)26);
                }
            }
        }
    }

    public void drawDisplay(Graphics g) {
        if (this.game.sinfo[this.game.infoSlot].forgeTalk < 8) {
            return;
        }
        int dx = this.game.x + 4;
        int dy = this.game.y + 4;
        for (int i = 0; i < this.game.sinfo[this.game.infoSlot].numHearts; ++i) {
            if (this.game.sinfo[this.game.infoSlot].health > i) {
                this.game.sprIcon.setFrame(1);
            } else {
                this.game.sprIcon.setFrame(0);
            }
            this.game.sprIcon.setPosition(dx + i * (this.game.sprIcon.getWidth() + 1), dy);
            this.game.sprIcon.paint(g);
        }
        int bh = this.game.sprIcon.getHeight() / 2;
        int bw = this.game.sprIcon.getWidth() * 3;
        int pct = bw * this.game.sinfo[this.game.infoSlot].magic / 100;
        g.setColor(0, 0, 0);
        g.fillRect(dx, dy + this.game.sprIcon.getHeight() + 4, bw, bh);
        if (this.game.sinfo[this.game.infoSlot].magic >= 100 && this.game.currframe % 5 == 0) {
            g.setColor(255, 255, 0);
        } else {
            g.setColor(255, 0, 255);
        }
        g.fillRect(dx, dy + this.game.sprIcon.getHeight() + 4, pct, bh);
        g.setColor(255, 255, 255);
        g.drawRect(dx, dy + this.game.sprIcon.getHeight() + 4, bw, bh);
        if (this.game.sinfo[this.game.infoSlot].currTileMap == 16 && this.game.sinfo[this.game.infoSlot].wizTalk > 2 && this.game.sinfo[this.game.infoSlot].wizTalk < 8 && !this.game.dvpopup.IsActive()) {
            bw = 50;
            int tmpX = this.game.x + this.game.resw - 2 - bw;
            pct = bw * this.game.world.wizHealth / 100;
            int offset = 0;
            g.setColor(0, 0, 0);
            g.fillRect(tmpX, dy + offset, bw, bh);
            g.setColor(255, 0, 0);
            g.fillRect(tmpX, dy + offset, pct, bh);
            g.setColor(255, 255, 0);
            g.drawRect(tmpX, dy + offset, bw, bh);
        }
        if (this.game.sinfo[this.game.infoSlot].swordLevel < 4) {
            this.game.sprIcon.setFrame(2);
            this.game.sprIcon.setPosition(this.game.x + this.game.resw - 2 - this.game.cfont.getWidth() * 2 - 2 - this.game.sprIcon.getWidth(), this.game.y + 4);
            this.game.sprIcon.paint(g);
            if (this.game.sinfo[this.game.infoSlot].numOre < 10) {
                this.game.cfont.drawString(g, "0" + this.game.sinfo[this.game.infoSlot].numOre, this.game.x + this.game.resw - 2 - this.game.cfont.getWidth() * 2, this.game.y + 4);
            } else {
                this.game.cfont.drawString(g, "" + this.game.sinfo[this.game.infoSlot].numOre, this.game.x + this.game.resw - 2 - this.game.cfont.getWidth() * 2, this.game.y + 4);
            }
        }
    }

    public void reset() {
        this.setAnimation((byte)0);
        this.game.sinfo[this.game.infoSlot].health = (byte)3;
        this.game.sinfo[this.game.infoSlot].magic = 0;
        this.carryRockIndex = (byte)-1;
        this.invinsible = false;
        this.invinsible_counter = 0;
        this.death = false;
        if (this.game.world.follow) {
            this.game.world.follow = false;
            this.game.sinfo[this.game.infoSlot].lostSisterTalk = (byte)(this.game.sinfo[this.game.infoSlot].lostSisterTalk - 1);
            this.game.sinfo[this.game.infoSlot].sisterTalk = (byte)(this.game.sinfo[this.game.infoSlot].sisterTalk - 1);
            if (this.game.sinfo[this.game.infoSlot].sisterTalk < 0) {
                this.game.sinfo[this.game.infoSlot].sisterTalk = 0;
            }
        }
        if (this.game.sinfo[this.game.infoSlot].wizTalk > 2) {
            this.game.sinfo[this.game.infoSlot].wizTalk = (byte)2;
        }
    }

    public void moveto(int x, int y) {
        this.wx = (short)x;
        this.wy = (short)y;
    }

    public void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        this.setFrame(0);
        switch (newAnimation) {
            case 0: {
                this.setFrameSequence(Gameplay.FRAMES_STAND);
                break;
            }
            case 1: {
                this.setFrameSequence(Gameplay.FRAMES_RUNLEFT);
                break;
            }
            case 2: {
                this.setFrameSequence(Gameplay.FRAMES_RUNRIGHT);
                break;
            }
            case 3: {
                this.setFrameSequence(Gameplay.FRAMES_RUNUP);
                break;
            }
            case 4: {
                this.setFrameSequence(Gameplay.FRAMES_RUNDOWN);
                break;
            }
            case 5: {
                this.setFrameSequence(Gameplay.FRAMES_CUTDOWN);
                break;
            }
            case 6: {
                this.setFrameSequence(Gameplay.FRAMES_CUTUP);
                break;
            }
            case 7: {
                this.setFrameSequence(Gameplay.FRAMES_CUTLEFT);
                break;
            }
            case 8: {
                this.setFrameSequence(Gameplay.FRAMES_CUTRIGHT);
                break;
            }
            case 9: {
                this.setFrameSequence(Gameplay.FRAMES_DEATH);
            }
        }
        this.mAnimation = newAnimation;
    }

    public void doFire() {
        if (this.game.sinfo[this.game.infoSlot].forgeTalk < 8) {
            return;
        }
        switch (this.game.sinfo[this.game.infoSlot].swordLevel) {
            case 0: {
                this.sword.setFrameSequence(Gameplay.FRAMES_SWORD0);
                break;
            }
            case 1: {
                this.sword.setFrameSequence(Gameplay.FRAMES_SWORD1);
                break;
            }
            case 2: {
                this.sword.setFrameSequence(Gameplay.FRAMES_SWORD2);
                break;
            }
            case 3: {
                this.sword.setFrameSequence(Gameplay.FRAMES_SWORD3);
                break;
            }
            case 4: {
                this.sword.setFrameSequence(Gameplay.FRAMES_SWORD4);
            }
        }
        switch (this.mAnimation) {
            case 3: {
                this.setAnimation((byte)6);
                this.setFrame(0);
                break;
            }
            case 1: {
                this.setAnimation((byte)7);
                this.setFrame(0);
                break;
            }
            case 2: {
                this.setAnimation((byte)8);
                this.setFrame(0);
                break;
            }
            case 0: 
            case 4: {
                this.setAnimation((byte)5);
                this.setFrame(0);
            }
        }
        this.nextFrame();
    }

    public boolean collidesWithFull(Image img, int ix, int iy) {
        int nx = this.getX() + this.getXOffset();
        int ny = this.getY() + this.getYOffset();
        return nx < ix + img.getWidth() && nx + img.getWidth() > ix && ny < iy + img.getHeight() && ny + img.getHeight() > iy;
    }

    public boolean collidesWithFull(dvSprite img, int ix, int iy) {
        int nx = this.getX() + this.getXOffset();
        int ny = this.getY() + this.getYOffset();
        return nx < ix + img.getWidth() && nx + img.getWidth() > ix && ny < iy + img.getHeight() && ny + img.getHeight() > iy;
    }
}

