/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ability;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.ui.component.MessageLog;

public abstract class SelfBuff
extends Ability {
    public SelfBuff(String string, String string2, int n) {
        super(string, string2, n);
    }

    public boolean effect(Creature creature) {
        if (!creature.isReadyToAct(this.getAbilitySlot())) {
            return false;
        }
        Creature creature2 = creature;
        if (creature2.mana < this.getManaCost()) {
            if (creature.getId() == Game.player.getId()) {
                MessageLog.getInstance().addMessage("Not enough energy!");
            }
            return false;
        }
        Game.player.addAbilityCooldown(this.getCooldownInRounds(), this.getAbilitySlot());
        creature2.mana -= this.getManaCost();
        creature2.addAbilityEffect(this.getTargetVisualEffect());
        Game.party.sendVisualEffect(creature2.getId(), this.getTargetVisualEffect());
        this.start(creature2, System.currentTimeMillis() + (long)this.getDurationMillis());
        return true;
    }

    public abstract void start(Creature var1, long var2);

    public abstract String getDescription();

    public abstract int getManaCost();

    public abstract int getDurationMillis();
}

