/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.core.CalculateException;
import graph.core.Color;
import graph.core.Settings;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.utils.Utils;

public class CriticalPoint {
    private double xmin;
    private double xmax;
    private Equation originalEquation;
    private Expression nullpointEquation;
    private double xValue = Double.NaN;
    private double yValue = Double.NaN;
    private final int[] internalEqnNumbers;
    private final String description;

    public CriticalPoint(Equation originalEquation, double x, double y, int[] internalEqnNumbers, String description) {
        this.xValue = x;
        this.yValue = y;
        this.internalEqnNumbers = internalEqnNumbers;
        this.originalEquation = originalEquation;
        this.description = description;
    }

    public CriticalPoint(Equation originalEquation, Expression nullpointExpression, double xmin, double xmax, int[] internalEqnNumbers, String description) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.internalEqnNumbers = internalEqnNumbers;
        this.description = description;
        this.originalEquation = originalEquation;
        this.nullpointEquation = nullpointExpression;
    }

    private void buildCriticalPoint() throws CalculateException {
        int nbDecimals = Settings.getNbDecimals();
        if (this.nullpointEquation == null) {
            this.noExactCalculation();
        }
        double xValueToRound = Utils.getNullpoint(this.nullpointEquation, this.xmin, this.xmax, Utils.pow(0.1, nbDecimals + 1));
        this.xValue = Utils.round(xValueToRound, nbDecimals);
        double yValueToRound = this.originalEquation.getFunctionValue(xValueToRound);
        this.yValue = Utils.round(yValueToRound, nbDecimals);
    }

    private void buildCriticalPointIfNotCalculatedYet() {
        if (Double.isNaN(this.xValue) && Double.isNaN(this.yValue)) {
            try {
                this.buildCriticalPoint();
            }
            catch (CalculateException e) {
                this.noExactCalculation();
            }
        }
    }

    private void noExactCalculation() {
        this.xValue = (this.xmin + this.xmax) / 2.0;
        this.yValue = this.originalEquation.getFunctionValue(this.xValue);
    }

    public String getEqnNumberString() {
        if (this.internalEqnNumbers.length == 1) {
            return "" + (this.internalEqnNumbers[0] + 1);
        }
        if (this.internalEqnNumbers.length == 2) {
            return this.internalEqnNumbers[0] + 1 + "," + (this.internalEqnNumbers[1] + 1);
        }
        return null;
    }

    public Color getColor() {
        if (this.internalEqnNumbers.length == 1) {
            return Color.ColorArray[this.internalEqnNumbers[0]];
        }
        if (this.internalEqnNumbers.length == 2) {
            return Color.ColorArray[this.internalEqnNumbers[0]].mix(Color.ColorArray[this.internalEqnNumbers[1]]);
        }
        return null;
    }

    public double getX() {
        this.buildCriticalPointIfNotCalculatedYet();
        return this.xValue;
    }

    public double getY() {
        this.buildCriticalPointIfNotCalculatedYet();
        return this.yValue;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.originalEquation.getFunctionAsString();
    }
}

