/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordComparator;

public class Sample {
    public static final int MIN_X_DEFAULT = -10;
    public static final int MAX_X_DEFAULT = 10;
    public static final int MIN_Y_DEFAULT = -10;
    public static final int MAX_Y_DEFAULT = 10;
    public static final Sample defaultSample = new Sample("Default", new String[]{"y=x"}, -10.0, 10.0, -10.0, 10.0, false, false, false, false);
    public String sampleName;
    public String[] equations;
    public boolean showAxisIntersections;
    public boolean showDerivate;
    public boolean showSecondDerivate;
    public boolean showIntegral;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public static final RecordComparator sampleComparator = new RecordComparator(){

        public int compare(byte[] sample1, byte[] sample2) {
            try {
                String sampleName1 = Utils.readString(sample1);
                String sampleName2 = Utils.readString(sample2);
                int stringCompare = sampleName1.compareTo(sampleName2);
                if (stringCompare < 0) {
                    return -1;
                }
                if (stringCompare == 0) {
                    return 0;
                }
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
    };

    public Sample(String sampleName, String[] equations) {
        this(sampleName, equations, -10.0, 10.0, -10.0, 10.0);
    }

    public Sample(String sampleName, String equation) {
        this(sampleName, new String[]{equation}, -10.0, 10.0, -10.0, 10.0);
    }

    public Sample(String sampleName, String equation, double xmin, double xmax, double ymin, double ymax) {
        this(sampleName, new String[]{equation}, xmin, xmax, ymin, ymax);
    }

    public Sample(String sampleName, String[] equations, double xmin, double xmax, double ymin, double ymax) {
        this(sampleName, equations, xmin, xmax, ymin, ymax, false, false, false, false);
    }

    public Sample(String sampleName, String[] equations, double xmin, double xmax, double ymin, double ymax, boolean showAxisIntersections, boolean showDerivate, boolean showSecondDerivate, boolean showIntegral) {
        this.sampleName = sampleName;
        this.equations = equations;
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.showAxisIntersections = showAxisIntersections;
        this.showDerivate = showDerivate;
        this.showSecondDerivate = showSecondDerivate;
        this.showIntegral = showIntegral;
    }

    public Sample(byte[] byteArray) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
        DataInputStream dataIn = new DataInputStream(in);
        this.sampleName = Utils.readString(dataIn);
        this.xmin = dataIn.readDouble();
        this.xmax = dataIn.readDouble();
        this.ymin = dataIn.readDouble();
        this.ymax = dataIn.readDouble();
        this.showAxisIntersections = dataIn.readBoolean();
        this.showDerivate = dataIn.readBoolean();
        this.showSecondDerivate = dataIn.readBoolean();
        this.showIntegral = dataIn.readBoolean();
        int nbEqn = dataIn.readInt();
        this.equations = new String[nbEqn];
        int i = 0;
        while (i < nbEqn) {
            this.equations[i] = Utils.readString(dataIn);
            ++i;
        }
        dataIn.close();
        in.close();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        Utils.writeString(dataOut, this.sampleName);
        dataOut.writeDouble(this.xmin);
        dataOut.writeDouble(this.xmax);
        dataOut.writeDouble(this.ymin);
        dataOut.writeDouble(this.ymax);
        dataOut.writeBoolean(this.showAxisIntersections);
        dataOut.writeBoolean(this.showDerivate);
        dataOut.writeBoolean(this.showSecondDerivate);
        dataOut.writeBoolean(this.showIntegral);
        dataOut.writeInt(this.equations.length);
        int i = 0;
        while (i < this.equations.length) {
            Utils.writeString(dataOut, this.equations[i]);
            ++i;
        }
        byte[] result = out.toByteArray();
        dataOut.close();
        out.close();
        return result;
    }
}

