/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphForm;
import graph.MyDisplayable;
import graph.core.Sample;
import graph.core.SampleStore;
import graph.lang.Phrases;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class SampleList
extends List
implements CommandListener,
SampleStore.SampleListener,
MyDisplayable {
    Command showCommand = new Command(Phrases.show, 1, 0);
    Command deleteCommand = new Command(Phrases.delete, 1, 1);
    Command resetToDefaultsCommand = new Command(Phrases.resetDefaults, 1, 2);

    public SampleList() {
        super(Phrases.Samples, 3);
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        CommandHandler.getInstance().registerDisplayable((Displayable)this);
        this.setCommandListener(this);
        this.addCommand(CommandHandler.getGlobalBackCommand());
        this.setSelectCommand(this.showCommand);
        CommandHandler.getInstance().registerCommand(this.showCommand, "graph.GraphForm");
        this.addCommand(this.deleteCommand);
        this.addCommand(this.resetToDefaultsCommand);
        this.samplesChanged();
        SampleStore.getInstance().setListener(this);
    }

    public void samplesChanged() {
        this.deleteAll();
        Sample[] samples = SampleStore.getInstance().getSamples();
        int i = 0;
        while (i < samples.length) {
            this.append(samples[i].sampleName, null);
            ++i;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        CommandHandler.getInstance().handleCommand(command);
        if (command == this.showCommand) {
            GraphForm graphForm = (GraphForm)CommandHandler.getInstance().getDisplayable("graph.GraphForm");
            graphForm.setSample(SampleStore.getInstance().getSample(this.getSelectedIndex()));
            graphForm.selectPlotButton();
        } else if (command == this.deleteCommand) {
            SampleStore.getInstance().deleteSample(this.getSelectedIndex());
        } else if (command == this.resetToDefaultsCommand) {
            SampleStore.getInstance().resetSamples();
        }
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

