/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.GraphCanvas;
import graph.core.PlotterWithFunctionEvaluation;
import graph.core.Settings;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlotterRunnable
implements Runnable {
    private GraphCanvas canvas;
    Image image;
    PlotterWithFunctionEvaluation plotter;
    private int currentPrecision;

    public PlotterWithFunctionEvaluation getPlotter() {
        return this.plotter;
    }

    public PlotterRunnable(GraphCanvas canvas, PlotterWithFunctionEvaluation plotter) {
        this.plotter = plotter;
        this.canvas = canvas;
    }

    Graphics getGraphics() {
        return this.image.getGraphics();
    }

    public Image getImage() {
        return this.image;
    }

    public void run() {
        if (this.plotter.isInterrupted()) {
            return;
        }
        Settings.PRECISION_DERIVATE = false;
        this.currentPrecision = 0;
        int stepSize = 100;
        int nbDrawingSteps = Settings.NB_REDRAWING_STEPS;
        if (nbDrawingSteps == 0) {
            return;
        }
        if (nbDrawingSteps != 1) {
            stepSize = 100 / (nbDrawingSteps - 1);
        }
        int i = 0;
        while (i < nbDrawingSteps && !this.plotter.isInterrupted()) {
            Settings.setInternalPrecision(this.currentPrecision);
            if (i >= nbDrawingSteps - 1) {
                Settings.PRECISION_DERIVATE = true;
                Settings.setInternalPrecision(100);
            }
            this.plotter.createImage(this);
            GraphCanvas.setState(15, "PlotterRunnable.run() in loop");
            this.canvas.repaint();
            this.currentPrecision += stepSize;
            ++i;
        }
        GraphCanvas.setState(20, "PlotterRunnable.run() out loop");
    }
}

