/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.Settings;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.eqn.SimpleEquation;
import graph.utils.Utils;

public class Derivate
extends Expression {
    Equation eqn;

    public Derivate(Equation eqn) {
        this.eqn = eqn;
    }

    public Derivate(Expression expr) {
        this.eqn = new SimpleEquation(expr);
    }

    public double getFunctionValue(double xValue) {
        double DELTA = Utils.pow(2.0, -Settings.DELTA);
        return (this.eqn.getFunctionValue(xValue + DELTA / 2.0) - this.eqn.getFunctionValue(xValue - DELTA / 2.0)) / DELTA;
    }

    public String getFunctionAsString() {
        return "D(" + this.eqn.getFunctionAsString() + ")";
    }

    public double getValue(double xValue, double yValue) {
        return this.getFunctionValue(xValue);
    }
}

