/*
 * Decompiled with CFR 0.152.
 */
public final class TinyGL {
    public static final int SHIFT_STRETCH = 12;
    public static final int UNIT_SCALE = 65536;
    static final int MATRIX_ONE_SHIFT = 14;
    static final int MATRIX_ONE = 16384;
    static final int SCREEN_SHIFT = 3;
    static final int SCREEN_ONE = 8;
    static final int INTERPOLATE_SHIFT = 16;
    static final int INTERPOLATE_TO_PIXELS_SHIFT = 19;
    static final int SCREEN_PRESTEP = 7;
    static final int INTERPOLATE_PRESTEP = 524287;
    static final boolean CLAMP_TO_VIEWPORT = false;
    static final int PIXEL_GUARD_SIZE = 1;
    static final int MAX_PRIMITIVE_VERTS = 20;
    static final int OE_SHIFT = 4;
    static final int CULL_NONE = 0;
    static final int CULL_CW = 1;
    static final int CULL_CCW = 2;
    static int faceCull = 2;
    public static Span span;
    public static int renderMode;
    public static final int NEAR_CLIP = 256;
    public static final int CULL_EXTRA = 272;
    public static final int NUM_FOG_LEVELS = 16;
    static byte[] textureBase;
    static int[] imageBounds;
    static int[] spanPalette;
    static int[][] paletteBase;
    static int[][] scratchPalette;
    static int sWidth;
    static int sShift;
    static int sMask;
    static int tHeight;
    static int tShift;
    static int tMask;
    static boolean swapXY;
    static int screenWidth;
    static int screenHeight;
    static int[] pixels;
    static int[] columnScale;
    static final int COLUMN_SCALE_INIT = Integer.MAX_VALUE;
    static final int COLUMN_SCALE_OCCLUDED = 0x7FFFFFFE;
    static int[] view;
    static int[] view2D;
    static int[] projection;
    static int[] mvp;
    static int[] mvp2D;
    static TGLVert[] cv;
    static TGLVert[] clippingVert1;
    static TGLVert[] clippingVert2;
    static TGLVert[] mv;
    static TGLEdge[] edges;
    public static int fogMin;
    public static int fogRange;
    public static int fogColor;
    public static int viewportX;
    public static int viewportY;
    public static int viewportWidth;
    public static int viewportHeight;
    static int viewportClampX1;
    static int viewportClampY1;
    static int viewportClampX2;
    static int viewportClampY2;
    public static int viewportX2;
    public static int viewportY2;
    static int viewportXScale;
    static int viewportXBias;
    static int viewportYScale;
    static int viewportYBias;
    static int viewportZScale;
    static int viewportZBias;
    static int viewX;
    static int viewY;
    static int viewZ;
    static int c_backFacedPolys;
    static int c_frontFacedPolys;
    static int c_totalQuad;
    static int c_clippedQuad;
    static int c_unclippedQuad;
    static int c_rejectedQuad;

    static boolean startup(int n, int n2) {
        int n3;
        mvp = new int[16];
        mvp2D = new int[16];
        view = new int[16];
        view2D = new int[16];
        projection = new int[16];
        cv = new TGLVert[20];
        for (n3 = 0; n3 < cv.length; ++n3) {
            TinyGL.cv[n3] = new TGLVert();
        }
        for (n3 = 0; n3 < mv.length; ++n3) {
            TinyGL.mv[n3] = new TGLVert();
        }
        TinyGL.scratchPalette[0] = new int[256];
        for (n3 = 1; n3 < 16; ++n3) {
            TinyGL.scratchPalette[n3] = scratchPalette[0];
        }
        clippingVert1 = new TGLVert[6];
        clippingVert2 = new TGLVert[6];
        for (n3 = 0; n3 < clippingVert1.length; ++n3) {
            TinyGL.clippingVert1[n3] = new TGLVert();
            TinyGL.clippingVert2[n3] = new TGLVert();
        }
        screenWidth = n;
        screenHeight = n2;
        columnScale = new int[screenWidth];
        pixels = new int[screenWidth * screenHeight];
        TinyGL.resetViewPort();
        TinyGL.setView(0, 0, 0, 0, 0, 0, 312, 312);
        return true;
    }

    public static final int[] getFogPalette(int n) {
        n = (0x7FFFFF / (n >> 16) - fogMin << 4) / fogRange;
        n = (n & ~n >> 31) - 15;
        n = (n & n >> 31) + 15;
        return paletteBase[n];
    }

    static void clearColorBuffer(int n) {
        int n2;
        int[] nArray = pixels;
        n |= 0xFF000000;
        int n3 = viewportX + viewportY * screenWidth;
        for (n2 = 0; n2 < viewportWidth; ++n2) {
            nArray[n3 + n2] = n;
        }
        n2 = n3;
        for (int i = 1; i < viewportHeight; ++i) {
            System.arraycopy(nArray, n3, nArray, n2 += screenWidth, viewportWidth);
        }
    }

    static void buildViewMatrix(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        int n7 = Render.sinTable[n4 + 512 & 0x3FF] >> 2;
        int n8 = Render.sinTable[n4 + 256 & 0x3FF] >> 2;
        int n9 = Render.sinTable[n5 + 512 & 0x3FF] >> 2;
        int n10 = Render.sinTable[n5 + 256 & 0x3FF] >> 2;
        int n11 = Render.sinTable[n6 & 0x3FF] >> 2;
        int n12 = Render.sinTable[n6 + 256 & 0x3FF] >> 2;
        int n13 = n11 * n9 >> 14;
        int n14 = n12 * n9 >> 14;
        nArray[0] = n13 * n8 + n12 * -n7 >> 14;
        nArray[4] = n13 * n7 + n12 * n8 >> 14;
        nArray[8] = n11 * n10 >> 14;
        nArray[1] = -(n14 * n8 + -n11 * -n7) >> 14;
        nArray[5] = -(n14 * n7 + -n11 * n8) >> 14;
        nArray[9] = -(n12 * n10) >> 14;
        nArray[2] = -(n10 * n8) >> 14;
        nArray[6] = -(n10 * n7) >> 14;
        nArray[10] = -(-n9);
        for (int i = 0; i < 3; ++i) {
            nArray[12 + i] = -(n * nArray[0 + i] + n2 * nArray[4 + i] + n3 * nArray[8 + i]) >> 14;
        }
        nArray[3] = 0;
        nArray[7] = 0;
        nArray[11] = 0;
        nArray[15] = 16384;
    }

    static void buildProjectionMatrix(int n, int n2, int[] nArray) {
        int n3 = n2 >> 1;
        int n4 = (n << 14) / n2;
        int n5 = Render.sinTable[n3 & 0x3FF] >> 2;
        int n6 = Render.sinTable[n3 + 256 & 0x3FF] >> 2;
        nArray[0] = (n6 << 14) / (n4 * n5 >> 14);
        nArray[4] = 0;
        nArray[8] = 0;
        nArray[12] = 0;
        nArray[1] = 0;
        nArray[5] = (n6 << 14) / n5;
        nArray[9] = 0;
        nArray[13] = 0;
        nArray[2] = 0;
        nArray[6] = 0;
        nArray[10] = -16384;
        nArray[14] = -512;
        nArray[3] = 0;
        nArray[7] = 0;
        nArray[11] = -16384;
        nArray[15] = 0;
    }

    static void multMatrix(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                nArray3[i * 4 + j] = nArray[i * 4 + 0] * nArray2[0 + j] + nArray[i * 4 + 1] * nArray2[4 + j] + nArray[i * 4 + 2] * nArray2[8 + j] + nArray[i * 4 + 3] * nArray2[12 + j] >> 14;
            }
        }
    }

    private static void _setViewport(int n, int n2, int n3, int n4) {
        viewportX = n;
        viewportY = n2;
        viewportWidth = n3;
        viewportHeight = n4;
        viewportX2 = n + n3;
        viewportY2 = n2 + n4;
        viewportClampX1 = viewportX << 3;
        viewportClampY1 = viewportY << 3;
        viewportClampX2 = (viewportX2 << 3) + 8 - 1;
        viewportClampY2 = (viewportY2 << 3) + 8 - 1;
        viewportXScale = n3 << 2;
        viewportYScale = n4 << 2;
        viewportXBias = (n + n3 / 2 << 3) - 4;
        viewportYBias = (n2 + n4 / 2 << 3) - 4;
        viewportZScale = 32768;
        viewportZBias = 32768;
    }

    static void setViewport(int n, int n2, int n3, int n4) {
        if (viewportX == n && viewportY == n2 && viewportWidth == n3 && viewportHeight == n4) {
            return;
        }
        TinyGL._setViewport(0, 0, screenWidth, screenHeight);
        TinyGL.clearColorBuffer(0);
        TinyGL._setViewport(n + 1, n2 + 1, n3 - 2, n4 - 2);
        Canvas.repaintFlags &= 0xFFFFFFBF;
    }

    public static void resetViewPort() {
        TinyGL.setViewport(0, 0, screenWidth, screenHeight);
    }

    static void setView(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        viewX = n;
        viewY = n2;
        viewZ = n3;
        TinyGL.buildViewMatrix(n, n2, n3, n4 &= 0x3FF, n5 &= 0x3FF, n6, view);
        TinyGL.buildViewMatrix(n, n2, 0, n4, 0, 0, view2D);
        TinyGL.buildProjectionMatrix(n7, n8, projection);
        TinyGL.multMatrix(view, projection, mvp);
        if (n5 > 512) {
            n5 -= 1024;
        }
        TinyGL.buildProjectionMatrix(n7 + Math.abs(n5), n8, projection);
        TinyGL.multMatrix(view2D, projection, mvp2D);
    }

    static void viewMtxMove(TGLVert tGLVert, int n, int n2, int n3) {
        if (n != 0) {
            n = -n;
            tGLVert.x += view[2] * n >> 14;
            tGLVert.y += view[6] * n >> 14;
            tGLVert.z += view[10] * n >> 14;
        }
        if (n2 != 0) {
            tGLVert.x += view[0] * n2 >> 14;
            tGLVert.y += view[4] * n2 >> 14;
            tGLVert.z += view[8] * n2 >> 14;
        }
        if (n3 != 0) {
            n3 = -n3;
            tGLVert.x += view[1] * n3 >> 14;
            tGLVert.y += view[5] * n3 >> 14;
            tGLVert.z += view[9] * n3 >> 14;
        }
    }

    static void drawModelVerts(TGLVert[] tGLVertArray, int n) {
        TGLVert[] tGLVertArray2;
        if ((Render.renderMode & 1) == 0) {
            return;
        }
        if (faceCull != 0) {
            tGLVertArray2 = tGLVertArray[0];
            TGLVert tGLVert = tGLVertArray[1];
            TGLVert tGLVert2 = tGLVertArray[2];
            int n2 = tGLVert.x - tGLVertArray2.x;
            int n3 = tGLVert.y - tGLVertArray2.y;
            int n4 = tGLVert.z - tGLVertArray2.z;
            int n5 = tGLVert2.x - tGLVertArray2.x;
            int n6 = tGLVert2.y - tGLVertArray2.y;
            int n7 = tGLVert2.z - tGLVertArray2.z;
            int n8 = n3 * n7 - n4 * n6 >> 14;
            int n9 = n4 * n5 - n2 * n7 >> 14;
            int n10 = n2 * n6 - n3 * n5 >> 14;
            int n11 = (viewX - tGLVertArray2.x) * n8 + (viewY - tGLVertArray2.y) * n9 + (viewZ - tGLVertArray2.z) * n10;
            if (faceCull == 2 && n11 < 0 || faceCull == 1 && n11 > 0) {
                ++c_backFacedPolys;
                return;
            }
        }
        ++c_frontFacedPolys;
        tGLVertArray2 = TinyGL.transform3DVerts(tGLVertArray, n);
        if ((Render.renderMode & 2) == 0) {
            return;
        }
        if (n == 4) {
            TinyGL.ClipQuad(tGLVertArray2[0], tGLVertArray2[1], tGLVertArray2[2], tGLVertArray2[3]);
        } else {
            TinyGL.ClipPolygon(0, n);
        }
    }

    static TGLVert[] transform3DVerts(TGLVert[] tGLVertArray, int n) {
        int[] nArray = mvp;
        for (int i = 0; i < n; ++i) {
            TGLVert tGLVert = tGLVertArray[i];
            TGLVert tGLVert2 = cv[i];
            int n2 = tGLVert.x;
            int n3 = tGLVert.y;
            int n4 = tGLVert.z;
            tGLVert2.x = (n2 * nArray[0] + n3 * nArray[4] + n4 * nArray[8] >> 14) + nArray[12];
            tGLVert2.y = (n2 * nArray[1] + n3 * nArray[5] + n4 * nArray[9] >> 14) + nArray[13];
            tGLVert2.z = (n2 * nArray[2] + n3 * nArray[6] + n4 * nArray[10] >> 14) + nArray[14];
            tGLVert2.w = (n2 * nArray[3] + n3 * nArray[7] + n4 * nArray[11] >> 14) + nArray[15];
            tGLVert2.s = tGLVert.s;
            tGLVert2.t = tGLVert.t;
        }
        return cv;
    }

    static TGLVert[] transform2DVerts(TGLVert[] tGLVertArray, int n) {
        int[] nArray = mvp2D;
        for (int i = 0; i < n; ++i) {
            TGLVert tGLVert = tGLVertArray[i];
            TGLVert tGLVert2 = cv[i];
            int n2 = tGLVert.x;
            int n3 = tGLVert.y;
            tGLVert2.x = (n2 * nArray[0] + n3 * nArray[4] >> 14) + nArray[12];
            tGLVert2.z = (n2 * nArray[2] + n3 * nArray[6] >> 14) + nArray[14];
            tGLVert2.w = (n2 * nArray[3] + n3 * nArray[7] >> 14) + nArray[15];
            tGLVert2.s = tGLVert.s;
            tGLVert2.t = tGLVert.t;
        }
        return cv;
    }

    static void ClipQuad(TGLVert tGLVert, TGLVert tGLVert2, TGLVert tGLVert3, TGLVert tGLVert4) {
        ++c_totalQuad;
        for (int i = 0; i < 5; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            switch (i) {
                default: {
                    n4 = tGLVert.w + tGLVert.x;
                    n3 = tGLVert2.w + tGLVert2.x;
                    n2 = tGLVert3.w + tGLVert3.x;
                    n = tGLVert4.w + tGLVert4.x;
                    break;
                }
                case 1: {
                    n4 = tGLVert.w - tGLVert.x;
                    n3 = tGLVert2.w - tGLVert2.x;
                    n2 = tGLVert3.w - tGLVert3.x;
                    n = tGLVert4.w - tGLVert4.x;
                    break;
                }
                case 2: {
                    n4 = tGLVert.w + tGLVert.y;
                    n3 = tGLVert2.w + tGLVert2.y;
                    n2 = tGLVert3.w + tGLVert3.y;
                    n = tGLVert4.w + tGLVert4.y;
                    break;
                }
                case 3: {
                    n4 = tGLVert.w - tGLVert.y;
                    n3 = tGLVert2.w - tGLVert2.y;
                    n2 = tGLVert3.w - tGLVert3.y;
                    n = tGLVert4.w - tGLVert4.y;
                    break;
                }
                case 4: {
                    n4 = tGLVert.w + tGLVert.z;
                    n3 = tGLVert2.w + tGLVert2.z;
                    n2 = tGLVert3.w + tGLVert3.z;
                    n = tGLVert4.w + tGLVert4.z;
                    break;
                }
                case 5: {
                    n4 = tGLVert.w - tGLVert.z;
                    n3 = tGLVert2.w - tGLVert2.z;
                    n2 = tGLVert3.w - tGLVert3.z;
                    n = tGLVert4.w - tGLVert4.z;
                }
            }
            int n5 = (n4 < 0 ? 1 : 0) | (n3 < 0 ? 2 : 0) | (n2 < 0 ? 4 : 0) | (n < 0 ? 8 : 0);
            if (n5 == 0) continue;
            if (n5 == 15) {
                ++c_rejectedQuad;
                return;
            }
            ++c_clippedQuad;
            TinyGL.ClipPolygon(i, 4);
            return;
        }
        ++c_unclippedQuad;
        TinyGL.RasterizeConvexPolygon(4);
    }

    static void ClipPolygon(int n, int n2) {
        while (n < 5) {
            int n3;
            switch (n) {
                default: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w + TinyGL.cv[n3].x;
                    }
                    break;
                }
                case 1: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w - TinyGL.cv[n3].x;
                    }
                    break;
                }
                case 2: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w + TinyGL.cv[n3].y;
                    }
                    break;
                }
                case 3: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w - TinyGL.cv[n3].y;
                    }
                    break;
                }
                case 4: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w + TinyGL.cv[n3].z;
                    }
                    break;
                }
                case 5: {
                    for (n3 = 0; n3 < n2; ++n3) {
                        TinyGL.cv[n3].clipDist = TinyGL.cv[n3].w - TinyGL.cv[n3].z;
                    }
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                TGLVert tGLVert;
                TGLVert tGLVert2;
                TGLVert tGLVert3;
                int n4 = n3 + 1;
                if (n4 == n2) {
                    n4 = 0;
                }
                if (TinyGL.cv[n3].clipDist < 0 == TinyGL.cv[n4].clipDist < 0) continue;
                int n5 = n2 - 1 - n3;
                if (n5 > 0) {
                    tGLVert3 = cv[n2];
                    System.arraycopy(cv, n3 + 1, cv, n3 + 2, n5);
                    TinyGL.cv[n3 + 1] = tGLVert3;
                    ++n4;
                }
                tGLVert3 = cv[n3 + 1];
                tGLVert3.clipDist = 0;
                if (TinyGL.cv[n3].clipDist < 0) {
                    tGLVert2 = cv[n4];
                    tGLVert = cv[n3];
                } else {
                    tGLVert2 = cv[n3];
                    tGLVert = cv[n4];
                }
                int n6 = (tGLVert2.clipDist << 16) / (tGLVert2.clipDist - tGLVert.clipDist);
                tGLVert3.x = tGLVert2.x + ((tGLVert.x - tGLVert2.x) * n6 >> 16);
                tGLVert3.y = tGLVert2.y + ((tGLVert.y - tGLVert2.y) * n6 >> 16);
                tGLVert3.z = tGLVert2.z + ((tGLVert.z - tGLVert2.z) * n6 >> 16);
                tGLVert3.w = tGLVert2.w + ((tGLVert.w - tGLVert2.w) * n6 >> 16);
                tGLVert3.s = tGLVert2.s + ((tGLVert.s - tGLVert2.s) * n6 >> 16);
                tGLVert3.t = tGLVert2.t + ((tGLVert.t - tGLVert2.t) * n6 >> 16);
                ++n2;
                ++n3;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                TGLVert tGLVert = cv[n3];
                if (tGLVert.clipDist >= 0) continue;
                System.arraycopy(cv, n3 + 1, cv, n3, n2 - 1 - n3);
                --n3;
                TinyGL.cv[--n2] = tGLVert;
            }
            if (n2 < 3) {
                return;
            }
            ++n;
        }
        TinyGL.RasterizeConvexPolygon(n2);
    }

    static boolean clipLine(TGLVert[] tGLVertArray) {
        TGLVert tGLVert = tGLVertArray[0];
        TGLVert tGLVert2 = tGLVertArray[1];
        block8: for (int i = 0; i < 3; ++i) {
            int n;
            int n2;
            switch (i) {
                default: {
                    n2 = tGLVert.w + tGLVert.x;
                    n = tGLVert2.w + tGLVert2.x;
                    break;
                }
                case 1: {
                    n2 = tGLVert.w - tGLVert.x;
                    n = tGLVert2.w - tGLVert2.x;
                    break;
                }
                case 2: {
                    n2 = tGLVert.w + tGLVert.z;
                    n = tGLVert2.w + tGLVert2.z;
                }
            }
            int n3 = (n2 < 0 ? 1 : 0) | (n < 0 ? 2 : 0);
            if (n3 == 0) continue;
            if (n3 == 3) {
                return false;
            }
            switch (n3) {
                case 1: {
                    int n4 = (n << 14) / (n - n2);
                    tGLVert.x = tGLVert2.x + ((tGLVert.x - tGLVert2.x) * n4 >> 14);
                    tGLVert.y = tGLVert2.y + ((tGLVert.y - tGLVert2.y) * n4 >> 14);
                    tGLVert.z = tGLVert2.z + ((tGLVert.z - tGLVert2.z) * n4 >> 14);
                    tGLVert.w = tGLVert2.w + ((tGLVert.w - tGLVert2.w) * n4 >> 14);
                    tGLVert.s = tGLVert2.s + ((tGLVert.s - tGLVert2.s) * n4 >> 14);
                    tGLVert.t = tGLVert2.t + ((tGLVert.t - tGLVert2.t) * n4 >> 14);
                    continue block8;
                }
                case 2: {
                    int n4 = (n2 << 14) / (n2 - n);
                    tGLVert2.x = tGLVert.x + ((tGLVert2.x - tGLVert.x) * n4 >> 14);
                    tGLVert2.y = tGLVert.y + ((tGLVert2.y - tGLVert.y) * n4 >> 14);
                    tGLVert2.z = tGLVert.z + ((tGLVert2.z - tGLVert.z) * n4 >> 14);
                    tGLVert2.w = tGLVert.w + ((tGLVert2.w - tGLVert.w) * n4 >> 14);
                    tGLVert2.s = tGLVert.s + ((tGLVert2.s - tGLVert.s) * n4 >> 14);
                    tGLVert2.t = tGLVert.t + ((tGLVert2.t - tGLVert.t) * n4 >> 14);
                }
            }
        }
        return true;
    }

    static void projectVerts(TGLVert[] tGLVertArray, int n) {
        for (int i = 0; i < n; ++i) {
            TGLVert tGLVert = tGLVertArray[i];
            tGLVert.x = viewportXBias + tGLVert.x * viewportXScale / tGLVert.w;
            tGLVert.y = viewportYBias + tGLVert.y * viewportYScale / tGLVert.w;
            tGLVert.z = 0x7FFFFF / tGLVert.w;
            tGLVert.s *= tGLVert.z;
            tGLVert.t *= tGLVert.z;
        }
    }

    static void RasterizeConvexPolygon(int n) {
        int n2;
        int n3;
        if ((Render.renderMode & 4) == 0) {
            return;
        }
        for (n3 = 0; n3 < n; ++n3) {
            TGLVert tGLVert = cv[n3];
            tGLVert.x = viewportXBias + tGLVert.x * viewportXScale / tGLVert.w;
            tGLVert.y = viewportYBias + tGLVert.y * viewportYScale / tGLVert.w;
            if (Render.isSkyMap) {
                swapXY = false;
                tGLVert.s = Render.skyMapX + (tGLVert.x * 170 >> 8);
                tGLVert.t = Render.skyMapY + (tGLVert.y * 170 >> 8);
                tGLVert.w = 1024;
            }
            tGLVert.z = 0x7FFFFF / tGLVert.w;
            tGLVert.s *= tGLVert.z;
            tGLVert.t *= tGLVert.z;
        }
        ++Span.countDrawn;
        if ((Render.renderMode & 8) == 0) {
            return;
        }
        if (swapXY) {
            for (n3 = 0; n3 < n; ++n3) {
                int n4 = TinyGL.cv[n3].x;
                TinyGL.cv[n3].x = TinyGL.cv[n3].y;
                TinyGL.cv[n3].y = n4;
            }
        }
        n3 = TinyGL.cv[0].y;
        int n5 = 0;
        for (n2 = 1; n2 < n; ++n2) {
            if (TinyGL.cv[n2].y >= n3) continue;
            n3 = TinyGL.cv[n2].y;
            n5 = n2;
        }
        n2 = n5;
        TGLVert tGLVert = cv[n5];
        TGLVert tGLVert2 = cv[n2];
        int n6 = n3 + 7 >> 3;
        TGLEdge tGLEdge = edges[0];
        TGLEdge tGLEdge2 = edges[1];
        tGLEdge.stopY = tGLEdge2.stopY = n6;
        int n7 = swapXY ? screenWidth : 1;
        int n8 = n5;
        block3: while (true) {
            int n9;
            TGLVert tGLVert3;
            if (n6 == tGLEdge.stopY) {
                if (n5 == n2 && n5 != n8) break;
                n5 = n5 == 0 ? n - 1 : --n5;
                tGLVert3 = tGLVert;
                tGLVert = cv[n5];
                tGLEdge.setFromVerts(tGLVert3, tGLVert);
            }
            if (n6 == tGLEdge2.stopY) {
                if (n5 == n2) break;
                if (++n2 == n) {
                    n2 = 0;
                }
                tGLVert3 = tGLVert2;
                tGLVert2 = cv[n2];
                tGLEdge2.setFromVerts(tGLVert3, tGLVert2);
            }
            int n10 = n9 = tGLEdge.stopY < tGLEdge2.stopY ? tGLEdge.stopY : tGLEdge2.stopY;
            if (n6 > n9) {
                return;
            }
            while (true) {
                TGLEdge tGLEdge3;
                TGLEdge tGLEdge4;
                if (n6 == n9) continue block3;
                if (tGLEdge2.fracX < tGLEdge.fracX) {
                    tGLEdge4 = tGLEdge2;
                    tGLEdge3 = tGLEdge;
                } else {
                    tGLEdge4 = tGLEdge;
                    tGLEdge3 = tGLEdge2;
                }
                int n11 = tGLEdge4.fracX + 524287 >> 19;
                int n12 = tGLEdge3.fracX + 524287 >> 19;
                if (n12 > n11) {
                    int n13 = swapXY ? n11 * screenWidth + n6 : n6 * screenWidth + n11;
                    int n14 = tGLEdge3.fracX - tGLEdge4.fracX >> 16;
                    int n15 = tGLEdge4.fracZ >> 16;
                    int n16 = tGLEdge4.fracS / n15 << 16;
                    int n17 = tGLEdge4.fracT / n15 << 16;
                    int n18 = tGLEdge3.fracZ >> 16;
                    int n19 = tGLEdge3.fracS / n18 << 16;
                    int n20 = tGLEdge3.fracT / n18 << 16;
                    if (n14 == 0) {
                        spanPalette = TinyGL.getFogPalette(Render.isSkyMap ? 0x10000000 : tGLEdge3.fracZ);
                        span.span(n13, n19, n20, tGLEdge3.fracZ, n7, 0, 0, 0, n12 - n11);
                    } else {
                        int n21 = (n11 << 3) - (tGLEdge4.fracX >> 16);
                        int n22 = (tGLEdge3.fracZ - tGLEdge4.fracZ) / n14;
                        int n23 = (n19 - n16) / n14;
                        int n24 = (n20 - n17) / n14;
                        spanPalette = TinyGL.getFogPalette(Render.isSkyMap ? 0x10000000 : tGLEdge4.fracZ);
                        span.span(n13, n16 + n23 * n21, n17 + n24 * n21, tGLEdge4.fracZ + n22 * n21, n7, n23 << 3, n24 << 3, n22 << 3, n12 - n11);
                    }
                }
                tGLEdge2.fracX += tGLEdge2.stepX;
                tGLEdge2.fracZ += tGLEdge2.stepZ;
                tGLEdge2.fracS += tGLEdge2.stepS;
                tGLEdge2.fracT += tGLEdge2.stepT;
                tGLEdge.fracX += tGLEdge.stepX;
                tGLEdge.fracZ += tGLEdge.stepZ;
                tGLEdge.fracS += tGLEdge.stepS;
                tGLEdge.fracT += tGLEdge.stepT;
                ++n6;
            }
            break;
        }
    }

    static boolean clippedLineVisCheck(TGLVert tGLVert, TGLVert tGLVert2, boolean bl) {
        int n = tGLVert.x + 7 >> 3;
        int n2 = tGLVert2.x + 7 >> 3;
        int[] nArray = columnScale;
        if (n < 0) {
            n = 0;
        }
        if (n2 > nArray.length) {
            n2 = nArray.length;
        }
        if (n2 <= n) {
            return false;
        }
        if (bl) {
            int n3 = tGLVert.z;
            int n4 = (tGLVert2.z - tGLVert.z) / (n2 - n);
            int n5 = (n << 3) - tGLVert.x;
            n3 += n4 * n5 >> 3;
            while (n < n2) {
                int n6 = 0x7FFFFF / n3;
                if (n6 < nArray[n]) {
                    return true;
                }
                ++n;
                n3 += n4;
            }
            return false;
        }
        while (n < n2) {
            if (nArray[n] == Integer.MAX_VALUE) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static boolean occludeClippedLine(TGLVert tGLVert, TGLVert tGLVert2) {
        int n = tGLVert.x + 7 >> 3;
        int n2 = tGLVert2.x + 7 >> 3;
        int[] nArray = columnScale;
        if (n < 0) {
            n = 0;
        }
        if (n2 > nArray.length) {
            n2 = nArray.length;
        }
        if (n2 <= n) {
            return false;
        }
        int n3 = tGLVert.z;
        int n4 = (tGLVert2.z - tGLVert.z) / (n2 - n);
        int n5 = (n << 3) - tGLVert.x;
        n3 += n4 * n5 >> 3;
        boolean bl = false;
        while (n < n2) {
            int n6 = 0x7FFFFF / n3;
            if (n6 < nArray[n]) {
                nArray[n] = n6;
                bl = true;
            }
            ++n;
            n3 += n4;
        }
        return bl;
    }

    static void drawClippedSpriteLine(TGLVert tGLVert, TGLVert tGLVert2, TGLVert tGLVert3, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = (tGLVert.y - tGLVert3.y << 12) / 64 >> 3;
        int n5 = tGLVert3.y >> 3;
        int n6 = 0x1000000 / n4;
        if (0 != (n & 0x40000)) {
            n6 = -n6;
        }
        byte[] byArray = textureBase;
        int n7 = (byArray[byArray.length - 1] & 0xFF) << 8 | byArray[byArray.length - 2] & 0xFF;
        int n8 = byArray.length - n7 - 2;
        int n9 = imageBounds[0];
        int n10 = imageBounds[1];
        int n11 = n8 + (n10 - n9 + 1 >> 1);
        n2 = 0;
        int n12 = tGLVert.x + 7 >> 3;
        int n13 = tGLVert2.x + 7 >> 3;
        if (n12 < viewportX) {
            n12 = viewportX;
        }
        if (n13 > viewportX2) {
            n13 = viewportX2;
        }
        if (n13 - n12 <= 0) {
            return;
        }
        int n14 = (tGLVert2.s - tGLVert.s) / (n13 - n12);
        int n15 = tGLVert.s;
        while (n12 < n13) {
            int n16 = n15 / tGLVert.z * 64 / 64 >> 4;
            if (0 != (n & 0x20000)) {
                n16 = 63 - n16;
            }
            if (n16 >= n9 && n16 < n10) {
                int n17;
                n16 -= n9;
                while (n3 < n16) {
                    n17 = byArray[n8 + (n3 >> 1)] >> ((n3 & 1) << 2) & 0xF;
                    while (n17-- > 0) {
                        n2 += byArray[n11 + 1];
                        n11 += 2;
                    }
                    ++n3;
                }
                while (n3 > n16) {
                    n17 = byArray[n8 + (--n3 >> 1)] >> ((n3 & 1) << 2) & 0xF;
                    while (n17-- > 0) {
                        n2 -= byArray[n11 - 1];
                        n11 -= 2;
                    }
                }
                n17 = byArray[n8 + (n3 >> 1)] >> ((n3 & 1) << 2) & 0xF;
                while (n17-- > 0) {
                    int n18 = byArray[n11++];
                    int n19 = byArray[n11++];
                    int n20 = n2 << 12;
                    n2 += n19;
                    if (0 != (n & 0x40000)) {
                        n18 = 64 - (n18 + n19);
                        n20 += (n19 << 12) - 1;
                    }
                    n18 = n5 + (n18 * n4 >> 12);
                    n19 = n4 * n19 >> 12;
                    if (n18 < viewportY) {
                        int n21 = viewportY - n18;
                        n19 -= n21;
                        n20 += n21 * n6;
                        n18 = viewportY;
                    }
                    if (n18 + n19 > viewportY2) {
                        n19 = viewportY2 - n18;
                    }
                    if (n19 <= 0) continue;
                    span.span(n12 + n18 * screenWidth, n20, screenWidth, n6, n19);
                }
                ++n3;
            }
            n15 += n14;
            ++n12;
        }
    }

    static {
        imageBounds = new int[4];
        scratchPalette = new int[16][];
        sWidth = 64;
        sShift = 20;
        sMask = 63;
        tHeight = 64;
        tShift = 14;
        tMask = 4032;
        mv = new TGLVert[18];
        edges = new TGLEdge[]{new TGLEdge(), new TGLEdge()};
        fogMin = 32752;
        fogRange = 1;
        fogColor = 0;
    }
}

