/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Player {
    public static int touchMe = 1;
    private static final int EXPIRE_DURATION = 5;
    private static final int MAX_DISPLAY_BUFFS = 6;
    public static final int ICE_FOG_DIST = 1024;
    public static final int MAX_NOTEBOOK_INDEXES = 8;
    public static Entity facingEntity;
    public static final short[] inventory;
    public static final short[] ammo;
    public static long weapons;
    public static final short[] inventoryCopy;
    public static final short[] ammoCopy;
    public static int weaponsCopy;
    public static long disabledWeapons;
    public static int level;
    public static int currentXP;
    public static int nextLevelXP;
    public static int gold;
    public static CombatEntity baseCe;
    public static CombatEntity ce;
    public static EntityDef activeWeaponDef;
    public static boolean noclip;
    public static boolean god;
    public static int playTime;
    public static int totalTime;
    public static int moves;
    public static int totalMoves;
    public static int completedLevels;
    public static int killedMonstersLevels;
    public static int foundSecretsLevels;
    public static int xpGained;
    public static int totalDeaths;
    public static final short[] notebookIndexes;
    public static final short[] notebookPositions;
    public static byte questComplete;
    public static byte questFailed;
    public static int numNotebookIndexes;
    public static int helpBitmask;
    public static int invHelpBitmask;
    public static int ammoHelpBitmask;
    public static int weaponHelpBitmask;
    public static int armorHelpBitmask;
    public static int cocktailDiscoverMask;
    public static int gamePlayedMask;
    public static int lastCombatTurn;
    public static boolean inCombat;
    public static boolean enableHelp;
    private static int turnTime;
    public static int highestMap;
    public static int prevWeapon;
    public static boolean noDeathFlag;
    private static int numStatusEffects;
    public static final int[] statusEffects;
    public static final int BUFF_TURNS = 0;
    public static final int BUFF_AMOUNT = 15;
    public static short[] buffs;
    public static int numbuffs;
    public static int purchasedWeapons;
    public static boolean gameCompleted;
    public static GameSprite playerSprite;
    public static int pickingStats;
    public static int oldPickingStats;
    public static byte[] allMedals;
    public static int[] medals;
    public static final int MEDAL_INFO_FIELDS = 2;
    public static final int MEDAL_DATA;
    public static byte[] medalInfo;
    public static final int NUM_BOOK_FIELDS = 4;
    public static byte[] bookMap;
    public static byte[] foundBooks;
    public static boolean showBookStat;
    public static int bookIndex;
    public static int[] counters;
    public static final int[] monsterStats;
    public static final int DEF_STATUS_TURNS = 30;
    public static final int ANTI_FIRE_TURNS = 10;
    public static final int AGILITY_TURNS = 20;
    public static final int PURIFY_TURNS = 10;
    public static final int FEAR_TURNS = 6;
    public static final int COLD_TURNS = 5;
    private static final int BOX_X1 = 17;
    private static final int BOX_X2 = 27;
    private static final int BOX_X3 = 35;
    private static final int BOX_X4 = 43;
    static final int[] pos;
    private static final int MEDAL_FIELDS = 3;

    Player() {
    }

    public static final boolean startup() {
        bookMap = App.TBL_BOOKS;
        allMedals = App.TBL_MEDALS;
        noclip = false;
        god = false;
        helpBitmask = 0;
        invHelpBitmask = 0;
        weaponHelpBitmask = 0;
        armorHelpBitmask = 0;
        enableHelp = true;
        totalDeaths = 0;
        Player.reset();
        return true;
    }

    public static boolean modifyCollision(Entity entity) {
        int n;
        return null != entity && entity.def.eType == 12 && (n = Render.mapSpriteInfo[(entity.info & 0xFFFF) - 1] & 0xFF) == 131;
    }

    public static final void advanceTurn() {
        Text text;
        ++moves;
        ++totalMoves;
        if (Game.isUnderWater()) {
            if (statusEffects[48] == 0) {
                Player.addStatusEffect(12, 1, 11);
                Player.statusEffects[48] = 1;
            }
            Player.removeStatusEffect(13);
        } else {
            Player.removeStatusEffect(12);
        }
        Entity entity = Game.findMapEntity(Canvas.viewX, Canvas.viewY, 16384);
        if (entity != null && entity.def.tileIndex == 203) {
            Player.addStatusEffect(12, 1, 11);
            Player.statusEffects[48] = 1;
            Sound.playSound(1);
            Hud.addMessage((short)1, (short)124, 7);
        }
        Player.updateStatusEffects();
        boolean bl = false;
        if (buffs[12] == 0 && Game.isUnderWater()) {
            Player.painEvent(null, true);
            Player.pain(10, null, true);
            Combat.totalDamage = 10;
            Hud.damageTime = App.time + 500;
            Hud.addMessage((short)1, (short)123, 3);
            bl = true;
        }
        if (buffs[3] > 0) {
            Player.addHealth(buffs[18], false);
        }
        if (statusEffects[53] > 0) {
            Player.addHealth(-statusEffects[35]);
            bl = true;
        }
        if (statusEffects[14] > 0) {
            Player.addHealth(buffs[29]);
            text = Hud.getMessageBuffer(0);
            Text.resetTextArgs();
            Text.addTextArg(-buffs[29]);
            Text.composeText((short)1, (short)107, text);
            Hud.finishMessageBuffer();
            bl = true;
            if (Canvas.state == 3) {
                Game.gsprite_allocAnim(251, 0, 0, 32);
                Canvas.blockInputTime = App.gameTime + 500;
            }
        }
        if (statusEffects[13] > 0) {
            Player.addHealth(-3);
            text = Hud.getMessageBuffer(0);
            Text.composeText((short)1, (short)84, text);
            text.append(' ');
            Text.resetTextArgs();
            Text.addTextArg(3);
            Text.composeText((short)1, (short)73, text);
            Hud.finishMessageBuffer();
            bl = true;
        }
        if ((weapons & 0x4000L) != 0L) {
            Player.give(2, 8, 17, true);
        }
        if (inCombat && totalMoves - lastCombatTurn >= 4) {
            inCombat = false;
        }
        if (statusEffects[15] > 0) {
            counters[3] = counters[3] + 1;
        }
        turnTime = App.time;
        if (bl && Canvas.state == 6) {
            Canvas.setState(3);
        }
    }

    public static final void levelInit() {
        moves = 0;
        numNotebookIndexes = 0;
        questComplete = 0;
        questFailed = 0;
        turnTime = App.time;
        inCombat = false;
        if (ce.getStat(0) == 0) {
            ce.setStat(0, 1);
        }
    }

    public static final void fillMonsterStats() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < Game.numEntities; ++i) {
            Entity entity = Game.entities[i];
            if (null == entity.monster || (entity.monster.flags & 0x80) != 0) continue;
            ++n;
            if ((Game.entities[i].info & 0x1010000) == 0) continue;
            ++n2;
        }
        Player.monsterStats[0] = n2;
        Player.monsterStats[1] = n;
    }

    public static final void readyWeapon() {
        Canvas.readyWeaponSound = 2;
    }

    public static final void selectWeapon(int n) {
        long l = weapons & (disabledWeapons ^ 0xFFFFFFFFFFFFFFFFL);
        if ((l & 1L << n) == 0L) {
            Player.ce.weapon = n;
            Player.selectNextWeapon();
        }
        if (Player.ce.weapon != n) {
            Canvas.invalidateRect();
            prevWeapon = Player.ce.weapon;
        }
        Player.ce.weapon = n;
        if (Canvas.state != 8 && Canvas.state != 18) {
            Canvas.drawPlayingSoftKeys();
        }
        if (n != prevWeapon) {
            Player.readyWeapon();
        }
        activeWeaponDef = EntityDef.find(6, 1, n);
        Canvas.updateFacingEntity = true;
        Hud.repaintFlags |= 4;
    }

    public static final void selectPrevWeapon() {
        int n;
        int n2;
        if (Canvas.isChickenKicking) {
            return;
        }
        int n3 = Player.ce.weapon;
        long l = weapons & (disabledWeapons ^ 0xFFFFFFFFFFFFFFFFL);
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if ((l & (long)(1 << (int)((long)n2))) == 0L || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0) continue;
            Player.selectWeapon(n2);
            return;
        }
        if (Player.ce.weapon == n3 && n3 != 16) {
            for (n2 = 16; n2 > n3; --n2) {
                if ((l & (long)(1 << (int)((long)n2))) == 0L || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0) continue;
                Player.selectWeapon(n2);
                return;
            }
        }
    }

    public static final void selectNextWeapon() {
        int n;
        int n2;
        if (Canvas.isChickenKicking) {
            return;
        }
        int n3 = Player.ce.weapon;
        long l = weapons & (disabledWeapons ^ 0xFFFFFFFFFFFFFFFFL);
        for (n2 = n3 + 1; n2 < 17; ++n2) {
            if ((l & (long)(1 << (int)((long)n2))) == 0L || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0) continue;
            Player.selectWeapon(n2);
            return;
        }
        if (Player.ce.weapon == n3 && n3 != 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if ((l & (long)(1 << (int)((long)n2))) == 0L || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0) continue;
                Player.selectWeapon(n2);
                return;
            }
        }
    }

    public static final void modifyStat(int n, int n2) {
        if (n == 0) {
            Player.addHealth(n2);
            if (n2 < 0) {
                Player.painEvent(null, false);
            }
        } else {
            baseCe.addStat(n, n2);
            Player.updateStats();
        }
    }

    public static final boolean requireStat(int n, int n2) {
        return ce.getStat(n) >= n2;
    }

    public static final boolean requireItem(int n, int n2, int n3, int n4) {
        int n5 = 1 << n2;
        if (n == 1) {
            if (n4 != 0) {
                return (weapons & (long)n5) != 0L;
            }
            return (weapons & (long)n5) == 0L;
        }
        if (n == 0) {
            return inventory[n2 - 0] >= n3 && inventory[n2 - 0] <= n4;
        }
        return false;
    }

    public static final void addXP(int n) {
        Text.resetTextArgs();
        Text.addTextArg(n);
        if (n < 0) {
            Hud.addMessage((short)108);
        } else {
            Hud.addMessage((short)109);
        }
        currentXP += n;
        xpGained += n;
        while (currentXP >= nextLevelXP) {
            Player.addLevel();
        }
        counters[5] = counters[5] + n;
    }

    public static final void addLevel() {
        nextLevelXP = Player.calcLevelXP(++level);
        Text text = Text.getLargeBuffer();
        text.setLength(0);
        Text.resetTextArgs();
        Text.addTextArg(level);
        Text.composeText((short)1, (short)110, text);
        int n = 10;
        int n2 = baseCe.getStat(1);
        if (n2 + n > 999) {
            n = 999 - n2;
        }
        if (n != 0) {
            baseCe.setStat(1, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)111, text);
        }
        n = 1;
        n2 = baseCe.getStat(3);
        if (n2 + n > 99) {
            n = 99 - n2;
        }
        if (n != 0) {
            baseCe.setStat(3, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)112, text);
        }
        n = 2;
        n2 = baseCe.getStat(4);
        if (n2 + n > 99) {
            n = 99 - n2;
        }
        if (n != 0) {
            baseCe.setStat(4, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)113, text);
        }
        n = 1;
        n2 = baseCe.getStat(5);
        if (n2 + n > 99) {
            n = 99 - n2;
        }
        if (n != 0) {
            baseCe.setStat(5, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)114, text);
        }
        n = 3;
        n2 = baseCe.getStat(6);
        if (n2 + n > 99) {
            n = 99 - n2;
        }
        if (n != 0) {
            baseCe.setStat(6, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)115, text);
        }
        Player.updateStats();
        Text.composeText((short)1, (short)116, text);
        ce.setStat(0, ce.getStat(1));
        Hud.repaintFlags |= 4;
        boolean bl = true;
        if (Canvas.state != 1) {
            Sound.playSound(5);
            boolean bl2 = bl = !Canvas.enqueueHelpDialog(text, 0);
        }
        if (bl) {
            text.dispose();
        }
    }

    public static final int calcLevelXP(int n) {
        return 500 * n + 100 * ((n - 1) * (n - 1) * (n - 1) + (n - 1));
    }

    public static final int calcScore() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        for (n2 = 0; n2 <= 8; ++n2) {
            if ((killedMonstersLevels & 1 << n2) != 0) {
                n += 1000;
                continue;
            }
            bl = false;
        }
        if (bl) {
            n += 1000;
        }
        n = totalDeaths == 0 ? (n += 1000) : (totalDeaths < 10 ? (n += (5 - totalDeaths) * 50) : (n -= 250));
        int n3 = (totalTime + (App.gameTime - playTime)) / 60000;
        if (n3 < 120) {
            n += (120 - n3) * 15;
        }
        if (totalMoves < 5000) {
            n += (5000 - totalMoves) / 2;
        }
        boolean bl2 = true;
        while (n2 <= 8) {
            if ((foundSecretsLevels & 1 << n2) != 0) {
                n += 1000;
            } else {
                bl2 = false;
            }
            ++n2;
        }
        if (bl2) {
            n += 1000;
        }
        for (n2 = 0; n2 < medals.length; ++n2) {
            int n4 = medals[n2];
            for (int i = 0; i < 32; ++i) {
                if ((n4 & 1 << i) != 1) continue;
                n += 100;
            }
        }
        return n;
    }

    public static final boolean addHealth(int n) {
        return Player.addHealth(n, true);
    }

    public static final boolean addHealth(int n, boolean bl) {
        Hud.repaintFlags |= 4;
        int n2 = ce.getStat(0);
        int n3 = ce.getStat(1);
        if (n > 0 ? n2 == n3 : god) {
            return false;
        }
        Hud.playerStartHealth = n2;
        ce.addStat(0, n);
        n3 = ce.getStat(0);
        if (bl && n3 > n2) {
            Text.resetTextArgs();
            Text.addTextArg(n3 - n2);
            Hud.addMessage((short)117);
        }
        return true;
    }

    public static final void reset() {
        Hud.msgCount = 0;
        numNotebookIndexes = 0;
        Player.resetCounters();
        level = 1;
        currentXP = 0;
        nextLevelXP = Player.calcLevelXP(level);
        facingEntity = null;
        noclip = false;
        questComplete = 0;
        questFailed = 0;
        purchasedWeapons = 0;
        pickingStats = 0;
        gold = 0;
        Player.give(3, 0, 2, true);
        playerSprite = null;
        Canvas.prevX = 0;
        Canvas.saveX = 0;
        Canvas.destX = 0;
        Canvas.viewX = 0;
        Canvas.prevY = 0;
        Canvas.saveY = 0;
        Canvas.destY = 0;
        Canvas.viewY = 0;
        Canvas.destZ = 36;
        Canvas.viewZ = 36;
        Canvas.saveAngle = 0;
        Canvas.destAngle = 0;
        Canvas.viewAngle = 0;
        Canvas.destPitch = 0;
        Canvas.viewPitch = 0;
        int n = 0;
        inCombat = false;
        for (n = 0; n < 10; ++n) {
            Player.ammo[n] = 0;
        }
        for (n = 0; n < 29; ++n) {
            Player.inventory[n] = 0;
        }
        numbuffs = 0;
        for (n = 0; n < 15; ++n) {
            Player.buffs[0 + n] = 0;
            Player.buffs[15 + n] = 0;
        }
        numStatusEffects = 0;
        for (n = 0; n < 18; ++n) {
            Player.statusEffects[0 + n] = 0;
            Player.statusEffects[36 + n] = 0;
            Player.statusEffects[18 + n] = 0;
        }
        for (n = 0; n < 2; ++n) {
            Player.medals[n] = 0;
        }
        for (n = 0; n < 4; ++n) {
            Player.foundBooks[n] = 0;
        }
        weapons = 9L;
        foundSecretsLevels = 0;
        killedMonstersLevels = 0;
        baseCe.setStat(1, 100);
        baseCe.setStat(3, 10);
        baseCe.setStat(4, 10);
        baseCe.setStat(5, 95);
        baseCe.setStat(6, 8);
        if (Game.difficulty == 2) {
            baseCe.setStat(3, 0);
        }
        Player.updateStats();
        ce.setStat(0, 100);
        Player.ce.weapon = 0;
        totalTime = 0;
        totalMoves = 0;
        completedLevels = 0;
        highestMap = 1;
        gameCompleted = false;
        cocktailDiscoverMask = 0;
        gamePlayedMask = 0;
    }

    public static final int calcDamageDir(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n;
        int n7 = n5 - n2;
        n3 &= 0x3FF;
        if (n6 == 0 && n7 == 0) {
            return 3;
        }
        int n8 = n6 > 0 ? (n7 < 0 ? 128 : (n7 > 0 ? 896 : 0)) : (n6 < 0 ? (n7 < 0 ? 384 : (n7 > 0 ? 640 : 512)) : (n7 > 0 ? 768 : 256));
        n8 = n8 - n3 & 0x3FF;
        if (n8 > 512) {
            n8 = -(1024 - n8);
        }
        if ((n8 = 3 + n8 / 128) < 0) {
            n8 = 7;
        }
        return n8;
    }

    public static final void painEvent(Entity entity, boolean bl) {
        if (god) {
            return;
        }
        if (entity == null) {
            Hud.damageDir = 3;
        }
        Hud.damageCount = 1;
        if (!bl) {
            Canvas.startShake(500, 2, 150);
        }
    }

    public static final void pain(int n, Entity entity, boolean bl) {
        if (god) {
            return;
        }
        if (bl) {
            Text.resetTextArgs();
            if (entity != null) {
                Text text = Text.getSmallBuffer();
                Text.composeText((short)2, (short)(entity.def.name & 0x3FF), text);
                Text.addTextArg(text);
                Text.addTextArg(n);
                Hud.addMessage((short)1, (short)118);
                text.dispose();
            } else {
                Text.addTextArg(n);
                Hud.addMessage((short)1, (short)73);
            }
        }
        if (n == 0) {
            return;
        }
        int n2 = ce.getStat(0);
        if (n >= n2 && noDeathFlag) {
            n = n2 - 1;
        }
        int n3 = (n2 << 16) / (ce.getStat(1) << 8);
        int n4 = (n2 - n << 16) / (ce.getStat(1) << 8);
        if (n4 > 0) {
            if (n3 > 26 && n4 <= 26) {
                Hud.addMessage((short)119, 3);
            } else if (n3 > 78 && n4 <= 78) {
                Hud.addMessage((short)120, 3);
            } else if (n3 > 128 && n4 <= 128 && (helpBitmask & 0x6000) == 0) {
                if (inventory[17] != 0 || inventory[16] != 0) {
                    Player.showHelp((short)13, true);
                } else {
                    Player.showHelp((short)14, true);
                }
            }
        }
        Player.addHealth(-n);
        if (Canvas.state == 6) {
            Canvas.setState(3);
        }
        if (ce.getStat(0) <= 0) {
            Player.died();
        }
    }

    public static final void died() {
        if (Canvas.state == 13) {
            return;
        }
        ++totalDeaths;
        Sound.playSound(7);
        Canvas.startShake(350, 5, 500);
        ce.setStat(0, 0);
        Canvas.setState(13);
        Game.combatMonsters = null;
    }

    public static final boolean fireWeapon(Entity entity, int n, int n2) {
        int n3;
        if (Combat.weaponDown || disabledWeapons != 0L && (weapons & 1L << Player.ce.weapon) == 0L) {
            return false;
        }
        if (Combat.lerpingWeapon) {
            if (Combat.lerpWpDown) {
                return false;
            }
            Combat.lerpingWeapon = false;
            Combat.weaponDown = false;
        }
        if (entity.monster != null) {
            entity.monster.flags = (short)(entity.monster.flags & 0xFFFFFFF7);
        }
        if (Combat.weapons[(n3 = Player.ce.weapon * 9) + 4] != 0) {
            short s = ammo[Combat.weapons[n3 + 4]];
            if (Combat.weapons[n3 + 5] > 0 && s - Combat.weapons[n3 + 5] < 0) {
                if (Player.ce.weapon == 14) {
                    Hud.addMessage((short)122, 3);
                } else {
                    Hud.addMessage((short)121, 3);
                }
                return false;
            }
        }
        Combat.performAttack(null, entity, n, n2, false);
        return true;
    }

    public static final boolean useItem(int n) {
        if (inventory[n] == 0) {
            return false;
        }
        boolean bl = true;
        switch (n) {
            case 16: {
                if (Player.addHealth(20)) break;
                return false;
            }
            case 17: {
                if (Player.addHealth(80)) break;
                return false;
            }
            case 0: {
                if (!Player.addStatusEffect(6, 20, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 1: {
                if (!Player.addStatusEffect(4, 20, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 2: {
                if (!Player.addStatusEffect(5, 20, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 3: {
                if (!Player.addStatusEffect(7, 5, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 14: {
                if (!Player.addStatusEffect(8, 50, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 4: {
                if (!Player.addStatusEffect(9, 0, 11)) {
                    return false;
                }
                Player.removeStatusEffect(13);
                Player.translateStatusEffects();
                break;
            }
            case 5: {
                if (!Player.addStatusEffect(8, 100, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 6: {
                if (statusEffects[2] != 0) {
                    return false;
                }
                bl = false;
                Player.addStatusEffect(2, 0, 21);
                Player.translateStatusEffects();
                break;
            }
            case 7: {
                if (!Player.addStatusEffect(10, 20, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                Player.addHealth(20);
                break;
            }
            case 8: {
                if (!Player.addStatusEffect(3, 5, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 9: {
                if (statusEffects[1] != 0) {
                    return false;
                }
                Player.removeStatusEffect(15);
                Player.removeStatusEffect(14);
                Player.removeStatusEffect(16);
                Player.removeStatusEffect(17);
                Player.addStatusEffect(1, 0, 11);
                Player.translateStatusEffects();
                break;
            }
            case 10: {
                if (!Player.addStatusEffect(0, 5, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 11: {
                boolean bl2 = false;
                if (Player.addStatusEffect(10, 50, 31)) {
                    bl2 = true;
                }
                if (Player.addStatusEffect(5, 25, 31)) {
                    bl2 = true;
                }
                if (Player.addStatusEffect(4, 25, 31)) {
                    bl2 = true;
                }
                if (bl2) {
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 12: {
                boolean bl3 = false;
                if (Player.addStatusEffect(7, 15, 31)) {
                    bl3 = true;
                }
                if (Player.addStatusEffect(8, 50, 31)) {
                    bl3 = true;
                }
                if (Player.addStatusEffect(6, 15, 31)) {
                    bl3 = true;
                }
                if (bl3) {
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 13: {
                if (statusEffects[47] != 0 || !Player.addStatusEffect(11, 50, 7)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 22: {
                boolean bl4 = false;
                if (Player.addHealth(20)) {
                    bl4 = true;
                }
                if (Player.addStatusEffect(15, 10, 31)) {
                    bl4 = true;
                }
                if (bl4) {
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 23: {
                return true;
            }
            default: {
                return false;
            }
        }
        Sound.playSound(8);
        int n2 = n;
        inventory[n2] = (short)(inventory[n2] - 1);
        if (bl) {
            Game.advanceTurn();
        }
        return true;
    }

    public static final void giveGold(int n) {
        if ((gold += n) < 0) {
            gold = 0;
        }
    }

    public static final boolean give(int n, int n2, int n3) {
        return Player.give(n, n2, n3, false);
    }

    public static final boolean give(int n, int n2, int n3, boolean bl) {
        if (n3 == 0) {
            return false;
        }
        int n4 = 1 << n2;
        switch (n) {
            case 1: {
                boolean bl2;
                if (n2 == 4 && ((weapons & 0x10L) != 0L || (weapons & 0x20L) != 0L)) {
                    n2 = 5;
                    weapons &= (long)(~n4);
                    n4 = 1 << n2;
                }
                boolean bl3 = bl2 = (weapons & (long)n4) == 0L;
                if (((long)n4 & 7L) != 0L) {
                    n4 = Math.max(n4, (int)(weapons & 7L));
                    weapons &= 0xFFFFFFFFFFFFFFF8L;
                }
                if (n3 < 0) {
                    weapons &= (long)(~n4);
                    if (n2 == Player.ce.weapon) {
                        Player.selectNextWeapon();
                    }
                    return true;
                }
                if (((long)n4 & 0x600L) != 0L) {
                    n4 = Math.max(n4, (int)(weapons & 0x600L));
                    weapons &= 0xFFFFFFFFFFFFF9FFL;
                }
                weapons |= (long)n4;
                if (!bl) {
                    Player.showWeaponHelp(n2, false);
                }
                if (!bl2) break;
                Player.selectWeapon(n2);
                break;
            }
            case 3: {
                if (gold + n3 < 0) {
                    return false;
                }
                gold += n3;
                if (n3 <= 0) break;
                counters[0] = counters[0] + n3;
                break;
            }
            case 0: {
                int n5 = n3 + inventory[n2 - 0];
                if (n5 > 999) {
                    n5 = 999;
                }
                if (n5 < 0) {
                    return false;
                }
                Player.inventory[n2 - 0] = (short)n5;
                if (n3 > 0 && n2 >= 25 && n2 <= 28) {
                    counters[0] = counters[0] + n3;
                }
                if (bl) break;
                Player.showInvHelp(n2 - 0, false);
                break;
            }
            case 2: {
                int n6 = n3 + ammo[n2];
                if (n6 > 100) {
                    n6 = 100;
                }
                if (n6 < 0) {
                    return false;
                }
                if (n2 == 7) {
                    Player.give(1, 11, 1, true);
                }
                Player.ammo[n2] = (short)n6;
                if (!bl) {
                    Player.showAmmoHelp(n2, false);
                }
                Hud.repaintFlags |= 4;
                break;
            }
            case 6: {
                Player.addArmor(n2 * 50);
                if (bl) break;
                Player.showArmorHelp(n2, false);
                break;
            }
            case 4: {
                Player.addHealth(n3);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static final void giveAmmoWeapon(int n, boolean bl) {
        weapons |= 1L << n;
        Player.selectWeapon(n);
        if (!bl) {
            Player.showWeaponHelp(n, false);
        }
    }

    public static final void updateQuests(short s, int n) {
        if (n == 0) {
            if (numNotebookIndexes == 8) {
                App.Error(39);
                return;
            }
            questComplete = (byte)(questComplete & ~(1 << numNotebookIndexes));
            questFailed = (byte)(questFailed & ~(1 << numNotebookIndexes));
            Player.notebookIndexes[Player.numNotebookIndexes++] = s;
        } else {
            for (int i = 0; i < numNotebookIndexes; ++i) {
                if (s != notebookIndexes[i]) continue;
                if (n == 1) {
                    questComplete = (byte)(questComplete | 1 << i);
                } else if (n == 2) {
                    questFailed = (byte)(questFailed | 1 << i);
                }
                return;
            }
            if (n == 1) {
                questComplete = (byte)(questComplete | 1 << numNotebookIndexes);
                questFailed = (byte)(questFailed & ~(1 << numNotebookIndexes));
            } else if (n == 2) {
                questComplete = (byte)(questComplete & ~(1 << numNotebookIndexes));
                questFailed = (byte)(questFailed | 1 << numNotebookIndexes);
            }
            Player.notebookPositions[Player.numNotebookIndexes] = 0;
            Player.notebookIndexes[Player.numNotebookIndexes++] = s;
        }
    }

    public static final void setQuestTile(int n, int n2, int n3) {
        for (int i = 0; i < numNotebookIndexes; ++i) {
            if (n != notebookIndexes[i]) continue;
            Player.notebookPositions[i] = (short)(n2 << 5 | n3);
            return;
        }
    }

    public static final boolean isQuestDone(int n) {
        return (questComplete & 1 << n) != 0;
    }

    public static final boolean isQuestFailed(int n) {
        return (questFailed & 1 << n) != 0;
    }

    public static final void formatTime(int n, Text text) {
        text.setLength(0);
        int n2 = n / 1000;
        int n3 = n2 / 60;
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        text.append(n4);
        text.append(":");
        if (n5 < 10) {
            text.append("0");
        }
        text.append(n5);
        text.append(":");
        if ((n2 -= n3 * 60) < 10) {
            text.append("0");
        }
        text.append(n2);
    }

    public static final void showInvHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        int n2 = n - 0;
        if ((invHelpBitmask & 1 << n2) != 0) {
            return;
        }
        invHelpBitmask |= 1 << n2;
        EntityDef entityDef = EntityDef.find(6, 0, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final void showAmmoHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        int n2 = 1 << n;
        if ((ammoHelpBitmask & n2) != 0) {
            return;
        }
        ammoHelpBitmask |= n2;
        EntityDef entityDef = EntityDef.find(6, 2, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final void showHelp(short s, boolean bl) {
        if (Game.isCameraActive()) {
            return;
        }
        if (!enableHelp && !bl) {
            return;
        }
        if ((helpBitmask & 1 << s) != 0 && !bl) {
            return;
        }
        helpBitmask |= 1 << s;
        Canvas.enqueueHelpDialog(s);
        if (s != 6 && Canvas.state == 3) {
            Canvas.dequeueHelpDialog();
        }
    }

    public static final void showWeaponHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        if ((weaponHelpBitmask & 1 << n) != 0) {
            return;
        }
        weaponHelpBitmask |= 1 << n;
        EntityDef entityDef = EntityDef.find(6, 1, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    private static final void showArmorHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        if ((armorHelpBitmask & 1 << n) != 0) {
            return;
        }
        armorHelpBitmask |= 1 << n;
        EntityDef entityDef = EntityDef.find(6, 6, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final void drawBuffs(Graphics graphics) {
        int n;
        if (numbuffs == 0 || Canvas.state == 8) {
            return;
        }
        int n2 = Canvas.viewRect[0] + Canvas.viewRect[2];
        int n3 = n2 - 17;
        int n4 = Canvas.viewRect[1] + 2;
        int n5 = 0;
        boolean bl = false;
        int n6 = numbuffs;
        if (n6 > 6) {
            n6 = 6;
            bl = true;
        }
        int n7 = n6 * 13 + 6;
        for (n = 0; n < 15 && n5 < 6; ++n) {
            if (buffs[0 + n] <= 0 || (1 << n & 0x3A07) != 0) continue;
            if (buffs[15 + n] > 99 || buffs[15 + n] < -99) {
                n3 = n2 - 43;
                break;
            }
            if (buffs[15 + n] > 9 || buffs[15 + n] < -9) {
                n3 = n2 - 35;
                continue;
            }
            if (n3 != n2 - 17) continue;
            n3 = n2 - 27;
        }
        n = n2 - n3 + 4;
        if (bl) {
            n7 += 5;
        }
        graphics.setColor(0);
        graphics.fillRect(n3 - 5, n4 - 2, n, n7);
        graphics.setColor(-5592406);
        graphics.drawRect(n3 - 5, n4 - 2, n, n7);
        int n8 = n2 - 18;
        for (int i = 0; i < 15 && n5 < 6; ++i) {
            if (buffs[0 + i] == 0) continue;
            ++n5;
            Player.drawStatusEffectIcon(graphics, i, buffs[15 + i], buffs[0 + i], n8, n4);
            n4 += 13;
        }
        if (bl) {
            Text text = Text.getSmallBuffer();
            text.setLength(0);
            text.append('\u0085');
            graphics.drawString(text, n3 + n / 2 - 4, n4 - 4, 1);
            text.dispose();
        }
    }

    public static final boolean loadState(DataInputStream dataInputStream) throws IOException {
        int n;
        baseCe.loadState(dataInputStream, true);
        ce.loadState(dataInputStream, true);
        purchasedWeapons = dataInputStream.readInt();
        weapons = dataInputStream.readLong();
        weaponsCopy = dataInputStream.readInt();
        level = dataInputStream.readByte() & 0xFF;
        currentXP = dataInputStream.readInt();
        nextLevelXP = Player.calcLevelXP(level);
        gold = dataInputStream.readShort();
        totalTime = dataInputStream.readInt();
        totalMoves = dataInputStream.readInt();
        completedLevels = dataInputStream.readInt();
        killedMonstersLevels = dataInputStream.readInt();
        foundSecretsLevels = dataInputStream.readInt();
        disabledWeapons = dataInputStream.readLong();
        pickingStats = dataInputStream.readInt();
        prevWeapon = dataInputStream.readByte();
        cocktailDiscoverMask = dataInputStream.readInt();
        gamePlayedMask = dataInputStream.readInt();
        lastCombatTurn = dataInputStream.readInt();
        inCombat = dataInputStream.readBoolean();
        highestMap = dataInputStream.readShort();
        int n2 = 10;
        for (n = 0; n < n2; ++n) {
            Player.ammo[n] = dataInputStream.readShort();
        }
        for (n = 0; n < n2; ++n) {
            Player.ammoCopy[n] = dataInputStream.readShort();
        }
        n2 = 29;
        for (n = 0; n < n2; ++n) {
            Player.inventory[n] = dataInputStream.readShort();
        }
        for (n = 0; n < n2; ++n) {
            Player.inventoryCopy[n] = dataInputStream.readShort();
        }
        numStatusEffects = dataInputStream.readByte();
        if (numStatusEffects == 0) {
            for (n = 0; n < 18; ++n) {
                Player.statusEffects[36 + n] = 0;
                Player.statusEffects[0 + n] = 0;
                Player.statusEffects[18 + n] = 0;
            }
        } else {
            for (n = 0; n < 18; ++n) {
                Player.statusEffects[36 + n] = dataInputStream.readShort();
                Player.statusEffects[0 + n] = dataInputStream.readShort();
                Player.statusEffects[18 + n] = dataInputStream.readShort();
            }
        }
        for (n = 0; n < 8; ++n) {
            Player.counters[n] = dataInputStream.readInt();
        }
        gameCompleted = dataInputStream.readBoolean();
        for (n = 0; n < 2; ++n) {
            Player.medals[n] = dataInputStream.readInt();
        }
        for (n = 0; n < 4; ++n) {
            Player.foundBooks[n] = dataInputStream.readByte();
        }
        Player.translateStatusEffects();
        Player.updateStats();
        return true;
    }

    public static final boolean saveState(DataOutputStream dataOutputStream) throws IOException {
        baseCe.saveState(dataOutputStream, true);
        ce.saveState(dataOutputStream, true);
        dataOutputStream.writeInt(purchasedWeapons);
        dataOutputStream.writeLong(weapons);
        dataOutputStream.writeInt(weaponsCopy);
        dataOutputStream.writeByte(level);
        dataOutputStream.writeInt(currentXP);
        int n = App.gameTime;
        totalTime += n - playTime;
        playTime = n;
        dataOutputStream.writeShort(gold);
        dataOutputStream.writeInt(totalTime);
        dataOutputStream.writeInt(totalMoves);
        dataOutputStream.writeInt(completedLevels);
        dataOutputStream.writeInt(killedMonstersLevels);
        dataOutputStream.writeInt(foundSecretsLevels);
        dataOutputStream.writeLong(disabledWeapons);
        dataOutputStream.writeInt(pickingStats);
        dataOutputStream.writeByte(prevWeapon);
        dataOutputStream.writeInt(cocktailDiscoverMask);
        dataOutputStream.writeInt(gamePlayedMask);
        dataOutputStream.writeInt(lastCombatTurn);
        dataOutputStream.writeBoolean(inCombat);
        dataOutputStream.writeShort(highestMap);
        int n2 = 10;
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(ammo[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(ammoCopy[n3]);
        }
        n2 = 29;
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(inventory[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(inventoryCopy[n3]);
        }
        dataOutputStream.writeByte(numStatusEffects);
        if (numStatusEffects != 0) {
            for (n3 = 0; n3 < 18; ++n3) {
                dataOutputStream.writeShort(statusEffects[36 + n3]);
                dataOutputStream.writeShort(statusEffects[0 + n3]);
                dataOutputStream.writeShort(statusEffects[18 + n3]);
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            dataOutputStream.writeInt(counters[n3]);
        }
        dataOutputStream.writeBoolean(gameCompleted);
        for (n3 = 0; n3 < 2; ++n3) {
            dataOutputStream.writeInt(medals[n3]);
        }
        for (n3 = 0; n3 < 4; ++n3) {
            dataOutputStream.writeByte(foundBooks[n3]);
        }
        return true;
    }

    public static final void unpause(int n) {
        if (n <= 0) {
            return;
        }
    }

    public static final void relink() {
        Player.unlink();
        Player.link();
    }

    public static final void unlink() {
        Entity entity = Player.getPlayerEnt();
        if ((entity.info & 0x100000) != 0) {
            Game.unlinkEntity(entity);
        }
    }

    public static final void link() {
        Entity entity = Player.getPlayerEnt();
        if (Canvas.destX >= 0 && Canvas.destX <= 2047 && Canvas.destY >= 0 && Canvas.destY <= 2047) {
            Game.linkEntity(entity, Canvas.destX >> 6, Canvas.destY >> 6);
        }
    }

    public static final void updateStats() {
        int n = baseCe.getStat(1) + buffs[25];
        ce.setStat(1, n);
        ce.setStat(0, ce.getStat(0));
        ce.setStat(4, baseCe.getStat(4) + buffs[20]);
        ce.setStat(5, baseCe.getStat(5) + buffs[22] - buffs[28]);
        ce.setStat(3, baseCe.getStat(3) + buffs[19]);
        ce.setStat(6, baseCe.getStat(6) + buffs[21]);
    }

    private static final void updateStatusEffects() {
        if (numStatusEffects == 0) {
            return;
        }
        for (int i = 0; i < 18; ++i) {
            if (statusEffects[0 + i] == 0) continue;
            if (statusEffects[0 + i] <= 5 && i != 12 && statusEffects[0 + i] == 1) {
                Player.removeStatusEffect(i);
                continue;
            }
            if (statusEffects[0 + i] == 0) continue;
            int n = 0 + i;
            statusEffects[n] = statusEffects[n] - 1;
        }
        Player.translateStatusEffects();
    }

    public static final void translateStatusEffects() {
        int n;
        for (n = 0; n < 15; ++n) {
            Player.buffs[15 + n] = 0;
            Player.buffs[0 + n] = 0;
        }
        numbuffs = 0;
        block6: for (n = 0; n < 18; ++n) {
            int n2 = statusEffects[0 + n];
            int n3 = statusEffects[18 + n];
            if (n2 == 0 || n2 <= 0) continue;
            switch (n) {
                case 14: {
                    int n4 = buffs[20] - n3;
                    Player.buffs[20] = (short)n4;
                    Player.buffs[5] = (short)n2;
                    n4 = buffs[19] - n3;
                    Player.buffs[19] = (short)n4;
                    Player.buffs[4] = (short)n2;
                    n4 = buffs[29] - statusEffects[36 + n] * 4;
                    Player.buffs[29] = (short)n4;
                    Player.buffs[14] = (short)n2;
                    continue block6;
                }
                case 15: 
                case 17: {
                    int n4 = buffs[20] + n3;
                    Player.buffs[20] = (short)n4;
                    Player.buffs[5] = (short)n2;
                    n4 = buffs[19] + n3;
                    Player.buffs[19] = (short)n4;
                    Player.buffs[4] = (short)n2;
                    n4 = buffs[22] - (n3 + n3 / 2);
                    Player.buffs[22] = (short)n4;
                    Player.buffs[7] = (short)n2;
                    continue block6;
                }
                case 16: {
                    int n4 = buffs[22] - n3;
                    Player.buffs[22] = (short)n4;
                    Player.buffs[7] = (short)n2;
                    continue block6;
                }
                default: {
                    int n4 = buffs[15 + n] + n3;
                    Player.buffs[15 + n] = (short)n4;
                    Player.buffs[0 + n] = (short)n2;
                }
            }
        }
        for (n = 0; n < 15; ++n) {
            if (buffs[0 + n] <= 0) continue;
            if ((0x1A07 & 1 << n) == 0 && buffs[15 + n] == 0) {
                Player.buffs[0 + n] = 0;
                continue;
            }
            ++numbuffs;
        }
        Player.updateStats();
    }

    public static final void removeStatusEffect(int n) {
        if (n == 18) {
            numStatusEffects = 0;
            for (int i = 0; i < 18; ++i) {
                Player.statusEffects[0 + i] = 0;
                Player.statusEffects[36 + i] = 0;
                Player.statusEffects[18 + i] = 0;
            }
        } else {
            if (statusEffects[36 + n] == 0) {
                return;
            }
            if (n == 17) {
                Render.startFogLerp(1, 0, 2000);
            }
            Player.statusEffects[18 + n] = 0;
            Player.statusEffects[36 + n] = 0;
            Player.statusEffects[0 + n] = 0;
            --numStatusEffects;
        }
        Player.translateStatusEffects();
    }

    public static final boolean addStatusEffect(int n, int n2, int n3) {
        if (n == 13 && buffs[9] > 0) {
            return false;
        }
        int n4 = statusEffects[36 + n] + 1;
        if (n4 > 3 || n == 9 && n4 > 1) {
            if (n == 14) {
                Player.statusEffects[0 + n] = n3;
            }
            return false;
        }
        if (n4 == 1) {
            ++numStatusEffects;
            if (n == 17) {
                TinyGL.fogMin = 0;
                if (TinyGL.fogRange > 0) {
                    TinyGL.fogRange = -1;
                }
                Render.startFogLerp(1024, 0, 2000);
            }
        }
        int n5 = 18 + n;
        statusEffects[n5] = statusEffects[n5] + n2;
        Player.statusEffects[0 + n] = n3;
        Player.statusEffects[36 + n] = n4;
        return true;
    }

    private static final void drawStatusEffectIcon(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Text text = Text.getSmallBuffer();
        text.setLength(0);
        if (n == 8) {
            text.append('%');
            text.append(n2);
        } else if ((1 << n & 0x3A07) == 0) {
            if (n2 >= 0) {
                text.append('+');
                text.append(n2);
            } else {
                text.append(n2);
            }
        }
        graphics.drawString(text, n4, n5 + 2, 24);
        graphics.drawBuffIcon(n, n4 + 3, n5 + 1, 0);
        if (App.time - turnTime < 600) {
            text.setLength(0);
            text.append(n3);
            graphics.drawString(text, n4 + 8, n5 + 2, 17);
            Canvas.forcePump = true;
        }
        text.dispose();
    }

    private static final void resetCounters() {
        for (int i = 0; i < 8; ++i) {
            Player.counters[i] = 0;
        }
    }

    public static final int[] GetPos() {
        Player.pos[0] = Canvas.destX;
        Player.pos[1] = Canvas.destY;
        Player.pos[2] = Canvas.destAngle;
        return pos;
    }

    public static final Entity getPlayerEnt() {
        return Game.entities[1];
    }

    public static final void setPickUpWeapon(int n) {
        EntityDef entityDef = null;
        EntityDef entityDef2 = EntityDef.find(6, 1, 16);
        if (n != 17) {
            entityDef = EntityDef.lookup(n);
        }
        if (null != entityDef) {
            entityDef2.tileIndex = entityDef.tileIndex;
            entityDef2.name = entityDef.name;
            entityDef2.longName = entityDef.longName;
            entityDef2.description = entityDef.description;
        } else {
            entityDef2.tileIndex = (short)17;
            entityDef2.name = (short)92;
            entityDef2.longName = (short)92;
            entityDef2.description = (short)92;
        }
    }

    public static final void giveAll() {
        int n;
        weapons = 65535L;
        for (n = 0; n < 10; ++n) {
            if (n == 9) continue;
            Player.give(2, n, 100);
        }
        for (n = 0; n < 29; ++n) {
            Player.give(0, (byte)n, 999);
            Canvas.numHelpMessages = 0;
        }
        for (n = 0; n < 28; ++n) {
            int n2 = n / 8;
            foundBooks[n2] = (byte)(foundBooks[n2] | 1 << (n & 7));
        }
        ce.setStat(0, ce.getStat(1));
    }

    public static void equipForLevel(int n) {
        int n2 = Canvas.viewX;
        int n3 = Canvas.viewY;
        int n4 = Canvas.viewAngle;
        Player.reset();
        Canvas.saveX = Canvas.prevX = n2;
        Canvas.destX = Canvas.prevX;
        Canvas.viewX = Canvas.prevX;
        Canvas.saveY = Canvas.prevY = n3;
        Canvas.destY = Canvas.prevY;
        Canvas.viewY = Canvas.prevY;
        Canvas.viewZ = Canvas.destZ = Render.getHeight(Canvas.viewX, Canvas.viewY) + 36;
        Canvas.destAngle = Canvas.saveAngle = n4;
        Canvas.viewAngle = Canvas.saveAngle;
        Canvas.destPitch = 0;
        Canvas.viewPitch = 0;
        highestMap = n;
        boolean bl = enableHelp;
        enableHelp = false;
        int n5 = 1;
        weapons = 0L;
        switch (n) {
            default: {
                if (n == 9 && Game.difficulty == 4) {
                    n5 = 0;
                    nextLevelXP = 0;
                    currentXP = 0;
                    Player.addXP(11297);
                    ce.setStat(2, 50);
                    ce.setStat(0, 150);
                    Player.give(0, 17, 7);
                    Player.give(0, 16, 3);
                    Player.give(0, 0, 4);
                    Player.give(0, 1, 7);
                    Player.give(0, 2, 5);
                    Player.give(0, 3, 5);
                    Player.give(0, 4, 5);
                    Player.give(0, 5, 1);
                    Player.give(0, 6, 1);
                    Player.give(0, 9, 3);
                    Player.give(0, 12, 1);
                    Player.give(0, 13, 1);
                    Player.give(0, 14, 1);
                    Player.give(0, 22, 14);
                    Player.give(1, 0, 1);
                    Player.give(1, 3, 1);
                    Player.give(1, 2, 1);
                    Player.give(1, 5, 1);
                    Player.give(1, 6, 1);
                    Player.give(1, 7, 1);
                    Player.give(2, 1, 62);
                    Player.give(2, 4, 61);
                    Player.give(2, 7, 1);
                    Player.give(0, 26, 19);
                    Player.give(0, 27, 22);
                    Player.give(0, 25, 29);
                    gold = 12;
                    break;
                }
                ++n5;
                Player.give(1, 8, 1);
                Player.give(2, 2, 10);
            }
            case 8: {
                if (n == 8 && Game.difficulty == 4) {
                    n5 = 0;
                    nextLevelXP = 0;
                    currentXP = 0;
                    Player.addXP(9462);
                    ce.setStat(2, 50);
                    ce.setStat(0, 150);
                    Player.give(0, 16, 12);
                    Player.give(0, 17, 13);
                    Player.give(0, 0, 5);
                    Player.give(0, 1, 6);
                    Player.give(0, 2, 5);
                    Player.give(0, 3, 7);
                    Player.give(0, 4, 5);
                    Player.give(0, 5, 1);
                    Player.give(0, 8, 3);
                    Player.give(0, 9, 1);
                    Player.give(0, 12, 2);
                    Player.give(0, 13, 1);
                    Player.give(0, 21, 1);
                    Player.give(0, 22, 10);
                    Player.give(1, 0, 1);
                    Player.give(1, 3, 1);
                    Player.give(1, 2, 1);
                    Player.give(1, 5, 1);
                    Player.give(1, 6, 1);
                    Player.give(1, 7, 1);
                    Player.give(2, 1, 80);
                    Player.give(2, 4, 88);
                    Player.give(2, 7, 1);
                    Player.give(0, 27, 21);
                    Player.give(0, 26, 19);
                    Player.give(0, 25, 29);
                    gold = 12;
                    break;
                }
                ++n5;
                Player.give(1, 12, 1);
                Player.give(2, 6, 10);
            }
            case 7: {
                if (n == 7 && Game.difficulty == 4) {
                    n5 = 0;
                    nextLevelXP = 0;
                    currentXP = 0;
                    Player.addXP(7617);
                    ce.setStat(2, 0);
                    ce.setStat(0, 140);
                    Player.give(0, 17, 18);
                    Player.give(0, 16, 6);
                    Player.give(0, 0, 5);
                    Player.give(0, 1, 7);
                    Player.give(0, 2, 7);
                    Player.give(0, 3, 8);
                    Player.give(0, 5, 2);
                    Player.give(0, 6, 1);
                    Player.give(0, 8, 5);
                    Player.give(0, 9, 1);
                    Player.give(0, 12, 1);
                    Player.give(0, 13, 1);
                    Player.give(0, 14, 2);
                    Player.give(0, 22, 6);
                    Player.give(1, 0, 1);
                    Player.give(1, 3, 1);
                    Player.give(1, 1, 1);
                    Player.give(1, 5, 1);
                    Player.give(1, 6, 1);
                    Player.give(2, 1, 10);
                    Player.give(2, 4, 39);
                    Player.give(2, 7, 3);
                    Player.give(0, 26, 19);
                    Player.give(0, 27, 19);
                    Player.give(0, 25, 28);
                    gold = 12;
                    break;
                }
                n5 = 0;
                nextLevelXP = 0;
                currentXP = 0;
                Player.addXP(Player.calcLevelXP(4));
                ce.setStat(2, 50);
                ce.setStat(0, 140);
                Player.give(0, 17, 80);
                Player.give(0, 16, 38);
                Player.give(0, 0, 4);
                Player.give(0, 1, 5);
                Player.give(0, 2, 9);
                Player.give(0, 3, 9);
                Player.give(0, 6, 1);
                Player.give(0, 8, 4);
                Player.give(0, 9, 1);
                Player.give(0, 10, 1);
                Player.give(0, 12, 1);
                Player.give(0, 13, 2);
                Player.give(0, 14, 3);
                Player.give(1, 0, 1);
                Player.give(1, 3, 1);
                Player.give(1, 1, 1);
                Player.give(1, 5, 1);
                Player.give(1, 6, 1);
                Player.give(1, 10, 1);
                Player.give(1, 13, 1);
                Player.give(2, 1, 10);
                Player.give(2, 4, 62);
                Player.give(2, 7, 8);
                Player.give(2, 3, 25);
                Player.give(2, 5, 32);
                Player.give(0, 26, 19);
                Player.give(0, 27, 19);
                Player.give(0, 25, 28);
                gold = 12;
                break;
            }
            case 6: {
                ++n5;
                if (n == 6 && Game.difficulty == 4) {
                    n5 = 0;
                    Player.addXP(6135);
                    ce.setStat(0, 50);
                    ce.setStat(2, 76);
                    Player.give(0, 17, 31);
                    Player.give(0, 16, 7);
                    Player.give(0, 22, 3);
                    Player.give(0, 0, 7);
                    Player.give(0, 1, 8);
                    Player.give(0, 2, 10);
                    Player.give(0, 3, 8);
                    Player.give(0, 4, 1);
                    Player.give(0, 8, 4);
                    Player.give(0, 13, 1);
                    Player.give(0, 14, 5);
                    Player.give(0, 26, 19);
                    Player.give(0, 27, 17);
                    Player.give(0, 25, 27);
                    gold = 12;
                    Player.give(1, 0, 1);
                    Player.give(1, 3, 1);
                    Player.give(1, 1, 1);
                    Player.give(1, 5, 1);
                    Player.give(2, 1, 38);
                    break;
                }
            }
            case 4: {
                if (n == 4 && Game.difficulty == 1) {
                    n5 = 0;
                    nextLevelXP = 0;
                    currentXP = 0;
                    Player.addXP(Player.calcLevelXP(3));
                    ce.setStat(0, 115);
                    ce.setStat(2, 100);
                    Player.give(0, 17, 45);
                    Player.give(0, 16, 11);
                    Player.give(0, 0, 4);
                    Player.give(0, 1, 4);
                    Player.give(0, 2, 4);
                    Player.give(0, 3, 4);
                    Player.give(0, 13, 2);
                    Player.give(0, 8, 2);
                    Player.give(0, 26, 3);
                    Player.give(0, 27, 5);
                    Player.give(0, 25, 13);
                    gold = 1;
                    Player.give(1, 0, 1);
                    Player.give(1, 3, 1);
                    Player.give(1, 1, 1);
                    Player.give(1, 5, 1);
                    Player.give(1, 6, 1);
                    Player.give(2, 1, 90);
                    Player.give(2, 4, 90);
                    Player.give(2, 7, 13);
                    break;
                }
                Player.give(1, 1, 1);
                Player.give(2, 4, 74);
                Player.give(2, 7, 5);
                Player.give(0, 21, 1);
                Player.give(0, 25, 6);
                Player.give(0, 26, 3);
                Player.give(0, 27, 5);
                Player.give(0, 0, 1);
                Player.give(0, 2, 4);
                Player.give(0, 14, 2);
                Player.give(0, 13, 1);
                ++n5;
            }
            case 3: {
                Player.give(1, 6, 1);
                Player.give(2, 4, 13);
                Player.give(1, 11, 1);
                Player.give(2, 7, 10);
                Player.give(0, 17, 12);
                Player.give(0, 21, 1);
                Player.give(0, 25, 3);
                Player.give(0, 26, 3);
                Player.give(0, 27, 1);
                Player.give(0, 0, 3);
                Player.give(0, 1, 3);
                Player.give(0, 2, 5);
                Player.give(0, 3, 5);
                Player.give(0, 4, 9);
                Player.give(0, 14, 1);
                Player.give(0, 8, 2);
                ++n5;
            }
            case 2: {
                Player.give(1, 5, 1);
                Player.give(2, 1, 80);
                Player.give(0, 17, 10);
                Player.give(0, 25, 6);
                Player.give(0, 26, 1);
                Player.give(0, 0, 1);
                Player.give(0, 1, 1);
                Player.give(0, 2, 1);
                Player.give(0, 3, 1);
                Player.give(0, 7, 2);
                Player.addArmor(70);
                ++n5;
            }
            case 1: {
                Player.give(1, 0, 1);
                Player.give(1, 3, 1);
            }
        }
        Player.give(0, 18, 1);
        enableHelp = bl;
        Player.selectNextWeapon();
        while (level <= n5) {
            Player.addLevel();
        }
        Canvas.updateFacingEntity = true;
    }

    public static void addArmor(int n) {
        Hud.repaintFlags |= 4;
        if (ce.addStat(2, n) > 200) {
            ce.setStat(2, 200);
        }
    }

    public static int distFrom(Entity entity) {
        int[] nArray = Player.GetPos();
        return entity.distFrom(nArray[0], nArray[1]);
    }

    public static void giveStandardMedal(int n, int n2) {
        if (n <= 10) {
            Player.giveMedal((n - 1) * 5 + n2, null);
        }
    }

    public static void giveMedal(int n, ScriptThread scriptThread) {
        int n2 = n / 32;
        medals[n2] = medals[n2] | 1 << n % 32;
        Text text = Text.getSmallBuffer();
        Text text2 = Text.getSmallBuffer();
        if (n < 50) {
            Text.composeText((short)4, allMedals[n * 3 + 1], text2);
        } else {
            for (int i = 150; i < 159; i += 3) {
                if (allMedals[i + 2] != n) continue;
                Text.composeText((short)4, allMedals[i + 1], text2);
            }
        }
        Text.resetTextArgs();
        Text.addTextArg(text2);
        text2.dispose();
        Sound.playSound(5);
        Text.composeText((short)1, (short)174, text);
        if (!Canvas.enqueueHelpDialog(text, 3)) {
            text.dispose();
        }
    }

    public static void offerBook(int n, ScriptThread scriptThread) {
        Text text = Text.getSmallBuffer();
        Text.resetTextArgs();
        Text.addTextArg((short)0, bookMap[n * 4]);
        Text.composeText((short)1, (short)178, text);
        Canvas.startDialog(scriptThread, text, 4, 1, true);
        text.dispose();
    }

    public static void giveBook(int n, ScriptThread scriptThread) {
        int n2 = n / 8;
        foundBooks[n2] = (byte)(foundBooks[n2] | 1 << n % 8);
        showBookStat = true;
        MenuSystem.menuParam = (byte)n;
        MenuSystem.setMenu(54);
    }

    public static byte[] getLevelMedalCount() {
        int n = 0;
        byte by = 0;
        boolean bl = false;
        for (int i = 1; i < 11; ++i) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < 5; ++n3) {
                int n6 = (i - 1) * 3 * 5 + n3 * 3;
                by = allMedals[n6 + 2];
                boolean bl2 = bl = (medals[by / 32] & 1 << by % 32) != 0;
                if (bl) {
                    ++n5;
                }
                ++n4;
                n += 2;
            }
            n3 = 0;
            byte[] byArray = allMedals;
            for (n2 = 150; n2 < 159; n2 += 3) {
                if (byArray[n2] == i) {
                    by = byArray[n2 + 2];
                    boolean bl3 = bl = (medals[by / 32] & 1 << by % 32) != 0;
                    if (bl) {
                        ++n5;
                    }
                    ++n4;
                    n += 2;
                    n3 = 1;
                    continue;
                }
                if (n3 != 0) break;
            }
            n2 = i - 1 << 1;
            Player.medalInfo[n2] = (byte)n5;
            Player.medalInfo[n2 + 1] = (byte)n4;
        }
        return medalInfo;
    }

    public static boolean hasAllKills(int n) {
        byte by = allMedals[n * 3 * 5 + 6 + 2];
        return (medals[by / 32] & 1 << by % 32) != 0;
    }

    public static byte[] getLevelMedals(int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < MEDAL_DATA; ++n2) {
            Player.medalInfo[n2] = -1;
        }
        boolean bl2 = false;
        int n3 = 0;
        byte by = 0;
        boolean bl3 = false;
        for (n2 = 0; n2 < 5; ++n2) {
            int n4 = (n - 1) * 3 * 5 + n2 * 3;
            by = allMedals[n4 + 2];
            boolean bl4 = bl3 = (medals[by / 32] & 1 << by % 32) != 0;
            if (bl && !bl3) continue;
            Player.medalInfo[n3 + 0] = allMedals[n4 + 1];
            Player.medalInfo[n3 + 1] = bl3 ? (byte)1 : 0;
            n3 += 2;
        }
        for (n2 = 150; n2 < 159; n2 += 3) {
            if (allMedals[n2] == n) {
                by = allMedals[n2 + 2];
                boolean bl5 = bl3 = (medals[by / 32] & 1 << by % 32) != 0;
                if (bl && !bl3) continue;
                Player.medalInfo[n3 + 0] = allMedals[n2 + 1];
                Player.medalInfo[n3 + 1] = bl3 ? (byte)1 : 0;
                n3 += 2;
                bl2 = true;
                continue;
            }
            if (bl2) break;
        }
        return medalInfo;
    }

    public static void statusToString(int n, Text text) {
        short s = 0;
        switch (n) {
            case 0: {
                s = 190;
                break;
            }
            case 1: {
                s = 191;
                break;
            }
            case 2: {
                s = 192;
                break;
            }
            case 3: {
                s = 193;
                break;
            }
            case 4: {
                s = 194;
                break;
            }
            case 5: {
                s = 195;
                break;
            }
            case 6: {
                s = 196;
                break;
            }
            case 7: {
                s = 197;
                break;
            }
            case 8: {
                s = 198;
                break;
            }
            case 9: {
                s = 199;
                break;
            }
            case 10: {
                s = 200;
                break;
            }
            case 11: {
                s = 201;
                break;
            }
            case 12: {
                s = 202;
                break;
            }
            case 13: {
                s = 203;
                break;
            }
            case 14: {
                s = 204;
                break;
            }
            case 15: {
                s = 205;
                break;
            }
            case 16: {
                s = 206;
            }
        }
        Text.composeText((short)1, s, text);
    }

    public static boolean hasPurifyEffect() {
        return statusEffects[1] != 0;
    }

    static {
        inventory = new short[29];
        ammo = new short[10];
        inventoryCopy = new short[29];
        ammoCopy = new short[10];
        baseCe = new CombatEntity();
        ce = new CombatEntity();
        notebookIndexes = new short[8];
        notebookPositions = new short[8];
        noDeathFlag = false;
        statusEffects = new int[54];
        buffs = new short[30];
        purchasedWeapons = 0;
        playerSprite = null;
        pickingStats = 0;
        oldPickingStats = 0;
        allMedals = null;
        medals = new int[2];
        MEDAL_DATA = Math.max(8, 11) * 2;
        medalInfo = new byte[MEDAL_DATA];
        bookMap = null;
        foundBooks = new byte[4];
        showBookStat = false;
        counters = new int[8];
        monsterStats = new int[2];
        pos = new int[3];
    }
}

