/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

final class Sound {
    public static int touchMe = 1;
    private static final int SLOT_COUNT = 3;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_LOOP = 1;
    public static final int SND_NEG = 0;
    public static final int SND_POS = 1;
    public static final int SND_DYN = 2;
    private static Player[] sounds = new Player[3];
    private static int[] soundTimes = new int[3];
    public static boolean soundLooped;
    public static boolean soundFormatAllowed;
    private static boolean vibrateAllowed;
    private static boolean vibrateEnabled;
    private static boolean allowSounds;
    public static boolean isRegistered;
    private static boolean sndLimited;
    private static final boolean sndSupportsSetMediaTime = false;
    private static int sndMaxPrefetched;
    private static int sndMaxRealized;
    public static final String SOUND_FORMAT = "audio/midi";
    private static int[] sndIndex;
    private static final int MAX_PREFETCH_ATTEMPTS = 5;
    public static long lLastTime_StartSound;
    private static int activeSound;

    Sound() {
    }

    public static final boolean startup() {
        try {
            sndIndex = Resource.loadFileIndex("/sounds.idx");
        }
        catch (Exception exception) {
            App.Error(exception, 80);
            return false;
        }
        Sound.soundRegister();
        vibrateAllowed = true;
        if (vibrateAllowed) {
            vibrateAllowed = App.display.vibrate(0);
        }
        Sound.setVibrate(true);
        allowSounds = soundFormatAllowed;
        if (!allowSounds) {
            return true;
        }
        return true;
    }

    public static boolean isSoundEnabled() {
        return allowSounds;
    }

    public static void setSound(boolean bl) {
        if (!soundFormatAllowed) {
            return;
        }
        allowSounds = bl;
    }

    public static boolean isVibrateEnabled() {
        return vibrateEnabled;
    }

    public static void setVibrate(boolean bl) {
        if (!vibrateAllowed) {
            return;
        }
        vibrateEnabled = bl;
    }

    public static final void soundUnregister() {
        isRegistered = false;
        activeSound = -1;
        if (sounds[1] != null) {
            sounds[1].close();
            Sound.sounds[1] = null;
        }
        if (!sndLimited) {
            if (sounds[0] != null) {
                sounds[0].close();
                Sound.sounds[0] = null;
            }
            if (sounds[2] != null) {
                sounds[2].close();
                Sound.sounds[2] = null;
            }
        }
    }

    public static final void soundRegister() {
        isRegistered = true;
        Sound.cacheSound(0);
        Sound.cacheSound(1);
    }

    public static final void soundPrefetch(Player player) {
        for (int i = 0; i < 5; ++i) {
            try {
                player.prefetch();
                break;
            }
            catch (MediaException mediaException) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    private static Player loadSoundFromFile(int n) throws MediaException, IOException {
        int n2 = App.getUpTimeMs();
        InputStream inputStream = App.getResourceAsStream("sounds" + sndIndex[n * 3] + ".bin");
        Player player = Manager.createPlayer((InputStream)inputStream, (String)SOUND_FORMAT);
        return player;
    }

    private static final void cacheSound(int n) {
        int n2;
        if (sndLimited && n != 1) {
            return;
        }
        Player player = sounds[n];
        if (player != null && player.getState() >= 300) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            if (n2 == n || sounds[n2] == null) continue;
            if (sounds[n2].getState() >= 300) {
                ++n3;
                continue;
            }
            if (sounds[n2].getState() < 200) continue;
            ++n4;
        }
        if (n3 == sndMaxPrefetched) {
            Player player2;
            int n5;
            long l = Long.MAX_VALUE;
            int n6 = -1;
            for (n5 = 0; n5 < 3; ++n5) {
                player2 = sounds[n5];
                if (n5 == n || player2 == null || (long)soundTimes[n5] >= l) continue;
                n6 = n5;
                l = soundTimes[n5];
            }
            player2 = sounds[n6];
            if (player2.getState() >= 300) {
                player2.deallocate();
                if (n4 == sndMaxRealized) {
                    n5 = n6 == 0 && n == 1 || n6 == 1 && n == 0 ? 2 : (n6 == 0 && n == 2 || n6 == 2 && n == 0 ? 1 : 0);
                    sounds[n5].close();
                    Sound.sounds[n5] = null;
                    Sound.soundTimes[n5] = 0;
                }
            } else {
                if (n4 == sndMaxRealized) {
                    player2.close();
                    Sound.sounds[n6] = null;
                    Sound.soundTimes[n6] = 0;
                }
                n5 = n6 == 0 && n == 1 || n6 == 1 && n == 0 ? 2 : (n6 == 0 && n == 2 || n6 == 2 && n == 0 ? 1 : 0);
                sounds[n5].deallocate();
            }
        }
        try {
            if (sounds[n] == null) {
                if (n == 0) {
                    n2 = 7;
                } else if (n == 1) {
                    n2 = 8;
                } else if (activeSound != -1) {
                    n2 = activeSound;
                } else {
                    return;
                }
                Sound.sounds[n] = Sound.loadSoundFromFile(n2);
            }
            Sound.soundPrefetch(sounds[n]);
            Sound.soundTimes[n] = App.getUpTimeMs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void startSound(int n) {
        if (System.currentTimeMillis() - lLastTime_StartSound < 500L) {
            return;
        }
        lLastTime_StartSound = System.currentTimeMillis();
        if (!allowSounds) {
            return;
        }
        if (sndLimited && n != 1) {
            return;
        }
        if (soundLooped && n != 2) {
            return;
        }
        if (sndLimited) {
            Sound.soundStop();
        } else {
            for (int i = 0; i < 3; ++i) {
                if (sounds[i] == null || sounds[i].getState() != 400) continue;
                try {
                    sounds[i].stop();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!sndLimited) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Sound.cacheSound(n);
        try {
            if (soundLooped) {
                sounds[n].setLoopCount(-1);
            }
            ((VolumeControl)sounds[n].getControl("VolumeControl")).setLevel(60);
            sounds[n].start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getActiveSound() {
        return activeSound;
    }

    public static final void loadSound(int n, boolean bl) {
        if (!allowSounds || sndLimited || n == activeSound) {
            return;
        }
        if (sounds[2] != null) {
            sounds[2].close();
            Sound.sounds[2] = null;
            activeSound = -1;
            soundLooped = false;
            System.gc();
        }
        activeSound = n;
        try {
            Sound.sounds[2] = Sound.loadSoundFromFile(n);
            if (bl) {
                sounds[2].setLoopCount(-1);
            }
            soundLooped = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Sound.cacheSound(2);
    }

    public static final void playSound(int n) {
        Sound.playSound(n, 0);
    }

    public static final void playSound(int n, int n2) {
        if (n == 14) {
            return;
        }
        if (n == 8) {
            soundLooped = false;
            Sound.startSound(1);
            return;
        }
        if (n == 7) {
            soundLooped = false;
            Sound.startSound(0);
            return;
        }
        boolean bl = (n2 & 1) != 0;
        Sound.loadSound(n, bl);
        Sound.startSound(2);
    }

    public static final void soundStop() {
        if (sounds[2] != null) {
            try {
                sounds[2].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void clearDynamicSound() {
        if (sounds[2] != null) {
            sounds[2].close();
            Sound.sounds[2] = null;
        }
    }

    static {
        soundFormatAllowed = true;
        allowSounds = true;
        isRegistered = false;
        sndLimited = false;
        sndMaxPrefetched = 2;
        sndMaxRealized = 1;
        lLastTime_StartSound = 0L;
        activeSound = -1;
    }
}

