/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class CombatEntity {
    public static int touchMe = 1;
    public static final int COMBATENTITY_MISS = 0;
    public static final int COMBATENTITY_HIT = 1;
    public static final int COMBATENTITY_CRIT = 2;
    private int[] stats = new int[8];
    public int weapon;

    public CombatEntity() {
    }

    public CombatEntity(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setStat(1, n);
        this.setStat(0, n);
        this.setStat(2, n2);
        this.setStat(3, n3);
        this.setStat(4, n4);
        this.setStat(5, n5);
        this.setStat(6, n6);
    }

    public CombatEntity clone() {
        CombatEntity combatEntity = new CombatEntity(this.stats[1], this.stats[2], this.stats[3], this.stats[4], this.stats[5], this.stats[6]);
        combatEntity.setStat(0, this.stats[0]);
        combatEntity.weapon = this.weapon;
        return combatEntity;
    }

    public int getStat(int n) {
        return this.stats[n];
    }

    public int getStatPercent(int n) {
        return (this.stats[n] << 8) / 100;
    }

    public int getIQPercent() {
        int n = (this.stats[7] - 100) * 100 / 100;
        n = Math.max(0, Math.min(n, 100));
        return n;
    }

    public int addStat(int n, int n2) {
        this.setStat(n, n2 += this.stats[n]);
        return this.stats[n];
    }

    public int setStat(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                n2 = Math.min(n2, this.getStat(1));
                break;
            }
            default: {
                n2 = Math.min(n2, 255);
            }
        }
        this.stats[n] = n2;
        return this.stats[n];
    }

    public int calcXP() {
        int n = (this.stats[3] + this.stats[4]) * 5 + this.stats[5] * 6;
        int n2 = this.stats[1] * 5;
        return (n + n2 + 49) / 50;
    }

    public void loadState(DataInputStream dataInputStream, boolean bl) throws IOException {
        if (bl) {
            this.stats[0] = dataInputStream.readShort();
            this.stats[1] = dataInputStream.readShort();
            this.stats[2] = dataInputStream.readByte() & 0xFF;
            this.stats[3] = dataInputStream.readByte() & 0xFF;
            this.stats[4] = dataInputStream.readByte() & 0xFF;
            this.stats[5] = dataInputStream.readByte() & 0xFF;
            this.stats[6] = dataInputStream.readByte() & 0xFF;
            this.stats[7] = dataInputStream.readByte() & 0xFF;
            this.weapon = dataInputStream.readByte() & 0xFF;
        } else {
            this.stats[0] = dataInputStream.readShort();
        }
    }

    public void saveState(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (bl) {
            dataOutputStream.writeShort(this.stats[0]);
            dataOutputStream.writeShort(this.stats[1]);
            dataOutputStream.writeByte(this.stats[2]);
            dataOutputStream.writeByte(this.stats[3]);
            dataOutputStream.writeByte(this.stats[4]);
            dataOutputStream.writeByte(this.stats[5]);
            dataOutputStream.writeByte(this.stats[6]);
            dataOutputStream.writeByte(this.stats[7]);
            dataOutputStream.writeByte(this.weapon);
        } else {
            dataOutputStream.writeShort(this.stats[0]);
        }
    }

    public static void calcCombat(CombatEntity combatEntity, Entity entity, boolean bl, int n, int n2) {
        Combat.crDamage = 0;
        Combat.crArmorDamage = 0;
        CombatEntity combatEntity2 = !bl ? entity.monster.ce : Player.ce;
        int n3 = CombatEntity.calcHit(combatEntity, combatEntity2, bl, n, false);
        if ((n3 & 0x1007) == 0) {
            return;
        }
        if (!bl && combatEntity.weapon == 1) {
            Player.usedChainsaw(true);
        }
        int n4 = 0;
        n4 = CombatEntity.calcDamage(combatEntity, entity, combatEntity2, bl, n2);
        if (n4 == 0 && Combat.crArmorDamage == 0) {
            n3 |= 0x100;
        }
        Combat.crFlags = n3;
        Combat.crDamage = n4;
    }

    public static int calcHit(CombatEntity combatEntity, CombatEntity combatEntity2, boolean bl, int n, boolean bl2) {
        int n2 = Combat.attackerWeapon;
        int n3 = Combat.attackerWeaponId;
        int n4 = 0;
        Entity entity = Combat.curTarget;
        byte by = entity == null ? (byte)1 : entity.def.eType;
        if (Combat.oneShotCheat && !bl) {
            return Combat.crFlags |= 1;
        }
        if ((1 << n3 & 0x200) != 0) {
            if (by == 2) {
                int n5 = entity.getSprite();
                int n6 = Canvas.zoomCollisionX - Render.mapSprites[Render.S_X + n5];
                int n7 = Canvas.zoomCollisionY - Render.mapSprites[Render.S_Y + n5];
                int n8 = Canvas.zoomCollisionZ - Render.mapSprites[Render.S_Z + n5];
                int n9 = Render.mapSpriteInfo[n5] >> 8 & 0xF0;
                int[][] nArray = Render.getImageFrameBounds(entity.def.tileIndex, 3, 2, 0);
                int n10 = -1;
                for (int i = 0; i < 3; ++i) {
                    if (n6 <= nArray[i][0] || n6 >= nArray[i][1] || n7 <= nArray[i][0] || n7 >= nArray[i][1] || n8 <= nArray[i][2] || n8 >= nArray[i][3]) continue;
                    n10 = i;
                    break;
                }
                if (n10 != -1) {
                    Combat.crFlags = n10 == 0 || n9 == 16 ? (Combat.crFlags |= 2) : (n10 == 1 ? (Combat.crFlags |= 1) : (Combat.crFlags |= 5));
                }
            }
            return Combat.crFlags;
        }
        boolean bl3 = false;
        int n11 = Combat.WorldDistToTileDist(n);
        if (n11 < Combat.weapons[n2 + 2]) {
            n4 = Combat.weapons[n2 + 2] - n11;
        } else if (n11 > Combat.weapons[n2 + 3]) {
            if (n3 == 7 || n3 == 2) {
                bl3 = true;
            }
            n4 = n11 - Combat.weapons[n2 + 3];
        } else {
            n4 = 0;
        }
        if ((Combat.crFlags & 0x10) != 0) {
            n4 = 0;
        } else if ((Combat.weapons[n2 + 2] == Combat.weapons[n2 + 3] || (Combat.crFlags & 0x40) != 0) && n4 > 0) {
            return Combat.crFlags |= 0x400;
        }
        if (bl2 |= combatEntity.weapon == 13) {
            return Combat.crFlags |= 1;
        }
        int n12 = combatEntity.getStat(5);
        int n13 = combatEntity2.getStat(6);
        if ((1 << n3 & 0x800) == 0) {
            n13 = n13 * 96 >> 8;
        }
        Combat.crHitChance = ((n12 -= n13) << 8) / 100;
        if ((Combat.crHitChance -= 16 * n4) < 1) {
            Combat.crHitChance = 1;
        }
        int n14 = App.nextByte();
        if (Combat.punchingMonster != 0) {
            if (Combat.animLoopCount == 1 || !Combat.punchMissed) {
                n14 = 0;
            } else if (Combat.punchMissed) {
                Combat.playerMissRepetition = 0;
                n14 = 255;
            }
        }
        int n15 = 1;
        if ((!bl && Combat.playerMissRepetition < n15 || bl && Combat.monsterMissRepetition < 2) && n14 > Combat.crHitChance && (bl || Canvas.loadMapID < 8 || Combat.tileDist > 1)) {
            if (bl) {
                ++Combat.monsterMissRepetition;
            } else {
                ++Combat.playerMissRepetition;
            }
            return Combat.crFlags;
        }
        if (bl && Player.statusEffects[18] > 0) {
            Player.statusEffects[18] = Player.statusEffects[18] - 1;
            if (Player.statusEffects[18] == 0) {
                Player.removeStatusEffect(0);
            }
            Player.translateStatusEffects();
            Combat.crFlags |= 0x100;
        }
        if (bl) {
            Combat.monsterMissRepetition = 0;
        } else {
            Combat.playerMissRepetition = 0;
        }
        if (bl3) {
            return Combat.crFlags |= 4;
        }
        Combat.crCritChance = !bl || Game.difficulty == 4 ? Combat.crHitChance / 20 : 0;
        n14 = App.nextByte();
        if (n14 < Combat.crCritChance) {
            return Combat.crFlags |= 2;
        }
        return Combat.crFlags |= 1;
    }

    public static int calcDamage(CombatEntity combatEntity, Entity entity, CombatEntity combatEntity2, boolean bl, int n) {
        int n2 = combatEntity.weapon * 9;
        int n3 = Combat.weapons[n2 + 0] & 0xFF;
        int n4 = Combat.weapons[n2 + 1] & 0xFF;
        if (bl && Player.buffs[0] > 0) {
            Combat.crDamage = n4;
            return Combat.crDamage;
        }
        if (Game.difficulty == 4) {
            n3 -= n3 >> 2;
        }
        if ((Combat.crFlags & 2) != 0 || (Combat.crFlags & 0x2000) != 0) {
            n3 = n4 * 2;
        } else if ((Combat.crFlags & 4) != 0) {
            n3 = n4 / 2;
        } else if (n4 != n3) {
            n3 += App.nextByte() % (n4 - n3);
        }
        if ((Combat.crFlags & 0x20) == 0) {
            n3 = !bl ? (n3 += 3 * (combatEntity.getStatPercent(4) * n3 >> 8)) : (n3 += combatEntity.getStatPercent(4) * n3 >> 8);
        }
        int n5 = 0;
        if (!bl) {
            int n6;
            if (Player.buffs[8] > 0) {
                n6 = (Player.buffs[23] << 8) / 100;
                n3 += n6 * n3 >> 8;
            }
            n6 = Combat.getWeaponWeakness(combatEntity.weapon, entity.def.eSubType, entity.def.parm);
            if (combatEntity.weapon == 2) {
                if (entity.def.eSubType == 2) {
                    n6 = Game.difficulty == 4 ? (n6 <<= 1) : (n6 <<= 2);
                } else if (entity.def.eSubType == 0) {
                    n6 = 0;
                }
            }
            n3 = n6 * n3 >> 8;
        } else {
            if (!Player.isFamiliar) {
                int n7 = 171 * n3 >> 8;
                n5 = Math.min((n7 + 1) / 2, combatEntity2.getStat(2));
                n3 -= 2 * n5;
            } else {
                n3 = Player.familiarType == 1 || Player.familiarType == 2 ? n3 * 7 / 8 : n3 * 5 / 8;
            }
            if ((1 << combatEntity.weapon & 0x900000) != 0 && Player.buffs[9] > 0) {
                n5 = 0;
                n3 = 0;
            }
        }
        n3 -= combatEntity2.getStatPercent(3) * n3 >> 8;
        if (Combat.oneShotCheat && !bl) {
            n3 = 999;
        }
        Combat.crArmorDamage = n5;
        Combat.crDamage = n3;
        return n3;
    }
}

