/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

class MenuList
extends List
implements CommandListener {
    private DarkHorde_Midlet midlet;
    private Command exitCommand;
    private boolean gameActive = false;
    public boolean soundActive = false;
    private boolean loadActive = false;
    private boolean saveActive = false;
    private Dictionary dict;

    MenuList(DarkHorde_Midlet darkHorde_Midlet, Dictionary dictionary) {
        super("Dark Horde", 3);
        this.midlet = darkHorde_Midlet;
        this.dict = dictionary;
        this.append(this.dict.getString(Dictionary.MENU_1), null);
        this.append(this.dict.getString(Dictionary.MENU_6), null);
        this.append(this.dict.getString(Dictionary.MENU_4), null);
        this.exitCommand = new Command(this.dict.getString(Dictionary.MENU_7), 7, 1);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    void setGameActive(boolean bl) {
        if (bl && !this.gameActive) {
            this.gameActive = true;
            this.insert(0, this.dict.getString(Dictionary.MENU_0), null);
        } else if (!bl && this.gameActive) {
            this.gameActive = false;
            this.delete(0);
        }
    }

    void setSoundActive(boolean bl) {
        if (bl && !this.soundActive) {
            this.soundActive = true;
            if (this.gameActive) {
                this.delete(2);
                this.insert(2, this.dict.getString(Dictionary.MENU_5), null);
            } else {
                this.delete(1);
                this.insert(1, this.dict.getString(Dictionary.MENU_5), null);
            }
        } else if (!bl && this.soundActive) {
            this.soundActive = false;
            if (this.gameActive) {
                this.delete(2);
                this.insert(2, this.dict.getString(Dictionary.MENU_6), null);
            } else {
                this.delete(1);
                this.insert(1, this.dict.getString(Dictionary.MENU_6), null);
            }
        }
        this.midlet.setSound(this.soundActive);
    }

    void setLoadActive(boolean bl) {
        if (bl == this.loadActive) {
            return;
        }
        if (bl && !this.loadActive) {
            this.loadActive = true;
            if (this.gameActive) {
                this.insert(3, this.dict.getString(Dictionary.MENU_2), null);
            } else {
                this.insert(2, this.dict.getString(Dictionary.MENU_3), null);
            }
        } else if (!bl && this.loadActive) {
            this.loadActive = false;
            if (this.gameActive) {
                this.delete(3);
            } else {
                this.delete(2);
            }
        }
    }

    void setSaveActive(boolean bl) {
        if (this.saveActive == bl) {
            return;
        }
        this.saveActive = bl;
        int n = 2;
        if (this.gameActive) {
            ++n;
        }
        if (this.loadActive) {
            ++n;
        }
        if (this.saveActive) {
            this.insert(n, this.dict.getString(Dictionary.MENU_3), null);
        } else {
            this.delete(n);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            int n = this.getSelectedIndex();
            if (n != -1) {
                if (!this.gameActive) {
                    ++n;
                }
                switch (n) {
                    case 0: {
                        this.midlet.menuListContinue();
                        break;
                    }
                    case 1: {
                        this.midlet.menuListNewGame(true);
                        break;
                    }
                    case 2: {
                        this.setSoundActive(!this.soundActive);
                        break;
                    }
                    case 3: {
                        if (this.loadActive) {
                            this.midlet.menuListNewGame(false);
                            break;
                        }
                        if (this.saveActive) {
                            this.midlet.menuListSaveGame();
                            break;
                        }
                        this.midlet.menuListInstructions();
                        break;
                    }
                    case 4: {
                        if (this.saveActive && this.loadActive) {
                            this.midlet.menuListSaveGame();
                            break;
                        }
                        this.midlet.menuListInstructions();
                        break;
                    }
                    case 5: {
                        this.midlet.menuListInstructions();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (command == this.exitCommand) {
            this.midlet.menuListQuit();
        }
    }
}

