/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.BaseRMS;
import game.DanAndMax;
import game.GameScreen;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Settings
extends BaseRMS {
    public int soundMode = 1;
    public int _currentRoom;
    public int _playerX;
    public int _playerY;
    public int[] _itemStates = new int[165];
    public int[] _itemVisible = new int[165];
    public int[] _roomStates = new int[25];
    public int[] _mapAllow = new int[4];
    public int[] _phoneStates = new int[5];
    public int[] _phoneBook = new int[5];
    public int _phoneLength;
    private DanAndMax midlet;
    public int[] _invItems = new int[20];
    public int _invCount;
    public int _danVisible;
    public int _maxVisible;
    public long _code;

    public Settings(DanAndMax midlet, String rmsName) {
        super(rmsName);
        this.midlet = midlet;
    }

    public void loadSettings() throws Exception {
        try {
            this.open();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception("Error loading Settings" + e);
        }
    }

    public void updateSettings() throws Exception {
        try {
            this.open();
            this._currentRoom = GameScreen.currentRoom;
            this._playerX = GameScreen.maxSprite.getX();
            this._playerY = GameScreen.maxSprite.getY();
            System.arraycopy(GameScreen.data.itemStates, 0, this._itemStates, 0, this._itemStates.length);
            System.arraycopy(GameScreen.data.itemVisible, 0, this._itemVisible, 0, this._itemVisible.length);
            System.arraycopy(GameScreen.data.invItems, 0, this._invItems, 0, this._invItems.length);
            System.arraycopy(GameScreen.data.roomStates, 0, this._roomStates, 0, this._roomStates.length);
            System.arraycopy(GameScreen.data.mapAllow, 0, this._mapAllow, 0, this._mapAllow.length);
            System.arraycopy(GameScreen.data.phoneStates, 0, this._phoneStates, 0, this._phoneStates.length);
            System.arraycopy(GameScreen.data.phoneBook, 0, this._phoneBook, 0, this._phoneBook.length);
            this._phoneLength = GameScreen.data.phoneLength;
            this._invCount = GameScreen.data.invCount;
            this._danVisible = GameScreen.dan.getVisible();
            this._maxVisible = GameScreen.maxSprite.getVisible();
            this._code = this.midlet.gameScreen.code;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::updateSettings::" + e);
        }
    }

    protected void loadData() throws Exception {
        try {
            byte[] record = this.getRecordStore().getRecord(1);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this._currentRoom = istream.readInt();
            this._playerX = istream.readInt();
            this._playerY = istream.readInt();
            int i = 0;
            while (i < this._itemStates.length) {
                this._itemStates[i] = istream.readInt();
                ++i;
            }
            int i2 = 0;
            while (i2 < this._itemVisible.length) {
                this._itemVisible[i2] = istream.readInt();
                ++i2;
            }
            int i3 = 0;
            while (i3 < this._roomStates.length) {
                this._roomStates[i3] = istream.readInt();
                ++i3;
            }
            int i4 = 0;
            while (i4 < this._mapAllow.length) {
                this._mapAllow[i4] = istream.readInt();
                ++i4;
            }
            int i5 = 0;
            while (i5 < this._phoneStates.length) {
                this._phoneStates[i5] = istream.readInt();
                ++i5;
            }
            int i6 = 0;
            while (i6 < this._phoneBook.length) {
                this._phoneBook[i6] = istream.readInt();
                ++i6;
            }
            this._phoneLength = istream.readInt();
            int i7 = 0;
            while (i7 < this._invItems.length) {
                this._invItems[i7] = istream.readInt();
                ++i7;
            }
            this._invCount = istream.readInt();
            this._danVisible = istream.readInt();
            this._maxVisible = istream.readInt();
            this._code = istream.readLong();
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::loadData::" + e);
        }
    }

    protected void createDefaultData() throws Exception {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this._currentRoom);
            ostream.writeInt(this._playerX);
            ostream.writeInt(this._playerY);
            int i = 0;
            while (i < this._itemStates.length) {
                ostream.writeInt(this._itemStates[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this._itemVisible.length) {
                ostream.writeInt(this._itemVisible[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < this._roomStates.length) {
                ostream.writeInt(this._roomStates[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < this._mapAllow.length) {
                ostream.writeInt(this._mapAllow[i4]);
                ++i4;
            }
            int i5 = 0;
            while (i5 < this._phoneStates.length) {
                ostream.writeInt(this._phoneStates[i5]);
                ++i5;
            }
            int i6 = 0;
            while (i6 < this._phoneBook.length) {
                ostream.writeInt(this._phoneBook[i6]);
                ++i6;
            }
            ostream.writeInt(this._phoneLength);
            int i7 = 0;
            while (i7 < this._invItems.length) {
                ostream.writeInt(this._invItems[i7]);
                ++i7;
            }
            ostream.writeInt(this._invCount);
            ostream.writeInt(this._danVisible);
            ostream.writeInt(this._maxVisible);
            ostream.writeLong(this._code);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().addRecord(record, 0, record.length);
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::createDefaultData::" + e);
        }
    }

    protected void updateData() throws Exception {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(12);
            DataOutputStream ostream = new DataOutputStream(bstream);
            System.out.println("save room " + this._currentRoom);
            System.out.println("save x " + this._playerX);
            System.out.println("save y " + this._playerY);
            ostream.writeInt(this._currentRoom);
            ostream.writeInt(this._playerX);
            ostream.writeInt(this._playerY);
            int i = 0;
            while (i < this._itemStates.length) {
                ostream.writeInt(this._itemStates[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this._itemVisible.length) {
                ostream.writeInt(this._itemVisible[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < this._roomStates.length) {
                ostream.writeInt(this._roomStates[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < this._mapAllow.length) {
                ostream.writeInt(this._mapAllow[i4]);
                ++i4;
            }
            int i5 = 0;
            while (i5 < this._phoneStates.length) {
                ostream.writeInt(this._phoneStates[i5]);
                ++i5;
            }
            int i6 = 0;
            while (i6 < this._phoneBook.length) {
                ostream.writeInt(this._phoneBook[i6]);
                ++i6;
            }
            ostream.writeInt(this._phoneLength);
            int i7 = 0;
            while (i7 < this._invItems.length) {
                ostream.writeInt(this._invItems[i7]);
                ++i7;
            }
            ostream.writeInt(this._invCount);
            ostream.writeInt(this._danVisible);
            ostream.writeInt(this._maxVisible);
            ostream.writeLong(this._code);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().setRecord(1, record, 0, record.length);
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::updateData::" + e);
        }
    }
}

