/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;
import game.gameData;
import game.itemAction;
import game.itemState;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class peopleClass {
    private int framesW;
    private int framesH;
    private int dirX;
    private int dirY;
    private int joinPos;
    private int[][][] dirIndex = new int[][][]{new int[][]{{6, 6, 14, 14}, {1, 1, 9, 9}, {5, 5, 13, 13}}, new int[][]{{2, 2, 10, 10}, {0, 0, 8, 8}, {3, 3, 11, 11}}, new int[][]{{7, 7, 15, 15}, {0, 0, 8, 8}, {4, 4, 12, 12}}};
    private int itemID;
    private String itemType;
    private int itemBottom;
    private String spriteName;
    private boolean backGround;
    private boolean inventory;
    private int frames;
    private itemState[] statesArray;
    private int[] hitZone;
    private Image image;
    private Sprite sprite;
    private int itemX;
    private int itemY = 0;
    private int cX;
    private int cY = 0;
    private boolean itemReady;

    public peopleClass(int _itemID, String _itemType, String _spriteName, int _frames, int[] _hitZone, int posX, int posY) {
        this.itemID = _itemID;
        this.itemType = _itemType;
        this.spriteName = _spriteName;
        this.frames = _frames;
        this.inventory = false;
        this.itemX = posX;
        this.hitZone = new int[_hitZone.length];
        System.arraycopy(_hitZone, 0, this.hitZone, 0, _hitZone.length);
        if (posY < 0) {
            this.itemY = -posY;
            this.backGround = true;
        } else {
            this.itemY = posY;
            this.backGround = false;
        }
        this.itemReady = false;
    }

    public void setupStates(String _states, String _labels, String _actions) {
        String[] states = gameData.split(_states, ",");
        String[] labels = gameData.split(_labels, "#");
        String[] actions = gameData.split(_actions, "#");
        this.statesArray = new itemState[states.length];
        int st = 0;
        while (st < states.length) {
            int[] statesPar = gameData.splitInt(states[st], ".");
            String[] labelsPar = gameData.split(labels[st], "$");
            String[] actionsTmp = gameData.split(actions[st], "$");
            itemAction[] actionsPar = new itemAction[actionsTmp.length];
            int act = 0;
            while (act < actionsTmp.length) {
                String[] actCur = gameData.split(actionsTmp[act], "=");
                actionsPar[act] = new itemAction(actCur[0], actCur[1]);
                ++act;
            }
            this.statesArray[st] = new itemState(statesPar, labelsPar, actionsPar);
            labelsPar = null;
            statesPar = null;
            actionsTmp = null;
            ++st;
        }
        actions = null;
        labels = null;
        states = null;
        this.setState(GameScreen.data.itemStates[this.itemID]);
    }

    public void erase() {
        this.image = null;
        this.sprite = null;
        this.itemReady = false;
    }

    public void init() {
        this.image = null;
        this.sprite = null;
        try {
            this.image = Image.createImage((String)("/images/peoples/" + this.spriteName + ".png"));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage() + "error in spriteName " + this.spriteName);
        }
        this.sprite = new Sprite(this.image, this.image.getWidth() / this.frames, this.image.getHeight());
        this.itemBottom = this.itemY + this.sprite.getHeight();
        this.itemReady = true;
        this.sprite.setFrameSequence(this.statesArray[GameScreen.data.itemStates[this.itemID]].getFrames());
    }

    public int getBottom() {
        return this.itemBottom;
    }

    public String getType() {
        return this.itemType;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public int getID() {
        return this.itemID;
    }

    public String getLabel() {
        return this.statesArray[GameScreen.data.itemStates[this.itemID]].getLabel();
    }

    public itemAction[] getAction() {
        return this.statesArray[GameScreen.data.itemStates[this.itemID]].getAction();
    }

    public void setState(int newState) {
        if (newState < this.statesArray.length) {
            if (this.itemReady) {
                this.sprite.setFrameSequence(this.statesArray[GameScreen.data.itemStates[this.itemID]].getFrames());
            }
        } else {
            System.out.println("trying to go bad state " + newState + " for item " + this.itemID);
        }
    }

    public void setPosition(int posX, int posY) {
        this.cX = posX;
        this.cY = posY;
        this.sprite.setPosition(posX + this.itemX, posY + this.itemY);
    }

    public void render(Graphics g) {
        if (this.itemReady && GameScreen.data.itemVisible[this.itemID] == 1) {
            g.setColor(0xFF0000);
            g.fillRect(this.cX + this.hitZone[0], this.cY + this.hitZone[1], this.hitZone[2], this.hitZone[3]);
            this.sprite.paint(g);
            this.sprite.nextFrame();
        }
    }

    public boolean isBackGround() {
        return this.backGround;
    }

    public boolean isInventory() {
        return this.inventory;
    }

    public void setInventory(boolean _inventory) {
        this.inventory = _inventory;
    }

    public boolean hitTest(int x, int y) {
        int cTestX = this.hitZone[0];
        int cTestY = this.hitZone[1];
        int cTestX1 = cTestX + this.hitZone[2];
        int cTestY1 = cTestY + this.hitZone[3];
        return x >= cTestX && x < cTestX1 && y >= cTestY && y < cTestY1 && GameScreen.data.itemVisible[this.itemID] == 1;
    }
}

