/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Loader
extends MyScreen {
    private Game game;
    private byte gamestate;
    private byte percentage;
    private boolean introLoaded = false;
    private int pct;
    private int x;
    private int y;
    private Image imgLoading;
    public boolean isAlive;
    public short width;
    public short height;

    public Loader(Game midlet) {
        this.game = midlet;
        this.introLoaded = false;
        this.gamestate = 0;
        this.width = (short)(this.game.resw / 4 * 3);
        this.Load();
        this.height = (short)(this.game.resh / 20 * 1);
        this.reset();
    }

    public void Load() {
        try {
            this.imgLoading = Image.createImage((String)(Game.DATA_PATH + this.game.dpath + "loading.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Free() {
        this.imgLoading = null;
    }

    private void reset() {
        this.pct = -1;
        this.isAlive = false;
        this.percentage = (byte)-1;
    }

    public void SetPosition(int ix, int iy) {
        this.x = ix;
        this.y = iy;
    }

    public void Start(byte gameState) {
        this.reset();
        this.gamestate = gameState;
        this.isAlive = true;
        this.game.setGameState((byte)3);
    }

    private void LoadPlay(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 90: {
                this.game.playscreen = new PlayScreen(this.game);
                break;
            }
        }
    }

    private void LoadTitle(byte percent) {
        switch (this.percentage) {
            case 10: {
                if (this.introLoaded) break;
                break;
            }
            case 20: {
                this.game.titlescreen = new TitleScreen(this.game);
                break;
            }
        }
    }

    private void LoadStory(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 50: {
                this.game.storyscreen = new StoryScreen(this.game);
                break;
            }
        }
    }

    private void LoadEnding(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 50: {
                this.game.endingscreen = new EndingScreen(this.game);
                break;
            }
        }
    }

    private void LoadDemo(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 50: {
                this.game.demoscreen = new DemoScreen(this.game);
                break;
            }
        }
    }

    private void LoadMission(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 50: {
                if (this.game.sinfo[this.game.infoSlot].training[0] && this.game.sinfo[this.game.infoSlot].training[1] && this.game.sinfo[this.game.infoSlot].training[2]) {
                    this.game.missionscreen = new MissionScreen(this.game, 1);
                    break;
                }
                this.game.missionscreen = new MissionScreen(this.game, 0);
                break;
            }
        }
    }

    private void LoadTorcher(byte percent) {
        switch (this.percentage) {
            case 10: {
                break;
            }
            case 50: {
                this.game.torcherscreen = new TorcherScreen(this.game);
                break;
            }
        }
    }

    public void Render(Graphics g) {
        if (!this.isAlive) {
            return;
        }
        this.game.render.ClearScreen(g, 0, 0, 0);
        g.drawImage(this.imgLoading, this.game.wcenter - this.imgLoading.getWidth() / 2, this.game.hcenter - this.imgLoading.getHeight() / 2, 20);
        this.game.util.pause(100L);
        if (this.pct < 0) {
            this.pct = 0;
            this.percentage = 0;
            if (this.game.popup != null) {
                this.game.popup.drawBackground = true;
                this.game.popup.drawBorder = true;
            }
        } else {
            switch (this.gamestate) {
                case 2: {
                    this.LoadPlay(this.percentage);
                    break;
                }
                case 1: {
                    this.LoadTitle(this.percentage);
                    break;
                }
                case 4: {
                    this.LoadStory(this.percentage);
                    break;
                }
                case 5: {
                    this.LoadMission(this.percentage);
                    break;
                }
                case 6: {
                    this.LoadTorcher(this.percentage);
                    break;
                }
                case 7: {
                    this.LoadEnding(this.percentage);
                    break;
                }
                case 8: {
                    this.LoadDemo(this.percentage);
                }
            }
            this.percentage = (byte)(this.percentage + 10);
            if (this.percentage > 100) {
                this.percentage = (byte)100;
                this.isAlive = false;
                this.introLoaded = true;
                this.game.setGameState(this.gamestate);
                return;
            }
            this.pct = this.width * this.percentage / 100;
        }
        g.setColor(0, 0, 255);
        g.fillRect(this.x, this.y, (int)this.width, (int)this.height);
        g.setColor(255, 0, 0);
        g.fillRect(this.x, this.y, this.pct, (int)this.height);
        g.setColor(255, 255, 255);
        g.drawRect(this.x, this.y, (int)this.width, (int)this.height);
    }

    public void Process(int arg0) {
    }

    public void keyReleased(int arg0) {
    }

    public void keyPressed(int arg0) {
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }
}

