/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import com.dvidearts.jengine.MyColor;
import javax.microedition.lcdui.Graphics;

public final class Wipe {
    public static final byte WIPE_OUT = 0;
    public static final byte WIPE_IN = 1;
    public static final byte WIPE_RIGHT = 2;
    public static final byte WIPE_LEFT = 3;
    public static final byte WIPE_BLINDS_OUT = 4;
    public static final byte WIPE_BLINDS_IN = 5;
    public static final byte WIPE_SQUARES_IN = 6;
    public static final byte WIPE_SQUARES_OUT = 7;
    public static final byte WIPE_CLOSE = 8;
    public static final byte WIPE_OPEN = 9;
    private boolean isActive = false;
    private boolean complete = false;
    private boolean firstPass = false;
    private short wipeType;
    private short wipespeed;
    private short numdivisions;
    private short lastPassCounter;
    private int idx;
    private int idy;
    private int idw;
    private int idh;
    private int x;
    private int y;
    private int resw;
    private int resh;
    private MyColor color = MyColor.BLACK;

    public Wipe(int speed, int screenX, int screenY, int screenW, int screenH) {
        this.reset();
        this.setSpeed(speed);
        this.setDimention(screenX, screenY, screenW, screenH);
    }

    public void setDimention(int screenX, int screenY, int screenW, int screenH) {
        this.idx = screenX;
        this.idy = screenY;
        this.idw = screenW;
        this.idh = screenH;
    }

    public void setColor(MyColor c2) {
        this.color = c2;
    }

    public MyColor getColor() {
        return this.color;
    }

    public void setSpeed(int speed) {
        this.wipespeed = (short)speed;
    }

    public void reset() {
        this.isActive = false;
        this.complete = false;
        this.firstPass = true;
        this.lastPassCounter = 0;
    }

    public short getWipeType() {
        return this.wipeType;
    }

    public void In() {
        this.reset();
        this.wipeType = 1;
        this.isActive = true;
    }

    public void Out() {
        this.reset();
        this.wipeType = 0;
        this.isActive = true;
    }

    public void Right() {
        this.reset();
        this.wipeType = (short)2;
        this.isActive = true;
    }

    public void Left() {
        this.reset();
        this.wipeType = (short)3;
        this.isActive = true;
    }

    public void BlindsIn(short numBlinds) {
        this.reset();
        if (numBlinds < 1) {
            numBlinds = 1;
        }
        this.numdivisions = numBlinds;
        this.wipeType = (short)5;
        this.isActive = true;
    }

    public void BlindsOut(short numBlinds) {
        this.reset();
        if (numBlinds < 1) {
            numBlinds = 1;
        }
        this.numdivisions = numBlinds;
        this.wipeType = (short)4;
        this.isActive = true;
    }

    public void SquaresIn(short numSquares) {
        this.reset();
        if (numSquares < 1) {
            numSquares = 1;
        }
        this.numdivisions = numSquares;
        this.wipeType = (short)6;
        this.isActive = true;
    }

    public void SquaresOut(short numSquares) {
        this.reset();
        if (numSquares < 1) {
            numSquares = 1;
        }
        this.numdivisions = numSquares;
        this.wipeType = (short)7;
        this.isActive = true;
    }

    public void Close() {
        this.reset();
        this.wipeType = (short)8;
        this.isActive = true;
    }

    public void Open() {
        this.reset();
        this.wipeType = (short)9;
        this.isActive = true;
    }

    public void paint(Graphics g) {
        if (!this.isActive) {
            return;
        }
        int wdist = this.idw / this.wipespeed;
        int hdist = this.idh / this.wipespeed;
        switch (this.wipeType) {
            case 8: {
                int hw = this.idw / 2;
                if (this.firstPass) {
                    this.x = this.idx + this.idw;
                    this.y = this.idy;
                    this.resw = 0;
                    this.resh = this.idh;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                this.resw += wdist;
                if (this.resw >= hw) {
                    this.complete = true;
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    break;
                }
                g.fillRect(this.idx, this.idy, this.resw, this.idh);
                g.fillRect(this.idx + this.idw - this.resw, this.idy, this.resw, this.idh);
                break;
            }
            case 9: {
                int hw = this.idw / 2;
                if (this.firstPass) {
                    this.x = this.idx + hw;
                    this.y = this.idy;
                    this.resw = hw;
                    this.resh = this.idh;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                this.resw -= wdist;
                if (this.resw <= 0) {
                    this.complete = true;
                    break;
                }
                g.fillRect(this.idx, this.idy, this.resw, this.idh);
                g.fillRect(this.idx + this.idw - this.resw, this.idy, this.resw, this.idh);
                break;
            }
            case 6: {
                int sw = this.idw / this.numdivisions;
                int sh = this.idh / this.numdivisions;
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = sw;
                    this.resh = sh;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                if (this.resw <= 0 || this.resh <= 0) {
                    this.complete = true;
                    break;
                }
                int r = 0;
                while (r < this.numdivisions) {
                    int c2 = 0;
                    while (c2 < this.numdivisions) {
                        g.fillRect(this.x + sw * c2 + sw / 2 - this.resw / 2, this.y + sh * r + sh / 2 - this.resh / 2, this.resw, this.resh);
                        ++c2;
                    }
                    ++r;
                }
                wdist = sw / this.wipespeed;
                hdist = sh / this.wipespeed;
                if (wdist < 1) {
                    wdist = 1;
                }
                if (hdist < 1) {
                    hdist = 1;
                }
                if (wdist > sw) {
                    wdist = sw;
                }
                if (hdist > sh) {
                    hdist = sh;
                }
                this.resw -= wdist;
                this.resh -= hdist;
                break;
            }
            case 7: {
                int sw = this.idw / this.numdivisions;
                int sh = this.idh / this.numdivisions;
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = 0;
                    this.resh = 0;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                if (this.resw >= sw || this.resh >= sh) {
                    this.complete = true;
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    break;
                }
                int r = 0;
                while (r < this.numdivisions) {
                    int c3 = 0;
                    while (c3 < this.numdivisions) {
                        g.fillRect(this.x + sw * c3 + sw / 2 - this.resw / 2, this.y + sh * r + sh / 2 - this.resh / 2, this.resw, this.resh);
                        ++c3;
                    }
                    ++r;
                }
                wdist = sw / this.wipespeed;
                hdist = sh / this.wipespeed;
                if (wdist < 1) {
                    wdist = 1;
                }
                if (hdist < 1) {
                    hdist = 1;
                }
                if (wdist > sw) {
                    wdist = sw;
                }
                if (hdist > sh) {
                    hdist = sh;
                }
                this.resw += wdist;
                this.resh += hdist;
                break;
            }
            case 5: {
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = this.idw;
                    this.resh = this.idh / this.numdivisions;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                this.y += this.resh / this.wipespeed * 2;
                if (this.y >= this.resh) {
                    this.complete = true;
                    break;
                }
                int i2 = 0;
                while (i2 < this.numdivisions) {
                    int start = i2 * this.resh;
                    g.fillRect(this.idx, start + this.y, this.idw, this.resh - this.y);
                    ++i2;
                }
                break;
            }
            case 4: {
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = this.idw;
                    this.resh = this.idh / this.numdivisions;
                    this.firstPass = false;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                this.y += this.resh / this.wipespeed * 2;
                if (this.y >= this.resh) {
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    this.lastPassCounter = (short)(this.lastPassCounter + 1);
                    if (this.lastPassCounter <= 1) break;
                    this.complete = true;
                    break;
                }
                int i3 = 0;
                while (i3 < this.numdivisions) {
                    int start = i3 * this.resh;
                    g.fillRect(this.idx, start, this.idw, this.y);
                    ++i3;
                }
                break;
            }
            case 2: {
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = this.idw;
                    this.resh = this.idh;
                    this.firstPass = false;
                }
                this.x += wdist * 2;
                if (this.x > this.idx + this.idw) {
                    this.x -= wdist;
                    g.setColor(this.color.r, this.color.g, this.color.b);
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    this.lastPassCounter = (short)(this.lastPassCounter + 1);
                    if (this.lastPassCounter <= 1) break;
                    this.complete = true;
                    break;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                g.fillRect(this.idx, this.idy, this.x, this.idh);
                break;
            }
            case 3: {
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = this.idw;
                    this.resh = this.idh;
                    this.firstPass = false;
                }
                this.resw -= wdist * 2;
                if (this.resw < this.x) {
                    g.setColor(this.color.r, this.color.g, this.color.b);
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    this.lastPassCounter = (short)(this.lastPassCounter + 1);
                    if (this.lastPassCounter <= 1) break;
                    this.complete = true;
                    break;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                g.fillRect(this.resw, this.idy, this.idw, this.idh);
                break;
            }
            case 0: {
                if (this.firstPass) {
                    this.x = this.idx;
                    this.y = this.idy;
                    this.resw = this.idw;
                    this.resh = this.idh;
                    this.firstPass = false;
                }
                this.x += wdist;
                this.y += hdist;
                this.resw -= wdist;
                this.resh -= hdist;
                if (this.x > this.idx + this.idw / 2) {
                    this.x -= wdist;
                    this.y -= hdist;
                    g.setColor(this.color.r, this.color.g, this.color.b);
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    this.lastPassCounter = (short)(this.lastPassCounter + 1);
                    if (this.lastPassCounter <= 1) break;
                    this.complete = true;
                    break;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                g.fillRect(this.idx, this.idy, this.x, this.idh);
                g.fillRect(this.resw, this.idy, this.idw, this.idh);
                g.fillRect(this.idx, this.idy, this.idw, this.y);
                g.fillRect(this.idx, this.resh, this.idw, this.idh);
                break;
            }
            case 1: {
                if (this.firstPass) {
                    this.x = this.idx + this.idw / 2;
                    this.y = this.idy + this.idh / 2;
                    this.resw = this.x;
                    this.resh = this.y;
                    g.setColor(this.color.r, this.color.g, this.color.b);
                    g.fillRect(this.idx, this.idy, this.idw, this.idh);
                    this.firstPass = false;
                }
                this.x -= wdist;
                this.y -= hdist;
                this.resw += wdist;
                this.resh += hdist;
                if (this.x <= this.idx) {
                    this.complete = true;
                    break;
                }
                g.setColor(this.color.r, this.color.g, this.color.b);
                g.fillRect(this.idx, this.idy, this.x - this.idx, this.idh);
                g.fillRect(this.idx, this.idy, this.idw, this.y - this.idy);
                g.fillRect(this.resw, this.idy, this.resw - 2, this.idh);
                g.fillRect(this.idx, this.resh, this.idw, this.resh - 2);
            }
        }
    }

    public boolean IsActive() {
        return this.isActive;
    }

    public boolean isComplete() {
        if (this.complete) {
            this.complete = false;
            this.reset();
            return true;
        }
        return false;
    }
}

