/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.CustomFont;
import com.dvidearts.jengine.MyScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PauseScreen
extends MyScreen {
    private Game game;
    Image imgControls;
    static final byte PS_Y_SPACING = 2;
    static final byte PO_RESUME = 0;
    static final byte PO_STATUS = 1;
    static final byte PO_CONTROLS = 2;
    static final byte PO_MISSION = 3;
    static final byte PO_TITLE = 4;
    static final byte PO_END = 5;
    static final byte PO_TOTAL = 6;
    public boolean isActive;
    public boolean showStatus;
    public boolean showControls;
    public short cursor;
    private int nameY;
    private byte exit;
    public static final byte EXIT_TITLE = 1;
    public static final byte EXIT_MISSION = 2;
    public static final byte EXIT_DEMO = 3;

    public PauseScreen(Game game) {
        this.game = game;
        this.isActive = false;
        this.cursor = 0;
        switch (this.game.buildType) {
            case 2: {
                this.nameY = this.game.y + this.game.cfont.getHeight() * 3;
                break;
            }
            case 0: 
            case 1: {
                this.nameY = this.game.y + this.game.cfont.getHeight() * 5;
            }
        }
        this.Load();
        this.exit = 0;
    }

    public void Load() {
        try {
            this.imgControls = Image.createImage((String)(Game.DATA_PATH + "controls.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Free() {
        this.imgControls = null;
        this.isActive = false;
    }

    public void Show() {
        this.game.popup.setMinWidth(this.game.resw - this.game.FONTW);
        this.cursor = 0;
        this.isActive = true;
        this.showStatus = false;
        this.showControls = false;
        this.game.cmdY = (short)(this.game.y + this.game.render.getOriginalResHeight() - this.game.COMMANDH);
    }

    public void Hide() {
        this.isActive = false;
        this.showStatus = false;
        this.showControls = false;
    }

    public void Render(Graphics graphics) {
        if (this.exit > 0) {
            switch (this.exit) {
                case 2: {
                    if (this.game.sinfo[this.game.infoSlot].currlevel == 13) {
                        this.game.loader.Start((byte)1);
                        break;
                    }
                    this.game.loader.Start((byte)5);
                    break;
                }
                case 1: {
                    this.game.loader.Start((byte)1);
                    break;
                }
                case 3: {
                    this.game.loader.Start((byte)8);
                }
            }
            this.game.LoadSettings();
            return;
        }
        this.game.popup.drawBackground = true;
        this.game.popup.drawBorder = true;
        this.game.popup.center = true;
        graphics.drawImage(this.game.imgBg, this.game.wcenter - this.game.imgBg.getWidth() / 2, this.game.hcenter - this.game.imgBg.getHeight() / 2, 20);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y);
        this.game.sprTextbar.paint(graphics);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y + this.game.render.getOriginalResHeight() - this.game.sprTextbar.getHeight());
        this.game.sprTextbar.paint(graphics);
        if (this.showStatus) {
            this.drawStatus(graphics);
            return;
        }
        if (this.showControls) {
            this.drawControls(graphics);
            return;
        }
        this.game.sprOptions.setFrame(4);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.game.y + this.game.sprTextbar.getHeight() / 2);
        this.game.sprOptions.paint(graphics);
        this.game.cfont.drawStringCentered(graphics, Text.txtRESUME, this.nameY + this.game.cfont.getHeight() * 1, this.game.wcenter);
        this.game.cfont.drawStringCentered(graphics, Text.txtSTATUS, this.nameY + this.game.cfont.getHeight() * 3, this.game.wcenter);
        this.game.cfont.drawStringCentered(graphics, Text.txtCONTROLS, this.nameY + this.game.cfont.getHeight() * 5, this.game.wcenter);
        this.game.cfont.drawStringCentered(graphics, Text.txtQUITTOMISSION, this.nameY + this.game.cfont.getHeight() * 7, this.game.wcenter);
        this.game.cfont.drawStringCentered(graphics, Text.txtQUITTOTITLE, this.nameY + this.game.cfont.getHeight() * 9, this.game.wcenter);
        this.game.cfont.drawStringCentered(graphics, Text.txtENDGAME, this.nameY + this.game.cfont.getHeight() * 11, this.game.wcenter);
        if (!this.game.popup.isActive && this.game.currframe % 10 != 0) {
            switch (this.cursor) {
                case 0: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtRESUME, this.nameY + this.game.cfont2.getHeight() * 1, this.game.wcenter);
                    break;
                }
                case 1: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtSTATUS, this.nameY + this.game.cfont2.getHeight() * 3, this.game.wcenter);
                    break;
                }
                case 2: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtCONTROLS, this.nameY + this.game.cfont2.getHeight() * 5, this.game.wcenter);
                    break;
                }
                case 3: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtQUITTOMISSION, this.nameY + this.game.cfont2.getHeight() * 7, this.game.wcenter);
                    break;
                }
                case 4: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtQUITTOTITLE, this.nameY + this.game.cfont2.getHeight() * 9, this.game.wcenter);
                    break;
                }
                case 5: {
                    this.game.cfont2.drawStringCentered(graphics, Text.txtENDGAME, this.nameY + this.game.cfont2.getHeight() * 11, this.game.wcenter);
                }
            }
        }
        this.game.showFPS(graphics);
    }

    public void drawControls(Graphics graphics) {
        CustomFont customFont = this.game.cfont;
        int n2 = this.game.y + this.game.sprTextbar.getHeight();
        int n3 = 0;
        int n4 = 3;
        graphics.drawImage(this.imgControls, this.game.wcenter - this.imgControls.getWidth() / 2, n2 + (n3 += n4), 20);
        customFont.drawStringCentered(graphics, "Smena igroka:    1", n2 + this.imgControls.getHeight() + (n3 += n4) + customFont.getHeight() * 1, this.game.wcenter);
        customFont.drawStringCentered(graphics, "Sila:          0", n2 + this.imgControls.getHeight() + (n3 += n4) + customFont.getHeight() * 2, this.game.wcenter);
        if (!this.game.popup.isActive) {
            this.game.drawCommand(graphics, (byte)3, (byte)0);
        }
        this.game.showFPS(graphics);
    }

    public void drawStatus(Graphics graphics) {
        int n2 = this.game.x + this.game.smallfont.getWidth();
        int n3 = this.game.y + this.game.render.getOriginalResHeight() - this.game.sprTextbar.getHeight() - this.game.sprCharacters.getHeight();
        if (this.game.buildType != 2) {
            this.game.sprCharacters.setPosition(this.game.x + this.game.resw - this.game.sprCharacters.getWidth(), n3);
            this.game.sprCharacters.setFrame(0);
            this.game.sprCharacters.paint(graphics);
        }
        CustomFont customFont = this.game.smallfont;
        int n4 = 3;
        n3 = this.game.y + this.game.sprTextbar.getHeight() + customFont.getHeight();
        customFont.drawString(graphics, "S+et:             " + this.game.sinfo[this.game.infoSlot].score, n2, n3);
        customFont.drawString(graphics, "Zdorovxe:        " + this.game.sinfo[this.game.infoSlot].maxHealth + " (" + 170 + " Maks)", n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Vrem$:  " + this.game.sinfo[this.game.infoSlot].destructionMaxTime + " (" + 160 + " Maks)", n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Sila oruji$:     " + this.game.sinfo[this.game.infoSlot].shotgunDamage + " (" + 70 + " Maks)", n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Tehn. Povrejdeni$: " + this.game.sinfo[this.game.infoSlot].taserDamage + " (" + 60 + " Maks)", n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Perezar$dka skrytnosti:    " + this.game.sinfo[this.game.infoSlot].stealthMaxTime + " (" + 40 + " Minim.)", n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Smerti:            " + (this.game.sinfo[this.game.infoSlot].numDeaths + this.game.tempNumDeaths), n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Zalojnikov vz$to:  " + (this.game.sinfo[this.game.infoSlot].totalHostages + this.game.newHostages), n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Polu+eno informacii:   " + this.game.sinfo[this.game.infoSlot].hostagesBroken, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Zalojnikov ubito:   " + this.game.sinfo[this.game.infoSlot].hostagesKilled, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Uni+tojeno obxektov: " + this.game.sinfo[this.game.infoSlot].numObjectsDestroyed, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Ohrannikov ubito:     " + this.game.sinfo[this.game.infoSlot].numGuardsKilled, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Ubito skrytnostxq:     " + this.game.sinfo[this.game.infoSlot].stealthKills, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Ubito vzryvami:   " + this.game.sinfo[this.game.infoSlot].explosionKills, n2, n3 += n4 + customFont.getHeight());
        customFont.drawString(graphics, "Ubito wokerom:       " + this.game.sinfo[this.game.infoSlot].taserKills, n2, n3 += n4 + customFont.getHeight());
        n3 += n4 + customFont.getHeight();
        if (this.game.buildType == 2) {
            customFont.drawString(graphics, "Vrem$:", n2, n3);
            customFont.drawString(graphics, "  " + this.game.getTimePlayed(), n2, n3 += n4 + customFont.getHeight());
        } else {
            customFont.drawString(graphics, " Vrem$ igry:       " + this.game.getTimePlayed(), n2, n3);
        }
        if (!this.game.popup.isActive) {
            this.game.drawCommand(graphics, (byte)3, (byte)0);
        }
        this.game.showFPS(graphics);
    }

    public void keyReleased(int n2) {
        if (this.showStatus || this.showControls) {
            switch (this.game.render.getInput()) {
                case '*': {
                    this.doNext();
                    break;
                }
                case '0': {
                    break;
                }
            }
            switch (n2) {
                case 8: {
                    this.doNext();
                }
            }
            return;
        }
        if (!this.isActive) {
            return;
        }
        if (this.game.popup.isActive) {
            int n3 = this.game.popup.keyPressed(n2);
            this.game.popup.getClass();
            if (n3 == 1) {
                switch (this.cursor) {
                    case 3: {
                        this.exit = (byte)2;
                        break;
                    }
                    case 4: {
                        this.exit = 1;
                        break;
                    }
                    case 5: {
                        if (this.game.isDemo) {
                            this.exit = (byte)3;
                            break;
                        }
                        this.game.close();
                    }
                }
            } else {
                this.game.popup.getClass();
                if (n3 == 0) {
                    // empty if block
                }
            }
            switch (n2) {
                default: 
            }
            return;
        }
        switch (n2) {
            case 1: {
                this.cursor = (short)(this.cursor - 1);
                if (this.cursor >= 0) break;
                this.cursor = (short)5;
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.cursor = (short)(this.cursor + 1);
                if (this.cursor < 6) break;
                this.cursor = 0;
                break;
            }
            case 8: {
                this.doNext();
            }
        }
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
        }
    }

    void doNext() {
        switch (this.cursor) {
            case 0: {
                this.Hide();
                break;
            }
            case 1: {
                if (this.showStatus) {
                    this.showStatus = false;
                    break;
                }
                this.showStatus = true;
                break;
            }
            case 2: {
                if (this.showControls) {
                    this.showControls = false;
                    break;
                }
                this.showControls = true;
                break;
            }
            case 3: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtQUITTOMISSION);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
                break;
            }
            case 4: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtQUIT);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
                break;
            }
            case 5: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtENDGAMEQUESTION);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
            }
        }
    }

    public void Process(int n2) {
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
        }
        if (n2 == 0) {
            return;
        }
        switch (n2) {
            case 6: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void keyPressed(int n2) {
    }

    public void commandAction(Command command, Displayable displayable) {
    }
}

