/*
 * Decompiled with CFR 0.152.
 */
package ui;

import docobj.DocEntry;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import math.MathEx;
import ui.App;
import win.ColorItem;

public class FrmEditEntry
implements CommandListener,
ItemStateListener {
    public App app;
    private Form form;
    private final Command CMD_OK;
    private final Command CMD_CANCEL;
    public int index;
    private static final int MAX_NUMERIC = 100;
    private static final String[][] exprLabel = new String[][]{{"y(x)=", ""}, {"r(t)=", ""}, {"x(t)=", "y(t)="}};
    private ChoiceGroup itemKind;
    private TextField[] itemExpr;
    private TextField itemTMin;
    private TextField itemTMax;
    private ColorItem itemColor;
    private ChoiceGroup itemVisible;

    public FrmEditEntry(App app) {
        int n;
        this.app = app;
        this.CMD_OK = new Command(this.app.langPack.get("OK"), 4, 1);
        this.CMD_CANCEL = new Command(this.app.langPack.get("CANCEL"), 2, 2);
        this.itemKind = new ChoiceGroup(this.app.langPack.get("KIND") + ":", 4, this.app.langPack.getArray("ITEMS_KIND"), null);
        this.itemExpr = new TextField[2];
        for (n = 0; n < this.itemExpr.length; ++n) {
            this.itemExpr[n] = new TextField("", "", 50, 524288);
        }
        this.itemTMin = new TextField("min(t)=", "", 100, 5);
        this.itemTMax = new TextField("max(t)=", "", 100, 5);
        this.itemColor = new ColorItem(this.app.langPack.get("COLOR") + ":", 0, this.app.display, this.app.langPack);
        this.itemVisible = this.newCheckBox(this.app.langPack.get("VISIBLE"));
        this.form = new Form(this.app.langPack.get("EDIT"));
        this.form.append((Item)this.itemKind);
        for (n = 0; n < this.itemExpr.length; ++n) {
            this.form.append((Item)this.itemExpr[n]);
        }
        this.form.append((Item)this.itemTMin);
        this.form.append((Item)this.itemTMax);
        this.form.append((Item)this.itemColor);
        this.form.append((Item)this.itemVisible);
        this.form.addCommand(this.CMD_OK);
        this.form.addCommand(this.CMD_CANCEL);
        this.form.setCommandListener((CommandListener)this);
        this.form.setItemStateListener((ItemStateListener)this);
    }

    public void show() {
        this.app.display.setCurrent((Displayable)this.form);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_OK) {
            this.updateEntry();
            this.app.frmFunctions.updateList();
            this.app.frmFunctions.show();
        } else if (command == this.CMD_CANCEL) {
            this.app.frmFunctions.show();
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.itemKind) {
            this.updateLabels();
        }
    }

    public ChoiceGroup newCheckBox(String string) {
        ChoiceGroup choiceGroup = new ChoiceGroup("", 2);
        choiceGroup.append(string, null);
        return choiceGroup;
    }

    private void updateLabels() {
        int n = this.itemKind.getSelectedIndex();
        for (int i = 0; i < this.itemExpr.length; ++i) {
            String string = exprLabel[n][i];
            if (string.length() == 0) {
                string = this.app.langPack.get("UNUSED");
            }
            this.itemExpr[i].setLabel(string);
        }
    }

    public void updateForm() {
        DocEntry docEntry = this.app.doc.getEntry(this.index);
        this.itemKind.setSelectedIndex(docEntry.kind, true);
        for (int i = 0; i < this.itemExpr.length; ++i) {
            this.itemExpr[i].setString(docEntry.exprString[i]);
        }
        this.itemTMin.setString(String.valueOf(docEntry.tMin));
        this.itemTMax.setString(String.valueOf(docEntry.tMax));
        this.itemColor.setColor(docEntry.color);
        this.itemVisible.setSelectedIndex(0, docEntry.visible);
        this.updateLabels();
    }

    public void updateEntry() {
        DocEntry docEntry = this.app.doc.getEntry(this.index);
        docEntry.kind = this.itemKind.getSelectedIndex();
        for (int i = 0; i < this.itemExpr.length; ++i) {
            docEntry.exprString[i] = this.itemExpr[i].getString();
        }
        docEntry.tMin = MathEx.safeParseDouble(this.itemTMin.getString());
        docEntry.tMax = MathEx.safeParseDouble(this.itemTMax.getString());
        docEntry.color = this.itemColor.getColor();
        docEntry.visible = this.itemVisible.isSelected(0);
        docEntry.compile();
        if (docEntry.valid) {
            docEntry.recalcGraph(this.app.doc.window);
        }
    }
}

