/*
 * Decompiled with CFR 0.152.
 */
package docobj;

import docobj.PlotRect;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import math.Complex;
import math.MathEx;
import parse.Expression;

public class DocEntry {
    public static final int MAX_EXPR = 2;
    private static final String DEFAULT_EXPR = "sin(x)";
    private static final int PARAMETRIC_STEPS = 500;
    private static final int EXPLICITE_XRES = 2;
    public String[] exprString = new String[2];
    public int kind;
    public double tMin;
    public double tMax;
    public int color;
    public boolean visible;
    public boolean valid;
    public Expression[] expr = new Expression[2];
    public int lineCount;
    public double[] lines;

    public DocEntry() {
        this.clear();
    }

    public DocEntry clone() {
        DocEntry docEntry = new DocEntry();
        for (int i = 0; i < 2; ++i) {
            docEntry.exprString[i] = this.exprString[i];
            docEntry.expr[i] = this.expr[i];
        }
        docEntry.kind = this.kind;
        docEntry.tMin = this.tMin;
        docEntry.tMax = this.tMax;
        docEntry.color = this.color;
        docEntry.visible = this.visible;
        docEntry.valid = this.valid;
        docEntry.lineCount = this.lineCount;
        docEntry.lines = new double[this.lines.length];
        System.arraycopy(this.lines, 0, docEntry.lines, 0, this.lines.length);
        return docEntry;
    }

    public void clear() {
        for (int i = 0; i < 2; ++i) {
            this.exprString[i] = "";
        }
        this.exprString[0] = DEFAULT_EXPR;
        this.kind = 0;
        this.tMin = 0.0;
        this.tMax = 1.0;
        this.color = new Random().nextInt() & 0xFFFFFF;
        this.visible = true;
        this.valid = false;
        this.lineCount = 0;
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "y(x)=" + this.exprString[0];
            }
            case 1: {
                return "r(t)=" + this.exprString[0];
            }
            case 2: {
                return "x(t)=" + this.exprString[0] + ", y(t)=" + this.exprString[1];
            }
        }
        return "";
    }

    public void compile() {
        this.valid = false;
        try {
            switch (this.kind) {
                case 0: {
                    this.expr[0] = new Expression(this.exprString[0], "x", "");
                    this.valid = this.expr[0].getError() == 0;
                    break;
                }
                case 1: {
                    this.expr[0] = new Expression(this.exprString[0], "t", "");
                    this.valid = this.expr[0].getError() == 0;
                    break;
                }
                case 2: {
                    this.expr[0] = new Expression(this.exprString[0], "t", "");
                    if (this.expr[0].getError() != 0) break;
                    this.expr[1] = new Expression(this.exprString[1], "t", "");
                    this.valid = this.expr[1].getError() == 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recalcGraph(PlotRect plotRect) {
        double d;
        double d2;
        double d3;
        this.lineCount = 0;
        if (!this.valid) {
            return;
        }
        switch (this.kind) {
            case 0: {
                d3 = plotRect.xMin();
                d2 = plotRect.xMax();
                d = MathEx.safeDiv(2.0, plotRect.zoom);
                break;
            }
            default: {
                d3 = this.tMin;
                d2 = this.tMax;
                d = (d2 - d3) / 500.0;
            }
        }
        if (d3 >= d2) {
            return;
        }
        int n = d == 0.0 ? 0 : (int)MathEx.round((d2 - d3) / d);
        this.lines = new double[4 * n];
        double d4 = d3;
        boolean bl = false;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i <= n; ++i) {
            Complex complex;
            double d7 = 0.0;
            double d8 = 0.0;
            Complex complex2 = new Complex(d4, 0.0);
            Complex complex3 = this.expr[0].calculate(complex2, Complex.CX_0);
            boolean bl2 = complex3.isReal();
            if (bl2 && this.kind == 2) {
                complex = this.expr[1].calculate(complex2, Complex.CX_0);
                bl2 = complex.isReal();
            } else {
                complex = null;
            }
            if (bl2) {
                switch (this.kind) {
                    case 0: {
                        d7 = d4;
                        d8 = complex3.r;
                        break;
                    }
                    case 1: {
                        d7 = complex3.r * Math.cos(d4);
                        d8 = complex3.r * Math.sin(d4);
                        break;
                    }
                    case 2: {
                        d7 = complex3.r;
                        d8 = complex.r;
                    }
                }
                if (bl) {
                    int n2 = this.lineCount << 2;
                    this.lines[n2] = d5;
                    this.lines[n2 + 1] = d6;
                    this.lines[n2 + 2] = d7;
                    this.lines[n2 + 3] = d8;
                    ++this.lineCount;
                }
            }
            d4 += d;
            bl = bl2;
            d5 = d7;
            d6 = d8;
        }
    }

    public void paint(Graphics graphics, PlotRect plotRect) {
        if (!this.valid || !this.visible) {
            return;
        }
        graphics.setColor(this.color);
        for (int i = 0; i < this.lineCount; ++i) {
            int n = i << 2;
            graphics.drawLine(plotRect.xToView(this.lines[n]), plotRect.yToView(this.lines[n + 1]), plotRect.xToView(this.lines[n + 2]), plotRect.yToView(this.lines[n + 3]));
        }
    }
}

