/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.MathEx;

public class Complex {
    public static final Complex CX_0 = new Complex(0.0);
    public static final Complex CX_1 = new Complex(1.0);
    public static final Complex CX_I = new Complex(0.0, 1.0);
    public static final Complex CX_NEG_I = new Complex(0.0, -1.0);
    public static final Complex CX_HALF_NEG_I = new Complex(0.0, -0.5);
    public static final Complex CX_E = new Complex(Math.E);
    public static final Complex CX_PI = new Complex(Math.PI);
    public static final Complex CX_HALF_PI = new Complex(1.5707963267948966);
    public static final Complex CX_INF = new Complex(Double.POSITIVE_INFINITY);
    public static final Complex CX_NAN = new Complex(Double.NaN);
    public final double r;
    public final double i;

    public Complex(double d) {
        this.r = d;
        this.i = 0.0;
    }

    public Complex(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        return complex.r == this.r && complex.i == this.i;
    }

    public boolean isReal() {
        return MathEx.isZero(this.i, 1.0E-15) && !MathEx.isInfOrNaN(this.r);
    }

    public int compareTo(Complex complex) {
        return this.r == complex.r ? 0 : (this.r > complex.r ? 1 : -1);
    }

    public String toString() {
        if (this.i == 0.0) {
            return String.valueOf(this.r);
        }
        if (this.r == 0.0) {
            return this.i + "i";
        }
        return this.r + " + " + this.i + "i";
    }

    public double abs() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public double arg() {
        return MathEx.getPolarAngle(this.r, this.i);
    }

    public double sqrlen() {
        return this.r * this.r + this.i * this.i;
    }

    public Complex conj() {
        return new Complex(this.r, -this.i);
    }

    public Complex sign() {
        double d = this.abs();
        if (d == 0.0) {
            return CX_0;
        }
        return this.scale(1.0 / d);
    }

    public boolean isZero() {
        return this.r == 0.0 && this.i == 0.0;
    }

    public Complex floor() {
        return new Complex(Math.floor(this.r), Math.floor(this.i));
    }

    public Complex ceil() {
        return new Complex(Math.ceil(this.r), Math.ceil(this.i));
    }

    public Complex frac() {
        return new Complex(MathEx.frac(this.r), MathEx.frac(this.i));
    }

    public Complex round() {
        return new Complex(MathEx.round(this.r), MathEx.round(this.i));
    }

    public Complex add(Complex complex) {
        return new Complex(this.r + complex.r, this.i + complex.i);
    }

    public Complex neg() {
        return new Complex(-this.r, -this.i);
    }

    public Complex sub(Complex complex) {
        return new Complex(this.r - complex.r, this.i - complex.i);
    }

    public Complex mul(Complex complex) {
        return new Complex(this.r * complex.r - this.i * complex.i, this.r * complex.i + this.i * complex.r);
    }

    public Complex scale(double d) {
        return new Complex(d * this.r, d * this.i);
    }

    public Complex rec() {
        double d = 1.0 / this.sqrlen();
        return new Complex(this.r * d, -this.i * d);
    }

    public Complex div(Complex complex) {
        double d = 1.0 / complex.sqrlen();
        return new Complex((this.r * complex.r + this.i * complex.i) * d, (this.i * complex.r - this.r * complex.i) * d);
    }

    public Complex mod(Complex complex) {
        return this.div(complex).frac().mul(complex);
    }

    public Complex sqr() {
        return new Complex(this.r * this.r - this.i * this.i, 2.0 * this.r * this.i);
    }

    public Complex sqrt() {
        int n = this.i < 0.0 ? -1 : 1;
        double d = this.abs();
        return new Complex(Math.sqrt((d + this.r) * 0.5), (double)n * Math.sqrt((d - this.r) * 0.5));
    }

    public Complex exp() {
        double d = MathEx.exp(this.r);
        return new Complex(d * Math.cos(this.i), d * Math.sin(this.i));
    }

    public Complex log() {
        return new Complex(MathEx.log(this.abs()), this.arg());
    }

    public Complex intPower(int n) {
        if (Math.abs(n) > 20) {
            return this.log().scale(n).exp();
        }
        Complex complex = CX_1;
        for (int i = 0; i < Math.abs(n); ++i) {
            complex = complex.mul(this);
        }
        if (n < 0) {
            return complex.rec();
        }
        return complex;
    }

    public Complex power(Complex complex) {
        if (this.isZero()) {
            return CX_0;
        }
        if (complex.isReal() && complex.r == (double)((int)complex.r) && Math.abs(complex.r) <= 20.0) {
            return this.intPower((int)complex.r);
        }
        return this.log().mul(complex).exp();
    }

    public Complex sin() {
        return new Complex(Math.sin(this.r) * MathEx.cosh(this.i), Math.cos(this.r) * MathEx.sinh(this.i));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.r) * MathEx.cosh(this.i), -Math.sin(this.r) * MathEx.sinh(this.i));
    }

    public Complex tan() {
        double d = 1.0 / (Math.cos(2.0 * this.r) + MathEx.cosh(2.0 * this.i));
        return new Complex(Math.sin(2.0 * this.r) * d, MathEx.sinh(2.0 * this.i) * d);
    }

    public Complex sinh() {
        return new Complex(MathEx.sinh(this.r) * Math.cos(this.i), MathEx.cosh(this.r) * Math.sin(this.i));
    }

    public Complex cosh() {
        return new Complex(MathEx.cosh(this.r) * Math.cos(this.i), MathEx.sinh(this.r) * Math.sin(this.i));
    }

    public Complex tanh() {
        return this.sinh().div(this.cosh());
    }

    public Complex asin() {
        return CX_1.sub(this.sqr()).sqrt().add(this.mul(CX_I)).log().mul(CX_NEG_I);
    }

    public Complex acos() {
        return CX_HALF_PI.sub(this.asin());
    }

    public Complex atan() {
        Complex complex = this.mul(CX_I);
        return CX_1.sub(complex).log().sub(CX_1.add(complex).log()).mul(CX_HALF_NEG_I);
    }

    public Complex asinh() {
        return this.sqr().add(CX_1).sqrt().sub(this).log().neg();
    }

    public Complex acosh() {
        return this.sqr().sub(CX_1).sqrt().add(this).log();
    }

    public Complex atanh() {
        return CX_1.add(this).log().sub(CX_1.sub(this).log()).scale(0.5);
    }
}

