/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public final class GTKBluetooth
extends Thread
implements DiscoveryListener {
    private static final long BT_PROTOCOL_UUID = 256L;
    public static final int BT_CONNECTION_TYPE_SERVER = 0;
    public static final int BT_CONNECTION_TYPE_AUTOMATIC_CLIENT = 1;
    public static final int BT_CONNECTION_TYPE_MANUAL_CLIENT = 2;
    public static final int BT_CONNECTION_STATE_STOPPED = 0;
    public static final int BT_CONNECTION_STATE_INIT = 1;
    public static final int BT_CONNECTION_STATE_WAITING_CLIENT = 2;
    public static final int BT_CONNECTION_STATE_SEARCHING_DEVICES = 3;
    public static final int BT_CONNECTION_STATE_SEARCHING_SERVICES = 4;
    public static final int BT_CONNECTION_STATE_TRYING_TO_CONNECT = 5;
    public static final int BT_CONNECTION_STATE_SERVER_CONNECTED = 6;
    public static final int BT_CONNECTION_STATE_CLIENT_INITIALIZED = 7;
    public static final int BT_CONNECTION_STATE_CLIENT_CONNECTED = 8;
    private static final int BT_DATA_SIZE = 48;
    private static final int BT_TIME_OUT = 2000;
    private static GTKBluetooth s_instance;
    private final String m_connectionUuid;
    private final int m_connectionType;
    private volatile int m_connectionState;
    private final boolean m_isThreadedReception;
    private final int m_discoveryMode;
    private DiscoveryAgent m_discoveryAgent;
    private int m_deviceMajorClass;
    private Vector m_devicesList;
    private String[] m_devicesNamesList;
    private volatile boolean m_isSearchCompleted;
    private volatile boolean m_isSearchAborted;
    private Vector m_servicesList;
    private int m_serviceSearchId;
    private volatile boolean m_isServiceSearchCompleted;
    private volatile boolean m_isServiceSearchAborted;
    private L2CAPConnectionNotifier m_connectionNotifier;
    private L2CAPConnection m_connection;
    private final byte[] m_dataBuffer;
    private volatile int m_dataBufferSize;
    private static byte[] s_outputBuffer;
    private static int s_outputBufferPointer;
    public static byte[] s_inputBuffer;
    public static int s_inputBufferPointer;
    public static final int MAX_DISCOVERED_DEVICES = 8;

    private static final void btDebug(String p_methodName, Throwable p_error) {
    }

    private GTKBluetooth(String p_connectionUuid, int p_connectionType, boolean p_useThreadedReception, int p_initialDiscoveryMode) {
        this.m_connectionUuid = p_connectionUuid;
        this.m_connectionType = p_connectionType;
        this.m_connectionState = 1;
        this.m_isThreadedReception = p_useThreadedReception;
        this.m_discoveryMode = p_initialDiscoveryMode;
        this.m_serviceSearchId = -1;
        this.m_dataBuffer = (byte[])(this.m_isThreadedReception ? new byte[48] : null);
    }

    private final boolean serverConnect() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            localDevice.setDiscoverable(10390323);
            this.m_connectionState = 2;
            this.m_connectionNotifier = (L2CAPConnectionNotifier)Connector.open((String)("btl2cap://localhost:" + this.m_connectionUuid + ";name=NAMCO;master=false;authenticate=false;authorize=false;encrypt=false;ReceiveMTU=" + 48 + ";TransmitMTU=" + 48));
            this.m_connection = this.m_connectionNotifier.acceptAndOpen();
            this.m_connectionNotifier.close();
            this.m_connectionNotifier = null;
            localDevice.setDiscoverable(0);
            this.m_connectionState = 6;
            return false;
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("serverConnect", e);
            return true;
        }
        catch (SecurityException e) {
            GTKBluetooth.btDebug("serverConnect", e);
            return true;
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("serverConnect", e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean clientSearchDevices() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            localDevice.setDiscoverable(0);
            this.m_discoveryAgent = localDevice.getDiscoveryAgent();
            this.m_deviceMajorClass = localDevice.getDeviceClass().getMajorDeviceClass();
            this.m_devicesList = new Vector();
            this.m_isSearchCompleted = false;
            this.m_discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("clientSearchDevices", e);
            return true;
        }
        while (!this.m_isSearchCompleted) {
            GTKBluetooth gTKBluetooth = this;
            synchronized (gTKBluetooth) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    GTKBluetooth.btDebug("clientSearchDevices", e);
                }
            }
        }
        return this.m_isSearchAborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean clientSearchService(UUID[] p_connectionUuid, RemoteDevice p_remoteDevice) {
        this.m_servicesList = new Vector();
        this.m_isServiceSearchCompleted = false;
        try {
            this.m_serviceSearchId = this.m_discoveryAgent.searchServices(null, p_connectionUuid, p_remoteDevice, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("clientSearchService", e);
            return true;
        }
        while (!this.m_isServiceSearchCompleted) {
            GTKBluetooth gTKBluetooth = this;
            synchronized (gTKBluetooth) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    GTKBluetooth.btDebug("mClientSearchService", e);
                }
            }
        }
        return this.m_isServiceSearchAborted;
    }

    private final boolean clientConnect(ServiceRecord p_serviceRecord) {
        try {
            this.m_connection = (L2CAPConnection)Connector.open((String)p_serviceRecord.getConnectionURL(0, false));
            return false;
        }
        catch (SecurityException e) {
            GTKBluetooth.btDebug("clientConnect", e);
            return true;
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("clientConnect", e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean clientConnect() {
        this.m_connectionState = 3;
        if (this.clientSearchDevices()) {
            return true;
        }
        if (this.m_connectionType == 2) {
            this.m_devicesNamesList = new String[this.m_devicesList.size()];
            int deviceIndex2 = this.m_devicesNamesList.length;
            while (deviceIndex2-- > 0) {
                RemoteDevice remoteDevice = (RemoteDevice)this.m_devicesList.elementAt(deviceIndex2);
                try {
                    this.m_devicesNamesList[deviceIndex2] = remoteDevice.getFriendlyName(false);
                }
                catch (IOException e) {
                    GTKBluetooth.btDebug("clientConnect", e);
                    this.m_devicesNamesList[deviceIndex2] = remoteDevice.getBluetoothAddress();
                }
            }
            this.m_connectionState = 7;
            while (this.m_connectionState != 1) {
                GTKBluetooth deviceIndex2 = this;
                synchronized (deviceIndex2) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        GTKBluetooth.btDebug("mClientConnect", e);
                    }
                }
                if (s_instance != null) continue;
                return true;
            }
        }
        UUID[] connectionUuid = new UUID[]{new UUID(256L), new UUID(this.m_connectionUuid, false)};
        int deviceIndex = this.m_devicesList.size();
        while (deviceIndex-- > 0) {
            this.m_connectionState = 4;
            if (this.clientSearchService(connectionUuid, (RemoteDevice)this.m_devicesList.elementAt(deviceIndex))) {
                return true;
            }
            this.m_connectionState = 5;
            int serviceIndex = this.m_servicesList.size();
            while (serviceIndex-- > 0) {
                if (this.clientConnect((ServiceRecord)this.m_servicesList.elementAt(serviceIndex))) continue;
                this.m_connectionState = 8;
                this.m_discoveryAgent = null;
                this.m_devicesList = null;
                this.m_devicesNamesList = null;
                this.m_servicesList = null;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean sClientConnect(int p_deviceIndex) {
        if (s_instance == null || GTKBluetooth.s_instance.m_connectionState != 7) {
            return true;
        }
        try {
            RemoteDevice removeDevice = (RemoteDevice)GTKBluetooth.s_instance.m_devicesList.elementAt(p_deviceIndex);
            GTKBluetooth.s_instance.m_devicesList.removeAllElements();
            GTKBluetooth.s_instance.m_devicesList.addElement(removeDevice);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            GTKBluetooth.btDebug("sClientConnect", e);
        }
        GTKBluetooth gTKBluetooth = s_instance;
        synchronized (gTKBluetooth) {
            GTKBluetooth.s_instance.m_connectionState = 1;
            s_instance.notify();
        }
        return false;
    }

    public static final boolean initialize(String p_connectionUuid, int p_connectionType, boolean p_useThreadedReception) {
        int discoveryMode;
        if (s_instance != null || p_connectionUuid == null || p_connectionType < 0 || p_connectionType > 2) {
            return true;
        }
        try {
            new UUID(p_connectionUuid, false);
        }
        catch (NumberFormatException e) {
            GTKBluetooth.btDebug("initialize", e);
            return true;
        }
        catch (IllegalArgumentException e) {
            GTKBluetooth.btDebug("initialize", e);
            return true;
        }
        try {
            discoveryMode = LocalDevice.getLocalDevice().getDiscoverable();
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("initialize", e);
            return true;
        }
        if (discoveryMode == 0) {
            return true;
        }
        s_instance = new GTKBluetooth(p_connectionUuid, p_connectionType, p_useThreadedReception, discoveryMode);
        s_instance.start();
        return false;
    }

    public static final int getState() {
        if (s_instance == null) {
            return 0;
        }
        return GTKBluetooth.s_instance.m_connectionState;
    }

    public static final String[] getServerList() {
        if (s_instance == null) {
            return null;
        }
        return GTKBluetooth.s_instance.m_devicesNamesList;
    }

    public static final boolean dataSend(byte[] p_data) {
        if (p_data == null || s_instance == null || GTKBluetooth.s_instance.m_connection == null) {
            return true;
        }
        try {
            GTKBluetooth.s_instance.m_connection.send(p_data);
            return false;
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("dataSend", e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean dataReceive() {
        boolean error;
        while (this.m_dataBufferSize != 0) {
            GTKBluetooth gTKBluetooth = this;
            synchronized (gTKBluetooth) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    GTKBluetooth.btDebug("dataReceive", e);
                }
            }
            if (s_instance != null) continue;
            return true;
        }
        try {
            this.m_dataBufferSize = this.m_connection.receive(this.m_dataBuffer);
            error = false;
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("dataReceive", e);
            this.m_dataBufferSize = -1;
            error = true;
        }
        GTKBluetooth gTKBluetooth = this;
        synchronized (gTKBluetooth) {
            this.notify();
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean dataReceive(byte[] p_dataBuffer, boolean p_requestTimeout) {
        GTKBluetooth gTKBluetooth;
        while (this.m_dataBufferSize <= 0) {
            gTKBluetooth = this;
            synchronized (gTKBluetooth) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    GTKBluetooth.btDebug("dataReceive", e);
                }
            }
            if (this.m_dataBufferSize >= 0 && (!p_requestTimeout || this.m_dataBufferSize != 0)) continue;
            return true;
        }
        gTKBluetooth = this;
        synchronized (gTKBluetooth) {
            System.arraycopy(this.m_dataBuffer, 0, p_dataBuffer, 0, this.m_dataBufferSize);
            this.m_dataBufferSize = 0;
            this.notify();
        }
        return false;
    }

    public static final boolean sDataReceive(byte[] p_dataBuffer, boolean p_timeoutRequested) {
        if (p_dataBuffer == null || s_instance == null || GTKBluetooth.s_instance.m_connection == null) {
            return true;
        }
        if (GTKBluetooth.s_instance.m_isThreadedReception) {
            return s_instance.dataReceive(p_dataBuffer, p_timeoutRequested);
        }
        try {
            GTKBluetooth.s_instance.m_connection.receive(p_dataBuffer);
            return false;
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("dataReceive", e);
            return true;
        }
    }

    public static final boolean dataAvailable() {
        if (s_instance != null && GTKBluetooth.s_instance.m_isThreadedReception) {
            return s_instance != null && GTKBluetooth.s_instance.m_dataBufferSize != 0;
        }
        try {
            return s_instance != null && GTKBluetooth.s_instance.m_connection != null && GTKBluetooth.s_instance.m_connection.ready();
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("dataAvailable", e);
            return false;
        }
    }

    public static final void cleanupBluetooth() {
        if (s_instance == null) {
            return;
        }
        if (GTKBluetooth.s_instance.m_discoveryAgent != null) {
            if (GTKBluetooth.s_instance.m_serviceSearchId == -1) {
                GTKBluetooth.s_instance.m_discoveryAgent.cancelInquiry((DiscoveryListener)s_instance);
            } else {
                GTKBluetooth.s_instance.m_discoveryAgent.cancelServiceSearch(GTKBluetooth.s_instance.m_serviceSearchId);
            }
        }
        try {
            if (GTKBluetooth.s_instance.m_connectionNotifier != null) {
                GTKBluetooth.s_instance.m_connectionNotifier.close();
            }
            if (GTKBluetooth.s_instance.m_connection != null) {
                GTKBluetooth.s_instance.m_connection.close();
            }
        }
        catch (IOException e) {
            GTKBluetooth.btDebug("btCleanup", e);
        }
        try {
            LocalDevice.getLocalDevice().setDiscoverable(GTKBluetooth.s_instance.m_discoveryMode);
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("btCleanup", e);
        }
        s_instance = null;
    }

    public static void forceCleanupBluetooth() {
        s_instance = null;
    }

    public final void deviceDiscovered(RemoteDevice p_remoteDevice, DeviceClass p_deviceClass) {
        if (p_deviceClass.getMajorDeviceClass() == this.m_deviceMajorClass && !this.m_devicesList.contains(p_remoteDevice) && this.m_devicesList.size() < 8) {
            try {
                String remoteName = p_remoteDevice.getFriendlyName(false);
                this.m_devicesList.addElement(p_remoteDevice);
            }
            catch (IOException e) {
                AALMidlet.outputDebugString(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void inquiryCompleted(int p_discoveryType) {
        this.m_isSearchCompleted = true;
        this.m_isSearchAborted = p_discoveryType == 5;
        GTKBluetooth gTKBluetooth = this;
        synchronized (gTKBluetooth) {
            this.notify();
        }
    }

    public final void servicesDiscovered(int p_transactionId, ServiceRecord[] p_serviceRecord) {
        if (p_transactionId == this.m_serviceSearchId) {
            int index = p_serviceRecord.length;
            while (index-- > 0) {
                this.m_servicesList.addElement(p_serviceRecord[index]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serviceSearchCompleted(int p_transactionId, int p_responseCode) {
        this.m_serviceSearchId = -1;
        this.m_isServiceSearchCompleted = true;
        this.m_isServiceSearchAborted = p_responseCode == 2;
        GTKBluetooth gTKBluetooth = this;
        synchronized (gTKBluetooth) {
            this.notify();
        }
    }

    public final void run() {
        boolean error = this.m_connectionType == 0 ? this.serverConnect() : this.clientConnect();
        if (this.m_isThreadedReception) {
            while (!error) {
                error = this.dataReceive();
            }
        }
        if (error) {
            this.m_connectionState = 0;
        }
    }

    public static final boolean forceDiscovery() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            localDevice.setDiscoverable(10390323);
            return false;
        }
        catch (BluetoothStateException e) {
            GTKBluetooth.btDebug("force discovery", e);
            return true;
        }
    }

    public static void resetOutputDataBuffer(int p_outputBufferSize) {
        if (s_outputBuffer == null || s_outputBuffer.length != p_outputBufferSize) {
            s_outputBuffer = new byte[p_outputBufferSize];
        }
        s_outputBufferPointer = 0;
    }

    public static void resetInputDataBuffer(int p_inputBufferSize) {
        if (s_inputBuffer == null || s_inputBuffer.length != p_inputBufferSize) {
            s_inputBuffer = new byte[p_inputBufferSize];
        }
        s_inputBufferPointer = 0;
    }

    public static void writeInt(int p_int) {
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)(p_int & 0xFF);
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)((p_int & 0xFF00) >> 8);
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)((p_int & 0xFF0000) >> 16);
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)((p_int & 0xFF000000) >> 24);
    }

    public static void writeShort(short p_short) {
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)(p_short & 0xFF);
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = (byte)((p_short & 0xFF00) >> 8);
    }

    public static void writeByte(byte p_byte) {
        GTKBluetooth.s_outputBuffer[GTKBluetooth.s_outputBufferPointer++] = p_byte;
    }

    public static int readInt() {
        return s_inputBuffer[s_inputBufferPointer++] & 0xFF | s_inputBuffer[s_inputBufferPointer++] << 8 & 0xFF00 | s_inputBuffer[s_inputBufferPointer++] << 16 & 0xFF0000 | s_inputBuffer[s_inputBufferPointer++] << 24 & 0xFF000000;
    }

    public static short readShort() {
        return (short)(s_inputBuffer[s_inputBufferPointer++] & 0xFF | s_inputBuffer[s_inputBufferPointer++] << 8 & 0xFF00);
    }

    public static byte readByte() {
        return s_inputBuffer[s_inputBufferPointer++];
    }

    public static boolean isServer() {
        return s_instance != null && GTKBluetooth.s_instance.m_connectionType == 0;
    }

    public static boolean isClient() {
        return s_instance != null && (GTKBluetooth.s_instance.m_connectionType == 2 || GTKBluetooth.s_instance.m_connectionType == 1);
    }

    public static boolean sendData() {
        return GTKBluetooth.dataSend(s_outputBuffer);
    }

    public static boolean receiveData() {
        return GTKBluetooth.sDataReceive(s_inputBuffer, true);
    }
}

