/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class AALTileset {
    private static final int[] AAL_TO_MIDP_TRANSFORMATION_TABLE = new int[]{0, 6, 3, 5, 2, 4, 1, 7};
    private static final int[] MIDP_TO_AAL_TRANSFORMATION_TABLE = new int[]{0, 6, 4, 2, 5, 3, 1, 7};
    public static final boolean PALETTE_REMAP_SUPPORTED = false;
    private Image m_image;
    private int[] m_midpTransMap;
    private byte[] m_indexMap;
    private int m_numTiles;
    private long[] m_rectsLong;

    public static AALTileset createTileset(int p_imageID, int[] p_tilesetRects, byte[] p_indexMap, byte[] p_transMap, boolean p_clipTilesetImage) throws IOException {
        AALTileset tileset = new AALTileset();
        return tileset;
    }

    public static AALTileset createTileset(int p_imageID, int[] p_tilesetRects, byte[] p_indexMap, byte[] p_transMap, boolean p_clipTilesetImage, byte[] p_data, int[] p_palette) throws IOException {
        AALTileset tileset = new AALTileset();
        return tileset;
    }

    public static AALTileset createTileset(int p_imageID, long[] p_tilesetRects, byte[] p_indexMap, byte[] p_transMap, boolean p_clipTilesetImage) throws IOException {
        AALTileset tileset = new AALTileset();
        tileset.m_image = AALDevice.createCustomImage(p_imageID);
        tileset.m_indexMap = p_indexMap;
        tileset.m_numTiles = p_indexMap.length;
        tileset.m_rectsLong = p_tilesetRects;
        tileset.m_midpTransMap = new int[p_transMap.length];
        for (int i = 0; i < p_transMap.length; ++i) {
            tileset.m_midpTransMap[i] = AAL_TO_MIDP_TRANSFORMATION_TABLE[p_transMap[i]];
        }
        return tileset;
    }

    public static AALTileset createTileset(int p_imageID, long[] p_tilesetRects, byte[] p_indexMap, byte[] p_transMap, boolean p_clipTilesetImage, byte[] p_data, int[] p_palette) throws IOException {
        AALTileset tileset = new AALTileset();
        tileset.m_image = AALDevice.createCustomImage(p_imageID, p_data, p_palette);
        tileset.m_indexMap = p_indexMap;
        tileset.m_numTiles = p_indexMap.length;
        tileset.m_rectsLong = p_tilesetRects;
        tileset.m_midpTransMap = new int[p_transMap.length];
        for (int i = 0; i < p_transMap.length; ++i) {
            tileset.m_midpTransMap[i] = AAL_TO_MIDP_TRANSFORMATION_TABLE[p_transMap[i]];
        }
        return tileset;
    }

    public static void setPaletteRemap(int[] p_paletteRemap) {
    }

    public int getNbTiles() {
        return this.m_numTiles;
    }

    public int getTileWidth(int p_tileIndex) {
        long tileRectLong = this.m_rectsLong[this.m_indexMap[p_tileIndex] & 0xFF];
        if ((this.m_midpTransMap[p_tileIndex] & 4) != 0) {
            return (int)(tileRectLong & 0xFFFFL);
        }
        int tileWidth = (int)(tileRectLong >>> 16 & 0xFFFFL);
        return tileWidth;
    }

    public int getTileHeight(int p_tileIndex) {
        long tileRectLong = this.m_rectsLong[this.m_indexMap[p_tileIndex] & 0xFF];
        if ((this.m_midpTransMap[p_tileIndex] & 4) != 0) {
            return (int)(tileRectLong >>> 16 & 0xFFFFL);
        }
        int tileHeight = (int)(tileRectLong & 0xFFFFL);
        return tileHeight;
    }

    public void drawTile(int p_tileIndex, int p_left, int p_top) {
        long rectShort = this.m_rectsLong[this.m_indexMap[p_tileIndex] & 0xFF];
        int height = (int)rectShort & 0xFFFF;
        int width = (int)(rectShort >>> 16 & 0xFFFFL);
        int top = (int)(rectShort >>> 32 & 0xFFFFL);
        int left = (int)(rectShort >>> 48 & 0xFFFFL);
        AALDevice.s_activeGraphics.drawRegion(this.m_image, left, top, width, height, this.m_midpTransMap[p_tileIndex], p_left, p_top, 20);
    }

    public int getTileWidth(int p_tileIndex, int p_tileTransformation) {
        if ((p_tileTransformation & 1) != 0) {
            return this.getTileHeight(p_tileIndex);
        }
        return this.getTileWidth(p_tileIndex);
    }

    public int getTileHeight(int p_tileIndex, int p_tileTransformation) {
        if ((p_tileTransformation & 1) != 0) {
            return this.getTileWidth(p_tileIndex);
        }
        return this.getTileHeight(p_tileIndex);
    }

    public void drawTile(int p_tileIndex, int p_tileTransformation, int p_left, int p_top) {
        long rectShort = this.m_rectsLong[this.m_indexMap[p_tileIndex] & 0xFF];
        int height = (int)rectShort & 0xFFFF;
        int width = (int)(rectShort >>> 16 & 0xFFFFL);
        int top = (int)(rectShort >>> 32 & 0xFFFFL);
        int left = (int)(rectShort >>> 48 & 0xFFFFL);
        int originalTransformation = MIDP_TO_AAL_TRANSFORMATION_TABLE[this.m_midpTransMap[p_tileIndex]];
        int modifiedTransformation = AALTileTransformation.TRANSFORMATION_TABLE[(p_tileTransformation << 3) + originalTransformation];
        AALDevice.s_activeGraphics.drawRegion(this.m_image, left, top, width, height, AAL_TO_MIDP_TRANSFORMATION_TABLE[modifiedTransformation], p_left, p_top, 20);
    }
}

