/*
 * Decompiled with CFR 0.152.
 */
public class TKTextbox {
    private static int[] textQueue;
    private static AALTileset s_bigFacesTileSet;
    private static GTKAnim s_player1Face;
    private static GTKAnim s_player2Face;
    private static final int[] PLAYER_FACES_GFX_DECLARATION;
    public static final int DIALOG_START_STATE = 0;
    public static final int DIALOG_WIN_STATE = 1;
    public static final int DIALOG_LOSE_STATE = 2;
    private static final int TEXTBOX_INTRO_STATE = 0;
    private static final int TEXTBOX_PLAYER_INTRO_STATE = 1;
    private static final int TEXTBOX_TYPEWRITING_STATE = 2;
    private static final int TEXTBOX_DISPLAY_TEXT = 3;
    private static final int TEXTBOX_PLAYER_OUTRO_STATE = 4;
    private static final int TEXTBOX_OUTRO_STATE = 5;
    private static final int TEXTBOX_FINISHED_STATE = 6;
    private static int s_textboxState;
    private static int s_textboxStateTimer;
    private static int s_textboxMaximumLines;
    private static int s_currentStartingLine;
    private static String[] s_stringsToDisplay;
    private static String[] s_currentString;
    private static String s_wholeString;
    private static int s_playerFaceHeight;
    private static final int BLACK_BARS_SLIDE_DURATION = 1000;
    private static final int AVATAR_SLIDE_DURATION = 200;
    private static final int AVATAR_SPACING_X = 29;
    private static final int AVATAR_SPACING_Y = 7;
    private static final int FRAME_BORDER_WIDTH = 3;
    private static final int TEXT_X = 60;
    private static final int NEXT_CHAR_DELAY = 100;
    private static final int TEXTBOX_SLIDE_DURATION = 200;
    private static final int TEXTBOX_HIDE_DURATION = 800;
    private static final int TEXTBOX_DIPLAY_TEXT_DURATION = 2000;
    private static int s_barsCurrentY;
    private static int s_avatarCurrentX;
    private static boolean s_isPlayer1Text;
    private static boolean s_isPlayer2Text;
    private static int s_currentText;
    private static int s_textboxCurrentX;
    private static int s_textboxCurrentHeight;
    private static int s_textBoxY;

    public static void initTextBox(int p_player1, int p_player2) {
        s_textboxCurrentX = 0;
        if (p_player1 < 0 || p_player1 >= 8 || p_player2 < 0 || p_player2 >= 8) {
            AALMidlet.outputDebugString(" initTextBox error: player1 " + p_player1 + " or player2 " + p_player2 + "is not correct");
        }
        try {
            s_bigFacesTileSet = AALDevice.createTileset(16777412, false);
            s_player1Face = GTKAnim.loadAnimation(PLAYER_FACES_GFX_DECLARATION[p_player1 * 2], PLAYER_FACES_GFX_DECLARATION[p_player1 * 2 + 1]);
            s_player2Face = GTKAnim.loadAnimation(PLAYER_FACES_GFX_DECLARATION[p_player2 * 2], PLAYER_FACES_GFX_DECLARATION[p_player2 * 2 + 1]);
        }
        catch (Exception e) {
            AALMidlet.outputDebugString(e.toString());
        }
        s_barsCurrentY = 0;
        s_avatarCurrentX = -29;
        s_isPlayer1Text = false;
        s_isPlayer2Text = false;
        s_currentText = -1;
        int[] sizes = new int[4];
        s_player1Face.computeGlobalBoundingBox(s_bigFacesTileSet, 0, sizes, 0);
        s_playerFaceHeight = sizes[3] - sizes[1];
        s_player2Face.computeGlobalBoundingBox(s_bigFacesTileSet, 0, sizes, 0);
        s_playerFaceHeight = Math.max(s_playerFaceHeight, sizes[3] - sizes[1]);
        TKTextbox.textBoxInitState(6);
    }

    private static void textBoxInitState(int p_newState) {
        s_textboxState = p_newState;
        s_textboxStateTimer = 0;
        switch (s_textboxState) {
            case 0: {
                GameMidlet.setCameraDestination(GameMidlet.s_battleFighter1.m_physicsData[0] + (GameMidlet.s_battleFighter2.m_physicsData[0] - GameMidlet.s_battleFighter1.m_physicsData[0]) / 2, GameMidlet.s_battleFighter1.m_physicsData[1] + (GameMidlet.s_battleFighter2.m_physicsData[1] - GameMidlet.s_battleFighter1.m_physicsData[1]) / 2 + (GameMidlet.s_viewportHeight / 4 << 8));
                s_barsCurrentY = 0;
                s_avatarCurrentX = -29;
                break;
            }
            case 1: {
                GameMidlet.setCameraDestination(GameMidlet.s_battleFighter1.m_physicsData[0] + (GameMidlet.s_battleFighter2.m_physicsData[0] - GameMidlet.s_battleFighter1.m_physicsData[0]) / 2, GameMidlet.s_battleFighter1.m_physicsData[1] + (GameMidlet.s_battleFighter2.m_physicsData[1] - GameMidlet.s_battleFighter1.m_physicsData[1]) / 2 + (GameMidlet.s_viewportHeight / 4 << 8));
                s_barsCurrentY = GameMidlet.s_viewportHeight * 3 / 8;
                s_isPlayer1Text = !s_isPlayer1Text;
                s_isPlayer2Text = !s_isPlayer1Text;
                s_currentString = null;
                s_avatarCurrentX = -29;
                if (++s_currentText >= textQueue.length) {
                    TKTextbox.textBoxInitState(5);
                }
                s_textboxCurrentX = 0;
                break;
            }
            case 2: {
                GameMidlet.setSoftkey(7, true);
                GameMidlet.setSoftkey(4, false);
                s_textboxMaximumLines = (GameMidlet.s_viewportHeight / 4 - 12) / GameMidlet.s_fontHeight;
                AALMidlet.outputDebugString("TEXTBOX TYPEWRITE INIT");
                int StringId = textQueue[s_currentText];
                String s = GameMidlet.getLocalizedString(StringId);
                s_stringsToDisplay = GameMidlet.wrapString(s, GameMidlet.s_viewportWidth - 60 - 3);
                if (s_stringsToDisplay.length <= s_textboxMaximumLines) {
                    s_currentString = s_stringsToDisplay;
                    s_wholeString = s;
                    break;
                }
                s_currentString = new String[s_textboxMaximumLines];
                s_currentStartingLine = 0;
                s_wholeString = "";
                for (int i = s_currentStartingLine; i < s_textboxMaximumLines + s_currentStartingLine; ++i) {
                    s_wholeString = s_wholeString + s_stringsToDisplay[i];
                    TKTextbox.s_currentString[i] = s_stringsToDisplay[i];
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                GameMidlet.setSoftkey(-1, true);
                GameMidlet.setSoftkey(4, false);
                s_avatarCurrentX = 29;
                break;
            }
            case 5: {
                GameMidlet.setSoftkey(-1, true);
                GameMidlet.setSoftkey(4, false);
                s_isPlayer1Text = false;
                s_isPlayer2Text = false;
                break;
            }
            case 6: {
                GameMidlet.setSoftkey(-1, true);
                GameMidlet.setSoftkey(4, false);
            }
        }
    }

    public static void updateTextBox() {
        GameMidlet.setFont(2);
        if (TKTextbox.isTextboxFinished()) {
            return;
        }
        s_textboxStateTimer += AALMidlet.s_elapsedTimeClamped;
        GameMidlet.updateCamera();
        TKTextbox.updateTextBoxState();
    }

    public static void launchTextBox(int p_dialogState) {
        s_isPlayer1Text = false;
        s_textboxCurrentX = 0;
        int storyModeP1 = GameMidlet.s_battleFighter1Id;
        int storyModeP2 = GameMidlet.s_battleFighter2Id;
        s_textboxCurrentHeight = Math.max(s_playerFaceHeight + 6, GameMidlet.s_viewportHeight / 4);
        int[] dialogs = GameMidlet.DIALOGS[storyModeP1][storyModeP2];
        switch (p_dialogState) {
            case 0: {
                textQueue = new int[dialogs[0]];
                for (int i = 0; i < textQueue.length; ++i) {
                    TKTextbox.textQueue[i] = dialogs[i + 2];
                }
                TKTextbox.textBoxInitState(0);
                break;
            }
            case 1: {
                textQueue = new int[dialogs[1] - dialogs[0]];
                for (int i = 0; i < textQueue.length; ++i) {
                    TKTextbox.textQueue[i] = dialogs[dialogs[0] + 2 + i];
                }
                TKTextbox.textBoxInitState(1);
                break;
            }
            case 2: {
                textQueue = new int[dialogs.length - dialogs[1] - 2];
                for (int i = 0; i < textQueue.length; ++i) {
                    TKTextbox.textQueue[i] = dialogs[dialogs[1] + 2 + i];
                }
                TKTextbox.textBoxInitState(1);
            }
        }
    }

    private static void updateTextBoxState() {
        boolean isAnimationFinished = true;
        switch (s_textboxState) {
            case 0: {
                GameMidlet.setCameraDestination(GameMidlet.s_battleFighter1.m_physicsData[0] + (GameMidlet.s_battleFighter2.m_physicsData[0] - GameMidlet.s_battleFighter1.m_physicsData[0]) / 2, GameMidlet.s_battleFighter1.m_physicsData[1] + (GameMidlet.s_battleFighter2.m_physicsData[1] - GameMidlet.s_battleFighter1.m_physicsData[1]) / 2 + (GameMidlet.s_viewportHeight / 4 << 8));
                s_barsCurrentY = GameMidlet.linearInterpolate(0, GameMidlet.s_viewportHeight * 3 / 8, s_textboxStateTimer, 1000);
                if (s_barsCurrentY != GameMidlet.s_viewportHeight * 3 / 8) {
                    isAnimationFinished = false;
                }
                if (!isAnimationFinished) break;
                TKTextbox.textBoxInitState(1);
                break;
            }
            case 1: {
                s_avatarCurrentX = GameMidlet.linearInterpolate(-29, 29, s_textboxStateTimer, 200);
                if (s_avatarCurrentX != 29) {
                    isAnimationFinished = false;
                }
                if (!isAnimationFinished) break;
                TKTextbox.textBoxInitState(2);
                break;
            }
            case 2: {
                int characterNumberToDisplay = s_textboxStateTimer / 100;
                if (characterNumberToDisplay <= s_wholeString.length() && (AALDevice.s_virtualKeysPressed & 0x40000) == 0) break;
                if (s_stringsToDisplay.length <= s_textboxMaximumLines || s_textboxMaximumLines + s_currentStartingLine >= s_stringsToDisplay.length) {
                    TKTextbox.textBoxInitState(3);
                    break;
                }
                s_textboxStateTimer = (s_wholeString.length() - s_currentString[0].length()) * 100;
                s_wholeString = "";
                for (int i = ++s_currentStartingLine; i < s_textboxMaximumLines + s_currentStartingLine; ++i) {
                    s_wholeString = s_wholeString + s_stringsToDisplay[i];
                    TKTextbox.s_currentString[i - TKTextbox.s_currentStartingLine] = s_stringsToDisplay[i];
                }
                break;
            }
            case 3: {
                if ((AALDevice.s_virtualKeysPressed & 0x40000) == 0 && s_textboxStateTimer <= 2000) break;
                TKTextbox.textBoxInitState(4);
                break;
            }
            case 4: {
                s_avatarCurrentX = GameMidlet.linearInterpolate(29, -29, s_textboxStateTimer, 200);
                if (s_avatarCurrentX != -29) {
                    isAnimationFinished = false;
                }
                if (!isAnimationFinished) break;
                TKTextbox.textBoxInitState(1);
                break;
            }
            case 5: {
                s_currentText = -1;
                GameMidlet.setCameraDestination(GameMidlet.s_battleFighter1.m_physicsData[0] + (GameMidlet.s_battleFighter2.m_physicsData[0] - GameMidlet.s_battleFighter1.m_physicsData[0]) / 2, GameMidlet.s_battleFighter1.m_physicsData[1] + (GameMidlet.s_battleFighter2.m_physicsData[1] - GameMidlet.s_battleFighter1.m_physicsData[1]) / 2);
                GameMidlet.outputDebugString("CAMERA " + GameMidlet.s_cameraBottom);
                if (GameMidlet.s_cameraFpPosY != GameMidlet.s_battleFighter1.m_physicsData[1] + (GameMidlet.s_battleFighter2.m_physicsData[1] - GameMidlet.s_battleFighter1.m_physicsData[1]) / 2) {
                    s_textboxCurrentHeight = GameMidlet.linearInterpolate(Math.max(s_playerFaceHeight + 6, GameMidlet.s_viewportHeight / 4), 0, s_textboxStateTimer, 800);
                }
                if (s_textboxCurrentHeight != 0) {
                    isAnimationFinished = false;
                }
                if (!isAnimationFinished) break;
                TKTextbox.textBoxInitState(6);
                break;
            }
        }
    }

    public static void drawTextBox() {
        GameMidlet.setFont(2);
        if (TKTextbox.isTextboxFinished()) {
            return;
        }
        s_textBoxY = GameMidlet.s_viewportTop + 30 + 0;
        GameMidlet.setColor(-1728053248);
        AALDevice.setFillColor(-1728053248);
        AALDevice.fillRect(s_textboxCurrentX, s_textBoxY, GameMidlet.s_viewportWidth, s_textboxCurrentHeight);
        GameMidlet.setColor(-2011028958);
        AALDevice.setFillColor(-2011028958);
        if (s_isPlayer1Text) {
            s_player1Face.drawInstance(0, s_bigFacesTileSet, s_avatarCurrentX, s_textBoxY + s_textboxCurrentHeight - 3, 0);
        } else {
            s_player2Face.drawInstance(0, s_bigFacesTileSet, s_avatarCurrentX, s_textBoxY + s_textboxCurrentHeight - 3, 0);
        }
        for (int i = 0; i < 3; ++i) {
            AALDevice.s_activeGraphics.drawRect(s_textboxCurrentX + i, s_textBoxY + i, GameMidlet.s_viewportWidth - i * 2, s_textboxCurrentHeight - i * 2);
        }
        AALDevice.s_activeGraphics.setColor(0);
        AALDevice.s_activeGraphics.fillRect(0, -s_barsCurrentY + 0, GameMidlet.s_viewportWidth, GameMidlet.s_viewportHeight / 2);
        AALDevice.s_activeGraphics.fillRect(0, GameMidlet.s_viewportCenterY + s_barsCurrentY, GameMidlet.s_viewportWidth, GameMidlet.s_viewportHeight / 2);
        TKTextbox.drawTextBoxState();
    }

    private static void drawTextBoxState() {
        switch (s_textboxState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (s_currentString == null) break;
                GameMidlet.drawStrings(s_currentString, 0, 0, 60, s_textBoxY + 6 + 0, 20, s_textboxStateTimer / 100);
                break;
            }
            case 3: {
                GameMidlet.drawStrings(s_currentString, 0, 0, 60, s_textBoxY + 6 + 0, 20);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public static boolean isTextboxFinished() {
        return s_textboxState == 6;
    }

    public static boolean isSkipAvailible() {
        return s_textboxState == 2 || s_textboxState == 3;
    }

    public static void cleanupTextBox() {
        s_textboxState = 6;
        s_currentString = null;
        s_bigFacesTileSet = null;
        s_player1Face = null;
        s_player2Face = null;
    }

    static {
        PLAYER_FACES_GFX_DECLARATION = new int[]{0x1000019, 0, 0x100001A, 0, 0x1000018, 0, 0x1000016, 0, 0x1000014, 0, 0x1000015, 0, 0x1000013, 0, 0x1000017, 0};
        s_textboxState = 6;
        s_isPlayer1Text = false;
        s_isPlayer2Text = false;
        s_currentText = -1;
    }
}

