/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class KMUIPanel
extends KMUIWidget {
    static final int MAX_WIDGETS = 10;
    private Image image;
    private KMUIWidget[] widgets;
    private int currentWidget;
    private int currentY;
    static final int DY = 5;
    private KMUIWidget currentFocused;

    public KMUIPanel(KMUIParametres param) throws Exception {
        super(param);
    }

    public static Image scale(Image src, int width, int height) {
        int scanline = src.getWidth();
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
        int[] buf2 = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = y * srch / height * scanline;
            for (int x = 0; x < width; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcw / width];
            }
        }
        Image img = Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
        buf = null;
        buf2 = null;
        return img;
    }

    public int init() throws Exception {
        this.widgets = new KMUIWidget[10];
        this.currentWidget = 0;
        this.currentY = 0;
        if (this.param.memory == 1) {
            if (this.param.bitmap != null) {
                Image imtmp = Image.createImage((String)this.param.bitmap);
                this.image = KMUIPanel.scale(imtmp, this.w, this.h);
                imtmp = null;
                System.gc();
            } else {
                this.image = Image.createImage((int)this.w, (int)this.h);
                Graphics g = this.image.getGraphics();
                g.setColor(this.param.marginColor);
                g.fillRect(0, 0, this.w, this.h);
                g.setClip(this.param.margin, this.param.margin, this.w - (this.param.margin << 1), this.h - (this.param.margin << 1));
                g.setColor(this.param.color);
                g.fillRect(0, 0, this.w, this.h);
                g.setClip(0, 0, this.w, this.h);
            }
        }
        super.init();
        return this.param.initScreenY + this.h;
    }

    public void addButtonList(KMUIParametres params) throws Exception {
        params.initScreenX = this.x + this.param.margin;
        params.initScreenY = this.y + this.param.margin;
        params.screenH = this.h - (this.param.margin << 1);
        params.screenW = this.w - (this.param.margin << 1);
        if (params.prefY == -1 && params.posV == -1) {
            params.prefY = this.currentY;
        }
        KMUIButtonList blist = new KMUIButtonList(this, params);
        this.currentY = blist.init();
        this.currentY = params.screenW <= 132 ? (this.currentY += 2) : (this.currentY += 5);
        this.addWidget(blist);
    }

    public void addTextField(KMUIParametres params) throws Exception {
        params.initScreenX = this.x + this.param.margin;
        params.initScreenY = this.y + this.param.margin;
        params.screenH = this.h - (this.param.margin << 1);
        params.screenW = this.w - (this.param.margin << 1);
        if (params.prefY == -1 && params.posV == -1) {
            params.prefY = this.currentY;
        }
        KMUITextField blist = new KMUITextField(this, params);
        this.currentY = blist.init();
        this.currentY += 5;
        this.addWidget(blist);
    }

    private void addWidget(KMUIWidget w) {
        if (this.currentWidget < 10) {
            this.widgets[this.currentWidget++] = w;
            KMUIMessage.vMessages.addElement(new KMUIMessage(this.widgets[this.currentWidget - 1].param.name, 1, 0, this.widgets[this.currentWidget - 1]));
        }
    }

    public void retrieveFocus() {
        if (this.currentFocused != null) {
            this.currentFocused.retrieveFocus();
        }
    }

    public int setFocusDownwards() {
        int i = 0;
        if (this.currentFocused != null) {
            int a;
            for (a = 0; a < this.currentWidget && this.widgets[a] != this.currentFocused; ++a) {
            }
            i = a + 1;
        }
        while (i < this.currentWidget) {
            if (this.widgets[i].focusable) {
                this.widgets[i].setFocusDownwards();
                if (this.currentFocused != null) {
                    this.currentFocused.retrieveFocus();
                }
                this.currentFocused = this.widgets[i];
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int setFocusUpwards() {
        int i = 0;
        if (this.currentFocused != null) {
            int a;
            for (a = 0; a < this.currentWidget && this.widgets[a] != this.currentFocused; ++a) {
            }
            i = a - 1;
        }
        while (i >= 0) {
            if (this.widgets[i].focusable) {
                this.widgets[i].setFocusUpwards();
                if (this.currentFocused != null) {
                    this.currentFocused.retrieveFocus();
                }
                this.currentFocused = this.widgets[i];
                return 1;
            }
            --i;
        }
        return 0;
    }

    public void paint(Graphics g) {
        try {
            if (!this.initialized) {
                return;
            }
            if (this.firstRun) {
                if (this.param.memory == 1) {
                    g.drawImage(this.image, this.param.initScreenX + this.x, this.param.initScreenY + this.y, 0);
                } else {
                    g.setColor(this.param.marginColor);
                    g.fillRect(this.param.initScreenX + this.x, this.param.initScreenY + this.y, this.w, this.h);
                    g.setClip(this.param.initScreenX + this.x + this.param.margin, this.param.initScreenY + this.y + this.param.margin, this.w - (this.param.margin << 1), this.h - (this.param.margin << 1));
                    g.setColor(this.param.color);
                    g.fillRect(this.param.initScreenX + this.x + this.param.margin, this.param.initScreenY + this.y + this.param.margin, this.w, this.h);
                }
                this.firstRun = false;
            }
            g.setClip(this.x, this.y, this.w, this.h);
            for (int i = 0; i < this.currentWidget; ++i) {
                this.widgets[i].paint(g);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.setClip(0, 0, this.param.screenW, this.param.screenH);
    }

    public int keyPressed(int gameaction) {
        if (this.currentFocused != null) {
            int t = this.currentFocused.keyPressed(gameaction);
            if (t == 0) {
                if (gameaction == 6 ? (t = this.setFocusDownwards()) == 1 : gameaction == 1 && (t = this.setFocusUpwards()) == 1) {
                    return 1;
                }
            } else {
                return 1;
            }
        }
        return 0;
    }

    public void delete() {
        super.delete();
        this.image = null;
        for (int i = 0; i < 10; ++i) {
            if (this.widgets[i] != null) {
                this.widgets[i].delete();
            }
            this.widgets[i] = null;
        }
        this.widgets = null;
        System.gc();
    }
}

