/*
 * Decompiled with CFR 0.152.
 */
public abstract class GameCommon {
    private static final int MIN_SLEEP = 0;
    private static final int MIN_ELAPSED_TIME = 50;
    private static final int MAX_ELAPSED_TIME = 125;
    private static final int MASK_UNDEF = 0;
    private static final int MASK_FIRE = 1;
    private static final int MASK_LEFT = 3;
    private static final int MASK_RIGHT = 4;
    private static final int MASK_UP = 5;
    private static final int MASK_DOWN = 6;
    private static final int MASK_RSK = 7;
    private static final int MASK_LSK = 8;
    private static final int MASK_NULL = 9;
    public static final int KEY_NONE = 0;
    public static final int KEY_FIRE = 2;
    public static final int KEY_LEFT = 8;
    public static final int KEY_RIGHT = 16;
    public static final int KEY_UP = 32;
    public static final int KEY_DOWN = 64;
    public static final int KEY_RSK = 128;
    public static final int KEY_LSK = 256;
    public static final int KEY_NULL = 512;
    public static final int G_STATE_NULL = 0;
    public static final int G_STATE_LOAD = 1;
    public static final int G_STATE_PLAY = 10;
    public static final int G_STATE_ENDSCREEN = 90;
    public static final int G_STATE_END = 99;
    public static final int PRECISION = 16;
    static int level;
    static int levelCount;
    static int keyCode;
    static int keyLast;
    static int keyStates;
    static boolean keyBlock;
    static int quitStatus;
    static boolean paused;
    static int gameState;
    public static final int SOUND_EVENT_DEAFULT = -1;
    public static final int SOUND_EVENT_DELAY = 499;
    private static int soundEvent;
    private static boolean sfxEnabled;
    private static int soundEvent_last;
    private static long soundEvnet_lT;
    static int deskX;
    static int deskY;
    static int deskW;
    static int deskW_2;
    static int deskH;
    static int deskH_2;
    public static boolean bGameInLoading;
    public static long loadingEndTime;
    public static long loadingUpdateLastTime;
    public static final int GLOADING_TIME = 3000;
    public static final int GLOADING_MAXDELAY = 100;
    public static final int GLOADING_MINDELAY = 50;
    private static final int MENU_FRAME_LEFT_TOP = 0;
    private static final int MENU_FRAME_TOP = 1;
    private static final int MENU_FRAME_RIGHT_TOP = 2;
    private static final int MENU_FRAME_LEFT = 3;
    private static final int MENU_FRAME_FILL = 4;
    private static final int MENU_FRAME_RIGHT = 5;
    private static final int MENU_FRAME_LEFT_BOTTOM = 6;
    private static final int MENU_FRAME_BOTTOM = 7;
    private static final int MENU_FRAME_RIGHT_BOTTOM = 8;
    private static final int MENU_FRAME_X_COUNT = 3;
    private static final int MENU_FRAME_Y_COUNT = 3;
    public static final int SPRITE_EA_RESPAWN = 1;
    public static final int SPRITE_EA_HIDE = 2;
    public static final int SPRITE_EA_PLAYNEXT = 4;
    public static final int SPRITE_EA_PLAYFIRST = 8;
    public static final int SPRITE_EA_ROTATE = 16;

    public static void beginGameLoading() {
        bGameInLoading = true;
        loadingUpdateLastTime = Platform.clock();
        loadingEndTime = loadingUpdateLastTime + 3000L;
    }

    public static void updateGameLoading() {
        if (!bGameInLoading) {
            return;
        }
        int n = (int)(loadingUpdateLastTime + 100L - Platform.clock());
        if (n > 50) {
            Platform.sleep(n);
        }
        Platform.redraw();
        loadingUpdateLastTime = Platform.clock();
    }

    public static void endGameLoading() {
        bGameInLoading = false;
        long l = Platform.clock();
        while (l < loadingEndTime) {
            Platform.sleep(100);
            l = Platform.clock();
            Platform.redraw();
        }
    }

    public void keyPressed(int n) {
        if (keyBlock) {
            return;
        }
        keyCode = n;
        if (n == 15) {
            if (this.canPause()) {
                paused = true;
                keyStates = 0;
                keyLast = 0;
                n = 0;
                return;
            }
        } else if (n == 14) {
            keyLast = 256;
            keyStates |= 0x100;
            return;
        }
        keyLast = this.mapKeyAction(n);
        int n2 = this.mapKeyMask(n);
        keyStates |= n2;
    }

    protected boolean canPause() {
        return true;
    }

    public void restartThis() {
    }

    public void keyReleased(int n) {
        if (keyBlock) {
            return;
        }
        int n2 = this.mapKeyMask(n);
        keyStates &= ~n2;
    }

    private int mapKeyAction(int n) {
        switch (n) {
            case 6: 
            case 16: {
                return 2;
            }
            case 5: 
            case 19: {
                return 8;
            }
            case 7: 
            case 20: {
                return 16;
            }
            case 3: 
            case 17: {
                return 32;
            }
            case 9: 
            case 18: {
                return 64;
            }
            case 2: {
                return 40;
            }
            case 8: {
                return 72;
            }
            case 4: {
                return 48;
            }
            case 10: {
                return 80;
            }
            case 1: {
                return 512;
            }
        }
        return 0;
    }

    private int mapKeyMask(int n) {
        switch (n) {
            case 6: 
            case 16: {
                return 2;
            }
            case 5: 
            case 19: {
                return 8;
            }
            case 7: 
            case 20: {
                return 16;
            }
            case 3: 
            case 17: {
                return 32;
            }
            case 9: 
            case 18: {
                return 64;
            }
            case 1: {
                return 512;
            }
        }
        return 0;
    }

    private static int clock() {
        return (int)Platform.clock();
    }

    protected void hideNotify() {
        paused = true;
        keyLast = 0;
        keyCode = 0;
        keyStates = 0;
    }

    protected void showNotify() {
        keyLast = 0;
        keyCode = 0;
        keyStates = 0;
        paused = false;
        this.initSound();
    }

    public void processCheat(int n) {
    }

    public boolean evolve() {
        int n = GameCommon.clock();
        this.update();
        if (!paused) {
            this.updateSound();
            Platform.redraw();
            int n2 = GameCommon.clock() - n;
            int n3 = 50 - n2;
            if (n3 > 0) {
                n3 = Math.min(50, n3);
                Platform.sleep(n3);
            } else {
                Platform.sleep(0);
            }
        }
        return quitStatus != 0;
    }

    public void paint() {
        this.draw();
    }

    protected void draw() {
    }

    public void quit(int n) {
        quitStatus = n;
    }

    public void enterNotify() {
        quitStatus = 0;
    }

    public void leaveNotify() {
    }

    public abstract void update();

    protected void initSound() {
        soundEvent_last = -1;
        soundEvnet_lT = Platform.clock();
        soundEvent = -1;
        switch (GMain.getOption(2)) {
            case 0: {
                int n;
                soundEvent = n = Utils.randomInterval(1, 3);
                sfxEnabled = false;
                break;
            }
            case 1: {
                soundEvent = -1;
                sfxEnabled = true;
            }
        }
    }

    public static void updateSoundEvnet(int n) {
        if (!sfxEnabled) {
            return;
        }
        if (soundEvent != -1 && n >= soundEvent) {
            return;
        }
        if (soundEvnet_lT + 499L > Platform.clock() && n >= soundEvent_last) {
            return;
        }
        soundEvent = n;
    }

    private void updateSound() {
        if (soundEvent > -1) {
            soundEvent_last = soundEvent;
            soundEvnet_lT = Platform.clock();
            if (soundEvent <= 3) {
                Platform.sleep(100);
            }
            Sound.playSound(soundEvent);
            if (soundEvent <= 3) {
                Platform.sleep(100);
            }
            soundEvent = -1;
        }
    }

    public void loadLevel(int n) {
        PlatformResource platformResource = Platform.getResource("/l" + n);
        this.loadLevel(platformResource);
        platformResource.close();
    }

    protected void loadLevel(PlatformResource platformResource) {
    }

    public static void markResource(int n, boolean bl) {
        if (bl) {
            Sprite.acquire(n);
        } else {
            Sprite.release(n);
        }
    }

    public static void markResources(int[] nArray, boolean bl) {
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                Sprite.acquire(nArray[i]);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                Sprite.release(nArray[i]);
            }
        }
    }

    private static void drawDialogBackgroud(int n, int n2, int n3, int n4, int n5) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n6 = GMain.canvasWidth;
        int n7 = GMain.canvasHeight;
        platformGraphics.setClip(0, 0, n6, n7);
        PlatformImage platformImage = GMain.getImage(n5);
        GameCommon.drawMenuFrameImage(platformImage, n, n2, n3, n4, true);
    }

    public static void drawMenuFrameImage(PlatformImage platformImage, int n, int n2, int n3, int n4, boolean bl) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n5 = GMain.canvasWidth;
        int n6 = GMain.canvasHeight;
        platformGraphics.setClip(0, 0, n5, n6);
        int n7 = platformImage.getWidth() / 3;
        int n8 = platformImage.getHeight() / 3;
        int n9 = n7;
        int n10 = n8;
        int n11 = n7;
        int n12 = n8;
        if (bl) {
            Utils.drawPattern(n, n2, n3, n4, platformImage, 1 * n7, 1 * n8, n7, n8);
        }
        Utils.drawPattern(n, n2 - n10, n3, n10, platformImage, 1 * n7, 0 * n8, n7, n8);
        Utils.drawPattern(n, n2 + n4, n3, n10, platformImage, 1 * n7, 2 * n8, n7, n8);
        Utils.drawPattern(n - n9, n2, n9, n4, platformImage, 0 * n7, 1 * n8, n7, n8);
        Utils.drawPattern(n + n3, n2, n9, n4, platformImage, 2 * n7, 1 * n8, n7, n8);
        Utils.drawRegion(platformImage, 0 * n7, 0 * n8, n7, n8, n - n11, n2 - n12, 0);
        Utils.drawRegion(platformImage, 2 * n7, 0 * n8, n7, n8, n + n3, n2 - n12, 0);
        Utils.drawRegion(platformImage, 0 * n7, 2 * n8, n7, n8, n - n11, n2 + n4, 0);
        Utils.drawRegion(platformImage, 2 * n7, 2 * n8, n7, n8, n + n3, n2 + n4, 0);
    }

    public void pathEnded(Sprite sprite, int n, int n2) {
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                sprite.visible = false;
                break;
            }
            case 8: {
                sprite.startPath(0);
                break;
            }
            case 4: {
                sprite.startPath(n + 1);
                break;
            }
        }
    }

    static {
        keyBlock = false;
    }
}

