/*
 * Decompiled with CFR 0.152.
 */
public abstract class OpenMathFP {
    private static final int PRECISION = 13;
    private static final int MAX_PRECISION = 30;
    public static final int PI = 25735;
    public static final int PI_HALF = 12867;
    public static final int PI_TWO = 51470;
    public static final int PI_TT = 38601;
    private static final int ONE_EIGHTY_OVER_PI = 469376;
    private static final int PI_OVER_ONE_EIGHTY = 142;
    private static final int MAX_DIGITS = 5;
    private static final int MAX_DIGITS_INT = 100000;
    public static final int ONE = 8192;
    public static final int FRAC_MASK = 8191;
    public static final int HALF = 4096;
    public static final int TWO = 16384;
    public static final int INFINITY = Integer.MAX_VALUE;
    private static final int[] SK = new int[]{62, 1360};
    private static final int[] AS = new int[]{-154, 608, 1737, 12867};
    private static final int LN2 = 5678;
    private static int LN2_INV = 11818;
    private static final int[] LG = new int[]{5461, 3276, 2340, 1820, 1489, 1254, 1212};
    private static final int[] EXP_P = new int[]{1365, -23, 0, -1, 0};
    private static int ATAN2_ZERO_ERROR = 65;
    public static final int[] iSINUS = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};
    public static int iX_vect;
    public static int iY_vect;
    public static final int SHIFT_SIN = 10000;

    public static int toFP(int n) {
        return n < 0 ? -(-n << 13) : n << 13;
    }

    public static int toInt(int n) {
        return n < 0 ? -(-n >> 13) : n >> 13;
    }

    public static int toFP(String string) {
        int n;
        int n2;
        int n3 = 0;
        String string2 = null;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1, string.length());
        }
        if ((n2 = string.indexOf(46)) < 0) {
            n = Integer.parseInt(string);
        } else if (n2 == 0) {
            n = 0;
            string2 = string.substring(1, string.length());
        } else if (n2 == string.length() - 1) {
            n = Integer.parseInt(string.substring(0, n2));
        } else {
            n = Integer.parseInt(string.substring(0, n2));
            string2 = string.substring(n2 + 1, string.length());
        }
        if (string2 != null) {
            if (string2.length() > 5) {
                string2 = string2.substring(0, 5);
            }
            if (string2.length() > 0) {
                n3 = Integer.parseInt(string2);
                for (int i = 0; i < 5 - string2.length(); ++i) {
                    n3 *= 10;
                }
            }
        }
        int n4 = (n << 13) + n3 * 8192 / 100000;
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    public static String toString(int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        String string = Integer.toString((n & 0x1FFF) * 100000 / 8192);
        int n6 = 5 - string.length();
        for (n5 = 0; n5 < n6; ++n5) {
            string = "0" + string;
        }
        int n7 = n3 + 1 < string.length() ? n3 + 1 : string.length();
        int n8 = 0;
        char[] cArray = string.toCharArray();
        if (cArray[n7 - 1] < '5') {
            cArray[n7 - 1] = 48;
        } else {
            cArray[n7 - 1] = 48;
            for (n5 = n7 - 2; n5 >= 0; --n5) {
                if (cArray[n5] != '9') {
                    int n9 = n5;
                    cArray[n9] = (char)(cArray[n9] + '\u0001');
                    break;
                }
                cArray[n5] = 48;
            }
            if (n5 == -1) {
                n8 = 1;
            }
        }
        for (n5 = n7; n5 < cArray.length; ++n5) {
            cArray[n5] = 48;
        }
        string = String.valueOf(cArray);
        for (n5 = string.length() - 1; n5 >= 0 && string.charAt(n5) == '0'; --n5) {
        }
        string = string.substring(0, n5 + 1);
        for (n5 = string.length(); n5 < n2; ++n5) {
            string = string + "0";
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        if ((n4 = (n >> 13) + n8) < 0) {
            n4 = -n4;
        }
        for (n5 = string.length() - 1; n5 >= 0; --n5) {
            if (string.charAt(n5) == '0') continue;
            bl2 = true;
            break;
        }
        if (string.length() > 0) {
            string = "." + string;
        }
        return (bl && (n4 != 0 || bl2) ? "-" : "") + Integer.toString(n4) + string;
    }

    public static String toString(int n) {
        return OpenMathFP.toString(n, 0, 5);
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static int ceil(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if ((n & 0x1FFF) == 0) {
            return bl ? -n : n;
        }
        if (bl) {
            return -(n & 0xFFFFE000);
        }
        return (n & 0xFFFFE000) + 8192;
    }

    public static int floor(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if ((n & 0x1FFF) == 0) {
            return bl ? -n : n;
        }
        if (bl) {
            return -(n & 0xFFFFE000) - 8192;
        }
        return n & 0xFFFFE000;
    }

    public static int trunc(int n) {
        return n < 0 ? -(-n & 0xFFFFE000) : n & 0xFFFFE000;
    }

    public static int frac(int n) {
        return n < 0 ? -(-n & 0x1FFF) : n & 0x1FFF;
    }

    public static int round(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        n += 4096;
        return bl ? -n : (n &= 0xFFFFE000);
    }

    public static int mul_OLD(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (n2 < 0) {
            bl2 = true;
            n2 = -n2;
        }
        int n3 = ((n >> 13) * (n2 >> 13) << 13) + (n & 0x1FFF) * (n2 >> 13) + (n >> 13) * (n2 & 0x1FFF) + ((n & 0x1FFF) * (n2 & 0x1FFF) >> 13);
        if (bl ^ bl2) {
            n3 = -n3;
        }
        return n3;
    }

    public static int mul(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (n2 < 0) {
            bl2 = true;
            n2 = -n2;
        }
        int n3 = ((n >> 13) * (n2 >> 13) << 13) + (n & 0x1FFF) * (n2 >> 13) + (n >> 13) * (n2 & 0x1FFF) + ((n & 0x1FFF) * (n2 & 0x1FFF) >> 13);
        if (bl ^ bl2) {
            n3 = -n3;
        }
        return n3;
    }

    public static int div(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return n < 0 ? -2147483647 : Integer.MAX_VALUE;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (n2 < 0) {
            bl2 = true;
            n2 = -n2;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n & 1 << 30 - n3) == 0) {
            ++n3;
        }
        while ((n2 & 1 << n4) == 0) {
            ++n4;
        }
        int n5 = 13 - (n3 + n4);
        int n6 = (n << n3) / (n2 >> n4);
        n6 = n5 > 0 ? (n6 <<= n5) : (n6 >>= -n5);
        if (bl ^ bl2) {
            n6 = -n6;
        }
        return n6;
    }

    public static int sqrt(int n) {
        int n2 = n + 8192 >> 1;
        for (int i = 0; i < 8; ++i) {
            n2 = n2 + OpenMathFP.div(n, n2) >> 1;
        }
        return n2;
    }

    public static int sin(int n) {
        int n2 = 1;
        if ((n %= 51470) < 0) {
            n = 51470 + n;
        }
        if (n > 12867 && n <= 25735) {
            n = 25735 - n;
        } else if (n > 25735 && n <= 38602) {
            n -= 25735;
            n2 = -1;
        } else if (n > 38602) {
            n = 51470 - n;
            n2 = -1;
        }
        int n3 = OpenMathFP.mul(n, n);
        int n4 = SK[0];
        n4 = OpenMathFP.mul(n4, n3);
        n4 -= SK[1];
        n4 = OpenMathFP.mul(n4, n3);
        n4 += 8192;
        n4 = OpenMathFP.mul(n4, n);
        return n2 * n4;
    }

    public static int cos(int n) {
        return OpenMathFP.sin(12867 - n);
    }

    public static int tan(int n) {
        return OpenMathFP.div(OpenMathFP.sin(n), OpenMathFP.cos(n));
    }

    public static int asin(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = OpenMathFP.sqrt(8192 - n);
        int n3 = AS[0];
        n3 = OpenMathFP.mul(n3, n);
        n3 += AS[1];
        n3 = OpenMathFP.mul(n3, n);
        n3 -= AS[2];
        n3 = OpenMathFP.mul(n3, n);
        n3 += AS[3];
        n3 = 12867 - OpenMathFP.mul(n2, n3);
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    public static int acos(int n) {
        return 12867 - OpenMathFP.asin(n);
    }

    public static int atan(int n) {
        return OpenMathFP.asin(OpenMathFP.div(n, OpenMathFP.sqrt(8192 + OpenMathFP.mul(n, n))));
    }

    public static int atan2(int n, int n2) {
        if (n == 0) {
            if (n2 >= 0) {
                return 0;
            }
            if (n2 < 0) {
                return 25735;
            }
        } else if (n2 >= -ATAN2_ZERO_ERROR && n2 <= ATAN2_ZERO_ERROR) {
            return n > 0 ? 12867 : -12867;
        }
        int n3 = OpenMathFP.atan(OpenMathFP.abs(OpenMathFP.div(n, n2)));
        if (n2 > 0) {
            return n > 0 ? n3 : -n3;
        }
        return n > 0 ? 25735 - n3 : n3 - 25735;
    }

    public static int exp(int n) {
        if (n == 0) {
            return 8192;
        }
        int n2 = OpenMathFP.abs(n);
        int n3 = OpenMathFP.mul(n2, LN2_INV);
        n3 += 4096;
        n3 &= 0xFFFFE000;
        if (n < 0) {
            n3 = -n3;
        }
        int n4 = OpenMathFP.mul(n -= OpenMathFP.mul(n3, 5678), n);
        int n5 = 16384 + OpenMathFP.mul(n4, EXP_P[0] + OpenMathFP.mul(n4, EXP_P[1] + OpenMathFP.mul(n4, EXP_P[2] + OpenMathFP.mul(n4, EXP_P[3] + OpenMathFP.mul(n4, EXP_P[4])))));
        int n6 = 8192 + OpenMathFP.div(OpenMathFP.mul(16384, n), n5 - n);
        n3 = n3 < 0 ? 8192 >> (-n3 >> 13) : 8192 << (n3 >> 13);
        return OpenMathFP.mul(n3, n6);
    }

    public static int log(int n) {
        if (n < 0) {
            return 0;
        }
        if (n == 0) {
            return -2147483647;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 >= 16384) {
            n3 >>= 1;
            ++n2;
        }
        int n4 = n3 - 8192;
        int n5 = OpenMathFP.div(n4, 16384 + n4);
        int n6 = OpenMathFP.mul(n5, n5);
        int n7 = OpenMathFP.mul(n6, n6);
        int n8 = OpenMathFP.mul(n7, LG[1] + OpenMathFP.mul(n7, LG[3] + OpenMathFP.mul(n7, LG[5]))) + OpenMathFP.mul(n6, LG[0] + OpenMathFP.mul(n7, LG[2] + OpenMathFP.mul(n7, LG[4] + OpenMathFP.mul(n7, LG[6]))));
        return OpenMathFP.mul(5678, n2 << 13) + n4 - OpenMathFP.mul(n5, n4 - n8);
    }

    public static int log(int n, int n2) {
        return OpenMathFP.div(OpenMathFP.log(n), OpenMathFP.log(n2));
    }

    public static int pow(int n, int n2) {
        if (n2 == 0) {
            return 8192;
        }
        if (n < 0) {
            return 0;
        }
        return OpenMathFP.exp(OpenMathFP.mul(OpenMathFP.log(n), n2));
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static int deg2rad(int n) {
        return OpenMathFP.mul(n, 142);
    }

    public static int rad2deg(int n) {
        return OpenMathFP.mul(n, 469376);
    }

    public static void setVect(int n, int n2) {
        int n3 = n / 90;
        int n4 = n - 90 * n3;
        OpenMathFP.GoTo(n4, n3, n2);
    }

    private static void GoTo(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n > 90) {
            n = 90;
        }
        int n4 = n;
        int n5 = iSINUS[90 - n4] * n3;
        int n6 = iSINUS[n4] * n3;
        switch (n2) {
            case 0: {
                iX_vect = n5;
                iY_vect = n6;
                break;
            }
            case 1: {
                iX_vect = -n6;
                iY_vect = n5;
                break;
            }
            case 2: {
                iX_vect = -n5;
                iY_vect = -n6;
                break;
            }
            case 3: {
                iX_vect = n6;
                iY_vect = -n5;
            }
        }
        iX_vect /= 10000;
        iY_vect /= 10000;
    }
}

