/*
 * Decompiled with CFR 0.152.
 */
public abstract class GMain
extends Application {
    public static final String NAME = "BreakSpin";
    public static final String VERSION = "1.0.1";
    public static GMain instance = null;
    static final int[] STRINGS_OFF_ON = new int[]{8, 7};
    protected static final int RUN_INITIAL = 0;
    protected static final int RUN_LOAD = 1;
    protected static final int RUN_MENU = 2;
    protected static final int RUN_GAME = 3;
    protected static final int RUN_BLOCK = 6;
    private static final int SC_INITIAL = 0;
    public static final int SC_LOAD = 1;
    private static final int SC_MENU = 2;
    private static final int SC_GAME = 3;
    private static final int SC_BUSY = 4;
    private static final int SC_LOADING = 5;
    private static final int SC_BLOCK = 6;
    public static final int RESUME_SOUND_DELAY = 1500;
    private static final int CHEAT_BEGIN = 12;
    private static final int CHEAT_END = 11;
    boolean loadingEnd = false;
    public static final int LOAD_MRC = 1;
    public static final int LOAD_RMS = 2;
    public static final int LOAD_LANG = 4;
    public static final int LOAD_TITLE = 8;
    public static final int LOAD_TITLE_DIN = 0;
    public static final int LOAD_TITLE_IMAGES = 1;
    public static final int LOAD_TITLE_SOUND = 2;
    public static final int LOAD_TITLE_GAMEXML = 3;
    public static final int LOAD_SPRITES = 16;
    public static final int LOAD_FONTS = 32;
    public static final int LOAD_LANGUAGE = 64;
    public static final int LOAD_MENURES = 128;
    public static final int LOAD_MENUCREAT = 256;
    public static final int LOAD_SAVERMS = 512;
    public static final int LOAD_END = 1024;
    protected int loadingState = 1;
    protected int loadingSubState = -1;
    public static int gameLoadingProgress = 0;
    protected int runCmd = 0;
    protected static int actScreen = 0;
    public static final int MENU_FPS = 14;
    public static GameCommon game;
    public static int canvasWidth;
    public static int canvasHeight;
    public static int pressedKeyCode;
    public static boolean firstStart;
    public static int numbersLang;
    public static int langIndex;
    public static String[] langCodes;
    public static String[] strings;
    public static String bonusURL;
    public static String portalURL;
    public static String disneyURL;
    public static String communityURL;
    public static boolean demoMode;
    public static String[] demoMessage;
    public static String[] demoURL;
    public static boolean MRCEnabled;
    public static String mrcURL;
    private int cheatCode;
    private int cheatCodeSize;
    boolean cheatEnable = false;
    private boolean cheatWriting = false;
    private boolean cheatProcess;
    private final boolean userCheatWriting;
    protected GForm activeForm;
    protected GForm mainMenu;
    protected GForm gameMenu;
    private boolean isShown;
    private boolean showNotifySeen;
    private boolean hideNotifySeen;
    static int introProgress;
    public static PlatformImage[] imageCache;
    public static byte[] imageColorVariantsCnt;
    public static PlatformImage[] imageCacheL18N;
    public static byte[] imageColorVariantsCntL18N;
    private PlatformResource ltDin;
    private int ltImageCount;
    private int ltIndex;
    public static byte prevSndOpt;
    private static final int BLOCK_HEIGHT = 0;
    private static final int BLOCK_FONT = 2;
    public static final int OPT_VIBRATION = 0;
    public static final int OPT_VOLUME = 1;
    public static final int OPT_SOUND = 2;
    public static final int OPT_SHOW_TEXTS_AND_ANIMATIONS = 3;
    public static final int OPT_DIFFICULTY_HARD = 4;
    public static final int OPT_SHOW_HINTS = 5;
    public static final int OPT_SHOW_TUTORIAL = 6;
    protected static byte[] options;

    public GMain() {
        this.userCheatWriting = false;
        instance = this;
        imageCache = new PlatformImage[20];
        imageColorVariantsCnt = new byte[20];
    }

    public void pause() {
        this.hideNotifySeen = true;
        if (game != null) {
            game.hideNotify();
        }
    }

    public void resume() {
        this.showNotifySeen = true;
    }

    public void keyPressed(int n) {
        if (!this.loadingEnd) {
            pressedKeyCode = 0;
            if (n == 13) {
                // empty if block
            }
            if (this.runCmd == 0 || this.runCmd == 1) {
                pressedKeyCode = 0;
                return;
            }
        }
        if (n == 13 && this.activeForm != this.mainMenu) {
            n = 15;
        }
        if (this.cheatWriting) {
            if (n == 11) {
                if (this.cheatCode == 0 && this.cheatCodeSize == 3) {
                    this.cheatEnable = !this.cheatEnable;
                } else {
                    this.cheatProcess = this.cheatEnable;
                }
                this.cheatWriting = false;
                return;
            }
            if (this.cheatCodeSize == 4 || n < 1 || n > 10) {
                this.cheatWriting = false;
                return;
            }
            int n2 = n - 1;
            this.cheatCode = this.cheatCode << 4 | n2;
            ++this.cheatCodeSize;
            if (this.cheatEnable) {
                return;
            }
        } else if (n == 12) {
            if (!this.cheatEnable) {
                if (this.activeForm != null && (this.activeForm.formId & 0x4000) != 0) {
                    this.cheatCode = 0;
                    this.cheatCodeSize = 0;
                    this.cheatWriting = true;
                }
            } else if (this.cheatEnable || game == null) {
                this.cheatCode = 0;
                this.cheatCodeSize = 0;
                this.cheatWriting = true;
            }
            return;
        }
        if (actScreen == 3) {
            game.keyPressed(n);
        } else {
            pressedKeyCode = n;
        }
    }

    public void keyReleased(int n) {
        if (actScreen == 3) {
            game.keyReleased(n);
        }
    }

    public static int mapLogicalKey(int n) {
        return n;
    }

    public static int mapYesNoKey(int n) {
        switch (n) {
            case 14: {
                return 1;
            }
            case 15: {
                return -1;
            }
        }
        return 0;
    }

    public void update() {
        switch (this.runCmd) {
            case 0: {
                boolean bl;
                firstStart = Platform.readRecord(0) == null;
                this.initDeafultOptions();
                if (firstStart && (bl = this.loadLang())) {
                    this.setActiveForm(this.createLangForm());
                    this.runCmd = 2;
                    actScreen = 2;
                    this.loadingState = 1;
                    return;
                }
                this.runCmd = 1;
                actScreen = 1;
                this.loadingState = 2;
                break;
            }
            case 1: {
                this.updateLoading();
                break;
            }
            case 2: {
                if (this.hideNotifySeen) {
                    if (!this.showNotifySeen) {
                        return;
                    }
                    pressedKeyCode = 0;
                    this.hideNotifySeen = false;
                    this.showNotifySeen = false;
                    if (game == null) {
                        Platform.sleep(1500);
                        Sound.playSound(0);
                    }
                }
                if (this.cheatProcess) {
                    this.cheatProcess = false;
                    this.processCheat(this.cheatCode, this.cheatCodeSize);
                }
                int n = pressedKeyCode;
                pressedKeyCode = 0;
                if (n != 0) {
                    this.controlActiveForm(this.activeForm, n);
                    if (this.runCmd != 2) break;
                }
                this.updateMenu();
                break;
            }
            case 3: {
                boolean bl = false;
                if (this.hideNotifySeen) {
                    if (!this.showNotifySeen) {
                        return;
                    }
                    bl = true;
                    this.hideNotifySeen = false;
                    this.showNotifySeen = false;
                }
                boolean bl2 = GameCommon.paused;
                if (bl || bl2) {
                    if (bl2) {
                        game.hideNotify();
                    }
                    this.runCmd = 2;
                    this.gameMenu.reset();
                    this.setActiveForm(this.gameMenu);
                    if (bl) break;
                    Sound.stopSound();
                    break;
                }
                if (this.cheatProcess) {
                    this.cheatProcess = false;
                    this.processCheat(this.cheatCode, this.cheatCodeSize);
                }
                if (!game.evolve()) break;
                this.leaveGame();
                break;
            }
        }
    }

    public void showGameMenu() {
    }

    protected void initDeafultOptions() {
        GMain.setOption(5, 1);
        GMain.setOption(6, 1);
        GMain.setOption(1, 0);
    }

    protected void updateMenu() {
        int n = (int)Platform.clock();
        Platform.redraw();
        int n2 = (int)Platform.clock() - n;
        int n3 = 71 - n2;
        if (n3 > 10) {
            n3 = Math.min(100, n3);
            Platform.sleep(n3);
        }
    }

    protected void drawLoad() {
    }

    protected void releaseLoad() {
    }

    protected boolean updateLoad(int n) {
        gameLoadingProgress |= n;
        ++introProgress;
        return true;
    }

    public static void updateProgress() {
        if (instance == null || GMain.instance.runCmd == 1) {
            // empty if block
        }
    }

    private void updateLoading() {
        switch (this.loadingState) {
            case 2: {
                if (!firstStart) {
                    this.loadRms(0);
                    this.loadLang();
                }
                this.loadingState = 1;
                return;
            }
            case 1: {
                if (!this.loadMRC()) {
                    return;
                }
                this.updateLoad(1);
                this.loadingState = 8;
                this.loadingSubState = 0;
                return;
            }
            case 8: {
                if (this.loadTitle()) {
                    this.loadingState = 16;
                }
                this.updateLoad(8);
                return;
            }
            case 16: {
                this.loadSprites();
                this.updateLoad(16);
                this.loadingState = 32;
                return;
            }
            case 32: {
                this.loadFonts();
                this.updateLoad(32);
                this.loadingState = 64;
                return;
            }
            case 64: {
                this.updateLanguage();
                this.updateLoad(64);
                this.loadingState = 128;
                return;
            }
            case 128: {
                if (this.loadCommon()) {
                    this.loadingState = 256;
                }
                this.updateLoad(128);
                return;
            }
            case 256: {
                this.mainMenu = this.createMainMenu();
                this.updateLoad(256);
                this.loadingState = 512;
                return;
            }
            case 512: {
                if (firstStart) {
                    this.saveRms(0);
                }
                this.loadingState = 1024;
                return;
            }
            case 1024: {
                if (this.updateLoad(1024)) {
                    this.setActiveForm(this.getInitialForm());
                    this.loadingEnd = true;
                    this.runCmd = 2;
                    actScreen = 2;
                    pressedKeyCode = 0;
                } else {
                    Platform.sleep(200);
                }
                return;
            }
        }
    }

    protected void loadFonts() {
        if (!Fonts.initFont()) {
            return;
        }
        PlatformResource platformResource = Platform.getResource(Fonts.fontName);
        Fonts.readFontGraphics(platformResource);
        platformResource.close();
    }

    private boolean loadLang() {
        String string;
        PlatformResource platformResource = Platform.getResource("/lang");
        if (platformResource == null) {
            numbersLang = 0;
            langCodes = null;
            return false;
        }
        langCodes = Utils.readStrings(platformResource);
        numbersLang = 0;
        for (int i = 0; i < langCodes.length; ++i) {
            Platform.assertTrue(langCodes[i] != null, "invalid langCodes");
            string = "/l18n__".concat(langCodes[i]);
            PlatformResource platformResource2 = Platform.getResource(string);
            if (platformResource2 == null) {
                GMain.langCodes[i] = null;
                continue;
            }
            GMain.langCodes[GMain.numbersLang] = langCodes[i];
            platformResource2.close();
            ++numbersLang;
        }
        demoURL = new String[numbersLang];
        demoMessage = new String[numbersLang];
        while (!platformResource.isEOF()) {
            int n;
            String string2 = platformResource.readUTF();
            if ("demo".equals(string2)) {
                demoMode = true;
                continue;
            }
            string = platformResource.readUTF();
            int n2 = string2.length();
            if ("portalURL".equals(string2)) {
                portalURL = GMain.getPropertyURL(string);
            }
            if ("disneyURL".equals(string2)) {
                disneyURL = GMain.getPropertyURL(string);
            }
            if ("mrcURL".equals(string2)) {
                mrcURL = GMain.getPropertyURL(string);
            }
            if ("bonusURL".equals(string2)) {
                bonusURL = GMain.getPropertyURL(string);
            }
            if ("communityURL".equals(string2)) {
                communityURL = GMain.getPropertyURL(string);
            }
            if (string2.startsWith("demoURL__") && n2 == "demoURL__".length() + 2) {
                for (n = 0; n < numbersLang; ++n) {
                    if (!string2.startsWith(langCodes[n], n2 - 2)) continue;
                    GMain.demoURL[n] = GMain.getPropertyURL(string);
                }
            }
            if (!string2.startsWith("demoMsg__") || n2 != "demoMsg__".length() + 2) continue;
            for (n = 0; n < numbersLang; ++n) {
                if (!string2.startsWith(langCodes[n], n2 - 2)) continue;
                GMain.demoMessage[n] = string;
            }
        }
        platformResource.close();
        String string3 = Platform.getManifestProperty("DemoMode");
        if (string3 != null && string3.length() > 0) {
            demoMode = string3.equals("ON");
        }
        if (langIndex >= 0 && langIndex < numbersLang) {
            return false;
        }
        string = Platform.getLocale();
        if (string == null) {
            langIndex = 0;
        } else {
            for (langIndex = 0; langIndex < numbersLang && !string.startsWith(langCodes[langIndex]); ++langIndex) {
            }
            if (langIndex >= numbersLang) {
                langIndex = 0;
            }
        }
        return numbersLang > 1;
    }

    protected boolean loadMRC() {
        boolean bl = MRCEnabled = "ON".equals(Platform.getManifestProperty("EnableMRC")) && mrcURL != null;
        if (MRCEnabled) {
            boolean bl2 = false;
            String string = mrcURL + "&subNo=" + Platform.getManifestProperty("CarrierDeviceId");
            PlatformResource platformResource = Platform.openConnection(string);
            if (platformResource != null) {
                int n;
                byte[] byArray = new byte[10];
                byte by = 0;
                for (n = 0; (by = platformResource.readByte()) != -1 && n < 10; ++n) {
                    byArray[n] = by;
                }
                String string2 = new String(byArray, 0, n);
                if (string2.trim().equals("valid")) {
                    bl2 = true;
                }
                if (platformResource != null) {
                    platformResource.close();
                    platformResource = null;
                }
                Platform.alert("License: " + string2);
            } else {
                Platform.alert("License: connection failed");
            }
            if (!bl2) {
                Platform.exit();
                return false;
            }
        }
        return true;
    }

    protected boolean loadTitle() {
        switch (this.loadingSubState) {
            case 0: {
                this.ltDin = Platform.getResource("/l");
                this.ltImageCount = this.ltDin.readByte() & 0xFF;
                this.ltIndex = 0;
                this.loadingSubState = 1;
                return false;
            }
            case 1: {
                if (this.ltIndex < this.ltImageCount) {
                    int n;
                    Utils.readDiffImage(this.ltDin, imageCache, imageColorVariantsCnt, this.ltIndex, -1);
                    this.ltIndex += Math.max(1, n);
                    for (n = imageColorVariantsCnt[this.ltIndex]; n > 1; --n) {
                        Utils.readDiffImage(this.ltDin, imageCache, imageColorVariantsCnt, 0, -1);
                    }
                } else {
                    this.loadingSubState = 2;
                }
                return false;
            }
            case 2: {
                Sound.readSnd(this.ltDin);
                this.loadingSubState = 3;
                return false;
            }
            case 3: {
                this.loadTitle(this.ltDin);
                this.ltDin.close();
                return true;
            }
        }
        return false;
    }

    protected abstract void loadTitle(PlatformResource var1);

    protected abstract boolean loadCommon();

    protected void loadSprites() {
        PlatformResource platformResource = Platform.getResource("/spr");
        short s = platformResource.readShort();
        Sprite.initImageCache(s);
        Sprite.readFragments(platformResource);
        int n = platformResource.readShort();
        Sprite.initDefCache(n);
        Sprite sprite = null;
        for (int i = 0; i < n; ++i) {
            Sprite sprite2 = new Sprite();
            sprite2.cacheIndex = i;
            sprite2.readDef(platformResource);
            if (sprite2.getPathsCount() == 0) {
                if (sprite == null) {
                    sprite = sprite2;
                } else {
                    sprite2 = sprite;
                }
            }
            Sprite.sprites[i] = sprite2;
        }
        platformResource.close();
    }

    protected void enterGame() {
        this.setActiveForm(null);
        GMain.showLoading();
        Sound.stopSound();
        Main.freeMenuRes();
        Main.freeMenuAnimations();
        game = this.createGame();
        game.enterNotify();
        game.showNotify();
        this.runCmd = 3;
        actScreen = 3;
    }

    protected GameCommon createGame() {
        return null;
    }

    protected void leaveGame() {
        Sound.stopSound();
        this.runCmd = 2;
        actScreen = 2;
        game.leaveNotify();
        game = null;
        Sound.playSound(0);
    }

    protected void resumeGame() {
        this.setActiveForm(null);
        game.showNotify();
        this.runCmd = 3;
        actScreen = 3;
    }

    public void paint() {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.translate(-platformGraphics.getTranslateX(), -platformGraphics.getTranslateY());
        switch (actScreen) {
            case 1: {
                canvasWidth = Platform.getDisplayWidth();
                canvasHeight = Platform.getDisplayHeight();
                this.drawLoad();
                this.drawDemo(platformGraphics);
                break;
            }
            case 3: {
                game.paint();
                break;
            }
            case 2: {
                this.drawActiveForm(this.activeForm);
                this.drawDemo(platformGraphics);
                break;
            }
            case 4: {
                this.drawBusy();
                this.drawDemo(platformGraphics);
                break;
            }
            case 5: {
                this.drawLoading(platformGraphics);
                this.drawDemo(platformGraphics);
            }
        }
    }

    private void drawDemo(PlatformGraphics platformGraphics) {
        if (demoMode) {
            if (!this.loadingEnd) {
                if (this.loadingState > 16 && platformGraphics != null && imageCache != null && imageCache.length > 19 && imageCache[19] != null) {
                    platformGraphics.drawImage(imageCache[19], 0, 0, 20);
                }
            } else {
                platformGraphics.drawImage(imageCache[19], 0, 0, 20);
            }
        }
    }

    public void setActiveForm(GForm gForm) {
        if (this.activeForm == gForm) {
            return;
        }
        GForm gForm2 = this.activeForm;
        this.activeForm = null;
        if (gForm2 != null) {
            this.leaveForm(gForm2);
        }
        if (gForm != null) {
            this.enterForm(gForm);
            this.activeForm = gForm;
            if (actScreen == 3) {
                actScreen = 2;
            }
            this.activeForm.setLabels();
        }
    }

    protected void leaveForm(GForm gForm) {
    }

    protected void enterForm(GForm gForm) {
    }

    public static GForm createMenuForm() {
        int n = Utils.getFormHeight(134, 40);
        GForm gForm = new GForm(canvasWidth - 60, n);
        gForm.dx0 = 30;
        gForm.dy0 = 134;
        gForm.contentHeight = gForm.height;
        gForm.anchor = 20;
        gForm.formId = 32;
        gForm.itemListener = instance;
        return gForm;
    }

    public static Item createMenuItem(int n, String[] stringArray) {
        Item item = new Item(0, n);
        item.fontNormal = (byte)3;
        item.fontSelected = (byte)2;
        item.messageTable = stringArray;
        return item;
    }

    public static Item createMenuItem(String[] stringArray) {
        Item item = new Item(0, stringArray[0]);
        item.fontNormal = (byte)3;
        item.fontSelected = (byte)2;
        item.multiLineMenuItem = true;
        item.multilineString = stringArray;
        return item;
    }

    public static Item createMenuItem(String string) {
        Item item = new Item(0, string);
        item.fontNormal = (byte)3;
        item.fontSelected = (byte)2;
        return item;
    }

    public static Item createBackItem(int n, GForm gForm) {
        Item item = new Item(3, n);
        item.data = gForm;
        return item;
    }

    protected GForm createSoundEnableForm(GForm gForm) {
        prevSndOpt = GMain.getOption(1);
        GMain.setOption(1, 0);
        Item item = GMain.createBackItem(9, gForm);
        item.inputConstrain = 1;
        GForm gForm2 = this.createYesNoForm(item, gForm, strings[37]);
        gForm2.formId |= 0x1000;
        return gForm2;
    }

    protected GForm createHeadedInfoForm(String string, Item item, Item item2) {
        int n = Utils.getFormHeight(134, 60);
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.formId |= 0x11;
        gForm.dx0 = canvasWidth >> 1;
        gForm.dy0 = 134;
        gForm.anchor = 17;
        gForm.addMultiText(string);
        gForm.selectSoftCmd = item;
        gForm.backSoftCmd = item2;
        gForm.reset();
        gForm.itemListener = this;
        return gForm;
    }

    protected GForm createYesNoForm(Item item, GForm gForm, String string) {
        Item item2 = null;
        if (gForm != null) {
            item2 = GMain.createBackItem(10, gForm);
        }
        GForm gForm2 = null;
        gForm2 = this.createHeadedInfoForm(string, item, item2);
        return gForm2;
    }

    protected GForm createBrowserForm(Item item, GForm gForm, String string) {
        Item item2 = null;
        if (gForm != null) {
            item2 = GMain.createBackItem(5, gForm);
        }
        GForm gForm2 = this.createHeadedInfoForm(string, item, item2);
        return gForm2;
    }

    public static final int getImageWidth(int n) {
        return imageCache[n].getWidth();
    }

    public static final int getImageHeight(int n) {
        return imageCache[n].getHeight();
    }

    public static final PlatformImage getImage(int n) {
        return imageCache[n];
    }

    public static final void replaceImage(int n, PlatformImage platformImage) {
        GMain.imageCache[n] = platformImage;
    }

    protected GForm createTextForm() {
        int n = Utils.getFormHeight(55, 40);
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.formId = 264;
        gForm.anchor = 20;
        gForm.dx0 = 25;
        gForm.dy0 = 55;
        return gForm;
    }

    protected void fillTextForm(GForm gForm, String string) {
        gForm.addMultiText(string);
    }

    protected Item createImageItem(GForm gForm, int n) {
        return null;
    }

    protected GForm createLangForm() {
        Item item;
        canvasWidth = Platform.getDisplayWidth();
        canvasHeight = Platform.getDisplayHeight();
        int n = canvasHeight - 55 - 40;
        Main.SOFT_LIST_H = 22;
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.formId |= 0xA20;
        gForm.formId |= 0x30000;
        gForm.anchor = 20;
        gForm.dx0 = canvasWidth / 8;
        gForm.dy0 = 55;
        int n2 = 0;
        for (int i = 0; i < langCodes.length; ++i) {
            Item item2;
            PlatformImage platformImage = Platform.createImage(0, "/lp__".concat(langCodes[i]));
            Platform.assertTrue(platformImage != null, "GMain.createLangForm");
            if (platformImage != null) {
                int n3 = platformImage.getHeight();
                n2 = Math.max(n2, n3);
                item2 = gForm.addItem(new Item(0, platformImage));
            } else {
                item2 = gForm.addItem(new Item(0, langCodes[i]));
            }
            item2.inputConstrain = (byte)i;
        }
        Main.loadImage(7, 1);
        Main.loadImage(0, 2);
        gForm.selectSoftCmd = item = new Item(4, GMain.getImage(7));
        gForm.itemListener = this;
        gForm.reset();
        return gForm;
    }

    protected void showAbout(Item item, int n, int n2, int n3) {
    }

    protected GForm showHelp(String string, int n, int n2, int n3, int[] nArray) {
        return null;
    }

    protected void drawActiveForm(GForm gForm) {
        if (gForm == null) {
            return;
        }
        if (gForm.contentHeight < 0) {
            this.initFormContent(gForm);
        }
        this.drawFormBackground(gForm, false);
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        gForm.paint(platformGraphics);
        platformGraphics.translate(-platformGraphics.getTranslateX(), -platformGraphics.getTranslateY());
    }

    protected void initFormContent(GForm gForm) {
        gForm.contentHeight = gForm.height;
        gForm.reset();
    }

    protected void drawFormBackground(GForm gForm, boolean bl) {
    }

    public void drawArrows(GForm gForm, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    public void loadRms(int n) {
        byte[] byArray = Platform.readRecord(n);
        ByteArrayBuffer byteArrayBuffer = null;
        if (byArray != null) {
            byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.set(byArray, 0, byArray.length);
        }
        this.readRms(n, byteArrayBuffer);
    }

    public void saveRms(int n) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byte[] byArray = new byte[1024];
        byteArrayBuffer.set(byArray, 0, byArray.length);
        this.writeRms(n, byteArrayBuffer);
        Platform.writeRecord(n, byArray, byteArrayBuffer.getPosition());
    }

    protected void readRms(int n, ByteArrayBuffer byteArrayBuffer) {
    }

    protected void writeRms(int n, ByteArrayBuffer byteArrayBuffer) {
    }

    protected void updateLanguage() {
        String string = "/l18n";
        if (langCodes != null) {
            string = "/l18n__".concat(langCodes[langIndex]);
        }
        PlatformResource platformResource = Platform.getResource(string);
        this.updateLanguage(platformResource);
        platformResource.close();
        GForm gForm = this.activeForm;
        if (gForm != null) {
            gForm.setLabels();
        }
    }

    protected void updateLanguage(PlatformResource platformResource) {
        platformResource.readShort();
        int n = platformResource.readUnsignedShort();
        if (imageCacheL18N == null) {
            imageCacheL18N = new PlatformImage[n];
            imageColorVariantsCntL18N = new byte[n];
        }
        for (int i = 0; i < n; ++i) {
            GMain.imageCacheL18N[i] = null;
            GMain.imageColorVariantsCntL18N[i] = 0;
        }
        Utils.readImages(platformResource, imageCacheL18N, imageColorVariantsCntL18N, n);
        platformResource.readShort();
        strings = GMain.updateLanguage(strings, platformResource);
        GMain.strings[60] = strings[57] + " / " + strings[58];
        GMain.strings[61] = "//";
        GMain.strings[62] = "////";
        GMain.strings[63] = "//////";
        platformResource.readShort();
        this.readMessages(platformResource);
        this.updateSTRfromTXT();
    }

    protected void readMessages(PlatformResource platformResource) {
    }

    protected void updateSTRfromTXT() {
    }

    public static String[] updateLanguage(String[] stringArray, PlatformResource platformResource) {
        String[] stringArray2 = Utils.readStrings(platformResource);
        if (stringArray == null) {
            stringArray = stringArray2;
        } else {
            Platform.assertTrue(stringArray.length == stringArray2.length, "illegal messages: old=" + stringArray.length + " new=" + stringArray2.length);
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = stringArray2[i];
            }
        }
        return stringArray;
    }

    protected void controlActiveForm(GForm gForm, int n) {
        if (gForm == null) {
            return;
        }
        if (gForm.sections != null) {
            if (n == 20 || n == 19 || n == 5 || n == 7) {
                if (n == 20 || n == 7) {
                    if (gForm.scrollableRight) {
                        gForm.scrollableLeft = true;
                        gForm.scrollableRight = ++gForm.actualSection != gForm.sections.length - 1;
                    }
                } else if (gForm.scrollableLeft) {
                    gForm.scrollableRight = true;
                    gForm.scrollableLeft = --gForm.actualSection != 0;
                }
                gForm.items = gForm.sections[gForm.actualSection];
                gForm.reset();
            } else {
                gForm.keyPressed(n);
            }
        } else {
            gForm.keyPressed(n);
        }
    }

    protected static void showBusy() {
        int n = actScreen;
        actScreen = 4;
        Platform.redraw();
        actScreen = n;
    }

    protected static void showLoading() {
        actScreen = 5;
        Platform.redraw();
    }

    protected void drawBusy() {
    }

    protected void drawLoading(PlatformGraphics platformGraphics) {
    }

    protected boolean processCheat(int n, int n2) {
        return true;
    }

    protected GForm getInitialForm() {
        return this.createSoundEnableForm(this.mainMenu);
    }

    protected abstract GForm createMainMenu();

    protected abstract void actionPerformed(Item var1, GForm var2);

    protected void drawItem(GForm gForm, Item item, int n) {
    }

    protected abstract void selectionChanged(GForm var1, Item var2, Item var3);

    protected void openURL(String string) {
        Platform.openURL(string);
        this.setActiveForm(this.mainMenu);
    }

    private static String getPropertyURL(String string) {
        if (!string.startsWith("jad:")) {
            return string;
        }
        int n = (string = string.substring("jad:".length())).lastIndexOf(124);
        if (n == -1 || string.substring(n + 1).trim().length() == 0) {
            String string2 = n == -1 ? string : string.substring(0, n);
            String string3 = Platform.getManifestProperty(string2);
            return string3;
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + 1);
        String string6 = Platform.getManifestProperty(string4);
        if (string6 == null) {
            return null;
        }
        String string7 = string5 + "&url=" + GMain.encodeURL(string6);
        if (string7.length() > 128) {
            return string6;
        }
        return string7;
    }

    private static String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("+");
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '-' || c == '_' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("%");
            stringBuffer.append(Utils.itoa(c, 16));
        }
        return stringBuffer.toString();
    }

    public void sizeChanged(int n, int n2) {
    }

    public static void setOption(int n, int n2) {
        byte by = options[n];
        GMain.options[n] = (byte)n2;
        if (n == 1) {
            if (n2 == 0) {
                Sound.stopSound();
            } else {
                Sound.setVolume(n2);
                if (game == null && by == 0) {
                    Sound.playSound(0);
                }
            }
        }
        if (n == 2) {
            // empty if block
        }
    }

    public static final byte getOption(int n) {
        return options[n];
    }

    static {
        numbersLang = -1;
        langIndex = -1;
        MRCEnabled = false;
        prevSndOpt = (byte)-1;
        options = new byte[]{1, 0, 0, 0, 0, 1, 0};
    }
}

