/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractCanvasState;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.graphics.Label;
import com.foxmobile.ghostcamera.framework.graphics.Sprite;
import com.foxmobile.ghostcamera.framework.resources.PreparedResources;
import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import com.foxmobile.ghostcamera.graphics.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MenuState
extends AbstractCanvasState {
    private static final String TAG;
    private static final int TOTAL_MENU_ITEMS = 5;
    private Image background;
    private Sprite cursor;
    private Label headerLabel;
    private Label[] menuLabels;
    private AppFont headerFont;
    private AppFont defaultFont;
    private int menuItemHeight;
    private int menuHeight;
    private int indent;
    private int menuTop;
    private boolean cursorEnabled = false;
    private int chosenMenuItem = 0;
    private float baseCursorY = 0.0f;
    private float cursorPhase = 0.0f;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.controller.state.MenuState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public MenuState(Canvas canvas) {
        super(canvas);
    }

    private void prepareMenuResources() {
        PreparedResources resources;
        DeviceTraits deviceTraits = AppController.getInstance().getDeviceTraits();
        if (deviceTraits.isSmallHeap() && (resources = AppController.getInstance().getPreparedResources()).getResource("menuBackground") == null) {
            Image menuBackground = ResourceProvider.getInstance().loadBitmap("menu_bg-");
            if (deviceTraits.getCanvasWidth() <= menuBackground.getWidth()) {
                resources.putResource("menuBackground", menuBackground);
            } else {
                resources.putResource("menuBackground", Bitmaps.scaleImageForBackground(menuBackground));
            }
        }
    }

    protected void doBeforeLoop() {
        AppController controller = AppController.getInstance();
        this.prepareMenuResources();
        this.background = (Image)controller.getPreparedResources().getResource("menuBackground");
        this.headerFont = (AppFont)controller.getPreparedResources().getResource("headerFont");
        this.defaultFont = (AppFont)controller.getPreparedResources().getResource("defaultFont");
        this.headerLabel = new Label(controller.getString("MAINMENUHEADER"), this.headerFont, this.canvas.getGraphics());
        this.headerLabel.setX((this.canvas.getWidth() - this.headerLabel.getWidth()) / 2);
        this.headerLabel.setY(this.headerLabel.getHeight() / 4 + this.headerLabel.getFont().getBaseline());
        this.initMenu();
        this.initCursor();
    }

    private void initCursor() {
        this.cursor = new Sprite("arrow-right", true);
        if (this.indent - this.cursor.getWidth() > -5) {
            this.cursorEnabled = true;
            this.cursor.setX(this.indent - this.cursor.getWidth());
            this.setChosenItem(0);
        }
        Log.log(TAG, "Cursor {0}enabled", this.cursorEnabled ? "" : "not ");
    }

    private void setChosenItem(int i) {
        this.chosenMenuItem = i;
        this.baseCursorY = this.menuTop + this.chosenMenuItem * this.menuItemHeight + this.menuItemHeight - this.defaultFont.getDescent() - this.cursor.getHeight() / 2 - this.defaultFont.getAscent() / 2;
    }

    private void initMenu() {
        AppController controller = AppController.getInstance();
        this.menuHeight = this.canvas.getHeight() - this.headerLabel.getHeight() - this.headerLabel.getHeight() / 4;
        this.menuItemHeight = (this.menuHeight - this.defaultFont.getLineHeight()) / 5;
        Graphics graphics = this.canvas.getGraphics();
        this.menuLabels = new Label[5];
        int i = 0;
        this.menuLabels[i++] = new Label(String.valueOf(i) + " " + controller.getString("TAKEPICTUREITEM"), this.defaultFont, graphics);
        this.menuLabels[i++] = new Label(String.valueOf(i) + " " + controller.getString("DISPLAYHELPITEM"), this.defaultFont, graphics);
        this.menuLabels[i++] = new Label(String.valueOf(i) + " " + controller.getString("SETTINGSITEM"), this.defaultFont, graphics);
        this.menuLabels[i++] = new Label(String.valueOf(i) + " " + controller.getString("MOREAPPSITEM"), this.defaultFont, graphics);
        this.menuLabels[i++] = new Label(String.valueOf(i) + " " + controller.getString("EXITITEM"), this.defaultFont, graphics);
        this.menuTop = this.canvas.getHeight() - this.menuHeight;
        int maxWidth = 0;
        int j = 0;
        while (j < 5) {
            int y = this.menuTop + j * this.menuItemHeight + this.menuItemHeight - this.defaultFont.getDescent();
            this.menuLabels[j].setY(y);
            if (this.menuLabels[j].getWidth() > maxWidth) {
                maxWidth = this.menuLabels[j].getWidth();
            }
            ++j;
        }
        this.indent = (this.canvas.getWidth() - maxWidth) / 2;
        j = 0;
        while (j < 5) {
            this.menuLabels[j].setX(this.indent);
            ++j;
        }
    }

    protected void executeRedraw(Graphics graphics, Timing timing) {
        this.clearScreen(graphics);
        graphics.drawImage(this.background, 0, 0, 0);
        this.headerLabel.blit(graphics);
        int i = 0;
        while (i < 5) {
            this.menuLabels[i].blit(graphics);
            ++i;
        }
        if (this.cursorEnabled) {
            this.cursor.blit(graphics);
        }
    }

    protected void afterFlush(Timing timing) {
        super.afterFlush(timing);
        if (this.cursorEnabled) {
            float angleDelta = timing.calculateDelta((float)Math.PI * 2);
            this.cursorPhase += angleDelta;
            if ((double)this.cursorPhase >= Math.PI * 2) {
                this.cursorPhase = 0.0f;
            }
            float amplitude = 3.0f;
            float distance = (float)Math.cos(this.cursorPhase) * amplitude;
            this.cursor.setY(this.baseCursorY + distance);
        }
    }

    public void handleKeyPressed(int keyCode) {
        super.handleKeyPressed(keyCode);
        DeviceTraits deviceTraits = AppController.getInstance().getDeviceTraits();
        if (this.cursorEnabled) {
            if (deviceTraits.isDownKeyCode(keyCode)) {
                this.setChosenItem((this.chosenMenuItem + 1) % 5);
            } else if (deviceTraits.isUpKeyCode(keyCode)) {
                if (this.chosenMenuItem == 0) {
                    this.setChosenItem(4);
                } else {
                    this.setChosenItem(this.chosenMenuItem - 1);
                }
            } else if (deviceTraits.isSelectKeyCode(keyCode) || deviceTraits.isLeftSoftKeyCode(keyCode) || deviceTraits.isRightSoftKeyCode(keyCode)) {
                this.handleMenuFire(this.chosenMenuItem);
            }
        }
        switch (keyCode) {
            case 49: {
                this.handleMenuFire(0);
                break;
            }
            case 50: {
                this.handleMenuFire(1);
                break;
            }
            case 51: {
                this.handleMenuFire(2);
                break;
            }
            case 52: {
                this.handleMenuFire(3);
                break;
            }
            case 53: {
                this.handleMenuFire(4);
            }
        }
    }

    private void handleMenuFire(int item) {
        switch (item) {
            case 0: {
                AppController.getInstance().takePicture();
                break;
            }
            case 1: {
                AppController.getInstance().handleGoToHelp();
                break;
            }
            case 2: {
                AppController.getInstance().handleGoToSettings();
                break;
            }
            case 3: {
                this.openMoreApps();
                break;
            }
            case 4: {
                AppController.getInstance().handleExit();
            }
        }
    }

    private void openMoreApps() {
        AppController.getInstance().openMoreAppsBrowser();
    }
}

